/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing.javac;

import androidx.room.compiler.processing.XConstructorElement;
import androidx.room.compiler.processing.XConstructorType;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.compiler.processing.javac.ElementExtKt;
import androidx.room.compiler.processing.javac.JavacConstructorType;
import androidx.room.compiler.processing.javac.JavacDeclaredType;
import androidx.room.compiler.processing.javac.JavacExecutableElement;
import androidx.room.compiler.processing.javac.JavacProcessingEnv;
import androidx.room.compiler.processing.javac.JavacTypeElement;
import androidx.room.compiler.processing.javac.kotlin.KmConstructor;
import androidx.room.compiler.processing.javac.kotlin.KotlinMetadataElement;
import com.google.auto.common.MoreTypes;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u001b\u0010\n\u001a\u00020\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00168VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000f\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Landroidx/room/compiler/processing/javac/JavacConstructorElement;", "Landroidx/room/compiler/processing/javac/JavacExecutableElement;", "Landroidx/room/compiler/processing/XConstructorElement;", "env", "Landroidx/room/compiler/processing/javac/JavacProcessingEnv;", "containing", "Landroidx/room/compiler/processing/javac/JavacTypeElement;", "element", "Ljavax/lang/model/element/ExecutableElement;", "(Landroidx/room/compiler/processing/javac/JavacProcessingEnv;Landroidx/room/compiler/processing/javac/JavacTypeElement;Ljavax/lang/model/element/ExecutableElement;)V", "enclosingElement", "Landroidx/room/compiler/processing/XTypeElement;", "getEnclosingElement", "()Landroidx/room/compiler/processing/XTypeElement;", "enclosingElement$delegate", "Lkotlin/Lazy;", "executableType", "Landroidx/room/compiler/processing/XConstructorType;", "getExecutableType", "()Landroidx/room/compiler/processing/XConstructorType;", "executableType$delegate", "kotlinMetadata", "Landroidx/room/compiler/processing/javac/kotlin/KmConstructor;", "getKotlinMetadata", "()Landroidx/room/compiler/processing/javac/kotlin/KmConstructor;", "kotlinMetadata$delegate", "asMemberOf", "other", "Landroidx/room/compiler/processing/XType;", "room-compiler-processing"})
public final class JavacConstructorElement
extends JavacExecutableElement
implements XConstructorElement {
    @NotNull
    private final Lazy enclosingElement$delegate;
    @NotNull
    private final Lazy executableType$delegate;
    @NotNull
    private final Lazy kotlinMetadata$delegate;

    public JavacConstructorElement(@NotNull JavacProcessingEnv env, @NotNull JavacTypeElement containing, @NotNull ExecutableElement element) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(env, containing, element);
        if (!(element.getKind() == ElementKind.CONSTRUCTOR)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Constructor element is constructed with invalid type: ", (Object)element);
            throw new IllegalStateException(string.toString());
        }
        this.enclosingElement$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JavacTypeElement>(element, env){
            final /* synthetic */ ExecutableElement $element;
            final /* synthetic */ JavacProcessingEnv $env;
            {
                this.$element = $element;
                this.$env = $env;
                super(0);
            }

            @NotNull
            public final JavacTypeElement invoke() {
                return ElementExtKt.requireEnclosingType(this.$element, this.$env);
            }
        }));
        this.executableType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JavacConstructorType>(env, containing, element, this){
            final /* synthetic */ JavacProcessingEnv $env;
            final /* synthetic */ JavacTypeElement $containing;
            final /* synthetic */ ExecutableElement $element;
            final /* synthetic */ JavacConstructorElement this$0;
            {
                this.$env = $env;
                this.$containing = $containing;
                this.$element = $element;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final JavacConstructorType invoke() {
                TypeMirror asMemberOf = this.$env.getTypeUtils().asMemberOf(this.$containing.getType().getTypeMirror(), this.$element);
                ExecutableType executableType2 = MoreTypes.asExecutable((TypeMirror)asMemberOf);
                Intrinsics.checkNotNullExpressionValue((Object)executableType2, (String)"asExecutable(asMemberOf)");
                return new JavacConstructorType(this.$env, this.this$0, executableType2);
            }
        }));
        this.kotlinMetadata$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KmConstructor>(this, element){
            final /* synthetic */ JavacConstructorElement this$0;
            final /* synthetic */ ExecutableElement $element;
            {
                this.this$0 = $receiver;
                this.$element = $element;
                super(0);
            }

            @Nullable
            public final KmConstructor invoke() {
                KmConstructor kmConstructor;
                XTypeElement xTypeElement = this.this$0.getEnclosingElement();
                JavacTypeElement javacTypeElement = xTypeElement instanceof JavacTypeElement ? (JavacTypeElement)xTypeElement : null;
                if (javacTypeElement == null) {
                    kmConstructor = null;
                } else {
                    KotlinMetadataElement kotlinMetadataElement = javacTypeElement.getKotlinMetadata();
                    kmConstructor = kotlinMetadataElement == null ? null : kotlinMetadataElement.getConstructorMetadata(this.$element);
                }
                return kmConstructor;
            }
        }));
    }

    @Override
    @NotNull
    public XTypeElement getEnclosingElement() {
        Lazy lazy = this.enclosingElement$delegate;
        return (XTypeElement)lazy.getValue();
    }

    @Override
    @NotNull
    public XConstructorType getExecutableType() {
        Lazy lazy = this.executableType$delegate;
        return (XConstructorType)lazy.getValue();
    }

    @Override
    @NotNull
    public XConstructorType asMemberOf(@NotNull XType other) {
        XConstructorType xConstructorType;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof JavacDeclaredType) || this.getContaining().getType().isSameType(other)) {
            xConstructorType = this.getExecutableType();
        } else {
            TypeMirror asMemberOf = this.getEnv().getTypeUtils().asMemberOf(((JavacDeclaredType)other).getTypeMirror(), this.getElement());
            JavacProcessingEnv javacProcessingEnv = this.getEnv();
            ExecutableType executableType2 = MoreTypes.asExecutable((TypeMirror)asMemberOf);
            Intrinsics.checkNotNullExpressionValue((Object)executableType2, (String)"asExecutable(asMemberOf)");
            xConstructorType = new JavacConstructorType(javacProcessingEnv, this, executableType2);
        }
        return xConstructorType;
    }

    @Override
    @Nullable
    public KmConstructor getKotlinMetadata() {
        Lazy lazy = this.kotlinMetadata$delegate;
        return (KmConstructor)lazy.getValue();
    }
}

