/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing.ksp;

import androidx.room.compiler.processing.XFieldElement;
import androidx.room.compiler.processing.XProcessingConfig;
import androidx.room.compiler.processing.ksp.KspFieldElement;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.Origin;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\u000e"}, d2={"Landroidx/room/compiler/processing/ksp/KspFieldOrdering;", "", "()V", "getFieldNamesComparator", "Landroidx/room/compiler/processing/ksp/KspFieldOrdering$FieldNameComparator;", "ksClassDeclaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "orderFields", "", "Landroidx/room/compiler/processing/ksp/KspFieldElement;", "owner", "fields", "FieldNameComparator", "ReflectionReferences", "room-compiler-processing"})
public final class KspFieldOrdering {
    @NotNull
    public static final KspFieldOrdering INSTANCE;

    @NotNull
    public final List<KspFieldElement> orderFields(@NotNull KSClassDeclaration owner, @NotNull List<KspFieldElement> fields) {
        List list;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        if (fields.isEmpty()) {
            return fields;
        }
        FieldNameComparator comparator = this.getFieldNamesComparator(owner);
        if (comparator == null) {
            list = fields;
        } else {
            Iterable $this$forEach$iv = fields;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KspFieldElement it = (KspFieldElement)element$iv;
                boolean bl = false;
                comparator.register(it.getName());
            }
            list = CollectionsKt.sortedWith((Iterable)fields, (Comparator)comparator);
        }
        return list;
    }

    private final FieldNameComparator getFieldNamesComparator(KSClassDeclaration ksClassDeclaration) {
        FieldNameComparator fieldNameComparator;
        try {
            if (ksClassDeclaration.getOrigin() != Origin.CLASS) {
                return null;
            }
            ReflectionReferences reflectionReferences = ReflectionReferences.Companion.getInstance(ksClassDeclaration);
            if (reflectionReferences == null) {
                return null;
            }
            ReflectionReferences typeReferences = reflectionReferences;
            Object object = typeReferences.getGetDescriptorMethod().invoke((Object)ksClassDeclaration, new Object[0]);
            if (object == null) {
                return null;
            }
            Object descriptor2 = object;
            if (!typeReferences.getDeserializedClassDescriptor().isInstance(descriptor2)) {
                return null;
            }
            Object object2 = typeReferences.getDescriptorSourceMethod().invoke(descriptor2, new Object[0]);
            if (object2 == null) {
                return null;
            }
            Object descriptorSrc = object2;
            if (!typeReferences.getKotlinJvmBinarySourceElement().isInstance(descriptorSrc)) {
                return null;
            }
            Object object3 = typeReferences.getBinaryClassMethod().invoke(descriptorSrc, new Object[0]);
            if (object3 == null) {
                return null;
            }
            Object binarySource = object3;
            FieldNameComparator fieldNameComparator2 = new FieldNameComparator();
            InvocationHandler invocationHandler2 = new InvocationHandler(typeReferences, fieldNameComparator2){
                final /* synthetic */ ReflectionReferences $typeReferences;
                final /* synthetic */ FieldNameComparator $fieldNameComparator;

                public final Object invoke(Object $noName_0, Method method, Object[] args) {
                    Object nameAsString;
                    Method method2 = method;
                    Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
                    if (Intrinsics.areEqual((Object)method2.getName(), (Object)"visitField") && (nameAsString = this.$typeReferences.getAsStringMethod().invoke(args[0], new Object[0])) instanceof String) {
                        this.$fieldNameComparator.register((String)nameAsString);
                    }
                    return null;
                }
                {
                    this.$typeReferences = reflectionReferences;
                    this.$fieldNameComparator = fieldNameComparator;
                }
            };
            Object proxy = Proxy.newProxyInstance(ksClassDeclaration.getClass().getClassLoader(), new Class[]{typeReferences.getMemberVisitor()}, invocationHandler2);
            typeReferences.getVisitMembersMethod().invoke(binarySource, proxy, null);
            fieldNameComparator2.seal();
            fieldNameComparator = fieldNameComparator2;
        }
        catch (Throwable ignored) {
            if (XProcessingConfig.INSTANCE.getSTRICT_MODE()) {
                throw (Throwable)new RuntimeException("failed to get fields", ignored);
            }
            fieldNameComparator = null;
        }
        return fieldNameComparator;
    }

    private KspFieldOrdering() {
    }

    static {
        KspFieldOrdering kspFieldOrdering;
        INSTANCE = kspFieldOrdering = new KspFieldOrdering();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0015\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0015\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0015\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0015\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0015\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010R\u0015\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u0011\u0010\u001d\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\b\u00a8\u0006 "}, d2={"Landroidx/room/compiler/processing/ksp/KspFieldOrdering$ReflectionReferences;", "", "classLoader", "Ljava/lang/ClassLoader;", "(Ljava/lang/ClassLoader;)V", "asStringMethod", "Ljava/lang/reflect/Method;", "getAsStringMethod", "()Ljava/lang/reflect/Method;", "binaryClassMethod", "getBinaryClassMethod", "descriptorSourceMethod", "getDescriptorSourceMethod", "deserializedClassDescriptor", "Ljava/lang/Class;", "getDeserializedClassDescriptor", "()Ljava/lang/Class;", "getDescriptorMethod", "getGetDescriptorMethod", "kotlinJvmBinaryClass", "getKotlinJvmBinaryClass", "kotlinJvmBinarySourceElement", "getKotlinJvmBinarySourceElement", "ksClassDeclarationDescriptorImpl", "getKsClassDeclarationDescriptorImpl", "memberVisitor", "getMemberVisitor", "name", "getName", "visitMembersMethod", "getVisitMembersMethod", "Companion", "room-compiler-processing"})
    private static final class ReflectionReferences {
        @NotNull
        private final Class<?> deserializedClassDescriptor;
        @NotNull
        private final Class<?> ksClassDeclarationDescriptorImpl;
        @NotNull
        private final Class<?> kotlinJvmBinarySourceElement;
        @NotNull
        private final Class<?> kotlinJvmBinaryClass;
        @NotNull
        private final Class<?> memberVisitor;
        @NotNull
        private final Class<?> name;
        @NotNull
        private final Method getDescriptorMethod;
        @NotNull
        private final Method descriptorSourceMethod;
        @NotNull
        private final Method binaryClassMethod;
        @NotNull
        private final Method visitMembersMethod;
        @NotNull
        private final Method asStringMethod;
        private static final Object FAILED;
        private static Object instance;
        @NotNull
        public static final Companion Companion;

        @NotNull
        public final Class<?> getDeserializedClassDescriptor() {
            return this.deserializedClassDescriptor;
        }

        @NotNull
        public final Class<?> getKsClassDeclarationDescriptorImpl() {
            return this.ksClassDeclarationDescriptorImpl;
        }

        @NotNull
        public final Class<?> getKotlinJvmBinarySourceElement() {
            return this.kotlinJvmBinarySourceElement;
        }

        @NotNull
        public final Class<?> getKotlinJvmBinaryClass() {
            return this.kotlinJvmBinaryClass;
        }

        @NotNull
        public final Class<?> getMemberVisitor() {
            return this.memberVisitor;
        }

        @NotNull
        public final Class<?> getName() {
            return this.name;
        }

        @NotNull
        public final Method getGetDescriptorMethod() {
            return this.getDescriptorMethod;
        }

        @NotNull
        public final Method getDescriptorSourceMethod() {
            return this.descriptorSourceMethod;
        }

        @NotNull
        public final Method getBinaryClassMethod() {
            return this.binaryClassMethod;
        }

        @NotNull
        public final Method getVisitMembersMethod() {
            return this.visitMembersMethod;
        }

        @NotNull
        public final Method getAsStringMethod() {
            return this.asStringMethod;
        }

        private ReflectionReferences(ClassLoader classLoader) {
            Class<?> clazz = classLoader.loadClass("org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor");
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"classLoader.loadClass(\n \u2026lassDescriptor\"\n        )");
            this.deserializedClassDescriptor = clazz;
            Class<?> clazz2 = classLoader.loadClass("com.google.devtools.ksp.symbol.impl.binary.KSClassDeclarationDescriptorImpl");
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"classLoader.loadClass(\n \u2026DescriptorImpl\"\n        )");
            this.ksClassDeclarationDescriptorImpl = clazz2;
            Class<?> clazz3 = classLoader.loadClass("org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement");
            Intrinsics.checkNotNullExpressionValue(clazz3, (String)"classLoader.loadClass(\n \u2026ySourceElement\"\n        )");
            this.kotlinJvmBinarySourceElement = clazz3;
            Class<?> clazz4 = classLoader.loadClass("org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass");
            Intrinsics.checkNotNullExpressionValue(clazz4, (String)"classLoader.loadClass(\n \u2026JvmBinaryClass\"\n        )");
            this.kotlinJvmBinaryClass = clazz4;
            Class<?> clazz5 = classLoader.loadClass("org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass$MemberVisitor");
            Intrinsics.checkNotNullExpressionValue(clazz5, (String)"classLoader.loadClass(\n \u2026$MemberVisitor\"\n        )");
            this.memberVisitor = clazz5;
            Class<?> clazz6 = classLoader.loadClass("org.jetbrains.kotlin.name.Name");
            Intrinsics.checkNotNullExpressionValue(clazz6, (String)"classLoader.loadClass(\n \u2026tlin.name.Name\"\n        )");
            this.name = clazz6;
            Method method = this.ksClassDeclarationDescriptorImpl.getDeclaredMethod("getDescriptor", new Class[0]);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"ksClassDeclarationDescri\u2026edMethod(\"getDescriptor\")");
            this.getDescriptorMethod = method;
            Method method2 = this.deserializedClassDescriptor.getMethod("getSource", new Class[0]);
            Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"deserializedClassDescriptor.getMethod(\"getSource\")");
            this.descriptorSourceMethod = method2;
            Method method3 = this.kotlinJvmBinarySourceElement.getMethod("getBinaryClass", new Class[0]);
            Intrinsics.checkNotNullExpressionValue((Object)method3, (String)"kotlinJvmBinarySourceEle\u2026tMethod(\"getBinaryClass\")");
            this.binaryClassMethod = method3;
            Method method4 = this.kotlinJvmBinaryClass.getDeclaredMethod("visitMembers", this.memberVisitor, byte[].class);
            Intrinsics.checkNotNullExpressionValue((Object)method4, (String)"kotlinJvmBinaryClass.get\u2026ray::class.java\n        )");
            this.visitMembersMethod = method4;
            Method method5 = this.name.getDeclaredMethod("asString", new Class[0]);
            Intrinsics.checkNotNullExpressionValue((Object)method5, (String)"name.getDeclaredMethod(\"asString\")");
            this.asStringMethod = method5;
        }

        static {
            Companion = new Companion(null);
            FAILED = new Object();
        }

        public /* synthetic */ ReflectionReferences(ClassLoader classLoader, DefaultConstructorMarker $constructor_marker) {
            this(classLoader);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0001R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/room/compiler/processing/ksp/KspFieldOrdering$ReflectionReferences$Companion;", "", "()V", "FAILED", "instance", "getInstance", "Landroidx/room/compiler/processing/ksp/KspFieldOrdering$ReflectionReferences;", "ref", "room-compiler-processing"})
        public static final class Companion {
            @Nullable
            public final ReflectionReferences getInstance(@NotNull Object ref) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                if (instance == null) {
                    Object object2;
                    try {
                        ClassLoader classLoader = ref.getClass().getClassLoader();
                        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"ref::class.java.classLoader");
                        object2 = new ReflectionReferences(classLoader, null);
                    }
                    catch (Throwable ignored) {
                        object2 = FAILED;
                    }
                    instance = object2;
                }
                if (!((object = instance) instanceof ReflectionReferences)) {
                    object = null;
                }
                return (ReflectionReferences)object;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\tJ\u0006\u0010\u0013\u001a\u00020\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/room/compiler/processing/ksp/KspFieldOrdering$FieldNameComparator;", "Ljava/util/Comparator;", "Landroidx/room/compiler/processing/XFieldElement;", "Lkotlin/Comparator;", "()V", "nextOrder", "", "orders", "", "", "sealed", "", "compare", "field1", "field2", "getOrder", "name", "register", "", "seal", "room-compiler-processing"})
    private static final class FieldNameComparator
    implements Comparator<XFieldElement> {
        private int nextOrder;
        private boolean sealed;
        private final Map<String, Integer> orders;

        public final void seal() {
            this.sealed = true;
        }

        public final void register(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.getOrder(name2);
        }

        private final int getOrder(String name2) {
            Integer n;
            Map<String, Integer> $this$getOrPut$iv = this.orders;
            boolean $i$f$getOrPut = false;
            Integer value$iv = $this$getOrPut$iv.get(name2);
            if (value$iv == null) {
                boolean bl = false;
                if (this.sealed && XProcessingConfig.INSTANCE.getSTRICT_MODE()) {
                    String string = "expected to find field " + name2 + " but it is non-existent";
                    boolean bl2 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                int n2 = this.nextOrder;
                this.nextOrder = n2 + 1;
                Integer answer$iv = n2;
                $this$getOrPut$iv.put(name2, answer$iv);
                n = answer$iv;
            } else {
                n = value$iv;
            }
            return ((Number)n).intValue();
        }

        @Override
        public int compare(@NotNull XFieldElement field1, @NotNull XFieldElement field2) {
            Intrinsics.checkNotNullParameter((Object)field1, (String)"field1");
            Intrinsics.checkNotNullParameter((Object)field2, (String)"field2");
            return Intrinsics.compare((int)this.getOrder(field1.getName()), (int)this.getOrder(field2.getName()));
        }

        public FieldNameComparator() {
            boolean bl = false;
            this.orders = new LinkedHashMap();
        }
    }
}

