/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.util.SparseArray;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.LongSparseArray;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.ItemKeyProvider;
import androidx.recyclerview.widget.RecyclerView;

public final class StableIdKeyProvider
extends ItemKeyProvider<Long> {
    private static final String TAG = "StableIdKeyProvider";
    private final SparseArray<Long> mPositionToKey = new SparseArray();
    private final LongSparseArray<Integer> mKeyToPosition = new LongSparseArray();
    private final ViewHost mHost;

    StableIdKeyProvider(@NonNull ViewHost host) {
        super(1);
        Preconditions.checkNotNull((Object)host);
        this.mHost = host;
        this.mHost.registerLifecycleListener(new ViewHost.LifecycleListener(){

            @Override
            public void onAttached(@NonNull View view) {
                StableIdKeyProvider.this.onAttached(view);
            }

            @Override
            public void onRecycled(@NonNull View view) {
                StableIdKeyProvider.this.onRecycled(view);
            }
        });
    }

    public StableIdKeyProvider(@NonNull RecyclerView recyclerView) {
        this(new DefaultViewHost(recyclerView));
        Preconditions.checkArgument((boolean)recyclerView.getAdapter().hasStableIds(), (Object)"RecyclerView.Adapter#hasStableIds must return true.");
    }

    void onAttached(@NonNull View view) {
        RecyclerView.ViewHolder holder = this.mHost.findViewHolder(view);
        if (holder == null) {
            return;
        }
        int position = this.mHost.getPosition(holder);
        long id = holder.getItemId();
        if (position != -1 && id != -1L) {
            this.mPositionToKey.put(position, (Object)id);
            this.mKeyToPosition.put(id, (Object)position);
        }
    }

    void onRecycled(@NonNull View view) {
        RecyclerView.ViewHolder holder = this.mHost.findViewHolder(view);
        if (holder == null) {
            return;
        }
        int position = this.mHost.getPosition(holder);
        long id = holder.getItemId();
        if (position != -1 && id != -1L) {
            this.mPositionToKey.delete(position);
            this.mKeyToPosition.remove(id);
        }
    }

    @Override
    @Nullable
    public Long getKey(int position) {
        return (Long)this.mPositionToKey.get(position, null);
    }

    @Override
    public int getPosition(@NonNull Long key) {
        return (Integer)this.mKeyToPosition.get(key.longValue(), (Object)-1);
    }

    private static class DefaultViewHost
    implements ViewHost {
        @NonNull
        private final RecyclerView mRecyclerView;

        DefaultViewHost(@NonNull RecyclerView recyclerView) {
            Preconditions.checkNotNull((Object)recyclerView);
            this.mRecyclerView = recyclerView;
        }

        @Override
        public void registerLifecycleListener(final @NonNull ViewHost.LifecycleListener listener) {
            this.mRecyclerView.addOnChildAttachStateChangeListener(new RecyclerView.OnChildAttachStateChangeListener(){

                public void onChildViewAttachedToWindow(@NonNull View view) {
                    listener.onAttached(view);
                }

                public void onChildViewDetachedFromWindow(@NonNull View view) {
                }
            });
            this.mRecyclerView.addRecyclerListener(new RecyclerView.RecyclerListener(){

                public void onViewRecycled(@NonNull RecyclerView.ViewHolder holder) {
                    listener.onRecycled(holder.itemView);
                }
            });
        }

        @Override
        @Nullable
        public RecyclerView.ViewHolder findViewHolder(@NonNull View view) {
            return this.mRecyclerView.findContainingViewHolder(view);
        }

        @Override
        public int getPosition(@NonNull RecyclerView.ViewHolder holder) {
            return holder.getAbsoluteAdapterPosition();
        }
    }

    static interface ViewHost {
        public void registerLifecycleListener(@NonNull LifecycleListener var1);

        @Nullable
        public RecyclerView.ViewHolder findViewHolder(@NonNull View var1);

        public int getPosition(@NonNull RecyclerView.ViewHolder var1);

        public static interface LifecycleListener {
            public void onAttached(@NonNull View var1);

            public void onRecycled(@NonNull View var1);
        }
    }
}

