/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.util.Log;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.Resettable;
import java.util.ArrayList;
import java.util.List;

public final class OperationMonitor {
    private static final String TAG = "OperationMonitor";
    private final List<OnChangeListener> mListeners = new ArrayList<OnChangeListener>();
    private final Resettable mResettable = new Resettable(){

        @Override
        public boolean isResetRequired() {
            return OperationMonitor.this.isResetRequired();
        }

        @Override
        public void reset() {
            OperationMonitor.this.reset();
        }
    };
    private int mNumOps = 0;

    @MainThread
    synchronized void start() {
        ++this.mNumOps;
        if (this.mNumOps == 1) {
            this.notifyStateChanged();
        }
    }

    @MainThread
    synchronized void stop() {
        if (this.mNumOps == 0) {
            return;
        }
        --this.mNumOps;
        if (this.mNumOps == 0) {
            this.notifyStateChanged();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @MainThread
    synchronized void reset() {
        if (this.mNumOps > 0) {
            Log.w((String)TAG, (String)("Resetting OperationMonitor with " + this.mNumOps + " active operations."));
        }
        this.mNumOps = 0;
        this.notifyStateChanged();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    synchronized boolean isResetRequired() {
        return this.isStarted();
    }

    public synchronized boolean isStarted() {
        return this.mNumOps > 0;
    }

    public void addListener(@NonNull OnChangeListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0);
        this.mListeners.add(listener);
    }

    public void removeListener(@NonNull OnChangeListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0);
        this.mListeners.remove(listener);
    }

    void checkStarted(boolean started) {
        if (started) {
            Preconditions.checkState((this.mNumOps > 0 ? 1 : 0) != 0);
        } else {
            Preconditions.checkState((this.mNumOps == 0 ? 1 : 0) != 0);
        }
    }

    private void notifyStateChanged() {
        for (OnChangeListener l : this.mListeners) {
            l.onChanged();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    Resettable asResettable() {
        return this.mResettable;
    }

    public static interface OnChangeListener {
        public void onChanged();
    }
}

