/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.AsyncPagedListDiffer;
import androidx.paging.PagedList;
import androidx.recyclerview.widget.AdapterListUpdateCallback;
import androidx.recyclerview.widget.AsyncDifferConfig;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListUpdateCallback;
import androidx.recyclerview.widget.RecyclerView;

public abstract class PagedListAdapter<T, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    final AsyncPagedListDiffer<T> mDiffer;
    private final AsyncPagedListDiffer.PagedListListener<T> mListener = new AsyncPagedListDiffer.PagedListListener<T>(){

        @Override
        public void onCurrentListChanged(@Nullable PagedList<T> previousList, @Nullable PagedList<T> currentList) {
            PagedListAdapter.this.onCurrentListChanged(currentList);
            PagedListAdapter.this.onCurrentListChanged(previousList, currentList);
        }
    };

    protected PagedListAdapter(@NonNull DiffUtil.ItemCallback<T> diffCallback) {
        this.mDiffer = new AsyncPagedListDiffer<T>(this, diffCallback);
        this.mDiffer.addPagedListListener(this.mListener);
    }

    protected PagedListAdapter(@NonNull AsyncDifferConfig<T> config) {
        this.mDiffer = new AsyncPagedListDiffer<T>((ListUpdateCallback)new AdapterListUpdateCallback((RecyclerView.Adapter)this), config);
        this.mDiffer.addPagedListListener(this.mListener);
    }

    public void submitList(@Nullable PagedList<T> pagedList) {
        this.mDiffer.submitList(pagedList);
    }

    public void submitList(@Nullable PagedList<T> pagedList, @Nullable Runnable commitCallback) {
        this.mDiffer.submitList(pagedList, commitCallback);
    }

    @Nullable
    protected T getItem(int position) {
        return this.mDiffer.getItem(position);
    }

    public int getItemCount() {
        return this.mDiffer.getItemCount();
    }

    @Nullable
    public PagedList<T> getCurrentList() {
        return this.mDiffer.getCurrentList();
    }

    @Deprecated
    public void onCurrentListChanged(@Nullable PagedList<T> currentList) {
    }

    public void onCurrentListChanged(@Nullable PagedList<T> previousList, @Nullable PagedList<T> currentList) {
    }
}

