/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.paging.PagedList;
import androidx.paging.PagedStorageDiffHelper;
import androidx.recyclerview.widget.AdapterListUpdateCallback;
import androidx.recyclerview.widget.AsyncDifferConfig;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListUpdateCallback;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;

public class AsyncPagedListDiffer<T> {
    final ListUpdateCallback mUpdateCallback;
    final AsyncDifferConfig<T> mConfig;
    Executor mMainThreadExecutor = ArchTaskExecutor.getMainThreadExecutor();
    private final List<PagedListListener<T>> mListeners = new CopyOnWriteArrayList<PagedListListener<T>>();
    private boolean mIsContiguous;
    private PagedList<T> mPagedList;
    private PagedList<T> mSnapshot;
    int mMaxScheduledGeneration;
    private PagedList.Callback mPagedListCallback = new PagedList.Callback(){

        public void onInserted(int position, int count) {
            AsyncPagedListDiffer.this.mUpdateCallback.onInserted(position, count);
        }

        public void onRemoved(int position, int count) {
            AsyncPagedListDiffer.this.mUpdateCallback.onRemoved(position, count);
        }

        public void onChanged(int position, int count) {
            AsyncPagedListDiffer.this.mUpdateCallback.onChanged(position, count, null);
        }
    };

    public AsyncPagedListDiffer(@NonNull RecyclerView.Adapter adapter, @NonNull DiffUtil.ItemCallback<T> diffCallback) {
        this.mUpdateCallback = new AdapterListUpdateCallback(adapter);
        this.mConfig = new AsyncDifferConfig.Builder(diffCallback).build();
    }

    public AsyncPagedListDiffer(@NonNull ListUpdateCallback listUpdateCallback, @NonNull AsyncDifferConfig<T> config) {
        this.mUpdateCallback = listUpdateCallback;
        this.mConfig = config;
    }

    @Nullable
    public T getItem(int index) {
        if (this.mPagedList == null) {
            if (this.mSnapshot == null) {
                throw new IndexOutOfBoundsException("Item count is zero, getItem() call is invalid");
            }
            return (T)this.mSnapshot.get(index);
        }
        this.mPagedList.loadAround(index);
        return (T)this.mPagedList.get(index);
    }

    public int getItemCount() {
        if (this.mPagedList != null) {
            return this.mPagedList.size();
        }
        return this.mSnapshot == null ? 0 : this.mSnapshot.size();
    }

    public void submitList(@Nullable PagedList<T> pagedList) {
        this.submitList(pagedList, null);
    }

    public void submitList(final @Nullable PagedList<T> pagedList, final @Nullable Runnable commitCallback) {
        PagedList<T> previous;
        if (pagedList != null) {
            if (this.mPagedList == null && this.mSnapshot == null) {
                this.mIsContiguous = pagedList.isContiguous();
            } else if (pagedList.isContiguous() != this.mIsContiguous) {
                throw new IllegalArgumentException("AsyncPagedListDiffer cannot handle both contiguous and non-contiguous lists.");
            }
        }
        final int runGeneration = ++this.mMaxScheduledGeneration;
        if (pagedList == this.mPagedList) {
            if (commitCallback != null) {
                commitCallback.run();
            }
            return;
        }
        PagedList<T> pagedList2 = previous = this.mSnapshot != null ? this.mSnapshot : this.mPagedList;
        if (pagedList == null) {
            int removedCount = this.getItemCount();
            if (this.mPagedList != null) {
                this.mPagedList.removeWeakCallback(this.mPagedListCallback);
                this.mPagedList = null;
            } else if (this.mSnapshot != null) {
                this.mSnapshot = null;
            }
            this.mUpdateCallback.onRemoved(0, removedCount);
            this.onCurrentListChanged(previous, null, commitCallback);
            return;
        }
        if (this.mPagedList == null && this.mSnapshot == null) {
            this.mPagedList = pagedList;
            pagedList.addWeakCallback(null, this.mPagedListCallback);
            this.mUpdateCallback.onInserted(0, pagedList.size());
            this.onCurrentListChanged(null, pagedList, commitCallback);
            return;
        }
        if (this.mPagedList != null) {
            this.mPagedList.removeWeakCallback(this.mPagedListCallback);
            this.mSnapshot = (PagedList)this.mPagedList.snapshot();
            this.mPagedList = null;
        }
        if (this.mSnapshot == null || this.mPagedList != null) {
            throw new IllegalStateException("must be in snapshot state to diff");
        }
        final PagedList<T> oldSnapshot = this.mSnapshot;
        final PagedList newSnapshot = (PagedList)pagedList.snapshot();
        this.mConfig.getBackgroundThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                final DiffUtil.DiffResult result = PagedStorageDiffHelper.computeDiff(oldSnapshot.mStorage, newSnapshot.mStorage, AsyncPagedListDiffer.this.mConfig.getDiffCallback());
                AsyncPagedListDiffer.this.mMainThreadExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (AsyncPagedListDiffer.this.mMaxScheduledGeneration == runGeneration) {
                            AsyncPagedListDiffer.this.latchPagedList(pagedList, newSnapshot, result, oldSnapshot.mLastLoad, commitCallback);
                        }
                    }
                });
            }
        });
    }

    void latchPagedList(@NonNull PagedList<T> newList, @NonNull PagedList<T> diffSnapshot, @NonNull DiffUtil.DiffResult diffResult, int lastAccessIndex, @Nullable Runnable commitCallback) {
        if (this.mSnapshot == null || this.mPagedList != null) {
            throw new IllegalStateException("must be in snapshot state to apply diff");
        }
        PagedList<T> previousSnapshot = this.mSnapshot;
        this.mPagedList = newList;
        this.mSnapshot = null;
        PagedStorageDiffHelper.dispatchDiff(this.mUpdateCallback, previousSnapshot.mStorage, newList.mStorage, diffResult);
        newList.addWeakCallback(diffSnapshot, this.mPagedListCallback);
        if (!this.mPagedList.isEmpty()) {
            int newPosition = PagedStorageDiffHelper.transformAnchorIndex(diffResult, previousSnapshot.mStorage, diffSnapshot.mStorage, lastAccessIndex);
            this.mPagedList.loadAround(Math.max(0, Math.min(this.mPagedList.size() - 1, newPosition)));
        }
        this.onCurrentListChanged(previousSnapshot, this.mPagedList, commitCallback);
    }

    private void onCurrentListChanged(@Nullable PagedList<T> previousList, @Nullable PagedList<T> currentList, @Nullable Runnable commitCallback) {
        for (PagedListListener<T> listener : this.mListeners) {
            listener.onCurrentListChanged(previousList, currentList);
        }
        if (commitCallback != null) {
            commitCallback.run();
        }
    }

    public void addPagedListListener(@NonNull PagedListListener<T> listener) {
        this.mListeners.add(listener);
    }

    public void removePagedListListener(@NonNull PagedListListener<T> listener) {
        this.mListeners.remove(listener);
    }

    @Nullable
    public PagedList<T> getCurrentList() {
        if (this.mSnapshot != null) {
            return this.mSnapshot;
        }
        return this.mPagedList;
    }

    public static interface PagedListListener<T> {
        public void onCurrentListChanged(@Nullable PagedList<T> var1, @Nullable PagedList<T> var2);
    }
}

