/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.AnyThread;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.ContiguousDataSource;
import androidx.paging.DataSource;
import androidx.paging.PageResult;
import androidx.paging.PagedList;
import androidx.paging.PagedStorage;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.concurrent.Executor;

class ContiguousPagedList<K, V>
extends PagedList<V>
implements PagedStorage.Callback {
    final ContiguousDataSource<K, V> mDataSource;
    private static final int READY_TO_FETCH = 0;
    private static final int FETCHING = 1;
    private static final int DONE_FETCHING = 2;
    int mPrependWorkerState = 0;
    int mAppendWorkerState = 0;
    int mPrependItemsRequested = 0;
    int mAppendItemsRequested = 0;
    boolean mReplacePagesWithNulls = false;
    final boolean mShouldTrim;
    PageResult.Receiver<V> mReceiver = new PageResult.Receiver<V>(){

        @Override
        @AnyThread
        public void onPageResult(int resultType, @NonNull PageResult<V> pageResult) {
            if (pageResult.isInvalid()) {
                ContiguousPagedList.this.detach();
                return;
            }
            if (ContiguousPagedList.this.isDetached()) {
                return;
            }
            List page = pageResult.page;
            if (resultType == 0) {
                ContiguousPagedList.this.mStorage.init(pageResult.leadingNulls, page, pageResult.trailingNulls, pageResult.positionOffset, ContiguousPagedList.this);
                if (ContiguousPagedList.this.mLastLoad == -1) {
                    ContiguousPagedList.this.mLastLoad = pageResult.leadingNulls + pageResult.positionOffset + page.size() / 2;
                }
            } else {
                boolean skipNewPage;
                boolean trimFromFront = ContiguousPagedList.this.mLastLoad > ContiguousPagedList.this.mStorage.getMiddleOfLoadedRange();
                boolean bl = skipNewPage = ContiguousPagedList.this.mShouldTrim && ContiguousPagedList.this.mStorage.shouldPreTrimNewPage(ContiguousPagedList.this.mConfig.maxSize, ContiguousPagedList.this.mRequiredRemainder, page.size());
                if (resultType == 1) {
                    if (skipNewPage && !trimFromFront) {
                        ContiguousPagedList.this.mAppendItemsRequested = 0;
                        ContiguousPagedList.this.mAppendWorkerState = 0;
                    } else {
                        ContiguousPagedList.this.mStorage.appendPage(page, ContiguousPagedList.this);
                    }
                } else if (resultType == 2) {
                    if (skipNewPage && trimFromFront) {
                        ContiguousPagedList.this.mPrependItemsRequested = 0;
                        ContiguousPagedList.this.mPrependWorkerState = 0;
                    } else {
                        ContiguousPagedList.this.mStorage.prependPage(page, ContiguousPagedList.this);
                    }
                } else {
                    throw new IllegalArgumentException("unexpected resultType " + resultType);
                }
                if (ContiguousPagedList.this.mShouldTrim) {
                    if (trimFromFront) {
                        if (ContiguousPagedList.this.mPrependWorkerState != 1 && ContiguousPagedList.this.mStorage.trimFromFront(ContiguousPagedList.this.mReplacePagesWithNulls, ContiguousPagedList.this.mConfig.maxSize, ContiguousPagedList.this.mRequiredRemainder, ContiguousPagedList.this)) {
                            ContiguousPagedList.this.mPrependWorkerState = 0;
                        }
                    } else if (ContiguousPagedList.this.mAppendWorkerState != 1 && ContiguousPagedList.this.mStorage.trimFromEnd(ContiguousPagedList.this.mReplacePagesWithNulls, ContiguousPagedList.this.mConfig.maxSize, ContiguousPagedList.this.mRequiredRemainder, ContiguousPagedList.this)) {
                        ContiguousPagedList.this.mAppendWorkerState = 0;
                    }
                }
            }
            if (ContiguousPagedList.this.mBoundaryCallback != null) {
                boolean deferEmpty = ContiguousPagedList.this.mStorage.size() == 0;
                boolean deferBegin = !deferEmpty && resultType == 2 && pageResult.page.size() == 0;
                boolean deferEnd = !deferEmpty && resultType == 1 && pageResult.page.size() == 0;
                ContiguousPagedList.this.deferBoundaryCallbacks(deferEmpty, deferBegin, deferEnd);
            }
        }
    };
    static final int LAST_LOAD_UNSPECIFIED = -1;

    ContiguousPagedList(@NonNull ContiguousDataSource<K, V> dataSource, @NonNull Executor mainThreadExecutor, @NonNull Executor backgroundThreadExecutor, @Nullable PagedList.BoundaryCallback<V> boundaryCallback, @NonNull PagedList.Config config, @Nullable K key, int lastLoad) {
        super(new PagedStorage(), mainThreadExecutor, backgroundThreadExecutor, boundaryCallback, config);
        this.mDataSource = dataSource;
        this.mLastLoad = lastLoad;
        if (this.mDataSource.isInvalid()) {
            this.detach();
        } else {
            this.mDataSource.dispatchLoadInitial(key, this.mConfig.initialLoadSizeHint, this.mConfig.pageSize, this.mConfig.enablePlaceholders, this.mMainThreadExecutor, this.mReceiver);
        }
        this.mShouldTrim = this.mDataSource.supportsPageDropping() && this.mConfig.maxSize != Integer.MAX_VALUE;
    }

    @Override
    @MainThread
    void dispatchUpdatesSinceSnapshot(@NonNull PagedList<V> pagedListSnapshot, @NonNull PagedList.Callback callback) {
        int addedCount;
        int changedCount;
        PagedStorage snapshot = pagedListSnapshot.mStorage;
        int newlyAppended = this.mStorage.getNumberAppended() - snapshot.getNumberAppended();
        int newlyPrepended = this.mStorage.getNumberPrepended() - snapshot.getNumberPrepended();
        int previousTrailing = snapshot.getTrailingNullCount();
        int previousLeading = snapshot.getLeadingNullCount();
        if (snapshot.isEmpty() || newlyAppended < 0 || newlyPrepended < 0 || this.mStorage.getTrailingNullCount() != Math.max(previousTrailing - newlyAppended, 0) || this.mStorage.getLeadingNullCount() != Math.max(previousLeading - newlyPrepended, 0) || this.mStorage.getStorageCount() != snapshot.getStorageCount() + newlyAppended + newlyPrepended) {
            throw new IllegalArgumentException("Invalid snapshot provided - doesn't appear to be a snapshot of this PagedList");
        }
        if (newlyAppended != 0) {
            changedCount = Math.min(previousTrailing, newlyAppended);
            addedCount = newlyAppended - changedCount;
            int endPosition = snapshot.getLeadingNullCount() + snapshot.getStorageCount();
            if (changedCount != 0) {
                callback.onChanged(endPosition, changedCount);
            }
            if (addedCount != 0) {
                callback.onInserted(endPosition + changedCount, addedCount);
            }
        }
        if (newlyPrepended != 0) {
            changedCount = Math.min(previousLeading, newlyPrepended);
            addedCount = newlyPrepended - changedCount;
            if (changedCount != 0) {
                callback.onChanged(previousLeading, changedCount);
            }
            if (addedCount != 0) {
                callback.onInserted(0, addedCount);
            }
        }
    }

    static int getPrependItemsRequested(int prefetchDistance, int index, int leadingNulls) {
        return prefetchDistance - (index - leadingNulls);
    }

    static int getAppendItemsRequested(int prefetchDistance, int index, int itemsBeforeTrailingNulls) {
        return index + prefetchDistance + 1 - itemsBeforeTrailingNulls;
    }

    @Override
    @MainThread
    protected void loadAroundInternal(int index) {
        int prependItems = ContiguousPagedList.getPrependItemsRequested(this.mConfig.prefetchDistance, index, this.mStorage.getLeadingNullCount());
        int appendItems = ContiguousPagedList.getAppendItemsRequested(this.mConfig.prefetchDistance, index, this.mStorage.getLeadingNullCount() + this.mStorage.getStorageCount());
        this.mPrependItemsRequested = Math.max(prependItems, this.mPrependItemsRequested);
        if (this.mPrependItemsRequested > 0) {
            this.schedulePrepend();
        }
        this.mAppendItemsRequested = Math.max(appendItems, this.mAppendItemsRequested);
        if (this.mAppendItemsRequested > 0) {
            this.scheduleAppend();
        }
    }

    @MainThread
    private void schedulePrepend() {
        if (this.mPrependWorkerState != 0) {
            return;
        }
        this.mPrependWorkerState = 1;
        final int position = this.mStorage.getLeadingNullCount() + this.mStorage.getPositionOffset();
        final Object item = this.mStorage.getFirstLoadedItem();
        this.mBackgroundThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (ContiguousPagedList.this.isDetached()) {
                    return;
                }
                if (ContiguousPagedList.this.mDataSource.isInvalid()) {
                    ContiguousPagedList.this.detach();
                } else {
                    ContiguousPagedList.this.mDataSource.dispatchLoadBefore(position, item, ContiguousPagedList.this.mConfig.pageSize, ContiguousPagedList.this.mMainThreadExecutor, ContiguousPagedList.this.mReceiver);
                }
            }
        });
    }

    @MainThread
    private void scheduleAppend() {
        if (this.mAppendWorkerState != 0) {
            return;
        }
        this.mAppendWorkerState = 1;
        final int position = this.mStorage.getLeadingNullCount() + this.mStorage.getStorageCount() - 1 + this.mStorage.getPositionOffset();
        final Object item = this.mStorage.getLastLoadedItem();
        this.mBackgroundThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (ContiguousPagedList.this.isDetached()) {
                    return;
                }
                if (ContiguousPagedList.this.mDataSource.isInvalid()) {
                    ContiguousPagedList.this.detach();
                } else {
                    ContiguousPagedList.this.mDataSource.dispatchLoadAfter(position, item, ContiguousPagedList.this.mConfig.pageSize, ContiguousPagedList.this.mMainThreadExecutor, ContiguousPagedList.this.mReceiver);
                }
            }
        });
    }

    @Override
    boolean isContiguous() {
        return true;
    }

    @Override
    @NonNull
    public DataSource<?, V> getDataSource() {
        return this.mDataSource;
    }

    @Override
    @Nullable
    public Object getLastKey() {
        return this.mDataSource.getKey(this.mLastLoad, this.mLastItem);
    }

    @Override
    @MainThread
    public void onInitialized(int count) {
        this.notifyInserted(0, count);
        this.mReplacePagesWithNulls = this.mStorage.getLeadingNullCount() > 0 || this.mStorage.getTrailingNullCount() > 0;
    }

    @Override
    @MainThread
    public void onPagePrepended(int leadingNulls, int changedCount, int addedCount) {
        this.mPrependItemsRequested = this.mPrependItemsRequested - changedCount - addedCount;
        this.mPrependWorkerState = 0;
        if (this.mPrependItemsRequested > 0) {
            this.schedulePrepend();
        }
        this.notifyChanged(leadingNulls, changedCount);
        this.notifyInserted(0, addedCount);
        this.offsetAccessIndices(addedCount);
    }

    @Override
    @MainThread
    public void onEmptyPrepend() {
        this.mPrependWorkerState = 2;
    }

    @Override
    @MainThread
    public void onPageAppended(int endPosition, int changedCount, int addedCount) {
        this.mAppendItemsRequested = this.mAppendItemsRequested - changedCount - addedCount;
        this.mAppendWorkerState = 0;
        if (this.mAppendItemsRequested > 0) {
            this.scheduleAppend();
        }
        this.notifyChanged(endPosition, changedCount);
        this.notifyInserted(endPosition + changedCount, addedCount);
    }

    @Override
    @MainThread
    public void onEmptyAppend() {
        this.mAppendWorkerState = 2;
    }

    @Override
    @MainThread
    public void onPagePlaceholderInserted(int pageIndex) {
        throw new IllegalStateException("Tiled callback on ContiguousPagedList");
    }

    @Override
    @MainThread
    public void onPageInserted(int start, int count) {
        throw new IllegalStateException("Tiled callback on ContiguousPagedList");
    }

    @Override
    public void onPagesRemoved(int startOfDrops, int count) {
        this.notifyRemoved(startOfDrops, count);
    }

    @Override
    public void onPagesSwappedToPlaceholder(int startOfDrops, int count) {
        this.notifyChanged(startOfDrops, count);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface FetchState {
    }
}

