/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.NonNull;
import androidx.arch.core.util.Function;
import androidx.paging.DataSource;
import androidx.paging.PositionalDataSource;
import java.util.List;

class WrapperPositionalDataSource<A, B>
extends PositionalDataSource<B> {
    private final PositionalDataSource<A> mSource;
    final Function<List<A>, List<B>> mListFunction;

    WrapperPositionalDataSource(PositionalDataSource<A> source, Function<List<A>, List<B>> listFunction) {
        this.mSource = source;
        this.mListFunction = listFunction;
    }

    @Override
    public void addInvalidatedCallback(@NonNull DataSource.InvalidatedCallback onInvalidatedCallback) {
        this.mSource.addInvalidatedCallback(onInvalidatedCallback);
    }

    @Override
    public void removeInvalidatedCallback(@NonNull DataSource.InvalidatedCallback onInvalidatedCallback) {
        this.mSource.removeInvalidatedCallback(onInvalidatedCallback);
    }

    @Override
    public void invalidate() {
        this.mSource.invalidate();
    }

    @Override
    public boolean isInvalid() {
        return this.mSource.isInvalid();
    }

    @Override
    public void loadInitial(@NonNull PositionalDataSource.LoadInitialParams params, final @NonNull PositionalDataSource.LoadInitialCallback<B> callback) {
        this.mSource.loadInitial(params, new PositionalDataSource.LoadInitialCallback<A>(){

            @Override
            public void onResult(@NonNull List<A> data, int position, int totalCount) {
                callback.onResult(DataSource.convert(WrapperPositionalDataSource.this.mListFunction, data), position, totalCount);
            }

            @Override
            public void onResult(@NonNull List<A> data, int position) {
                callback.onResult(DataSource.convert(WrapperPositionalDataSource.this.mListFunction, data), position);
            }
        });
    }

    @Override
    public void loadRange(@NonNull PositionalDataSource.LoadRangeParams params, final @NonNull PositionalDataSource.LoadRangeCallback<B> callback) {
        this.mSource.loadRange(params, new PositionalDataSource.LoadRangeCallback<A>(){

            @Override
            public void onResult(@NonNull List<A> data) {
                callback.onResult(DataSource.convert(WrapperPositionalDataSource.this.mListFunction, data));
            }
        });
    }
}

