/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.lint;

import androidx.navigation.lint.BaseTypeSafeDestinationMissingAnnotationDetectorKt;
import androidx.navigation.lint.UtilKt;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\b\u0010\u0012\u001a\u00020\u0013H&J\b\u0010\u0014\u001a\u00020\u0013H&J\u001e\u0010\u0015\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0019J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004*\u00020\u000bH\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u000b*\u00020\u0017H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/navigation/lint/BaseTypeSafeDestinationMissingAnnotationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "methodNames", "", "", "constructorNames", "(Ljava/util/List;Ljava/util/List;)V", "checkMissingKeepAnnotation", "", "fields", "Lcom/intellij/psi/PsiClass;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "checkMissingSerializableAnnotation", "kClazz", "getApplicableConstructorTypes", "getApplicableMethodNames", "getMissingKeepIssue", "Lcom/android/tools/lint/detector/api/Issue;", "getMissingSerializableIssue", "visitConstructor", "node", "Lorg/jetbrains/uast/UCallExpression;", "constructor", "Lcom/intellij/psi/PsiMethod;", "visitMethodCall", "method", "getEnumFields", "getRouteKClassType", "common"})
@SourceDebugExtension(value={"SMAP\nBaseTypeSafeDestinationMissingAnnotationDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseTypeSafeDestinationMissingAnnotationDetector.kt\nandroidx/navigation/lint/BaseTypeSafeDestinationMissingAnnotationDetector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n11653#2,9:193\n13579#2:202\n13580#2:205\n11662#2:206\n1#3:203\n1#3:204\n1#3:208\n2634#4:207\n*S KotlinDebug\n*F\n+ 1 BaseTypeSafeDestinationMissingAnnotationDetector.kt\nandroidx/navigation/lint/BaseTypeSafeDestinationMissingAnnotationDetector\n*L\n133#1:193,9\n133#1:202\n133#1:205\n133#1:206\n133#1:204\n140#1:208\n140#1:207\n*E\n"})
public abstract class BaseTypeSafeDestinationMissingAnnotationDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    private final List<String> methodNames;
    @NotNull
    private final List<String> constructorNames;

    public BaseTypeSafeDestinationMissingAnnotationDetector(@NotNull List<String> methodNames, @NotNull List<String> constructorNames) {
        Intrinsics.checkNotNullParameter(methodNames, (String)"methodNames");
        Intrinsics.checkNotNullParameter(constructorNames, (String)"constructorNames");
        this.methodNames = methodNames;
        this.constructorNames = constructorNames;
    }

    @NotNull
    public abstract Issue getMissingSerializableIssue();

    @NotNull
    public abstract Issue getMissingKeepIssue();

    @NotNull
    public final List<String> getApplicableMethodNames() {
        return this.methodNames;
    }

    @NotNull
    public final List<String> getApplicableConstructorTypes() {
        return this.constructorNames;
    }

    public final void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Object object;
        String packageName;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        PsiFile psiFile = method.getContainingFile();
        PsiClassOwner psiClassOwner = psiFile instanceof PsiClassOwner ? (PsiClassOwner)psiFile : null;
        String string = packageName = psiClassOwner != null ? psiClassOwner.getPackageName() : null;
        if (!Intrinsics.areEqual((Object)packageName, (Object)BaseTypeSafeDestinationMissingAnnotationDetectorKt.getNAVIGATION_PACKAGE_NAME()) && !Intrinsics.areEqual((Object)packageName, (Object)BaseTypeSafeDestinationMissingAnnotationDetectorKt.getNAVIGATION_COMPOSE_PACKAGE_NAME())) {
            return;
        }
        UExpression uExpression = node.getReceiver();
        String receiver = uExpression != null && (uExpression = uExpression.getExpressionType()) != null ? uExpression.getCanonicalText() : null;
        if (Intrinsics.areEqual((Object)node.getMethodName(), (Object)"navigation") && Intrinsics.areEqual((Object)receiver, (Object)"androidx.navigation.NavigatorProvider")) {
            object = this.getRouteKClassType(node);
        } else if (!((Collection)node.getTypeArguments()).isEmpty()) {
            Object object2 = CollectionsKt.first((List)node.getTypeArguments());
            PsiClassReferenceType psiClassReferenceType = object2 instanceof PsiClassReferenceType ? (PsiClassReferenceType)object2 : null;
            object = psiClassReferenceType != null ? psiClassReferenceType.resolve() : null;
        } else {
            object = null;
        }
        if (object == null) {
            return;
        }
        PsiClass kClazzType = object;
        this.checkMissingSerializableAnnotation(kClazzType, context);
        List<PsiClass> enums = this.getEnumFields(kClazzType);
        if (!((Collection)enums).isEmpty()) {
            this.checkMissingKeepAnnotation(enums, context);
        }
    }

    public final void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        PsiClass psiClass = this.getRouteKClassType(node);
        if (psiClass == null) {
            return;
        }
        PsiClass kClazzType = psiClass;
        this.checkMissingSerializableAnnotation(kClazzType, context);
        List<PsiClass> enums = this.getEnumFields(kClazzType);
        if (!((Collection)enums).isEmpty()) {
            this.checkMissingKeepAnnotation(enums, context);
        }
    }

    private final PsiClass getRouteKClassType(UCallExpression $this$getRouteKClassType) {
        Object v1;
        block2: {
            Iterable iterable = $this$getRouteKClassType.getValueArguments();
            for (Object t : iterable) {
                UExpression it = (UExpression)t;
                boolean bl = false;
                PsiParameter psiParameter = UastUtils.getParameterForArgument((UCallExpression)$this$getRouteKClassType, (UExpression)it);
                if (!(Intrinsics.areEqual((Object)(psiParameter != null ? psiParameter.getName() : null), (Object)"route") && it.getSourcePsi() instanceof KtClassLiteralExpression)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        UExpression uExpression = v1;
        if (uExpression == null) {
            return null;
        }
        UExpression routeNode = uExpression;
        return UtilKt.getKClassType(routeNode);
    }

    private final void checkMissingSerializableAnnotation(PsiClass kClazz, JavaContext context) {
        if (!(kClazz instanceof PsiCompiledElement || kClazz.isInterface() || kClazz.hasAnnotation("kotlinx.serialization.Serializable"))) {
            UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)kClazz));
            if (uElement == null) {
                return;
            }
            UElement uElement2 = uElement;
            JavaContext.report$default((JavaContext)context, (Issue)this.getMissingSerializableIssue(), (UElement)uElement2, (Location)context.getNameLocation(uElement2), (String)"To use this class or object as a type-safe destination, annotate it with @Serializable", null, (int)16, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiClass> getEnumFields(PsiClass $this$getEnumFields) {
        void $this$mapNotNullTo$iv$iv;
        PsiField[] psiFieldArray = $this$getEnumFields.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"fields");
        Object[] $this$mapNotNull$iv = psiFieldArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Object object;
            PsiClass resolved;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            PsiField it = (PsiField)element$iv$iv;
            boolean bl2 = false;
            PsiType psiType = it.getType();
            PsiClassReferenceType psiClassReferenceType = psiType instanceof PsiClassReferenceType ? (PsiClassReferenceType)psiType : null;
            Object object2 = resolved = psiClassReferenceType != null ? psiClassReferenceType.resolve() : null;
            if (resolved != null) {
                PsiClass psiClass;
                PsiClass it2 = psiClass;
                boolean bl3 = false;
                object = resolved.isEnum() ? psiClass : null;
            } else {
                object = null;
            }
            if (object == null) continue;
            PsiClass it$iv$iv = object;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void checkMissingKeepAnnotation(List<? extends PsiClass> fields, JavaContext context) {
        Iterable iterable;
        Iterable $this$onEach$iv = fields;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            UElement uElement;
            PsiClass it = (PsiClass)element$iv;
            boolean bl2 = false;
            if (it.hasAnnotation("androidx.annotation.Keep")) continue;
            if (UastContextKt.toUElement((PsiElement)((PsiElement)it)) == null) {
                return;
            }
            JavaContext.report$default((JavaContext)context, (Issue)this.getMissingKeepIssue(), (UElement)uElement, (Location)context.getNameLocation(uElement), (String)"To prevent this Enum's serializer from being obfuscated in minified builds, annotate it with @androidx.annotation.Keep", null, (int)16, null);
        }
    }
}

