/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.lint.common;

import androidx.navigation.lint.common.LintUtilKt;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\b\u0010\t\u001a\u00020\nH&J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/navigation/lint/common/BaseWrongStartDestinationTypeDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "methodNames", "", "", "parameterNames", "(Ljava/util/List;Ljava/util/List;)V", "getApplicableMethodNames", "getIssue", "Lcom/android/tools/lint/detector/api/Issue;", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "navigation-lint-common"})
public abstract class BaseWrongStartDestinationTypeDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    private final List<String> methodNames;
    @NotNull
    private final List<String> parameterNames;

    public BaseWrongStartDestinationTypeDetector(@NotNull List<String> methodNames, @NotNull List<String> parameterNames) {
        Intrinsics.checkNotNullParameter(methodNames, (String)"methodNames");
        Intrinsics.checkNotNullParameter(parameterNames, (String)"parameterNames");
        this.methodNames = methodNames;
        this.parameterNames = parameterNames;
    }

    @NotNull
    public final List<String> getApplicableMethodNames() {
        return this.methodNames;
    }

    public final void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Iterable iterable = node.getValueArguments();
            for (Object t : iterable) {
                UExpression it = (UExpression)t;
                boolean bl = false;
                PsiParameter psiParameter = UastUtils.getParameterForArgument((UCallExpression)node, (UExpression)it);
                if (!CollectionsKt.contains((Iterable)this.parameterNames, (Object)(psiParameter != null ? psiParameter.getName() : null))) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        UExpression uExpression = v1;
        if (uExpression == null) {
            return;
        }
        UExpression startNode = uExpression;
        Pair pair = LintUtilKt.isClassReference$default(startNode, false, false, false, 7, null);
        boolean isClassType = (Boolean)pair.component1();
        String name = (String)pair.component2();
        if (isClassType) {
            JavaContext.report$default((JavaContext)context, (Issue)this.getIssue(), (UElement)((UElement)startNode), (Location)context.getNameLocation((UElement)startNode), (String)StringsKt.trimIndent((String)("\n                        StartDestination should not be a simple class name reference.\n                        Did you mean to call its constructor " + name + "(...)?\n                        If the class " + name + " does not contain arguments,\n                        you can also pass in its KClass reference " + name + "::class\n                    ")), null, (int)16, null);
        }
    }

    @NotNull
    public abstract Issue getIssue();
}

