/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.compose.lint;

import androidx.compose.lint.ComposableUtilsKt;
import androidx.compose.lint.PsiUtilsKt;
import androidx.navigation.compose.lint.ComposableDestinationInComposeScopeDetectorKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/navigation/compose/lint/ComposableDestinationInComposeScopeDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "navigation-compose-lint"})
public final class ComposableDestinationInComposeScopeDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue ComposableDestinationInComposeScope = Issue.Companion.create("ComposableDestinationInComposeScope", "Building composable destination in compose scope", "Composable destinations should only be constructed directly within a NavGraphBuilder scope. Composable destinations cannot be nested, and you should use the `navigation` function to create a nested graph instead.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(ComposableDestinationInComposeScopeDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));
    @NotNull
    private static final Issue ComposableNavGraphInComposeScope = Issue.Companion.create("ComposableNavGraphInComposeScope", "Building navigation graph in compose scope", "Composable destinations should only be constructed directly within a NavGraphBuilder scope.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(ComposableDestinationInComposeScopeDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{ComposableDestinationInComposeScopeDetectorKt.access$getComposable$p().getShortName(), ComposableDestinationInComposeScopeDetectorKt.access$getNavigation$p().getShortName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!PsiUtilsKt.isInPackageName(method, ComposableDestinationInComposeScopeDetectorKt.access$getPackageName$p())) {
            return;
        }
        if (ComposableUtilsKt.isInvokedWithinComposable((UExpression)node)) {
            if (Intrinsics.areEqual((Object)method.getName(), (Object)ComposableDestinationInComposeScopeDetectorKt.access$getComposable$p().getShortName())) {
                JavaContext.report$default((JavaContext)context, (Issue)ComposableDestinationInComposeScope, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)"Using composable inside of a compose scope", null, (int)16, null);
            } else {
                JavaContext.report$default((JavaContext)context, (Issue)ComposableNavGraphInComposeScope, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)"Using navigation inside of a compose scope", null, (int)16, null);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Landroidx/navigation/compose/lint/ComposableDestinationInComposeScopeDetector$Companion;", "", "()V", "ComposableDestinationInComposeScope", "Lcom/android/tools/lint/detector/api/Issue;", "getComposableDestinationInComposeScope", "()Lcom/android/tools/lint/detector/api/Issue;", "ComposableNavGraphInComposeScope", "getComposableNavGraphInComposeScope", "navigation-compose-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getComposableDestinationInComposeScope() {
            return ComposableDestinationInComposeScope;
        }

        @NotNull
        public final Issue getComposableNavGraphInComposeScope() {
            return ComposableNavGraphInComposeScope;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

