/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.compose.lint;

import androidx.compose.lint.ComposableUtilsKt;
import androidx.compose.lint.Name;
import androidx.compose.lint.PsiUtilsKt;
import androidx.navigation.compose.lint.UnrememberedGetBackStackEntryDetectorKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/navigation/compose/lint/UnrememberedGetBackStackEntryDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "navigation-compose-lint"})
public final class UnrememberedGetBackStackEntryDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue UnrememberedGetBackStackEntry = Issue.Companion.create("UnrememberedGetBackStackEntry", "Calling getBackStackEntry during composition without using `remember`with a NavBackStackEntry key", "Backstack entries retrieved during composition need to be `remember`ed, otherwise they will be retrieved from the navController again, and be changed. You also need to pass in a key of a NavBackStackEntry to the remember call or they will not be updated properly. If this is in a `NavGraphBuilder.composable` scope, you should pass in the lambda's given entry as the key. Either hoist the state to an object that is not created during composition, or wrap the state in a call to `remember` with a `NavBackStackEntry` as a key.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(UnrememberedGetBackStackEntryDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)UnrememberedGetBackStackEntryDetectorKt.access$getGetBackStackEntry$p().getShortName());
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        if (!PsiUtilsKt.isInPackageName(method, UnrememberedGetBackStackEntryDetectorKt.access$getPackageName$p())) {
            return;
        }
        Name[] nameArray = new Name[]{UnrememberedGetBackStackEntryDetectorKt.access$getNavBackStackEntry$p()};
        if (ComposableUtilsKt.isNotRememberedWithKeys(node, nameArray)) {
            JavaContext.report$default((JavaContext)context, (Issue)UnrememberedGetBackStackEntry, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)"Calling getBackStackEntry during composition without using `remember` with a NavBackStackEntry key", null, (int)16, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/navigation/compose/lint/UnrememberedGetBackStackEntryDetector$Companion;", "", "()V", "UnrememberedGetBackStackEntry", "Lcom/android/tools/lint/detector/api/Issue;", "getUnrememberedGetBackStackEntry", "()Lcom/android/tools/lint/detector/api/Issue;", "navigation-compose-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getUnrememberedGetBackStackEntry() {
            return UnrememberedGetBackStackEntry;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

