/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.serialization;

import android.os.Bundle;
import androidx.core.os.BundleKt;
import androidx.lifecycle.SavedStateHandle;
import androidx.navigation.NavType;
import androidx.navigation.serialization.ArgStore;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/navigation/serialization/SavedStateArgStore;", "Landroidx/navigation/serialization/ArgStore;", "handle", "Landroidx/lifecycle/SavedStateHandle;", "typeMap", "", "", "Landroidx/navigation/NavType;", "(Landroidx/lifecycle/SavedStateHandle;Ljava/util/Map;)V", "contains", "", "key", "get", "", "navigation-common_release"})
@SourceDebugExtension(value={"SMAP\nRouteDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteDecoder.kt\nandroidx/navigation/serialization/SavedStateArgStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1#2:184\n*E\n"})
final class SavedStateArgStore
extends ArgStore {
    @NotNull
    private final SavedStateHandle handle;
    @NotNull
    private final Map<String, NavType<?>> typeMap;

    public SavedStateArgStore(@NotNull SavedStateHandle handle, @NotNull Map<String, ? extends NavType<?>> typeMap) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        Intrinsics.checkNotNullParameter(typeMap, (String)"typeMap");
        this.handle = handle;
        this.typeMap = typeMap;
    }

    @Override
    @Nullable
    public Object get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object arg = this.handle.get(key);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)key, (Object)arg)};
        Bundle bundle = BundleKt.bundleOf((Pair[])pairArray);
        NavType<?> navType = this.typeMap.get(key);
        if (navType == null) {
            boolean bl = false;
            String string = "Failed to find type for " + key + " when decoding " + this.handle;
            throw new IllegalStateException(string.toString());
        }
        return navType.get(bundle, key);
    }

    @Override
    public boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.handle.contains(key);
    }
}

