/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.serialization;

import android.os.Bundle;
import androidx.lifecycle.SavedStateHandle;
import androidx.navigation.NavType;
import androidx.navigation.serialization.ArgStore;
import androidx.navigation.serialization.BundleArgStore;
import androidx.navigation.serialization.RouteSerializerKt;
import androidx.navigation.serialization.SavedStateArgStore;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005\u00a2\u0006\u0002\u0010\bB'\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J#\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#H\u0000\u00a2\u0006\u0004\b$\u0010%J!\u0010&\u001a\u0002H!\"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#H\u0016\u00a2\u0006\u0002\u0010%J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Landroidx/navigation/serialization/RouteDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "bundle", "Landroid/os/Bundle;", "typeMap", "", "", "Landroidx/navigation/NavType;", "(Landroid/os/Bundle;Ljava/util/Map;)V", "handle", "Landroidx/lifecycle/SavedStateHandle;", "(Landroidx/lifecycle/SavedStateHandle;Ljava/util/Map;)V", "elementIndex", "", "elementName", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule$annotations", "()V", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "store", "Landroidx/navigation/serialization/ArgStore;", "decodeElementIndex", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeInline", "Lkotlinx/serialization/encoding/Decoder;", "decodeNotNullMark", "", "decodeNull", "", "decodeRouteWithArgs", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "decodeRouteWithArgs$navigation_common_release", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "decodeSerializableValue", "decodeValue", "", "internalDecodeValue", "navigation-common_release"})
@SourceDebugExtension(value={"SMAP\nRouteDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteDecoder.kt\nandroidx/navigation/serialization/RouteDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1#2:184\n*E\n"})
public final class RouteDecoder
extends AbstractDecoder {
    @NotNull
    private final ArgStore store;
    private int elementIndex;
    @NotNull
    private String elementName;
    @NotNull
    private final SerializersModule serializersModule;

    public RouteDecoder(@NotNull Bundle bundle, @NotNull Map<String, ? extends NavType<?>> typeMap) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter(typeMap, (String)"typeMap");
        this.elementIndex = -1;
        this.elementName = "";
        this.serializersModule = SerializersModuleKt.getEmptySerializersModule();
        this.store = new BundleArgStore(bundle, typeMap);
    }

    public RouteDecoder(@NotNull SavedStateHandle handle, @NotNull Map<String, ? extends NavType<?>> typeMap) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        Intrinsics.checkNotNullParameter(typeMap, (String)"typeMap");
        this.elementIndex = -1;
        this.elementName = "";
        this.serializersModule = SerializersModuleKt.getEmptySerializersModule();
        this.store = new SavedStateArgStore(handle, typeMap);
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public static /* synthetic */ void getSerializersModule$annotations() {
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        String currentName;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        int currentIndex = this.elementIndex;
        do {
            if (++currentIndex < descriptor.getElementsCount()) continue;
            return -1;
        } while (!this.store.contains(currentName = descriptor.getElementName(currentIndex)));
        this.elementIndex = currentIndex;
        this.elementName = currentName;
        return this.elementIndex;
    }

    @NotNull
    public Object decodeValue() {
        return this.internalDecodeValue();
    }

    @Nullable
    public Void decodeNull() {
        return null;
    }

    public boolean decodeNotNullMark() {
        return this.store.get(this.elementName) != null;
    }

    @NotNull
    public Decoder decodeInline(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (RouteSerializerKt.isValueClass(descriptor)) {
            this.elementName = descriptor.getElementName(0);
            this.elementIndex = 0;
        }
        return super.decodeInline(descriptor);
    }

    public final <T> T decodeRouteWithArgs$navigation_common_release(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        return (T)super.decodeSerializableValue(deserializer);
    }

    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        return (T)this.internalDecodeValue();
    }

    private final Object internalDecodeValue() {
        Object arg = this.store.get(this.elementName);
        if (arg == null) {
            boolean bl = false;
            String string = "Unexpected null value for non-nullable argument " + this.elementName;
            throw new IllegalStateException(string.toString());
        }
        return arg;
    }
}

