/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.serialization;

import android.net.Uri;
import android.os.Bundle;
import androidx.navigation.CollectionNavType;
import androidx.navigation.NavType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\"#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0019\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0019\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007R\u0019\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0019\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0007R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R!\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0018\u00010\u001d0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0007R!\u0010\u001f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0018\u00010 0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0007\u00a8\u0006$"}, d2={"Landroidx/navigation/serialization/InternalNavType;", "", "()V", "BoolNullableType", "Landroidx/navigation/NavType;", "", "getBoolNullableType", "()Landroidx/navigation/NavType;", "DoubleArrayType", "", "getDoubleArrayType", "DoubleNullableType", "", "getDoubleNullableType", "DoubleType", "getDoubleType", "FloatNullableType", "", "getFloatNullableType", "IntNullableType", "", "getIntNullableType", "LongNullableType", "", "getLongNullableType", "StringNonNullableType", "", "getStringNonNullableType", "StringNullableArrayType", "", "getStringNullableArrayType", "StringNullableListType", "", "getStringNullableListType", "EnumNullableType", "SerializableNullableType", "navigation-common_release"})
public final class InternalNavType {
    @NotNull
    public static final InternalNavType INSTANCE = new InternalNavType();
    @NotNull
    private static final NavType<Integer> IntNullableType = new NavType<Integer>(){

        public String getName() {
            return "integer_nullable";
        }

        public void put(Bundle bundle, String key, Integer value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (value == null) {
                bundle.putSerializable(key, null);
            } else {
                NavType.IntType.put(bundle, key, value);
            }
        }

        public Integer get(Bundle bundle, String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object object = bundle.get(key);
            return object instanceof Integer ? (Integer)object : null;
        }

        public Integer parseValue(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Intrinsics.areEqual((Object)value, (Object)"null") ? null : NavType.IntType.parseValue(value);
        }
    };
    @NotNull
    private static final NavType<Boolean> BoolNullableType = new NavType<Boolean>(){

        public String getName() {
            return "boolean_nullable";
        }

        public void put(Bundle bundle, String key, Boolean value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (value == null) {
                bundle.putSerializable(key, null);
            } else {
                NavType.BoolType.put(bundle, key, value);
            }
        }

        public Boolean get(Bundle bundle, String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object object = bundle.get(key);
            return object instanceof Boolean ? (Boolean)object : null;
        }

        public Boolean parseValue(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Intrinsics.areEqual((Object)value, (Object)"null") ? null : NavType.BoolType.parseValue(value);
        }
    };
    @NotNull
    private static final NavType<Double> DoubleType = new NavType<Double>(){

        public String getName() {
            return "double";
        }

        public void put(Bundle bundle, String key, double value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            bundle.putDouble(key, value);
        }

        public Double get(Bundle bundle, String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object object = bundle.get(key);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            return (Double)object;
        }

        public Double parseValue(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Double.parseDouble(value);
        }
    };
    @NotNull
    private static final NavType<Double> DoubleNullableType = new NavType<Double>(){

        public String getName() {
            return "double_nullable";
        }

        public void put(Bundle bundle, String key, Double value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (value == null) {
                bundle.putSerializable(key, null);
            } else {
                InternalNavType.INSTANCE.getDoubleType().put(bundle, key, value);
            }
        }

        public Double get(Bundle bundle, String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object object = bundle.get(key);
            return object instanceof Double ? (Double)object : null;
        }

        public Double parseValue(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Intrinsics.areEqual((Object)value, (Object)"null") ? null : InternalNavType.INSTANCE.getDoubleType().parseValue(value);
        }
    };
    @NotNull
    private static final NavType<Float> FloatNullableType = new NavType<Float>(){

        public String getName() {
            return "float_nullable";
        }

        public void put(Bundle bundle, String key, Float value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (value == null) {
                bundle.putSerializable(key, null);
            } else {
                NavType.FloatType.put(bundle, key, value);
            }
        }

        public Float get(Bundle bundle, String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object object = bundle.get(key);
            return object instanceof Float ? (Float)object : null;
        }

        public Float parseValue(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Intrinsics.areEqual((Object)value, (Object)"null") ? null : NavType.FloatType.parseValue(value);
        }
    };
    @NotNull
    private static final NavType<Long> LongNullableType = new NavType<Long>(){

        public String getName() {
            return "long_nullable";
        }

        public void put(Bundle bundle, String key, Long value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (value == null) {
                bundle.putSerializable(key, null);
            } else {
                NavType.LongType.put(bundle, key, value);
            }
        }

        public Long get(Bundle bundle, String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object object = bundle.get(key);
            return object instanceof Long ? (Long)object : null;
        }

        public Long parseValue(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Intrinsics.areEqual((Object)value, (Object)"null") ? null : NavType.LongType.parseValue(value);
        }
    };
    @NotNull
    private static final NavType<String> StringNonNullableType = new NavType<String>(){

        public String getName() {
            return "string_non_nullable";
        }

        public void put(Bundle bundle, String key, String value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            bundle.putString(key, value);
        }

        public String get(Bundle bundle, String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String string = bundle.getString(key);
            if (string == null) {
                string = "null";
            }
            return string;
        }

        public String parseValue(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value;
        }

        public String serializeAsValue(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = Uri.encode((String)value);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(value)");
            return string;
        }
    };
    @NotNull
    private static final NavType<String[]> StringNullableArrayType = new CollectionNavType<String[]>(){

        public String getName() {
            return "string_nullable[]";
        }

        public void put(Bundle bundle, String key, String[] value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            bundle.putStringArray(key, value);
        }

        public String[] get(Bundle bundle, String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (String[])bundle.get(key);
        }

        public String[] parseValue(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String[] stringArray = new String[]{NavType.StringType.parseValue(value)};
            return stringArray;
        }

        public String[] parseValue(String value, String[] previousValue) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Object[] objectArray = previousValue;
            if (previousValue == null || (objectArray = (String[])ArraysKt.plus((Object[])objectArray, (Object[])this.parseValue(value))) == null) {
                objectArray = this.parseValue(value);
            }
            return objectArray;
        }

        public boolean valueEquals(String[] value, String[] other) {
            Object[] objectArray = value;
            return ArraysKt.contentDeepEquals((Object[])objectArray, (Object[])other);
        }

        /*
         * WARNING - void declaration
         */
        public List<String> serializeAsValues(String[] value) {
            List list;
            if (value != null) {
                void $this$mapTo$iv$iv;
                String[] $this$map$iv = value;
                boolean $i$f$map = false;
                String[] stringArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Uri.encode((String)it));
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        public String[] emptyCollection() {
            return new String[0];
        }
    };
    @NotNull
    private static final NavType<List<String>> StringNullableListType = new CollectionNavType<List<? extends String>>(){

        public String getName() {
            return "List<String?>";
        }

        public void put(Bundle bundle, String key, List<String> value) {
            String[] stringArray;
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            List<String> list = value;
            if (list != null) {
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                stringArray = thisCollection$iv.toArray(new String[0]);
            } else {
                stringArray = null;
            }
            bundle.putStringArray(key, stringArray);
        }

        public List<String> get(Bundle bundle, String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object[] objectArray = (String[])bundle.get(key);
            return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
        }

        public List<String> parseValue(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return CollectionsKt.listOf((Object)NavType.StringType.parseValue(value));
        }

        public List<String> parseValue(String value, List<String> previousValue) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            List<String> list = previousValue;
            if (list == null || (list = CollectionsKt.plus((Collection)list, (Iterable)((Iterable)this.parseValue(value)))) == null) {
                list = this.parseValue(value);
            }
            return list;
        }

        public boolean valueEquals(List<String> value, List<String> other) {
            String[] stringArray;
            Object[] objectArray;
            List<String> list = value;
            if (list != null) {
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                objectArray = thisCollection$iv.toArray(new String[0]);
            } else {
                objectArray = null;
            }
            Object[] valueArray = objectArray;
            List<String> list2 = other;
            if (list2 != null) {
                Collection $this$toTypedArray$iv = list2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                stringArray = thisCollection$iv.toArray(new String[0]);
            } else {
                stringArray = null;
            }
            String[] otherArray = stringArray;
            Object[] objectArray2 = valueArray;
            return ArraysKt.contentDeepEquals((Object[])objectArray2, otherArray);
        }

        /*
         * WARNING - void declaration
         */
        public List<String> serializeAsValues(List<String> value) {
            List list;
            List<String> list2 = value;
            if (list2 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Uri.encode((String)it));
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        public List<String> emptyCollection() {
            return CollectionsKt.emptyList();
        }
    };
    @NotNull
    private static final NavType<double[]> DoubleArrayType = new CollectionNavType<double[]>(){

        public String getName() {
            return "double[]";
        }

        public void put(Bundle bundle, String key, double[] value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            bundle.putDoubleArray(key, value);
        }

        public double[] get(Bundle bundle, String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (double[])bundle.get(key);
        }

        public double[] parseValue(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            double[] dArray = new double[]{((Number)InternalNavType.INSTANCE.getDoubleType().parseValue(value)).doubleValue()};
            return dArray;
        }

        public double[] parseValue(String value, double[] previousValue) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            double[] dArray = previousValue;
            if (previousValue == null || (dArray = ArraysKt.plus((double[])dArray, (double[])this.parseValue(value))) == null) {
                dArray = this.parseValue(value);
            }
            return dArray;
        }

        public boolean valueEquals(double[] value, double[] other) {
            Object[] valueArray = value != null ? ArraysKt.toTypedArray((double[])value) : null;
            Object[] otherArray = other != null ? ArraysKt.toTypedArray((double[])other) : null;
            Object[] objectArray = valueArray;
            return ArraysKt.contentDeepEquals((Object[])objectArray, (Object[])otherArray);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public List<String> serializeAsValues(double[] value) {
            List list;
            Object object = value;
            if (value != null) {
                List list2 = ArraysKt.toList((double[])object);
                object = list2;
                if (list2 != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = (Iterable)object;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                    while (true) {
                        void it;
                        if (!iterator2.hasNext()) {
                            list = (List)destination$iv$iv;
                            return list;
                        }
                        T item$iv$iv = iterator2.next();
                        double d = ((Number)item$iv$iv).doubleValue();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(String.valueOf((double)it));
                    }
                }
            }
            list = CollectionsKt.emptyList();
            return list;
        }

        public double[] emptyCollection() {
            return new double[0];
        }
    };

    private InternalNavType() {
    }

    @NotNull
    public final NavType<Integer> getIntNullableType() {
        return IntNullableType;
    }

    @NotNull
    public final NavType<Boolean> getBoolNullableType() {
        return BoolNullableType;
    }

    @NotNull
    public final NavType<Double> getDoubleType() {
        return DoubleType;
    }

    @NotNull
    public final NavType<Double> getDoubleNullableType() {
        return DoubleNullableType;
    }

    @NotNull
    public final NavType<Float> getFloatNullableType() {
        return FloatNullableType;
    }

    @NotNull
    public final NavType<Long> getLongNullableType() {
        return LongNullableType;
    }

    @NotNull
    public final NavType<String> getStringNonNullableType() {
        return StringNonNullableType;
    }

    @NotNull
    public final NavType<String[]> getStringNullableArrayType() {
        return StringNullableArrayType;
    }

    @NotNull
    public final NavType<List<String>> getStringNullableListType() {
        return StringNullableListType;
    }

    @NotNull
    public final NavType<double[]> getDoubleArrayType() {
        return DoubleArrayType;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0002\b\u0003\u0018\u00010\u00022\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0003B\u0015\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/navigation/serialization/InternalNavType$EnumNullableType;", "D", "", "Landroidx/navigation/serialization/InternalNavType$SerializableNullableType;", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "name", "", "getName", "()Ljava/lang/String;", "parseValue", "value", "(Ljava/lang/String;)Ljava/lang/Enum;", "navigation-common_release"})
    @SourceDebugExtension(value={"SMAP\nNavTypeConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavTypeConverter.kt\nandroidx/navigation/serialization/InternalNavType$EnumNullableType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,500:1\n1#2:501\n1282#3,2:502\n*S KotlinDebug\n*F\n+ 1 NavTypeConverter.kt\nandroidx/navigation/serialization/InternalNavType$EnumNullableType\n*L\n450#1:502,2\n*E\n"})
    public static final class EnumNullableType<D extends Enum<?>>
    extends SerializableNullableType<D> {
        @NotNull
        private final Class<D> type;

        public EnumNullableType(@NotNull Class<D> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(type);
            if (!type.isEnum()) {
                boolean bl = false;
                String string = type + " is not an Enum type.";
                throw new IllegalArgumentException(string.toString());
            }
            this.type = type;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.type.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.name");
            return string;
        }

        @Override
        @Nullable
        public D parseValue(@NotNull String value) {
            Enum enum_;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (Intrinsics.areEqual((Object)value, (Object)"null")) {
                enum_ = null;
            } else {
                Object v3;
                block4: {
                    D[] DArray = this.type.getEnumConstants();
                    Intrinsics.checkNotNull(DArray);
                    D[] $this$firstOrNull$iv = DArray;
                    boolean $i$f$firstOrNull = false;
                    for (D element$iv : $this$firstOrNull$iv) {
                        Enum constant = (Enum)element$iv;
                        boolean bl = false;
                        Enum enum_2 = constant;
                        Intrinsics.checkNotNull((Object)enum_2);
                        if (!StringsKt.equals((String)enum_2.name(), (String)value, (boolean)true)) continue;
                        v3 = element$iv;
                        break block4;
                    }
                    v3 = null;
                }
                if ((enum_ = (Enum)v3) == null) {
                    throw new IllegalArgumentException("Enum value " + value + " not found for type " + this.type.getName() + '.');
                }
            }
            return (D)enum_;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0003B\u0015\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J \u0010\u000f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0017\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0018J'\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/navigation/serialization/InternalNavType$SerializableNullableType;", "D", "Ljava/io/Serializable;", "Landroidx/navigation/NavType;", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "name", "", "getName", "()Ljava/lang/String;", "equals", "", "other", "", "get", "bundle", "Landroid/os/Bundle;", "key", "(Landroid/os/Bundle;Ljava/lang/String;)Ljava/io/Serializable;", "hashCode", "", "parseValue", "value", "(Ljava/lang/String;)Ljava/io/Serializable;", "put", "", "(Landroid/os/Bundle;Ljava/lang/String;Ljava/io/Serializable;)V", "navigation-common_release"})
    public static class SerializableNullableType<D extends Serializable>
    extends NavType<D> {
        @NotNull
        private final Class<D> type;

        public SerializableNullableType(@NotNull Class<D> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(true);
            this.type = type;
            if (!Serializable.class.isAssignableFrom(this.type)) {
                boolean bl = false;
                String string = this.type + " does not implement Serializable.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.type.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type.name");
            return string;
        }

        @Override
        public void put(@NotNull Bundle bundle, @NotNull String key, @Nullable D value) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            bundle.putSerializable(key, (Serializable)this.type.cast(value));
        }

        @Override
        @Nullable
        public D get(@NotNull Bundle bundle, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object object = bundle.get(key);
            return (D)(object instanceof Serializable ? (Serializable)object : null);
        }

        @Override
        @Nullable
        public D parseValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            throw new UnsupportedOperationException("Serializables don't support default values.");
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SerializableNullableType)) {
                return false;
            }
            return Intrinsics.areEqual(this.type, ((SerializableNullableType)other).type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }
}

