/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.os.Bundle;
import androidx.annotation.RestrictTo;
import androidx.navigation.NavType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001eB9\b\u0000\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\b\u0010\u001c\u001a\u00020\u0019H\u0016J\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\rR\u0019\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Landroidx/navigation/NavArgument;", "", "type", "Landroidx/navigation/NavType;", "isNullable", "", "defaultValue", "defaultValuePresent", "unknownDefaultValuePresent", "(Landroidx/navigation/NavType;ZLjava/lang/Object;ZZ)V", "getDefaultValue", "()Ljava/lang/Object;", "isDefaultValuePresent", "()Z", "isDefaultValueUnknown", "isDefaultValueUnknown$navigation_common_release", "getType", "()Landroidx/navigation/NavType;", "equals", "other", "hashCode", "", "putDefaultValue", "", "name", "", "bundle", "Landroid/os/Bundle;", "toString", "verify", "Builder", "navigation-common_release"})
public final class NavArgument {
    @NotNull
    private final NavType<Object> type;
    private final boolean isNullable;
    private final boolean isDefaultValuePresent;
    private final boolean isDefaultValueUnknown;
    @Nullable
    private final Object defaultValue;

    public NavArgument(@NotNull NavType<Object> type, boolean isNullable, @Nullable Object defaultValue, boolean defaultValuePresent, boolean unknownDefaultValuePresent) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (!(type.isNullableAllowed() || !isNullable)) {
            boolean $i$a$-require-NavArgument$32 = false;
            String $i$a$-require-NavArgument$32 = type.getName() + " does not allow nullable values";
            throw new IllegalArgumentException($i$a$-require-NavArgument$32.toString());
        }
        if (!(isNullable || !defaultValuePresent || defaultValue != null)) {
            boolean bl = false;
            String string = "Argument with type " + type.getName() + " has null value but is not nullable.";
            throw new IllegalArgumentException(string.toString());
        }
        this.type = type;
        this.isNullable = isNullable;
        this.defaultValue = defaultValue;
        this.isDefaultValuePresent = defaultValuePresent || unknownDefaultValuePresent;
        this.isDefaultValueUnknown = unknownDefaultValuePresent;
    }

    @NotNull
    public final NavType<Object> getType() {
        return this.type;
    }

    public final boolean isNullable() {
        return this.isNullable;
    }

    public final boolean isDefaultValuePresent() {
        return this.isDefaultValuePresent;
    }

    public final boolean isDefaultValueUnknown$navigation_common_release() {
        return this.isDefaultValueUnknown;
    }

    @Nullable
    public final Object getDefaultValue() {
        return this.defaultValue;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void putDefaultValue(@NotNull String name, @NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        if (this.isDefaultValuePresent && this.defaultValue != null) {
            this.type.put(bundle, name, this.defaultValue);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean verify(@NotNull String name, @NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        if (!this.isNullable && bundle.containsKey(name) && bundle.get(name) == null) {
            return false;
        }
        try {
            this.type.get(bundle, name);
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" Type: " + this.type);
        sb.append(" Nullable: " + this.isNullable);
        if (this.isDefaultValuePresent) {
            sb.append(" DefaultValue: " + this.defaultValue);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        NavArgument that = (NavArgument)other;
        if (this.isNullable != that.isNullable) {
            return false;
        }
        if (this.isDefaultValuePresent != that.isDefaultValuePresent) {
            return false;
        }
        if (!Intrinsics.areEqual(this.type, that.type)) {
            return false;
        }
        return this.defaultValue != null ? Intrinsics.areEqual((Object)this.defaultValue, (Object)that.defaultValue) : that.defaultValue == null;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.isNullable ? 1 : 0);
        result = 31 * result + (this.isDefaultValuePresent ? 1 : 0);
        Object object = this.defaultValue;
        result = 31 * result + (object != null ? object.hashCode() : 0);
        return result;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005J\u001a\u0010\u000e\u001a\u00020\u0000\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u000f0\bJ\u0015\u0010\u0010\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0011R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/navigation/NavArgument$Builder;", "", "()V", "defaultValue", "defaultValuePresent", "", "isNullable", "type", "Landroidx/navigation/NavType;", "unknownDefaultValuePresent", "build", "Landroidx/navigation/NavArgument;", "setDefaultValue", "setIsNullable", "setType", "T", "setUnknownDefaultValuePresent", "setUnknownDefaultValuePresent$navigation_common_release", "navigation-common_release"})
    public static final class Builder {
        @Nullable
        private NavType<Object> type;
        private boolean isNullable;
        @Nullable
        private Object defaultValue;
        private boolean defaultValuePresent;
        private boolean unknownDefaultValuePresent;

        @NotNull
        public final <T> Builder setType(@NotNull NavType<T> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            this.type = type;
            return this;
        }

        @NotNull
        public final Builder setIsNullable(boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        @NotNull
        public final Builder setDefaultValue(@Nullable Object defaultValue) {
            this.defaultValue = defaultValue;
            this.defaultValuePresent = true;
            return this;
        }

        @NotNull
        public final Builder setUnknownDefaultValuePresent$navigation_common_release(boolean unknownDefaultValuePresent) {
            this.unknownDefaultValuePresent = unknownDefaultValuePresent;
            return this;
        }

        @NotNull
        public final NavArgument build() {
            NavType<Object> navType = this.type;
            if (navType == null) {
                NavType<Object> navType2 = NavType.Companion.inferFromValueType(this.defaultValue);
                navType = navType2;
                Intrinsics.checkNotNull(navType2, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any?>");
            }
            NavType<Object> finalType = navType;
            return new NavArgument(finalType, this.isNullable, this.defaultValue, this.defaultValuePresent, this.unknownDefaultValuePresent);
        }
    }
}

