/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.collection.SparseArrayCompat;
import androidx.navigation.NavDeepLinkRequest;
import androidx.navigation.NavDestination;
import androidx.navigation.Navigator;
import androidx.navigation.common.R;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class NavGraph
extends NavDestination
implements Iterable<NavDestination> {
    final SparseArrayCompat<NavDestination> mNodes = new SparseArrayCompat();
    private int mStartDestId;
    private String mStartDestIdName;

    public NavGraph(@NonNull Navigator<? extends NavGraph> navGraphNavigator) {
        super(navGraphNavigator);
    }

    @Override
    public void onInflate(@NonNull Context context, @NonNull AttributeSet attrs) {
        super.onInflate(context, attrs);
        TypedArray a = context.getResources().obtainAttributes(attrs, R.styleable.NavGraphNavigator);
        this.setStartDestination(a.getResourceId(R.styleable.NavGraphNavigator_startDestination, 0));
        this.mStartDestIdName = NavGraph.getDisplayName(context, this.mStartDestId);
        a.recycle();
    }

    @Override
    @Nullable
    NavDestination.DeepLinkMatch matchDeepLink(@NonNull NavDeepLinkRequest request) {
        NavDestination.DeepLinkMatch bestMatch = super.matchDeepLink(request);
        for (NavDestination child : this) {
            NavDestination.DeepLinkMatch childBestMatch = child.matchDeepLink(request);
            if (childBestMatch == null || bestMatch != null && childBestMatch.compareTo(bestMatch) <= 0) continue;
            bestMatch = childBestMatch;
        }
        return bestMatch;
    }

    public final void addDestination(@NonNull NavDestination node) {
        if (node.getId() == 0) {
            throw new IllegalArgumentException("Destinations must have an id. Call setId() or include an android:id in your navigation XML.");
        }
        NavDestination existingDestination = (NavDestination)this.mNodes.get(node.getId());
        if (existingDestination == node) {
            return;
        }
        if (node.getParent() != null) {
            throw new IllegalStateException("Destination already has a parent set. Call NavGraph.remove() to remove the previous parent.");
        }
        if (existingDestination != null) {
            existingDestination.setParent(null);
        }
        node.setParent(this);
        this.mNodes.put(node.getId(), (Object)node);
    }

    public final void addDestinations(@NonNull Collection<NavDestination> nodes) {
        for (NavDestination node : nodes) {
            if (node == null) continue;
            this.addDestination(node);
        }
    }

    public final void addDestinations(NavDestination ... nodes) {
        for (NavDestination node : nodes) {
            if (node == null) continue;
            this.addDestination(node);
        }
    }

    @Nullable
    public final NavDestination findNode(@IdRes int resid) {
        return this.findNode(resid, true);
    }

    @Nullable
    final NavDestination findNode(@IdRes int resid, boolean searchParents) {
        NavDestination destination = (NavDestination)this.mNodes.get(resid);
        return destination != null ? destination : (searchParents && this.getParent() != null ? this.getParent().findNode(resid) : null);
    }

    @Override
    @NonNull
    public final Iterator<NavDestination> iterator() {
        return new Iterator<NavDestination>(){
            private int mIndex = -1;
            private boolean mWentToNext = false;

            @Override
            public boolean hasNext() {
                return this.mIndex + 1 < NavGraph.this.mNodes.size();
            }

            @Override
            public NavDestination next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.mWentToNext = true;
                return (NavDestination)NavGraph.this.mNodes.valueAt(++this.mIndex);
            }

            @Override
            public void remove() {
                if (!this.mWentToNext) {
                    throw new IllegalStateException("You must call next() before you can remove an element");
                }
                ((NavDestination)NavGraph.this.mNodes.valueAt(this.mIndex)).setParent(null);
                NavGraph.this.mNodes.removeAt(this.mIndex);
                --this.mIndex;
                this.mWentToNext = false;
            }
        };
    }

    public final void addAll(@NonNull NavGraph other) {
        Iterator<NavDestination> iterator = other.iterator();
        while (iterator.hasNext()) {
            NavDestination destination = iterator.next();
            iterator.remove();
            this.addDestination(destination);
        }
    }

    public final void remove(@NonNull NavDestination node) {
        int index = this.mNodes.indexOfKey(node.getId());
        if (index >= 0) {
            ((NavDestination)this.mNodes.valueAt(index)).setParent(null);
            this.mNodes.removeAt(index);
        }
    }

    public final void clear() {
        Iterator<NavDestination> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public String getDisplayName() {
        return this.getId() != 0 ? super.getDisplayName() : "the root navigation";
    }

    @IdRes
    public final int getStartDestination() {
        return this.mStartDestId;
    }

    public final void setStartDestination(@IdRes int startDestId) {
        this.mStartDestId = startDestId;
        this.mStartDestIdName = null;
    }

    @NonNull
    String getStartDestDisplayName() {
        if (this.mStartDestIdName == null) {
            this.mStartDestIdName = Integer.toString(this.mStartDestId);
        }
        return this.mStartDestIdName;
    }

    @Override
    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" startDestination=");
        NavDestination startDestination = this.findNode(this.getStartDestination());
        if (startDestination == null) {
            if (this.mStartDestIdName == null) {
                sb.append("0x");
                sb.append(Integer.toHexString(this.mStartDestId));
            } else {
                sb.append(this.mStartDestIdName);
            }
        } else {
            sb.append("{");
            sb.append(startDestination.toString());
            sb.append("}");
        }
        return sb.toString();
    }
}

