/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Bundle;
import android.util.AttributeSet;
import androidx.annotation.CallSuper;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.collection.SparseArrayCompat;
import androidx.navigation.NavAction;
import androidx.navigation.NavArgument;
import androidx.navigation.NavDeepLink;
import androidx.navigation.NavDeepLinkRequest;
import androidx.navigation.NavGraph;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.common.R;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NavDestination {
    private static final HashMap<String, Class<?>> sClasses = new HashMap();
    private final String mNavigatorName;
    private NavGraph mParent;
    private int mId;
    private String mIdName;
    private CharSequence mLabel;
    private ArrayList<NavDeepLink> mDeepLinks;
    private SparseArrayCompat<NavAction> mActions;
    private HashMap<String, NavArgument> mArguments;

    @NonNull
    protected static <C> Class<? extends C> parseClassFromName(@NonNull Context context, @NonNull String name, @NonNull Class<? extends C> expectedClassType) {
        Class<?> clazz;
        if (name.charAt(0) == '.') {
            name = context.getPackageName() + name;
        }
        if ((clazz = sClasses.get(name)) == null) {
            try {
                clazz = Class.forName(name, true, context.getClassLoader());
                sClasses.put(name, clazz);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (!expectedClassType.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(name + " must be a subclass of " + expectedClassType);
        }
        return clazz;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    static String getDisplayName(@NonNull Context context, int id) {
        if (id <= 0xFFFFFF) {
            return Integer.toString(id);
        }
        try {
            return context.getResources().getResourceName(id);
        }
        catch (Resources.NotFoundException e) {
            return Integer.toString(id);
        }
    }

    @NonNull
    public final Map<String, NavArgument> getArguments() {
        return this.mArguments == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.mArguments);
    }

    public NavDestination(@NonNull Navigator<? extends NavDestination> navigator) {
        this(NavigatorProvider.getNameForNavigator(navigator.getClass()));
    }

    public NavDestination(@NonNull String navigatorName) {
        this.mNavigatorName = navigatorName;
    }

    @CallSuper
    public void onInflate(@NonNull Context context, @NonNull AttributeSet attrs) {
        TypedArray a = context.getResources().obtainAttributes(attrs, R.styleable.Navigator);
        this.setId(a.getResourceId(R.styleable.Navigator_android_id, 0));
        this.mIdName = NavDestination.getDisplayName(context, this.mId);
        this.setLabel(a.getText(R.styleable.Navigator_android_label));
        a.recycle();
    }

    final void setParent(NavGraph parent) {
        this.mParent = parent;
    }

    @Nullable
    public final NavGraph getParent() {
        return this.mParent;
    }

    @IdRes
    public final int getId() {
        return this.mId;
    }

    public final void setId(@IdRes int id) {
        this.mId = id;
        this.mIdName = null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public String getDisplayName() {
        if (this.mIdName == null) {
            this.mIdName = Integer.toString(this.mId);
        }
        return this.mIdName;
    }

    public final void setLabel(@Nullable CharSequence label) {
        this.mLabel = label;
    }

    @Nullable
    public final CharSequence getLabel() {
        return this.mLabel;
    }

    @NonNull
    public final String getNavigatorName() {
        return this.mNavigatorName;
    }

    public boolean hasDeepLink(@NonNull Uri deepLink) {
        return this.hasDeepLink(new NavDeepLinkRequest(deepLink, null, null));
    }

    public boolean hasDeepLink(@NonNull NavDeepLinkRequest deepLinkRequest) {
        return this.matchDeepLink(deepLinkRequest) != null;
    }

    public final void addDeepLink(@NonNull String uriPattern) {
        this.addDeepLink(new NavDeepLink.Builder().setUriPattern(uriPattern).build());
    }

    public final void addDeepLink(@NonNull NavDeepLink navDeepLink) {
        if (this.mDeepLinks == null) {
            this.mDeepLinks = new ArrayList();
        }
        this.mDeepLinks.add(navDeepLink);
    }

    @Nullable
    DeepLinkMatch matchDeepLink(@NonNull NavDeepLinkRequest navDeepLinkRequest) {
        if (this.mDeepLinks == null) {
            return null;
        }
        DeepLinkMatch bestMatch = null;
        for (NavDeepLink deepLink : this.mDeepLinks) {
            int mimeTypeMatchLevel;
            Uri uri = navDeepLinkRequest.getUri();
            Bundle matchingArguments = uri != null ? deepLink.getMatchingArguments(uri, this.getArguments()) : null;
            String requestAction = navDeepLinkRequest.getAction();
            boolean matchingAction = requestAction != null && requestAction.equals(deepLink.getAction());
            String mimeType = navDeepLinkRequest.getMimeType();
            int n = mimeTypeMatchLevel = mimeType != null ? deepLink.getMimeTypeMatchRating(mimeType) : -1;
            if (matchingArguments == null && !matchingAction && mimeTypeMatchLevel <= -1) continue;
            DeepLinkMatch newMatch = new DeepLinkMatch(this, matchingArguments, deepLink.isExactDeepLink(), matchingAction, mimeTypeMatchLevel);
            if (bestMatch != null && newMatch.compareTo(bestMatch) <= 0) continue;
            bestMatch = newMatch;
        }
        return bestMatch;
    }

    @NonNull
    int[] buildDeepLinkIds() {
        NavGraph parent;
        ArrayDeque<NavDestination> hierarchy = new ArrayDeque<NavDestination>();
        NavDestination current = this;
        do {
            if ((parent = current.getParent()) != null && parent.getStartDestination() == current.getId()) continue;
            hierarchy.addFirst(current);
        } while ((current = parent) != null);
        int[] deepLinkIds = new int[hierarchy.size()];
        int index = 0;
        for (NavDestination destination : hierarchy) {
            deepLinkIds[index++] = destination.getId();
        }
        return deepLinkIds;
    }

    boolean supportsActions() {
        return true;
    }

    @Nullable
    public final NavAction getAction(@IdRes int id) {
        NavAction destination;
        NavAction navAction = destination = this.mActions == null ? null : (NavAction)this.mActions.get(id);
        return destination != null ? destination : (this.getParent() != null ? this.getParent().getAction(id) : null);
    }

    public final void putAction(@IdRes int actionId, @IdRes int destId) {
        this.putAction(actionId, new NavAction(destId));
    }

    public final void putAction(@IdRes int actionId, @NonNull NavAction action) {
        if (!this.supportsActions()) {
            throw new UnsupportedOperationException("Cannot add action " + actionId + " to " + this + " as it does not support actions, indicating that it is a terminal destination in your navigation graph and will never trigger actions.");
        }
        if (actionId == 0) {
            throw new IllegalArgumentException("Cannot have an action with actionId 0");
        }
        if (this.mActions == null) {
            this.mActions = new SparseArrayCompat();
        }
        this.mActions.put(actionId, (Object)action);
    }

    public final void removeAction(@IdRes int actionId) {
        if (this.mActions == null) {
            return;
        }
        this.mActions.remove(actionId);
    }

    public final void addArgument(@NonNull String argumentName, @NonNull NavArgument argument) {
        if (this.mArguments == null) {
            this.mArguments = new HashMap();
        }
        this.mArguments.put(argumentName, argument);
    }

    public final void removeArgument(@NonNull String argumentName) {
        if (this.mArguments == null) {
            return;
        }
        this.mArguments.remove(argumentName);
    }

    @Nullable
    Bundle addInDefaultArgs(@Nullable Bundle args) {
        if (args == null && (this.mArguments == null || this.mArguments.isEmpty())) {
            return null;
        }
        Bundle defaultArgs = new Bundle();
        if (this.mArguments != null) {
            for (Map.Entry<String, NavArgument> argument : this.mArguments.entrySet()) {
                argument.getValue().putDefaultValue(argument.getKey(), defaultArgs);
            }
        }
        if (args != null) {
            defaultArgs.putAll(args);
            if (this.mArguments != null) {
                for (Map.Entry<String, NavArgument> argument : this.mArguments.entrySet()) {
                    if (argument.getValue().verify(argument.getKey(), args)) continue;
                    throw new IllegalArgumentException("Wrong argument type for '" + argument.getKey() + "' in argument bundle. " + argument.getValue().getType().getName() + " expected.");
                }
            }
        }
        return defaultArgs;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        if (this.mIdName == null) {
            sb.append("0x");
            sb.append(Integer.toHexString(this.mId));
        } else {
            sb.append(this.mIdName);
        }
        sb.append(")");
        if (this.mLabel != null) {
            sb.append(" label=");
            sb.append(this.mLabel);
        }
        return sb.toString();
    }

    static class DeepLinkMatch
    implements Comparable<DeepLinkMatch> {
        @NonNull
        private final NavDestination mDestination;
        @Nullable
        private final Bundle mMatchingArgs;
        private final boolean mIsExactDeepLink;
        private final boolean mHasMatchingAction;
        private final int mMimeTypeMatchLevel;

        DeepLinkMatch(@NonNull NavDestination destination, @Nullable Bundle matchingArgs, boolean isExactDeepLink, boolean hasMatchingAction, int mimeTypeMatchLevel) {
            this.mDestination = destination;
            this.mMatchingArgs = matchingArgs;
            this.mIsExactDeepLink = isExactDeepLink;
            this.mHasMatchingAction = hasMatchingAction;
            this.mMimeTypeMatchLevel = mimeTypeMatchLevel;
        }

        @NonNull
        NavDestination getDestination() {
            return this.mDestination;
        }

        @Nullable
        Bundle getMatchingArgs() {
            return this.mMatchingArgs;
        }

        @Override
        public int compareTo(@NonNull DeepLinkMatch other) {
            if (this.mIsExactDeepLink && !other.mIsExactDeepLink) {
                return 1;
            }
            if (!this.mIsExactDeepLink && other.mIsExactDeepLink) {
                return -1;
            }
            if (this.mMatchingArgs != null && other.mMatchingArgs == null) {
                return 1;
            }
            if (this.mMatchingArgs == null && other.mMatchingArgs != null) {
                return -1;
            }
            if (this.mMatchingArgs != null) {
                int sizeDifference = this.mMatchingArgs.size() - other.mMatchingArgs.size();
                if (sizeDifference > 0) {
                    return 1;
                }
                if (sizeDifference < 0) {
                    return -1;
                }
            }
            if (this.mHasMatchingAction && !other.mHasMatchingAction) {
                return 1;
            }
            if (!this.mHasMatchingAction && other.mHasMatchingAction) {
                return -1;
            }
            return this.mMimeTypeMatchLevel - other.mMimeTypeMatchLevel;
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.TYPE})
    public static @interface ClassType {
        public Class<?> value();
    }
}

