/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import android.widget.LinearLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.TrackSelectionOverride;
import androidx.media3.common.Tracks;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.ui.DefaultTrackNameProvider;
import androidx.media3.ui.R;
import androidx.media3.ui.TrackNameProvider;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@UnstableApi
public class TrackSelectionView
extends LinearLayout {
    private final int selectableItemBackgroundResourceId;
    private final LayoutInflater inflater;
    private final CheckedTextView disableView;
    private final CheckedTextView defaultView;
    private final ComponentListener componentListener;
    private final List<Tracks.Group> trackGroups;
    private final Map<TrackGroup, TrackSelectionOverride> overrides;
    private boolean allowAdaptiveSelections;
    private boolean allowMultipleOverrides;
    private TrackNameProvider trackNameProvider;
    private CheckedTextView[][] trackViews;
    private boolean isDisabled;
    @Nullable
    private Comparator<TrackInfo> trackInfoComparator;
    @Nullable
    private TrackSelectionListener listener;

    public static Map<TrackGroup, TrackSelectionOverride> filterOverrides(Map<TrackGroup, TrackSelectionOverride> overrides, List<Tracks.Group> trackGroups, boolean allowMultipleOverrides) {
        HashMap<TrackGroup, TrackSelectionOverride> filteredOverrides = new HashMap<TrackGroup, TrackSelectionOverride>();
        for (int i = 0; i < trackGroups.size(); ++i) {
            Tracks.Group trackGroup = trackGroups.get(i);
            TrackSelectionOverride override = overrides.get(trackGroup.getMediaTrackGroup());
            if (override == null || !allowMultipleOverrides && !filteredOverrides.isEmpty()) continue;
            filteredOverrides.put(override.mediaTrackGroup, override);
        }
        return filteredOverrides;
    }

    public TrackSelectionView(Context context) {
        this(context, null);
    }

    public TrackSelectionView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TrackSelectionView(Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        this.setSaveFromParentEnabled(false);
        TypedArray attributeArray = context.getTheme().obtainStyledAttributes(new int[]{16843534});
        this.selectableItemBackgroundResourceId = attributeArray.getResourceId(0, 0);
        attributeArray.recycle();
        this.inflater = LayoutInflater.from((Context)context);
        this.componentListener = new ComponentListener();
        this.trackNameProvider = new DefaultTrackNameProvider(this.getResources());
        this.trackGroups = new ArrayList<Tracks.Group>();
        this.overrides = new HashMap<TrackGroup, TrackSelectionOverride>();
        this.disableView = (CheckedTextView)this.inflater.inflate(17367055, (ViewGroup)this, false);
        this.disableView.setBackgroundResource(this.selectableItemBackgroundResourceId);
        this.disableView.setText(R.string.exo_track_selection_none);
        this.disableView.setEnabled(false);
        this.disableView.setFocusable(true);
        this.disableView.setOnClickListener((View.OnClickListener)this.componentListener);
        this.disableView.setVisibility(8);
        this.addView((View)this.disableView);
        this.addView(this.inflater.inflate(R.layout.exo_list_divider, (ViewGroup)this, false));
        this.defaultView = (CheckedTextView)this.inflater.inflate(17367055, (ViewGroup)this, false);
        this.defaultView.setBackgroundResource(this.selectableItemBackgroundResourceId);
        this.defaultView.setText(R.string.exo_track_selection_auto);
        this.defaultView.setEnabled(false);
        this.defaultView.setFocusable(true);
        this.defaultView.setOnClickListener((View.OnClickListener)this.componentListener);
        this.addView((View)this.defaultView);
    }

    public void setAllowAdaptiveSelections(boolean allowAdaptiveSelections) {
        if (this.allowAdaptiveSelections != allowAdaptiveSelections) {
            this.allowAdaptiveSelections = allowAdaptiveSelections;
            this.updateViews();
        }
    }

    public void setAllowMultipleOverrides(boolean allowMultipleOverrides) {
        if (this.allowMultipleOverrides != allowMultipleOverrides) {
            this.allowMultipleOverrides = allowMultipleOverrides;
            if (!allowMultipleOverrides && this.overrides.size() > 1) {
                Map<TrackGroup, TrackSelectionOverride> filteredOverrides = TrackSelectionView.filterOverrides(this.overrides, this.trackGroups, false);
                this.overrides.clear();
                this.overrides.putAll(filteredOverrides);
            }
            this.updateViews();
        }
    }

    public void setShowDisableOption(boolean showDisableOption) {
        this.disableView.setVisibility(showDisableOption ? 0 : 8);
    }

    public void setTrackNameProvider(TrackNameProvider trackNameProvider) {
        this.trackNameProvider = (TrackNameProvider)Assertions.checkNotNull((Object)trackNameProvider);
        this.updateViews();
    }

    public void init(List<Tracks.Group> trackGroups, boolean isDisabled, Map<TrackGroup, TrackSelectionOverride> overrides, @Nullable Comparator<Format> trackFormatComparator, @Nullable TrackSelectionListener listener) {
        this.isDisabled = isDisabled;
        this.trackInfoComparator = trackFormatComparator == null ? null : (o1, o2) -> trackFormatComparator.compare(o1.getFormat(), o2.getFormat());
        this.listener = listener;
        this.trackGroups.clear();
        this.trackGroups.addAll(trackGroups);
        this.overrides.clear();
        this.overrides.putAll(TrackSelectionView.filterOverrides(overrides, trackGroups, this.allowMultipleOverrides));
        this.updateViews();
    }

    public boolean getIsDisabled() {
        return this.isDisabled;
    }

    public Map<TrackGroup, TrackSelectionOverride> getOverrides() {
        return this.overrides;
    }

    private void updateViews() {
        for (int i = this.getChildCount() - 1; i >= 3; --i) {
            this.removeViewAt(i);
        }
        if (this.trackGroups.isEmpty()) {
            this.disableView.setEnabled(false);
            this.defaultView.setEnabled(false);
            return;
        }
        this.disableView.setEnabled(true);
        this.defaultView.setEnabled(true);
        this.trackViews = new CheckedTextView[this.trackGroups.size()][];
        boolean enableMultipleChoiceForMultipleOverrides = this.shouldEnableMultiGroupSelection();
        for (int trackGroupIndex = 0; trackGroupIndex < this.trackGroups.size(); ++trackGroupIndex) {
            int trackIndex;
            Tracks.Group trackGroup = this.trackGroups.get(trackGroupIndex);
            boolean enableMultipleChoiceForAdaptiveSelections = this.shouldEnableAdaptiveSelection(trackGroup);
            this.trackViews[trackGroupIndex] = new CheckedTextView[trackGroup.length];
            TrackInfo[] trackInfos = new TrackInfo[trackGroup.length];
            for (trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                trackInfos[trackIndex] = new TrackInfo(trackGroup, trackIndex);
            }
            if (this.trackInfoComparator != null) {
                Arrays.sort(trackInfos, this.trackInfoComparator);
            }
            for (trackIndex = 0; trackIndex < trackInfos.length; ++trackIndex) {
                if (trackIndex == 0) {
                    this.addView(this.inflater.inflate(R.layout.exo_list_divider, (ViewGroup)this, false));
                }
                int trackViewLayoutId = enableMultipleChoiceForAdaptiveSelections || enableMultipleChoiceForMultipleOverrides ? 0x1090010 : 17367055;
                CheckedTextView trackView = (CheckedTextView)this.inflater.inflate(trackViewLayoutId, (ViewGroup)this, false);
                trackView.setBackgroundResource(this.selectableItemBackgroundResourceId);
                trackView.setText((CharSequence)this.trackNameProvider.getTrackName(trackInfos[trackIndex].getFormat()));
                trackView.setTag((Object)trackInfos[trackIndex]);
                if (trackGroup.isTrackSupported(trackIndex)) {
                    trackView.setFocusable(true);
                    trackView.setOnClickListener((View.OnClickListener)this.componentListener);
                } else {
                    trackView.setFocusable(false);
                    trackView.setEnabled(false);
                }
                this.trackViews[trackGroupIndex][trackIndex] = trackView;
                this.addView((View)trackView);
            }
        }
        this.updateViewStates();
    }

    private void updateViewStates() {
        this.disableView.setChecked(this.isDisabled);
        this.defaultView.setChecked(!this.isDisabled && this.overrides.size() == 0);
        for (int i = 0; i < this.trackViews.length; ++i) {
            TrackSelectionOverride override = this.overrides.get(this.trackGroups.get(i).getMediaTrackGroup());
            for (int j = 0; j < this.trackViews[i].length; ++j) {
                if (override != null) {
                    TrackInfo trackInfo = (TrackInfo)Assertions.checkNotNull((Object)this.trackViews[i][j].getTag());
                    this.trackViews[i][j].setChecked(override.trackIndices.contains((Object)trackInfo.trackIndex));
                    continue;
                }
                this.trackViews[i][j].setChecked(false);
            }
        }
    }

    private void onClick(View view) {
        if (view == this.disableView) {
            this.onDisableViewClicked();
        } else if (view == this.defaultView) {
            this.onDefaultViewClicked();
        } else {
            this.onTrackViewClicked(view);
        }
        this.updateViewStates();
        if (this.listener != null) {
            this.listener.onTrackSelectionChanged(this.getIsDisabled(), this.getOverrides());
        }
    }

    private void onDisableViewClicked() {
        this.isDisabled = true;
        this.overrides.clear();
    }

    private void onDefaultViewClicked() {
        this.isDisabled = false;
        this.overrides.clear();
    }

    private void onTrackViewClicked(View view) {
        this.isDisabled = false;
        TrackInfo trackInfo = (TrackInfo)Assertions.checkNotNull((Object)view.getTag());
        TrackGroup mediaTrackGroup = trackInfo.trackGroup.getMediaTrackGroup();
        int trackIndex = trackInfo.trackIndex;
        TrackSelectionOverride override = this.overrides.get(mediaTrackGroup);
        if (override == null) {
            if (!this.allowMultipleOverrides && this.overrides.size() > 0) {
                this.overrides.clear();
            }
            this.overrides.put(mediaTrackGroup, new TrackSelectionOverride(mediaTrackGroup, (List)ImmutableList.of((Object)trackIndex)));
        } else {
            boolean isUsingCheckBox;
            ArrayList<Integer> trackIndices = new ArrayList<Integer>((Collection<Integer>)override.trackIndices);
            boolean isCurrentlySelected = ((CheckedTextView)view).isChecked();
            boolean isAdaptiveAllowed = this.shouldEnableAdaptiveSelection(trackInfo.trackGroup);
            boolean bl = isUsingCheckBox = isAdaptiveAllowed || this.shouldEnableMultiGroupSelection();
            if (isCurrentlySelected && isUsingCheckBox) {
                trackIndices.remove((Object)trackIndex);
                if (trackIndices.isEmpty()) {
                    this.overrides.remove(mediaTrackGroup);
                } else {
                    this.overrides.put(mediaTrackGroup, new TrackSelectionOverride(mediaTrackGroup, trackIndices));
                }
            } else if (!isCurrentlySelected) {
                if (isAdaptiveAllowed) {
                    trackIndices.add(trackIndex);
                    this.overrides.put(mediaTrackGroup, new TrackSelectionOverride(mediaTrackGroup, trackIndices));
                } else {
                    this.overrides.put(mediaTrackGroup, new TrackSelectionOverride(mediaTrackGroup, (List)ImmutableList.of((Object)trackIndex)));
                }
            }
        }
    }

    private boolean shouldEnableAdaptiveSelection(Tracks.Group trackGroup) {
        return this.allowAdaptiveSelections && trackGroup.isAdaptiveSupported();
    }

    private boolean shouldEnableMultiGroupSelection() {
        return this.allowMultipleOverrides && this.trackGroups.size() > 1;
    }

    private class ComponentListener
    implements View.OnClickListener {
        private ComponentListener() {
        }

        public void onClick(View view) {
            TrackSelectionView.this.onClick(view);
        }
    }

    public static interface TrackSelectionListener {
        public void onTrackSelectionChanged(boolean var1, Map<TrackGroup, TrackSelectionOverride> var2);
    }

    private static final class TrackInfo {
        public final Tracks.Group trackGroup;
        public final int trackIndex;

        public TrackInfo(Tracks.Group trackGroup, int trackIndex) {
            this.trackGroup = trackGroup;
            this.trackIndex = trackIndex;
        }

        public Format getFormat() {
            return this.trackGroup.getTrackFormat(this.trackIndex);
        }
    }
}

