/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.ts;

import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.TimestampAdjuster;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.TrackOutput;
import androidx.media3.extractor.ts.SectionPayloadReader;
import androidx.media3.extractor.ts.TsPayloadReader;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public final class PassthroughSectionPayloadReader
implements SectionPayloadReader {
    private Format format;
    private @MonotonicNonNull TimestampAdjuster timestampAdjuster;
    private @MonotonicNonNull TrackOutput output;

    public PassthroughSectionPayloadReader(String mimeType) {
        this.format = new Format.Builder().setSampleMimeType(mimeType).build();
    }

    @Override
    public void init(TimestampAdjuster timestampAdjuster, ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        this.timestampAdjuster = timestampAdjuster;
        idGenerator.generateNewId();
        this.output = extractorOutput.track(idGenerator.getTrackId(), 5);
        this.output.format(this.format);
    }

    @Override
    public void consume(ParsableByteArray sectionData) {
        this.assertInitialized();
        long sampleTimestampUs = this.timestampAdjuster.getLastAdjustedTimestampUs();
        long subsampleOffsetUs = this.timestampAdjuster.getTimestampOffsetUs();
        if (sampleTimestampUs == -9223372036854775807L || subsampleOffsetUs == -9223372036854775807L) {
            return;
        }
        if (subsampleOffsetUs != this.format.subsampleOffsetUs) {
            this.format = this.format.buildUpon().setSubsampleOffsetUs(subsampleOffsetUs).build();
            this.output.format(this.format);
        }
        int sampleSize = sectionData.bytesLeft();
        this.output.sampleData(sectionData, sampleSize);
        this.output.sampleMetadata(sampleTimestampUs, 1, sampleSize, 0, null);
    }

    @EnsuresNonNull(value={"timestampAdjuster", "output"})
    private void assertInitialized() {
        Assertions.checkStateNotNull((Object)this.timestampAdjuster);
        Util.castNonNull((Object)this.output);
    }
}

