/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.ts;

import androidx.annotation.Nullable;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.CodecSpecificDataUtil;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.container.NalUnitUtil;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.TrackOutput;
import androidx.media3.extractor.ts.ElementaryStreamReader;
import androidx.media3.extractor.ts.NalUnitTargetBuffer;
import androidx.media3.extractor.ts.SeiReader;
import androidx.media3.extractor.ts.TsPayloadReader;
import com.google.common.base.Preconditions;
import java.util.Collections;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@UnstableApi
public final class H265Reader
implements ElementaryStreamReader {
    private final SeiReader seiReader;
    private @MonotonicNonNull String formatId;
    private @MonotonicNonNull TrackOutput output;
    private @MonotonicNonNull SampleReader sampleReader;
    private boolean hasOutputFormat;
    private final boolean[] prefixFlags;
    private final NalUnitTargetBuffer vps;
    private final NalUnitTargetBuffer sps;
    private final NalUnitTargetBuffer pps;
    private final NalUnitTargetBuffer prefixSei;
    private final NalUnitTargetBuffer suffixSei;
    private long totalBytesWritten;
    private long pesTimeUs;
    private final ParsableByteArray seiWrapper;

    public H265Reader(SeiReader seiReader) {
        this.seiReader = seiReader;
        this.prefixFlags = new boolean[3];
        this.vps = new NalUnitTargetBuffer(32, 128);
        this.sps = new NalUnitTargetBuffer(33, 128);
        this.pps = new NalUnitTargetBuffer(34, 128);
        this.prefixSei = new NalUnitTargetBuffer(39, 128);
        this.suffixSei = new NalUnitTargetBuffer(40, 128);
        this.pesTimeUs = -9223372036854775807L;
        this.seiWrapper = new ParsableByteArray();
    }

    @Override
    public void seek() {
        this.totalBytesWritten = 0L;
        this.pesTimeUs = -9223372036854775807L;
        NalUnitUtil.clearPrefixFlags((boolean[])this.prefixFlags);
        this.vps.reset();
        this.sps.reset();
        this.pps.reset();
        this.prefixSei.reset();
        this.suffixSei.reset();
        this.seiReader.flush();
        if (this.sampleReader != null) {
            this.sampleReader.reset();
        }
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        idGenerator.generateNewId();
        this.formatId = idGenerator.getFormatId();
        this.output = extractorOutput.track(idGenerator.getTrackId(), 2);
        this.sampleReader = new SampleReader(this.output);
        this.seiReader.createTracks(extractorOutput, idGenerator);
    }

    @Override
    public void packetStarted(long pesTimeUs, int flags) {
        this.pesTimeUs = pesTimeUs;
    }

    @Override
    public void consume(ParsableByteArray data) {
        this.assertTracksCreated();
        while (data.bytesLeft() > 0) {
            int offset = data.getPosition();
            int limit = data.limit();
            byte[] dataArray = data.getData();
            this.totalBytesWritten += (long)data.bytesLeft();
            this.output.sampleData(data, data.bytesLeft());
            while (offset < limit) {
                int nalUnitOffset = NalUnitUtil.findNalUnit((byte[])dataArray, (int)offset, (int)limit, (boolean[])this.prefixFlags);
                if (nalUnitOffset == limit) {
                    this.nalUnitData(dataArray, offset, limit);
                    return;
                }
                int nalUnitType = NalUnitUtil.getH265NalUnitType((byte[])dataArray, (int)nalUnitOffset);
                int lengthToNalUnit = nalUnitOffset - offset;
                if (lengthToNalUnit > 0) {
                    this.nalUnitData(dataArray, offset, nalUnitOffset);
                }
                int bytesWrittenPastPosition = limit - nalUnitOffset;
                long absolutePosition = this.totalBytesWritten - (long)bytesWrittenPastPosition;
                this.endNalUnit(absolutePosition, bytesWrittenPastPosition, lengthToNalUnit < 0 ? -lengthToNalUnit : 0, this.pesTimeUs);
                this.startNalUnit(absolutePosition, bytesWrittenPastPosition, nalUnitType, this.pesTimeUs);
                offset = nalUnitOffset + 3;
            }
        }
    }

    @Override
    public void packetFinished(boolean isEndOfInput) {
        this.assertTracksCreated();
        if (isEndOfInput) {
            this.seiReader.flush();
            this.sampleReader.end(this.totalBytesWritten);
        }
    }

    @RequiresNonNull(value={"sampleReader"})
    private void startNalUnit(long position, int offset, int nalUnitType, long pesTimeUs) {
        this.sampleReader.startNalUnit(position, offset, nalUnitType, pesTimeUs, this.hasOutputFormat);
        if (!this.hasOutputFormat) {
            this.vps.startNalUnit(nalUnitType);
            this.sps.startNalUnit(nalUnitType);
            this.pps.startNalUnit(nalUnitType);
        }
        this.prefixSei.startNalUnit(nalUnitType);
        this.suffixSei.startNalUnit(nalUnitType);
    }

    @RequiresNonNull(value={"sampleReader"})
    private void nalUnitData(byte[] dataArray, int offset, int limit) {
        this.sampleReader.readNalUnitData(dataArray, offset, limit);
        if (!this.hasOutputFormat) {
            this.vps.appendToNalUnit(dataArray, offset, limit);
            this.sps.appendToNalUnit(dataArray, offset, limit);
            this.pps.appendToNalUnit(dataArray, offset, limit);
        }
        this.prefixSei.appendToNalUnit(dataArray, offset, limit);
        this.suffixSei.appendToNalUnit(dataArray, offset, limit);
    }

    @RequiresNonNull(value={"output", "sampleReader"})
    private void endNalUnit(long position, int offset, int discardPadding, long pesTimeUs) {
        this.sampleReader.endNalUnit(position, offset, this.hasOutputFormat);
        if (!this.hasOutputFormat) {
            this.vps.endNalUnit(discardPadding);
            this.sps.endNalUnit(discardPadding);
            this.pps.endNalUnit(discardPadding);
            if (this.vps.isCompleted() && this.sps.isCompleted() && this.pps.isCompleted()) {
                Format format = H265Reader.parseMediaFormat(this.formatId, this.vps, this.sps, this.pps);
                this.output.format(format);
                Preconditions.checkState((format.maxNumReorderSamples != -1 ? 1 : 0) != 0);
                this.seiReader.setReorderingQueueSize(format.maxNumReorderSamples);
                this.hasOutputFormat = true;
            }
        }
        if (this.prefixSei.endNalUnit(discardPadding)) {
            int unescapedLength = NalUnitUtil.unescapeStream((byte[])this.prefixSei.nalData, (int)this.prefixSei.nalLength);
            this.seiWrapper.reset(this.prefixSei.nalData, unescapedLength);
            this.seiWrapper.skipBytes(5);
            this.seiReader.consume(pesTimeUs, this.seiWrapper);
        }
        if (this.suffixSei.endNalUnit(discardPadding)) {
            int unescapedLength = NalUnitUtil.unescapeStream((byte[])this.suffixSei.nalData, (int)this.suffixSei.nalLength);
            this.seiWrapper.reset(this.suffixSei.nalData, unescapedLength);
            this.seiWrapper.skipBytes(5);
            this.seiReader.consume(pesTimeUs, this.seiWrapper);
        }
    }

    private static Format parseMediaFormat(@Nullable String formatId, NalUnitTargetBuffer vps, NalUnitTargetBuffer sps, NalUnitTargetBuffer pps) {
        byte[] csdData = new byte[vps.nalLength + sps.nalLength + pps.nalLength];
        System.arraycopy(vps.nalData, 0, csdData, 0, vps.nalLength);
        System.arraycopy(sps.nalData, 0, csdData, vps.nalLength, sps.nalLength);
        System.arraycopy(pps.nalData, 0, csdData, vps.nalLength + sps.nalLength, pps.nalLength);
        NalUnitUtil.H265SpsData spsData = NalUnitUtil.parseH265SpsNalUnit((byte[])sps.nalData, (int)3, (int)sps.nalLength, null);
        String codecs = null;
        if (spsData.profileTierLevel != null) {
            codecs = CodecSpecificDataUtil.buildHevcCodecString((int)spsData.profileTierLevel.generalProfileSpace, (boolean)spsData.profileTierLevel.generalTierFlag, (int)spsData.profileTierLevel.generalProfileIdc, (int)spsData.profileTierLevel.generalProfileCompatibilityFlags, (int[])spsData.profileTierLevel.constraintBytes, (int)spsData.profileTierLevel.generalLevelIdc);
        }
        return new Format.Builder().setId(formatId).setSampleMimeType("video/hevc").setCodecs(codecs).setWidth(spsData.width).setHeight(spsData.height).setColorInfo(new ColorInfo.Builder().setColorSpace(spsData.colorSpace).setColorRange(spsData.colorRange).setColorTransfer(spsData.colorTransfer).setLumaBitdepth(spsData.bitDepthLumaMinus8 + 8).setChromaBitdepth(spsData.bitDepthChromaMinus8 + 8).build()).setPixelWidthHeightRatio(spsData.pixelWidthHeightRatio).setMaxNumReorderSamples(spsData.maxNumReorderPics).setInitializationData(Collections.singletonList(csdData)).build();
    }

    @EnsuresNonNull(value={"output", "sampleReader"})
    private void assertTracksCreated() {
        Assertions.checkStateNotNull((Object)this.output);
        Util.castNonNull((Object)this.sampleReader);
    }

    private static final class SampleReader {
        private static final int FIRST_SLICE_FLAG_OFFSET = 2;
        private final TrackOutput output;
        private long nalUnitPosition;
        private boolean nalUnitHasKeyframeData;
        private int nalUnitBytesRead;
        private long nalUnitTimeUs;
        private boolean lookingForFirstSliceFlag;
        private boolean isFirstSlice;
        private boolean isFirstPrefixNalUnit;
        private boolean readingSample;
        private boolean readingPrefix;
        private long samplePosition;
        private long sampleTimeUs;
        private boolean sampleIsKeyframe;

        public SampleReader(TrackOutput output) {
            this.output = output;
        }

        public void reset() {
            this.lookingForFirstSliceFlag = false;
            this.isFirstSlice = false;
            this.isFirstPrefixNalUnit = false;
            this.readingSample = false;
            this.readingPrefix = false;
        }

        public void startNalUnit(long position, int offset, int nalUnitType, long pesTimeUs, boolean hasOutputFormat) {
            this.isFirstSlice = false;
            this.isFirstPrefixNalUnit = false;
            this.nalUnitTimeUs = pesTimeUs;
            this.nalUnitBytesRead = 0;
            this.nalUnitPosition = position;
            if (!SampleReader.isVclBodyNalUnit(nalUnitType)) {
                if (this.readingSample && !this.readingPrefix) {
                    if (hasOutputFormat) {
                        this.outputSample(offset);
                    }
                    this.readingSample = false;
                }
                if (SampleReader.isPrefixNalUnit(nalUnitType)) {
                    this.isFirstPrefixNalUnit = !this.readingPrefix;
                    this.readingPrefix = true;
                }
            }
            this.nalUnitHasKeyframeData = nalUnitType >= 16 && nalUnitType <= 21;
            this.lookingForFirstSliceFlag = this.nalUnitHasKeyframeData || nalUnitType <= 9;
        }

        public void readNalUnitData(byte[] data, int offset, int limit) {
            if (this.lookingForFirstSliceFlag) {
                int headerOffset = offset + 2 - this.nalUnitBytesRead;
                if (headerOffset < limit) {
                    this.isFirstSlice = (data[headerOffset] & 0x80) != 0;
                    this.lookingForFirstSliceFlag = false;
                } else {
                    this.nalUnitBytesRead += limit - offset;
                }
            }
        }

        public void endNalUnit(long position, int offset, boolean hasOutputFormat) {
            if (this.readingPrefix && this.isFirstSlice) {
                this.sampleIsKeyframe = this.nalUnitHasKeyframeData;
                this.readingPrefix = false;
            } else if (this.isFirstPrefixNalUnit || this.isFirstSlice) {
                if (hasOutputFormat && this.readingSample) {
                    int nalUnitLength = (int)(position - this.nalUnitPosition);
                    this.outputSample(offset + nalUnitLength);
                }
                this.samplePosition = this.nalUnitPosition;
                this.sampleTimeUs = this.nalUnitTimeUs;
                this.sampleIsKeyframe = this.nalUnitHasKeyframeData;
                this.readingSample = true;
            }
        }

        public void end(long position) {
            this.sampleIsKeyframe = this.nalUnitHasKeyframeData;
            this.outputSample((int)(position - this.nalUnitPosition));
            this.samplePosition = this.nalUnitPosition;
            this.nalUnitPosition = position;
            this.outputSample(0);
            this.readingSample = false;
        }

        private void outputSample(int offset) {
            if (this.sampleTimeUs == -9223372036854775807L) {
                return;
            }
            int flags = this.sampleIsKeyframe ? 1 : 0;
            int size = (int)(this.nalUnitPosition - this.samplePosition);
            this.output.sampleMetadata(this.sampleTimeUs, flags, size, offset, null);
        }

        private static boolean isPrefixNalUnit(int nalUnitType) {
            return 32 <= nalUnitType && nalUnitType <= 35 || nalUnitType == 39;
        }

        private static boolean isVclBodyNalUnit(int nalUnitType) {
            return nalUnitType < 32 || nalUnitType == 40;
        }
    }
}

