/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text.cea;

import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Util;
import androidx.media3.decoder.DecoderOutputBuffer;
import androidx.media3.extractor.text.Subtitle;
import androidx.media3.extractor.text.SubtitleDecoder;
import androidx.media3.extractor.text.SubtitleDecoderException;
import androidx.media3.extractor.text.SubtitleInputBuffer;
import androidx.media3.extractor.text.SubtitleOutputBuffer;
import java.util.ArrayDeque;

abstract class CeaDecoder
implements SubtitleDecoder {
    private static final int NUM_INPUT_BUFFERS = 10;
    private static final int NUM_OUTPUT_BUFFERS = 2;
    private final ArrayDeque<CeaInputBuffer> availableInputBuffers = new ArrayDeque();
    private final ArrayDeque<SubtitleOutputBuffer> availableOutputBuffers;
    private final ArrayDeque<CeaInputBuffer> queuedInputBuffers;
    @Nullable
    private CeaInputBuffer dequeuedInputBuffer;
    private long playbackPositionUs;
    private long queuedInputBufferCount;
    private long outputStartTimeUs;

    public CeaDecoder() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.availableInputBuffers.add(new CeaInputBuffer());
        }
        this.availableOutputBuffers = new ArrayDeque();
        for (i = 0; i < 2; ++i) {
            this.availableOutputBuffers.add(new CeaOutputBuffer((DecoderOutputBuffer.Owner<CeaOutputBuffer>)((DecoderOutputBuffer.Owner)this::releaseOutputBuffer)));
        }
        this.queuedInputBuffers = new ArrayDeque();
        this.outputStartTimeUs = -9223372036854775807L;
    }

    public abstract String getName();

    public final void setOutputStartTimeUs(long outputStartTimeUs) {
        this.outputStartTimeUs = outputStartTimeUs;
    }

    @Override
    public void setPositionUs(long positionUs) {
        this.playbackPositionUs = positionUs;
    }

    @Nullable
    public SubtitleInputBuffer dequeueInputBuffer() throws SubtitleDecoderException {
        Assertions.checkState((this.dequeuedInputBuffer == null ? 1 : 0) != 0);
        if (this.availableInputBuffers.isEmpty()) {
            return null;
        }
        this.dequeuedInputBuffer = this.availableInputBuffers.pollFirst();
        return this.dequeuedInputBuffer;
    }

    public void queueInputBuffer(SubtitleInputBuffer inputBuffer) throws SubtitleDecoderException {
        Assertions.checkArgument((inputBuffer == this.dequeuedInputBuffer ? 1 : 0) != 0);
        CeaInputBuffer ceaInputBuffer = (CeaInputBuffer)inputBuffer;
        if (ceaInputBuffer.timeUs != Long.MIN_VALUE && this.outputStartTimeUs != -9223372036854775807L && ceaInputBuffer.timeUs < this.outputStartTimeUs) {
            this.releaseInputBuffer(ceaInputBuffer);
        } else {
            ceaInputBuffer.queuedInputBufferCount = this.queuedInputBufferCount++;
            this.queuedInputBuffers.add(ceaInputBuffer);
        }
        this.dequeuedInputBuffer = null;
    }

    @Nullable
    public SubtitleOutputBuffer dequeueOutputBuffer() throws SubtitleDecoderException {
        if (this.availableOutputBuffers.isEmpty()) {
            return null;
        }
        while (!this.queuedInputBuffers.isEmpty() && ((CeaInputBuffer)Util.castNonNull((Object)this.queuedInputBuffers.peek())).timeUs <= this.playbackPositionUs) {
            CeaInputBuffer inputBuffer = (CeaInputBuffer)Util.castNonNull((Object)this.queuedInputBuffers.poll());
            if (inputBuffer.isEndOfStream()) {
                SubtitleOutputBuffer outputBuffer = (SubtitleOutputBuffer)Util.castNonNull((Object)this.availableOutputBuffers.pollFirst());
                outputBuffer.addFlag(4);
                this.releaseInputBuffer(inputBuffer);
                return outputBuffer;
            }
            this.decode(inputBuffer);
            if (this.isNewSubtitleDataAvailable()) {
                Subtitle subtitle = this.createSubtitle();
                SubtitleOutputBuffer outputBuffer = (SubtitleOutputBuffer)Util.castNonNull((Object)this.availableOutputBuffers.pollFirst());
                outputBuffer.setContent(inputBuffer.timeUs, subtitle, Long.MAX_VALUE);
                this.releaseInputBuffer(inputBuffer);
                return outputBuffer;
            }
            this.releaseInputBuffer(inputBuffer);
        }
        return null;
    }

    private void releaseInputBuffer(CeaInputBuffer inputBuffer) {
        inputBuffer.clear();
        this.availableInputBuffers.add(inputBuffer);
    }

    protected void releaseOutputBuffer(SubtitleOutputBuffer outputBuffer) {
        outputBuffer.clear();
        this.availableOutputBuffers.add(outputBuffer);
    }

    public void flush() {
        this.queuedInputBufferCount = 0L;
        this.playbackPositionUs = 0L;
        while (!this.queuedInputBuffers.isEmpty()) {
            this.releaseInputBuffer((CeaInputBuffer)Util.castNonNull((Object)this.queuedInputBuffers.poll()));
        }
        if (this.dequeuedInputBuffer != null) {
            this.releaseInputBuffer(this.dequeuedInputBuffer);
            this.dequeuedInputBuffer = null;
        }
    }

    public void release() {
    }

    protected abstract boolean isNewSubtitleDataAvailable();

    protected abstract Subtitle createSubtitle();

    protected abstract void decode(SubtitleInputBuffer var1);

    @Nullable
    protected final SubtitleOutputBuffer getAvailableOutputBuffer() {
        return this.availableOutputBuffers.pollFirst();
    }

    protected final long getPositionUs() {
        return this.playbackPositionUs;
    }

    private static final class CeaInputBuffer
    extends SubtitleInputBuffer
    implements Comparable<CeaInputBuffer> {
        private long queuedInputBufferCount;

        private CeaInputBuffer() {
        }

        @Override
        public int compareTo(CeaInputBuffer other) {
            if (this.isEndOfStream() != other.isEndOfStream()) {
                return this.isEndOfStream() ? 1 : -1;
            }
            long delta = this.timeUs - other.timeUs;
            if (delta == 0L && (delta = this.queuedInputBufferCount - other.queuedInputBufferCount) == 0L) {
                return 0;
            }
            return delta > 0L ? 1 : -1;
        }
    }

    private static final class CeaOutputBuffer
    extends SubtitleOutputBuffer {
        private DecoderOutputBuffer.Owner<CeaOutputBuffer> owner;

        public CeaOutputBuffer(DecoderOutputBuffer.Owner<CeaOutputBuffer> owner) {
            this.owner = owner;
        }

        public final void release() {
            this.owner.releaseOutputBuffer((DecoderOutputBuffer)this);
        }
    }
}

