/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.mp4;

import androidx.annotation.Nullable;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.mp4.BoxParser;
import java.nio.ByteBuffer;
import java.util.UUID;

@UnstableApi
public final class PsshAtomUtil {
    private static final String TAG = "PsshAtomUtil";

    private PsshAtomUtil() {
    }

    public static byte[] buildPsshAtom(UUID systemId, @Nullable byte[] data) {
        return PsshAtomUtil.buildPsshAtom(systemId, null, data);
    }

    public static byte[] buildPsshAtom(UUID systemId, @Nullable UUID[] keyIds, @Nullable byte[] data) {
        int dataLength = data != null ? data.length : 0;
        int psshBoxLength = 32 + dataLength;
        if (keyIds != null) {
            psshBoxLength += 4 + keyIds.length * 16;
        }
        ByteBuffer psshBox = ByteBuffer.allocate(psshBoxLength);
        psshBox.putInt(psshBoxLength);
        psshBox.putInt(1886614376);
        psshBox.putInt(keyIds != null ? 0x1000000 : 0);
        psshBox.putLong(systemId.getMostSignificantBits());
        psshBox.putLong(systemId.getLeastSignificantBits());
        if (keyIds != null) {
            psshBox.putInt(keyIds.length);
            for (UUID keyId : keyIds) {
                psshBox.putLong(keyId.getMostSignificantBits());
                psshBox.putLong(keyId.getLeastSignificantBits());
            }
        }
        if (data != null && data.length != 0) {
            psshBox.putInt(data.length);
            psshBox.put(data);
        } else {
            psshBox.putInt(0);
        }
        return psshBox.array();
    }

    public static boolean isPsshAtom(byte[] data) {
        return PsshAtomUtil.parsePsshAtom(data) != null;
    }

    @Nullable
    public static UUID parseUuid(byte[] atom) {
        PsshAtom parsedAtom = PsshAtomUtil.parsePsshAtom(atom);
        if (parsedAtom == null) {
            return null;
        }
        return parsedAtom.uuid;
    }

    public static int parseVersion(byte[] atom) {
        PsshAtom parsedAtom = PsshAtomUtil.parsePsshAtom(atom);
        if (parsedAtom == null) {
            return -1;
        }
        return parsedAtom.version;
    }

    @Nullable
    public static byte[] parseSchemeSpecificData(byte[] atom, UUID uuid) {
        PsshAtom parsedAtom = PsshAtomUtil.parsePsshAtom(atom);
        if (parsedAtom == null) {
            return null;
        }
        if (!uuid.equals(parsedAtom.uuid)) {
            Log.w((String)TAG, (String)("UUID mismatch. Expected: " + uuid + ", got: " + parsedAtom.uuid + "."));
            return null;
        }
        return parsedAtom.schemeData;
    }

    @Nullable
    public static PsshAtom parsePsshAtom(byte[] atom) {
        int dataSize;
        ParsableByteArray atomData = new ParsableByteArray(atom);
        if (atomData.limit() < 32) {
            return null;
        }
        atomData.setPosition(0);
        int bufferLength = atomData.bytesLeft();
        int atomSize = atomData.readInt();
        if (atomSize != bufferLength) {
            Log.w((String)TAG, (String)("Advertised atom size (" + atomSize + ") does not match buffer size: " + bufferLength));
            return null;
        }
        int atomType = atomData.readInt();
        if (atomType != 1886614376) {
            Log.w((String)TAG, (String)("Atom type is not pssh: " + atomType));
            return null;
        }
        int atomVersion = BoxParser.parseFullBoxVersion(atomData.readInt());
        if (atomVersion > 1) {
            Log.w((String)TAG, (String)("Unsupported pssh version: " + atomVersion));
            return null;
        }
        UUID uuid = new UUID(atomData.readLong(), atomData.readLong());
        UUID[] keyIds = null;
        if (atomVersion == 1) {
            int keyIdCount = atomData.readUnsignedIntToInt();
            keyIds = new UUID[keyIdCount];
            for (int i = 0; i < keyIdCount; ++i) {
                keyIds[i] = new UUID(atomData.readLong(), atomData.readLong());
            }
        }
        if ((dataSize = atomData.readUnsignedIntToInt()) != (bufferLength = atomData.bytesLeft())) {
            Log.w((String)TAG, (String)("Atom data size (" + dataSize + ") does not match the bytes left: " + bufferLength));
            return null;
        }
        byte[] data = new byte[dataSize];
        atomData.readBytes(data, 0, dataSize);
        return new PsshAtom(uuid, atomVersion, data, keyIds);
    }

    public static final class PsshAtom {
        public final UUID uuid;
        public final int version;
        public final byte[] schemeData;
        @Nullable
        public final UUID[] keyIds;

        PsshAtom(UUID uuid, int version, byte[] schemeData, @Nullable UUID[] keyIds) {
            this.uuid = uuid;
            this.version = version;
            this.schemeData = schemeData;
            this.keyIds = keyIds;
        }
    }
}

