/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.mp3;

import androidx.annotation.Nullable;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.MpegAudioUtil;
import androidx.media3.extractor.SeekMap;
import androidx.media3.extractor.SeekPoint;
import androidx.media3.extractor.mp3.Seeker;

final class VbriSeeker
implements Seeker {
    private static final String TAG = "VbriSeeker";
    private final long[] timesUs;
    private final long[] positions;
    private final long durationUs;
    private final long dataEndPosition;
    private final int bitrate;

    @Nullable
    public static VbriSeeker create(long inputLength, long position, MpegAudioUtil.Header mpegAudioHeader, ParsableByteArray frame) {
        frame.skipBytes(6);
        int bytes = frame.readInt();
        long endOfMp3Data = position + (long)mpegAudioHeader.frameSize + (long)bytes;
        int numFrames = frame.readInt();
        if (numFrames <= 0) {
            return null;
        }
        int sampleRate = mpegAudioHeader.sampleRate;
        long durationUs = Util.scaleLargeTimestamp((long)numFrames, (long)(1000000L * (long)(sampleRate >= 32000 ? 1152 : 576)), (long)sampleRate);
        int entryCount = frame.readUnsignedShort();
        int scale = frame.readUnsignedShort();
        int entrySize = frame.readUnsignedShort();
        frame.skipBytes(2);
        position += (long)mpegAudioHeader.frameSize;
        long[] timesUs = new long[entryCount];
        long[] positions = new long[entryCount];
        for (int index = 0; index < entryCount; ++index) {
            int segmentSize;
            timesUs[index] = (long)index * durationUs / (long)entryCount;
            positions[index] = position;
            switch (entrySize) {
                case 1: {
                    segmentSize = frame.readUnsignedByte();
                    break;
                }
                case 2: {
                    segmentSize = frame.readUnsignedShort();
                    break;
                }
                case 3: {
                    segmentSize = frame.readUnsignedInt24();
                    break;
                }
                case 4: {
                    segmentSize = frame.readUnsignedIntToInt();
                    break;
                }
                default: {
                    return null;
                }
            }
            position += (long)segmentSize * (long)scale;
        }
        if (inputLength != -1L && inputLength != endOfMp3Data) {
            Log.w((String)TAG, (String)("VBRI data size mismatch: " + inputLength + ", " + endOfMp3Data));
        }
        if (endOfMp3Data != position) {
            Log.w((String)TAG, (String)("VBRI bytes and ToC mismatch (using max): " + endOfMp3Data + ", " + position + "\nSeeking will be inaccurate."));
            endOfMp3Data = Math.max(endOfMp3Data, position);
        }
        return new VbriSeeker(timesUs, positions, durationUs, endOfMp3Data, mpegAudioHeader.bitrate);
    }

    private VbriSeeker(long[] timesUs, long[] positions, long durationUs, long dataEndPosition, int bitrate) {
        this.timesUs = timesUs;
        this.positions = positions;
        this.durationUs = durationUs;
        this.dataEndPosition = dataEndPosition;
        this.bitrate = bitrate;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public SeekMap.SeekPoints getSeekPoints(long timeUs) {
        int tableIndex = Util.binarySearchFloor((long[])this.timesUs, (long)timeUs, (boolean)true, (boolean)true);
        SeekPoint seekPoint = new SeekPoint(this.timesUs[tableIndex], this.positions[tableIndex]);
        if (seekPoint.timeUs >= timeUs || tableIndex == this.timesUs.length - 1) {
            return new SeekMap.SeekPoints(seekPoint);
        }
        SeekPoint nextSeekPoint = new SeekPoint(this.timesUs[tableIndex + 1], this.positions[tableIndex + 1]);
        return new SeekMap.SeekPoints(seekPoint, nextSeekPoint);
    }

    @Override
    public long getTimeUs(long position) {
        return this.timesUs[Util.binarySearchFloor((long[])this.positions, (long)position, (boolean)true, (boolean)true)];
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }

    @Override
    public long getDataEndPosition() {
        return this.dataEndPosition;
    }

    @Override
    public int getAverageBitrate() {
        return this.bitrate;
    }
}

