/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.mp3;

import androidx.annotation.VisibleForTesting;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.IndexSeekMap;
import androidx.media3.extractor.SeekMap;
import androidx.media3.extractor.mp3.Seeker;
import java.math.RoundingMode;

final class IndexSeeker
implements Seeker {
    @VisibleForTesting
    static final long MIN_TIME_BETWEEN_POINTS_US = 100000L;
    private final long dataEndPosition;
    private final int averageBitrate;
    private final IndexSeekMap indexSeekMap;

    public IndexSeeker(long durationUs, long dataStartPosition, long dataEndPosition) {
        long bitrate;
        this.indexSeekMap = new IndexSeekMap(new long[]{dataStartPosition}, new long[]{0L}, durationUs);
        this.dataEndPosition = dataEndPosition;
        this.averageBitrate = durationUs != -9223372036854775807L ? ((bitrate = Util.scaleLargeValue((long)(dataStartPosition - dataEndPosition), (long)8L, (long)durationUs, (RoundingMode)RoundingMode.HALF_UP)) > 0L && bitrate <= Integer.MAX_VALUE ? (int)bitrate : -2147483647) : -2147483647;
    }

    @Override
    public long getTimeUs(long position) {
        return this.indexSeekMap.getTimeUs(position);
    }

    @Override
    public long getDataEndPosition() {
        return this.dataEndPosition;
    }

    @Override
    public boolean isSeekable() {
        return this.indexSeekMap.isSeekable();
    }

    @Override
    public long getDurationUs() {
        return this.indexSeekMap.getDurationUs();
    }

    @Override
    public SeekMap.SeekPoints getSeekPoints(long timeUs) {
        return this.indexSeekMap.getSeekPoints(timeUs);
    }

    @Override
    public int getAverageBitrate() {
        return this.averageBitrate;
    }

    public void maybeAddSeekPoint(long timeUs, long position) {
        if (this.isTimeUsInIndex(timeUs)) {
            return;
        }
        this.indexSeekMap.addSeekPoint(timeUs, position);
    }

    public boolean isTimeUsInIndex(long timeUs) {
        return this.indexSeekMap.isTimeUsInIndex(timeUs, 100000L);
    }

    void setDurationUs(long durationUs) {
        this.indexSeekMap.setDurationUs(durationUs);
    }
}

