/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.mp3;

import androidx.media3.extractor.ConstantBitrateSeekMap;
import androidx.media3.extractor.MpegAudioUtil;
import androidx.media3.extractor.mp3.Seeker;

final class ConstantBitrateSeeker
extends ConstantBitrateSeekMap
implements Seeker {
    private final long firstFramePosition;
    private final int bitrate;
    private final int frameSize;
    private final boolean allowSeeksIfLengthUnknown;
    private final long dataEndPosition;

    public ConstantBitrateSeeker(long inputLength, long firstFramePosition, MpegAudioUtil.Header mpegAudioHeader, boolean allowSeeksIfLengthUnknown) {
        this(inputLength, firstFramePosition, mpegAudioHeader.bitrate, mpegAudioHeader.frameSize, allowSeeksIfLengthUnknown);
    }

    public ConstantBitrateSeeker(long inputLength, long firstFramePosition, int bitrate, int frameSize, boolean allowSeeksIfLengthUnknown) {
        super(inputLength, firstFramePosition, bitrate, frameSize, allowSeeksIfLengthUnknown);
        this.firstFramePosition = firstFramePosition;
        this.bitrate = bitrate;
        this.frameSize = frameSize;
        this.allowSeeksIfLengthUnknown = allowSeeksIfLengthUnknown;
        this.dataEndPosition = inputLength != -1L ? inputLength : -1L;
    }

    @Override
    public long getTimeUs(long position) {
        return this.getTimeUsAtPosition(position);
    }

    @Override
    public long getDataEndPosition() {
        return this.dataEndPosition;
    }

    @Override
    public int getAverageBitrate() {
        return this.bitrate;
    }

    public ConstantBitrateSeeker copyWithNewDataEndPosition(long dataEndPosition) {
        return new ConstantBitrateSeeker(dataEndPosition, this.firstFramePosition, this.bitrate, this.frameSize, this.allowSeeksIfLengthUnknown);
    }
}

