/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.metadata.flac;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaMetadata;
import androidx.media3.common.Metadata;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.base.Ascii;
import com.google.common.primitives.Ints;

@Deprecated
@UnstableApi
public class VorbisComment
implements Metadata.Entry {
    public final String key;
    public final String value;
    public static final Parcelable.Creator<VorbisComment> CREATOR = new Parcelable.Creator<VorbisComment>(){

        public VorbisComment createFromParcel(Parcel in) {
            return new VorbisComment(in);
        }

        public VorbisComment[] newArray(int size) {
            return new VorbisComment[size];
        }
    };

    public VorbisComment(String key, String value) {
        this.key = Ascii.toUpperCase((String)key);
        this.value = value;
    }

    protected VorbisComment(Parcel in) {
        this.key = (String)Util.castNonNull((Object)in.readString());
        this.value = (String)Util.castNonNull((Object)in.readString());
    }

    public void populateMediaMetadata(MediaMetadata.Builder builder) {
        switch (this.key) {
            case "TITLE": {
                builder.setTitle((CharSequence)this.value);
                break;
            }
            case "ARTIST": {
                builder.setArtist((CharSequence)this.value);
                break;
            }
            case "ALBUM": {
                builder.setAlbumTitle((CharSequence)this.value);
                break;
            }
            case "ALBUMARTIST": {
                builder.setAlbumArtist((CharSequence)this.value);
                break;
            }
            case "TRACKNUMBER": {
                Integer trackNumber = Ints.tryParse((String)this.value);
                if (trackNumber == null) break;
                builder.setTrackNumber(trackNumber);
                break;
            }
            case "TOTALTRACKS": {
                Integer totalTracks = Ints.tryParse((String)this.value);
                if (totalTracks == null) break;
                builder.setTotalTrackCount(totalTracks);
                break;
            }
            case "DISCNUMBER": {
                Integer discNumber = Ints.tryParse((String)this.value);
                if (discNumber == null) break;
                builder.setDiscNumber(discNumber);
                break;
            }
            case "TOTALDISCS": {
                Integer totalDiscs = Ints.tryParse((String)this.value);
                if (totalDiscs == null) break;
                builder.setTotalDiscCount(totalDiscs);
                break;
            }
            case "GENRE": {
                builder.setGenre((CharSequence)this.value);
                break;
            }
            case "DESCRIPTION": {
                builder.setDescription((CharSequence)this.value);
                break;
            }
        }
    }

    public String toString() {
        return "VC: " + this.key + "=" + this.value;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VorbisComment other = (VorbisComment)obj;
        return this.key.equals(other.key) && this.value.equals(other.value);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.key);
        dest.writeString(this.value);
    }

    public int describeContents() {
        return 0;
    }
}

