/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.avif;

import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.Extractor;
import androidx.media3.extractor.ExtractorInput;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.PositionHolder;
import androidx.media3.extractor.SingleSampleExtractor;
import java.io.IOException;

@UnstableApi
public final class AvifExtractor
implements Extractor {
    private static final int AVIF_FILE_SIGNATURE_PART_1 = 1718909296;
    private static final int AVIF_FILE_SIGNATURE_PART_2 = 1635150182;
    private static final int FILE_SIGNATURE_SEGMENT_LENGTH = 4;
    private final ParsableByteArray scratch = new ParsableByteArray(4);
    private final SingleSampleExtractor imageExtractor = new SingleSampleExtractor(-1, -1, "image/avif");

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        input.advancePeekPosition(4);
        return this.readAndCompareFourBytes(input, 1718909296) && this.readAndCompareFourBytes(input, 1635150182);
    }

    @Override
    public void init(ExtractorOutput output) {
        this.imageExtractor.init(output);
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        return this.imageExtractor.read(input, seekPosition);
    }

    @Override
    public void seek(long position, long timeUs) {
        this.imageExtractor.seek(position, timeUs);
    }

    @Override
    public void release() {
    }

    private boolean readAndCompareFourBytes(ExtractorInput input, int bytesToCompare) throws IOException {
        this.scratch.reset(4);
        input.peekFully(this.scratch.getData(), 0, 4);
        return this.scratch.readUnsignedInt() == (long)bytesToCompare;
    }
}

