/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.amr;

import androidx.media3.common.Format;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.ConstantBitrateSeekMap;
import androidx.media3.extractor.DiscardingTrackOutput;
import androidx.media3.extractor.Extractor;
import androidx.media3.extractor.ExtractorInput;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.ExtractorsFactory;
import androidx.media3.extractor.IndexSeekMap;
import androidx.media3.extractor.PositionHolder;
import androidx.media3.extractor.SeekMap;
import androidx.media3.extractor.TrackOutput;
import java.io.EOFException;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@UnstableApi
public final class AmrExtractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = () -> new Extractor[]{new AmrExtractor()};
    public static final int FLAG_ENABLE_CONSTANT_BITRATE_SEEKING = 1;
    public static final int FLAG_ENABLE_CONSTANT_BITRATE_SEEKING_ALWAYS = 2;
    public static final int FLAG_ENABLE_INDEX_SEEKING = 4;
    private static final int[] frameSizeBytesByTypeNb = new int[]{13, 14, 16, 18, 20, 21, 27, 32, 6, 7, 6, 6, 1, 1, 1, 1};
    private static final int[] frameSizeBytesByTypeWb = new int[]{18, 24, 33, 37, 41, 47, 51, 59, 61, 6, 1, 1, 1, 1, 1, 1};
    private static final byte[] amrSignatureNb = Util.getUtf8Bytes((String)"#!AMR\n");
    private static final byte[] amrSignatureWb = Util.getUtf8Bytes((String)"#!AMR-WB\n");
    private static final int NUM_SAME_SIZE_CONSTANT_BIT_RATE_THRESHOLD = 20;
    private static final int SAMPLE_RATE_WB = 16000;
    private static final int SAMPLE_RATE_NB = 8000;
    private static final int SAMPLE_TIME_PER_FRAME_US = 20000;
    private final byte[] scratch;
    private final int flags;
    private final TrackOutput skippingTrackOutput;
    private boolean isWideBand;
    private long currentSampleTimeUs;
    private int currentSampleSize;
    private int currentSampleBytesRemaining;
    private long firstSamplePosition;
    private int firstSampleSize;
    private int numSamplesWithSameSize;
    private long timeOffsetUs;
    private @MonotonicNonNull ExtractorOutput extractorOutput;
    private @MonotonicNonNull TrackOutput realTrackOutput;
    private TrackOutput currentTrackOutput;
    private @MonotonicNonNull SeekMap seekMap;
    private boolean isSeekInProgress;
    private long seekTimeUs;
    private boolean hasOutputFormat;

    public AmrExtractor() {
        this(0);
    }

    public AmrExtractor(int flags) {
        if ((flags & 2) != 0) {
            flags |= 1;
        }
        this.flags = flags;
        this.scratch = new byte[1];
        this.firstSampleSize = -1;
        this.currentTrackOutput = this.skippingTrackOutput = new DiscardingTrackOutput();
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        return this.readAmrHeader(input);
    }

    @Override
    public void init(ExtractorOutput output) {
        this.extractorOutput = output;
        this.currentTrackOutput = this.realTrackOutput = output.track(0, 1);
        output.endTracks();
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        this.assertInitialized();
        if (input.getPosition() == 0L && !this.readAmrHeader(input)) {
            throw ParserException.createForMalformedContainer((String)"Could not find AMR header.", null);
        }
        this.maybeOutputFormat();
        int sampleReadResult = this.readSample(input);
        this.maybeOutputSeekMap(input.getLength(), sampleReadResult);
        if (sampleReadResult == -1 && this.seekMap instanceof IndexSeekMap) {
            long durationUs = this.timeOffsetUs + this.currentSampleTimeUs;
            ((IndexSeekMap)this.seekMap).setDurationUs(durationUs);
            this.extractorOutput.seekMap(this.seekMap);
        }
        return sampleReadResult;
    }

    @Override
    public void seek(long position, long timeUs) {
        this.currentSampleTimeUs = 0L;
        this.currentSampleSize = 0;
        this.currentSampleBytesRemaining = 0;
        this.seekTimeUs = timeUs;
        if (this.seekMap instanceof IndexSeekMap) {
            this.timeOffsetUs = ((IndexSeekMap)this.seekMap).getTimeUs(position);
            if (!this.isSeekTimeUsWithinRange(this.timeOffsetUs, this.seekTimeUs)) {
                this.isSeekInProgress = true;
                this.currentTrackOutput = this.skippingTrackOutput;
            }
        } else {
            this.timeOffsetUs = position != 0L && this.seekMap instanceof ConstantBitrateSeekMap ? ((ConstantBitrateSeekMap)this.seekMap).getTimeUsAtPosition(position) : 0L;
        }
    }

    @Override
    public void release() {
    }

    static int frameSizeBytesByTypeNb(int frameType) {
        return frameSizeBytesByTypeNb[frameType];
    }

    static int frameSizeBytesByTypeWb(int frameType) {
        return frameSizeBytesByTypeWb[frameType];
    }

    static byte[] amrSignatureNb() {
        return Arrays.copyOf(amrSignatureNb, amrSignatureNb.length);
    }

    static byte[] amrSignatureWb() {
        return Arrays.copyOf(amrSignatureWb, amrSignatureWb.length);
    }

    private boolean readAmrHeader(ExtractorInput input) throws IOException {
        if (AmrExtractor.peekAmrSignature(input, amrSignatureNb)) {
            this.isWideBand = false;
            input.skipFully(amrSignatureNb.length);
            return true;
        }
        if (AmrExtractor.peekAmrSignature(input, amrSignatureWb)) {
            this.isWideBand = true;
            input.skipFully(amrSignatureWb.length);
            return true;
        }
        return false;
    }

    private static boolean peekAmrSignature(ExtractorInput input, byte[] amrSignature) throws IOException {
        input.resetPeekPosition();
        byte[] header = new byte[amrSignature.length];
        input.peekFully(header, 0, amrSignature.length);
        return Arrays.equals(header, amrSignature);
    }

    @RequiresNonNull(value={"realTrackOutput"})
    private void maybeOutputFormat() {
        if (!this.hasOutputFormat) {
            this.hasOutputFormat = true;
            String mimeType = this.isWideBand ? "audio/amr-wb" : "audio/3gpp";
            int sampleRate = this.isWideBand ? 16000 : 8000;
            int maxInputSize = this.isWideBand ? frameSizeBytesByTypeWb[8] : frameSizeBytesByTypeNb[7];
            this.currentTrackOutput.format(new Format.Builder().setSampleMimeType(mimeType).setMaxInputSize(maxInputSize).setChannelCount(1).setSampleRate(sampleRate).build());
        }
    }

    @RequiresNonNull(value={"realTrackOutput"})
    private int readSample(ExtractorInput extractorInput) throws IOException {
        int bytesAppended;
        if (this.currentSampleBytesRemaining == 0) {
            try {
                this.currentSampleSize = this.peekNextSampleSize(extractorInput);
            }
            catch (EOFException e) {
                return -1;
            }
            this.currentSampleBytesRemaining = this.currentSampleSize;
            if (this.firstSampleSize == -1) {
                this.firstSamplePosition = extractorInput.getPosition();
                this.firstSampleSize = this.currentSampleSize;
            }
            if (this.firstSampleSize == this.currentSampleSize) {
                ++this.numSamplesWithSameSize;
            }
            if (this.seekMap instanceof IndexSeekMap) {
                IndexSeekMap indexSeekMap = (IndexSeekMap)this.seekMap;
                long nextSampleTimeUs = this.timeOffsetUs + this.currentSampleTimeUs + 20000L;
                long nextSamplePosition = extractorInput.getPosition() + (long)this.currentSampleSize;
                if (!indexSeekMap.isTimeUsInIndex(nextSampleTimeUs, 100000L)) {
                    indexSeekMap.addSeekPoint(nextSampleTimeUs, nextSamplePosition);
                }
                if (this.isSeekInProgress && this.isSeekTimeUsWithinRange(nextSampleTimeUs, this.seekTimeUs)) {
                    this.isSeekInProgress = false;
                    this.currentTrackOutput = this.realTrackOutput;
                }
            }
        }
        if ((bytesAppended = this.currentTrackOutput.sampleData(extractorInput, this.currentSampleBytesRemaining, true)) == -1) {
            return -1;
        }
        this.currentSampleBytesRemaining -= bytesAppended;
        if (this.currentSampleBytesRemaining > 0) {
            return 0;
        }
        this.currentTrackOutput.sampleMetadata(this.timeOffsetUs + this.currentSampleTimeUs, 1, this.currentSampleSize, 0, null);
        this.currentSampleTimeUs += 20000L;
        return 0;
    }

    private int peekNextSampleSize(ExtractorInput extractorInput) throws IOException {
        extractorInput.resetPeekPosition();
        extractorInput.peekFully(this.scratch, 0, 1);
        byte frameHeader = this.scratch[0];
        if ((frameHeader & 0x83) > 0) {
            throw ParserException.createForMalformedContainer((String)("Invalid padding bits for frame header " + frameHeader), null);
        }
        int frameType = frameHeader >> 3 & 0xF;
        return this.getFrameSizeInBytes(frameType);
    }

    private int getFrameSizeInBytes(int frameType) throws ParserException {
        if (!this.isValidFrameType(frameType)) {
            throw ParserException.createForMalformedContainer((String)("Illegal AMR " + (this.isWideBand ? "WB" : "NB") + " frame type " + frameType), null);
        }
        return this.isWideBand ? frameSizeBytesByTypeWb[frameType] : frameSizeBytesByTypeNb[frameType];
    }

    private boolean isValidFrameType(int frameType) {
        return frameType >= 0 && frameType <= 15 && (this.isWideBandValidFrameType(frameType) || this.isNarrowBandValidFrameType(frameType));
    }

    private boolean isWideBandValidFrameType(int frameType) {
        return this.isWideBand && (frameType < 10 || frameType > 13);
    }

    private boolean isNarrowBandValidFrameType(int frameType) {
        return !this.isWideBand && (frameType < 12 || frameType > 14);
    }

    @RequiresNonNull(value={"extractorOutput"})
    private void maybeOutputSeekMap(long inputLength, int sampleReadResult) {
        if (this.seekMap != null) {
            return;
        }
        if ((this.flags & 4) != 0) {
            this.seekMap = new IndexSeekMap(new long[]{this.firstSamplePosition}, new long[]{0L}, -9223372036854775807L);
        } else if ((this.flags & 1) == 0 || this.firstSampleSize != -1 && this.firstSampleSize != this.currentSampleSize) {
            this.seekMap = new SeekMap.Unseekable(-9223372036854775807L);
        } else if (this.numSamplesWithSameSize >= 20 || sampleReadResult == -1) {
            this.seekMap = this.getConstantBitrateSeekMap(inputLength, (this.flags & 2) != 0);
        }
        if (this.seekMap != null) {
            this.extractorOutput.seekMap(this.seekMap);
        }
    }

    private SeekMap getConstantBitrateSeekMap(long inputLength, boolean allowSeeksIfLengthUnknown) {
        int bitrate = AmrExtractor.getBitrateFromFrameSize(this.firstSampleSize, 20000L);
        return new ConstantBitrateSeekMap(inputLength, this.firstSamplePosition, bitrate, this.firstSampleSize, allowSeeksIfLengthUnknown);
    }

    @EnsuresNonNull(value={"extractorOutput", "realTrackOutput"})
    private void assertInitialized() {
        Assertions.checkStateNotNull((Object)this.realTrackOutput);
        Util.castNonNull((Object)this.extractorOutput);
    }

    private boolean isSeekTimeUsWithinRange(long timeUs, long seekTimeUs) {
        return Math.abs(seekTimeUs - timeUs) < 20000L;
    }

    private static int getBitrateFromFrameSize(int frameSize, long durationUsPerFrame) {
        return (int)((long)frameSize * 8L * 1000000L / durationUsPerFrame);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Flags {
    }
}

