/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text;

import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.Extractor;
import androidx.media3.extractor.ExtractorInput;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.PositionHolder;
import androidx.media3.extractor.text.SubtitleParser;
import androidx.media3.extractor.text.SubtitleTranscodingExtractorOutput;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public class SubtitleTranscodingExtractor
implements Extractor {
    private final Extractor delegate;
    private final SubtitleParser.Factory subtitleParserFactory;
    private @MonotonicNonNull SubtitleTranscodingExtractorOutput transcodingExtractorOutput;

    public SubtitleTranscodingExtractor(Extractor delegate, SubtitleParser.Factory subtitleParserFactory) {
        this.delegate = delegate;
        this.subtitleParserFactory = subtitleParserFactory;
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        return this.delegate.sniff(input);
    }

    @Override
    public void init(ExtractorOutput output) {
        this.transcodingExtractorOutput = new SubtitleTranscodingExtractorOutput(output, this.subtitleParserFactory);
        this.delegate.init(this.transcodingExtractorOutput);
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        return this.delegate.read(input, seekPosition);
    }

    @Override
    public void seek(long position, long timeUs) {
        if (this.transcodingExtractorOutput != null) {
            this.transcodingExtractorOutput.resetSubtitleParsers();
        }
        this.delegate.seek(position, timeUs);
    }

    @Override
    public void release() {
        this.delegate.release();
    }

    @Override
    public Extractor getUnderlyingImplementation() {
        return this.delegate;
    }
}

