/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text;

import androidx.media3.common.Format;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.text.SubtitleParser;
import androidx.media3.extractor.text.dvb.DvbParser;
import androidx.media3.extractor.text.pgs.PgsParser;
import androidx.media3.extractor.text.ssa.SsaParser;
import androidx.media3.extractor.text.subrip.SubripParser;
import androidx.media3.extractor.text.ttml.TtmlParser;
import androidx.media3.extractor.text.tx3g.Tx3gParser;
import androidx.media3.extractor.text.webvtt.Mp4WebvttParser;
import androidx.media3.extractor.text.webvtt.WebvttParser;
import java.util.Objects;

@UnstableApi
public final class DefaultSubtitleParserFactory
implements SubtitleParser.Factory {
    @Override
    public boolean supportsFormat(Format format) {
        String mimeType = format.sampleMimeType;
        return Objects.equals(mimeType, "text/x-ssa") || Objects.equals(mimeType, "text/vtt") || Objects.equals(mimeType, "application/x-mp4-vtt") || Objects.equals(mimeType, "application/x-subrip") || Objects.equals(mimeType, "application/x-quicktime-tx3g") || Objects.equals(mimeType, "application/pgs") || Objects.equals(mimeType, "application/dvbsubs") || Objects.equals(mimeType, "application/ttml+xml");
    }

    @Override
    public int getCueReplacementBehavior(Format format) {
        String mimeType = format.sampleMimeType;
        if (mimeType != null) {
            switch (mimeType) {
                case "text/x-ssa": {
                    return 1;
                }
                case "text/vtt": {
                    return 1;
                }
                case "application/x-mp4-vtt": {
                    return 2;
                }
                case "application/x-subrip": {
                    return 1;
                }
                case "application/x-quicktime-tx3g": {
                    return 2;
                }
                case "application/pgs": {
                    return 2;
                }
                case "application/dvbsubs": {
                    return 2;
                }
                case "application/ttml+xml": {
                    return 1;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported MIME type: " + mimeType);
    }

    @Override
    public SubtitleParser create(Format format) {
        String mimeType = format.sampleMimeType;
        if (mimeType != null) {
            switch (mimeType) {
                case "text/x-ssa": {
                    return new SsaParser(format.initializationData);
                }
                case "text/vtt": {
                    return new WebvttParser();
                }
                case "application/x-mp4-vtt": {
                    return new Mp4WebvttParser();
                }
                case "application/x-subrip": {
                    return new SubripParser();
                }
                case "application/x-quicktime-tx3g": {
                    return new Tx3gParser(format.initializationData);
                }
                case "application/pgs": {
                    return new PgsParser();
                }
                case "application/dvbsubs": {
                    return new DvbParser(format.initializationData);
                }
                case "application/ttml+xml": {
                    return new TtmlParser();
                }
            }
        }
        throw new IllegalArgumentException("Unsupported MIME type: " + mimeType);
    }
}

