/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text;

import android.os.Bundle;
import android.os.Parcel;
import androidx.media3.common.text.Cue;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.BundleCollectionUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.text.CuesWithTiming;
import java.util.ArrayList;
import java.util.List;

@UnstableApi
public final class CueDecoder {
    static final String BUNDLE_FIELD_CUES = "c";
    static final String BUNDLE_FIELD_DURATION_US = "d";

    public CuesWithTiming decode(long startTimeUs, byte[] bytes) {
        return this.decode(startTimeUs, bytes, 0, bytes.length);
    }

    public CuesWithTiming decode(long startTimeUs, byte[] bytes, int offset, int length) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(bytes, offset, length);
        parcel.setDataPosition(0);
        Bundle bundle = parcel.readBundle(Bundle.class.getClassLoader());
        parcel.recycle();
        ArrayList bundledCues = (ArrayList)Assertions.checkNotNull((Object)bundle.getParcelableArrayList(BUNDLE_FIELD_CUES));
        return new CuesWithTiming((List<Cue>)BundleCollectionUtil.fromBundleList(Cue::fromBundle, (List)bundledCues), startTimeUs, bundle.getLong(BUNDLE_FIELD_DURATION_US));
    }
}

