/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.jpeg;

import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.Extractor;
import androidx.media3.extractor.ExtractorInput;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.PositionHolder;
import androidx.media3.extractor.SingleSampleExtractor;
import androidx.media3.extractor.jpeg.JpegMotionPhotoExtractor;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@UnstableApi
public final class JpegExtractor
implements Extractor {
    public static final int FLAG_READ_IMAGE = 1;
    private static final int JPEG_FILE_SIGNATURE = 65496;
    private static final int JPEG_FILE_SIGNATURE_LENGTH = 2;
    private final Extractor extractor;

    public JpegExtractor() {
        this(0);
    }

    public JpegExtractor(int flags) {
        this.extractor = (flags & 1) != 0 ? new SingleSampleExtractor(65496, 2, "image/jpeg") : new JpegMotionPhotoExtractor();
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        return this.extractor.sniff(input);
    }

    @Override
    public void init(ExtractorOutput output) {
        this.extractor.init(output);
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        return this.extractor.read(input, seekPosition);
    }

    @Override
    public void seek(long position, long timeUs) {
        this.extractor.seek(position, timeUs);
    }

    @Override
    public void release() {
        this.extractor.release();
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Flags {
    }
}

