/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text;

import android.util.SparseArray;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.SeekMap;
import androidx.media3.extractor.TrackOutput;
import androidx.media3.extractor.text.SubtitleParser;
import androidx.media3.extractor.text.SubtitleTranscodingTrackOutput;

class SubtitleTranscodingExtractorOutput
implements ExtractorOutput {
    private final ExtractorOutput delegate;
    private final SubtitleParser.Factory subtitleParserFactory;
    private final SparseArray<SubtitleTranscodingTrackOutput> textTrackOutputs;

    public SubtitleTranscodingExtractorOutput(ExtractorOutput delegate, SubtitleParser.Factory subtitleParserFactory) {
        this.delegate = delegate;
        this.subtitleParserFactory = subtitleParserFactory;
        this.textTrackOutputs = new SparseArray();
    }

    public void resetSubtitleParsers() {
        for (int i = 0; i < this.textTrackOutputs.size(); ++i) {
            ((SubtitleTranscodingTrackOutput)this.textTrackOutputs.valueAt(i)).resetSubtitleParser();
        }
    }

    @Override
    public TrackOutput track(int id, int type) {
        if (type != 3) {
            return this.delegate.track(id, type);
        }
        SubtitleTranscodingTrackOutput existingTrackOutput = (SubtitleTranscodingTrackOutput)this.textTrackOutputs.get(id);
        if (existingTrackOutput != null) {
            return existingTrackOutput;
        }
        SubtitleTranscodingTrackOutput trackOutput = new SubtitleTranscodingTrackOutput(this.delegate.track(id, type), this.subtitleParserFactory);
        this.textTrackOutputs.put(id, (Object)trackOutput);
        return trackOutput;
    }

    @Override
    public void endTracks() {
        this.delegate.endTracks();
    }

    @Override
    public void seekMap(SeekMap seekMap) {
        this.delegate.seekMap(seekMap);
    }
}

