/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.decoder;

import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.decoder.DecoderOutputBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@UnstableApi
public class SimpleDecoderOutputBuffer
extends DecoderOutputBuffer {
    private final DecoderOutputBuffer.Owner<SimpleDecoderOutputBuffer> owner;
    @Nullable
    public ByteBuffer data;

    public SimpleDecoderOutputBuffer(DecoderOutputBuffer.Owner<SimpleDecoderOutputBuffer> owner) {
        this.owner = owner;
    }

    public ByteBuffer init(long timeUs, int size) {
        this.timeUs = timeUs;
        if (this.data == null || this.data.capacity() < size) {
            this.data = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
        }
        this.data.position(0);
        this.data.limit(size);
        return this.data;
    }

    public ByteBuffer grow(int newSize) {
        ByteBuffer oldData = (ByteBuffer)Assertions.checkNotNull((Object)this.data);
        Assertions.checkArgument((newSize >= oldData.limit() ? 1 : 0) != 0);
        ByteBuffer newData = ByteBuffer.allocateDirect(newSize).order(ByteOrder.nativeOrder());
        int restorePosition = oldData.position();
        oldData.position(0);
        newData.put(oldData);
        newData.position(restorePosition);
        newData.limit(newSize);
        this.data = newData;
        return newData;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.data != null) {
            this.data.clear();
        }
    }

    @Override
    public void release() {
        this.owner.releaseOutputBuffer(this);
    }
}

