/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource;

import android.net.Uri;
import android.net.http.HttpEngine;
import android.net.http.HttpException;
import android.net.http.NetworkException;
import android.net.http.UploadDataProvider;
import android.net.http.UrlRequest;
import android.net.http.UrlResponseInfo;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresExtension;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.ConditionVariable;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.BaseDataSource;
import androidx.media3.datasource.ByteArrayUploadDataProvider;
import androidx.media3.datasource.DataSourceException;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.HttpDataSource;
import androidx.media3.datasource.HttpUtil;
import androidx.media3.datasource.TransferListener;
import com.google.common.base.Ascii;
import com.google.common.base.Predicate;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

@RequiresExtension(extension=31, version=7)
@UnstableApi
public final class HttpEngineDataSource
extends BaseDataSource
implements HttpDataSource {
    @UnstableApi
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 8000;
    @UnstableApi
    public static final int DEFAULT_READ_TIMEOUT_MILLIS = 8000;
    private static final int READ_BUFFER_SIZE_BYTES = 32768;
    private final HttpEngine httpEngine;
    private final Executor executor;
    private final int requestPriority;
    private final int connectTimeoutMs;
    private final int readTimeoutMs;
    private final boolean resetTimeoutOnRedirects;
    private final boolean handleSetCookieRequests;
    @Nullable
    private final String userAgent;
    @Nullable
    private final HttpDataSource.RequestProperties defaultRequestProperties;
    private final HttpDataSource.RequestProperties requestProperties;
    private final ConditionVariable operation;
    private final Clock clock;
    @Nullable
    private Predicate<String> contentTypePredicate;
    private final boolean keepPostFor302Redirects;
    private boolean transferStarted;
    private long bytesRemaining;
    @Nullable
    private DataSpec currentDataSpec;
    @Nullable
    private UrlRequestWrapper currentUrlRequestWrapper;
    @Nullable
    private ByteBuffer readBuffer;
    @Nullable
    private UrlResponseInfo responseInfo;
    @Nullable
    private IOException exception;
    private boolean finished;
    private volatile long currentConnectTimeoutMs;

    @UnstableApi
    HttpEngineDataSource(HttpEngine httpEngine, Executor executor, int requestPriority, int connectTimeoutMs, int readTimeoutMs, boolean resetTimeoutOnRedirects, boolean handleSetCookieRequests, @Nullable String userAgent, @Nullable HttpDataSource.RequestProperties defaultRequestProperties, @Nullable Predicate<String> contentTypePredicate, boolean keepPostFor302Redirects) {
        super(true);
        this.httpEngine = (HttpEngine)Assertions.checkNotNull((Object)httpEngine);
        this.executor = (Executor)Assertions.checkNotNull((Object)executor);
        this.requestPriority = requestPriority;
        this.connectTimeoutMs = connectTimeoutMs;
        this.readTimeoutMs = readTimeoutMs;
        this.resetTimeoutOnRedirects = resetTimeoutOnRedirects;
        this.handleSetCookieRequests = handleSetCookieRequests;
        this.userAgent = userAgent;
        this.defaultRequestProperties = defaultRequestProperties;
        this.contentTypePredicate = contentTypePredicate;
        this.keepPostFor302Redirects = keepPostFor302Redirects;
        this.clock = Clock.DEFAULT;
        this.requestProperties = new HttpDataSource.RequestProperties();
        this.operation = new ConditionVariable();
    }

    @Override
    @UnstableApi
    public void setRequestProperty(String name, String value) {
        this.requestProperties.set(name, value);
    }

    @Override
    @UnstableApi
    public void clearRequestProperty(String name) {
        this.requestProperties.remove(name);
    }

    @Override
    @UnstableApi
    public void clearAllRequestProperties() {
        this.requestProperties.clear();
    }

    @Override
    @UnstableApi
    public int getResponseCode() {
        return this.responseInfo == null || this.responseInfo.getHttpStatusCode() <= 0 ? -1 : this.responseInfo.getHttpStatusCode();
    }

    @Override
    @UnstableApi
    public Map<String, List<String>> getResponseHeaders() {
        return this.responseInfo == null ? Collections.emptyMap() : this.responseInfo.getHeaders().getAsMap();
    }

    @Override
    @UnstableApi
    @Nullable
    public Uri getUri() {
        if (this.responseInfo != null) {
            return Uri.parse((String)this.responseInfo.getUrl());
        }
        if (this.currentDataSpec != null) {
            return this.currentDataSpec.uri;
        }
        return null;
    }

    @Override
    @UnstableApi
    public long open(DataSpec dataSpec) throws HttpDataSource.HttpDataSourceException {
        long contentLength;
        long bytesToSkip;
        String contentType;
        UrlRequestWrapper urlRequestWrapper;
        Assertions.checkNotNull((Object)dataSpec);
        Assertions.checkState((!this.transferStarted ? 1 : 0) != 0);
        this.operation.close();
        this.resetConnectTimeout();
        this.currentDataSpec = dataSpec;
        try {
            this.currentUrlRequestWrapper = urlRequestWrapper = this.buildRequestWrapper(dataSpec);
        }
        catch (IOException e) {
            if (e instanceof HttpDataSource.HttpDataSourceException) {
                throw (HttpDataSource.HttpDataSourceException)e;
            }
            throw new OpenException(e, dataSpec, 2000, 0);
        }
        urlRequestWrapper.start();
        this.transferInitializing(dataSpec);
        try {
            boolean connectionOpened = this.blockUntilConnectTimeout();
            IOException connectionOpenException = this.exception;
            if (connectionOpenException != null) {
                String message = connectionOpenException.getMessage();
                if (message != null && Ascii.toLowerCase((String)message).contains("err_cleartext_not_permitted")) {
                    throw new HttpDataSource.CleartextNotPermittedException(connectionOpenException, dataSpec);
                }
                throw new OpenException(connectionOpenException, dataSpec, 2001, urlRequestWrapper.getStatus());
            }
            if (!connectionOpened) {
                throw new OpenException(new SocketTimeoutException(), dataSpec, 2002, urlRequestWrapper.getStatus());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OpenException(new InterruptedIOException(), dataSpec, 1004, -1);
        }
        UrlResponseInfo responseInfo = (UrlResponseInfo)Assertions.checkNotNull((Object)this.responseInfo);
        int responseCode = responseInfo.getHttpStatusCode();
        Map responseHeaders = responseInfo.getHeaders().getAsMap();
        if (responseCode < 200 || responseCode > 299) {
            byte[] responseBody;
            long documentSize;
            if (responseCode == 416 && dataSpec.position == (documentSize = HttpUtil.getDocumentSize(HttpEngineDataSource.getFirstHeader(responseHeaders, "Content-Range")))) {
                this.transferStarted = true;
                this.transferStarted(dataSpec);
                return dataSpec.length != -1L ? dataSpec.length : 0L;
            }
            try {
                responseBody = this.readResponseBody();
            }
            catch (IOException e) {
                responseBody = Util.EMPTY_BYTE_ARRAY;
            }
            DataSourceException cause = responseCode == 416 ? new DataSourceException(2008) : null;
            throw new HttpDataSource.InvalidResponseCodeException(responseCode, responseInfo.getHttpStatusText(), cause, responseHeaders, dataSpec, responseBody);
        }
        Predicate<String> contentTypePredicate = this.contentTypePredicate;
        if (contentTypePredicate != null && (contentType = HttpEngineDataSource.getFirstHeader(responseHeaders, "Content-Type")) != null && !contentTypePredicate.apply((Object)contentType)) {
            throw new HttpDataSource.InvalidContentTypeException(contentType, dataSpec);
        }
        long l = bytesToSkip = responseCode == 200 && dataSpec.position != 0L ? dataSpec.position : 0L;
        this.bytesRemaining = !HttpEngineDataSource.isCompressed(responseInfo) ? (dataSpec.length != -1L ? dataSpec.length : ((contentLength = HttpUtil.getContentLength(HttpEngineDataSource.getFirstHeader(responseHeaders, "Content-Length"), HttpEngineDataSource.getFirstHeader(responseHeaders, "Content-Range"))) != -1L ? contentLength - bytesToSkip : -1L)) : dataSpec.length;
        this.transferStarted = true;
        this.transferStarted(dataSpec);
        this.skipFully(bytesToSkip, dataSpec);
        return this.bytesRemaining;
    }

    @Override
    @UnstableApi
    public int read(byte[] buffer, int offset, int length) throws HttpDataSource.HttpDataSourceException {
        Assertions.checkState((boolean)this.transferStarted);
        if (length == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        ByteBuffer readBuffer = this.getOrCreateReadBuffer();
        if (!readBuffer.hasRemaining()) {
            this.operation.close();
            readBuffer.clear();
            this.readInternal(readBuffer, (DataSpec)Util.castNonNull((Object)this.currentDataSpec));
            if (this.finished) {
                this.bytesRemaining = 0L;
                return -1;
            }
            readBuffer.flip();
            Assertions.checkState((boolean)readBuffer.hasRemaining());
        }
        int bytesRead = (int)Longs.min((long[])new long[]{this.bytesRemaining != -1L ? this.bytesRemaining : Long.MAX_VALUE, readBuffer.remaining(), length});
        readBuffer.get(buffer, offset, bytesRead);
        if (this.bytesRemaining != -1L) {
            this.bytesRemaining -= (long)bytesRead;
        }
        this.bytesTransferred(bytesRead);
        return bytesRead;
    }

    @UnstableApi
    public int read(ByteBuffer buffer) throws HttpDataSource.HttpDataSourceException {
        int copyBytes;
        Assertions.checkState((boolean)this.transferStarted);
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Passed buffer is not a direct ByteBuffer");
        }
        if (!buffer.hasRemaining()) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        int readLength = buffer.remaining();
        if (this.readBuffer != null && (copyBytes = HttpEngineDataSource.copyByteBuffer(this.readBuffer, buffer)) != 0) {
            if (this.bytesRemaining != -1L) {
                this.bytesRemaining -= (long)copyBytes;
            }
            this.bytesTransferred(copyBytes);
            return copyBytes;
        }
        this.operation.close();
        this.readInternal(buffer, (DataSpec)Util.castNonNull((Object)this.currentDataSpec));
        if (this.finished) {
            this.bytesRemaining = 0L;
            return -1;
        }
        Assertions.checkState((readLength > buffer.remaining() ? 1 : 0) != 0);
        int bytesRead = readLength - buffer.remaining();
        if (this.bytesRemaining != -1L) {
            this.bytesRemaining -= (long)bytesRead;
        }
        this.bytesTransferred(bytesRead);
        return bytesRead;
    }

    @Override
    @UnstableApi
    public synchronized void close() {
        if (this.currentUrlRequestWrapper != null) {
            this.currentUrlRequestWrapper.close();
            this.currentUrlRequestWrapper = null;
        }
        if (this.readBuffer != null) {
            this.readBuffer.limit(0);
        }
        this.currentDataSpec = null;
        this.responseInfo = null;
        this.exception = null;
        this.finished = false;
        if (this.transferStarted) {
            this.transferStarted = false;
            this.transferEnded();
        }
    }

    @UnstableApi
    @VisibleForTesting
    @Nullable
    UrlRequest.Callback getCurrentUrlRequestCallback() {
        return this.currentUrlRequestWrapper == null ? null : this.currentUrlRequestWrapper.getUrlRequestCallback();
    }

    private UrlRequestWrapper buildRequestWrapper(DataSpec dataSpec) throws IOException {
        UrlRequestCallback callback = new UrlRequestCallback();
        return new UrlRequestWrapper(this.buildRequestBuilder(dataSpec, callback).build(), callback);
    }

    private UrlRequest.Builder buildRequestBuilder(DataSpec dataSpec, UrlRequest.Callback urlRequestCallback) throws IOException {
        UrlRequest.Builder requestBuilder = this.httpEngine.newUrlRequestBuilder(dataSpec.uri.toString(), this.executor, urlRequestCallback).setPriority(this.requestPriority).setDirectExecutorAllowed(true);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        if (this.defaultRequestProperties != null) {
            requestHeaders.putAll(this.defaultRequestProperties.getSnapshot());
        }
        requestHeaders.putAll(this.requestProperties.getSnapshot());
        requestHeaders.putAll(dataSpec.httpRequestHeaders);
        for (Map.Entry headerEntry : requestHeaders.entrySet()) {
            String key = (String)headerEntry.getKey();
            String value = (String)headerEntry.getValue();
            requestBuilder.addHeader(key, value);
        }
        if (dataSpec.httpBody != null && !requestHeaders.containsKey("Content-Type")) {
            throw new OpenException("HTTP request with non-empty body must set Content-Type", dataSpec, 1004, 0);
        }
        String rangeHeader = HttpUtil.buildRangeRequestHeader(dataSpec.position, dataSpec.length);
        if (rangeHeader != null) {
            requestBuilder.addHeader("Range", rangeHeader);
        }
        if (this.userAgent != null) {
            requestBuilder.addHeader("User-Agent", this.userAgent);
        }
        requestBuilder.setHttpMethod(dataSpec.getHttpMethodString());
        if (dataSpec.httpBody != null) {
            requestBuilder.setUploadDataProvider((UploadDataProvider)new ByteArrayUploadDataProvider(dataSpec.httpBody), this.executor);
        }
        return requestBuilder;
    }

    private boolean blockUntilConnectTimeout() throws InterruptedException {
        long now = this.clock.elapsedRealtime();
        boolean opened = false;
        while (!opened && now < this.currentConnectTimeoutMs) {
            opened = this.operation.block(this.currentConnectTimeoutMs - now + 5L);
            now = this.clock.elapsedRealtime();
        }
        return opened;
    }

    private void resetConnectTimeout() {
        this.currentConnectTimeoutMs = this.clock.elapsedRealtime() + (long)this.connectTimeoutMs;
    }

    private void skipFully(long bytesToSkip, DataSpec dataSpec) throws HttpDataSource.HttpDataSourceException {
        if (bytesToSkip == 0L) {
            return;
        }
        ByteBuffer readBuffer = this.getOrCreateReadBuffer();
        try {
            while (bytesToSkip > 0L) {
                this.operation.close();
                readBuffer.clear();
                this.readInternal(readBuffer, dataSpec);
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedIOException();
                }
                if (this.finished) {
                    throw new OpenException(dataSpec, 2008, 14);
                }
                readBuffer.flip();
                Assertions.checkState((boolean)readBuffer.hasRemaining());
                int bytesSkipped = (int)Math.min((long)readBuffer.remaining(), bytesToSkip);
                readBuffer.position(readBuffer.position() + bytesSkipped);
                bytesToSkip -= (long)bytesSkipped;
            }
        }
        catch (IOException e) {
            if (e instanceof HttpDataSource.HttpDataSourceException) {
                throw (HttpDataSource.HttpDataSourceException)e;
            }
            throw new OpenException(e, dataSpec, e instanceof SocketTimeoutException ? 2002 : 2001, 14);
        }
    }

    private byte[] readResponseBody() throws IOException {
        byte[] responseBody = Util.EMPTY_BYTE_ARRAY;
        ByteBuffer readBuffer = this.getOrCreateReadBuffer();
        while (!this.finished) {
            this.operation.close();
            readBuffer.clear();
            this.readInternal(readBuffer, (DataSpec)Util.castNonNull((Object)this.currentDataSpec));
            readBuffer.flip();
            if (readBuffer.remaining() <= 0) continue;
            int existingResponseBodyEnd = responseBody.length;
            responseBody = Arrays.copyOf(responseBody, responseBody.length + readBuffer.remaining());
            readBuffer.get(responseBody, existingResponseBodyEnd, readBuffer.remaining());
        }
        return responseBody;
    }

    private void readInternal(ByteBuffer buffer, DataSpec dataSpec) throws HttpDataSource.HttpDataSourceException {
        ((UrlRequestWrapper)Util.castNonNull((Object)this.currentUrlRequestWrapper)).read(buffer);
        try {
            if (!this.operation.block((long)this.readTimeoutMs)) {
                throw new SocketTimeoutException();
            }
        }
        catch (InterruptedException e) {
            if (buffer == this.readBuffer) {
                this.readBuffer = null;
            }
            Thread.currentThread().interrupt();
            this.exception = new InterruptedIOException();
        }
        catch (SocketTimeoutException e) {
            if (buffer == this.readBuffer) {
                this.readBuffer = null;
            }
            this.exception = new HttpDataSource.HttpDataSourceException(e, dataSpec, 2002, 2);
        }
        if (this.exception != null) {
            if (this.exception instanceof HttpDataSource.HttpDataSourceException) {
                throw (HttpDataSource.HttpDataSourceException)this.exception;
            }
            throw HttpDataSource.HttpDataSourceException.createForIOException(this.exception, dataSpec, 2);
        }
    }

    private ByteBuffer getOrCreateReadBuffer() {
        if (this.readBuffer == null) {
            this.readBuffer = ByteBuffer.allocateDirect(32768);
            this.readBuffer.limit(0);
        }
        return this.readBuffer;
    }

    private static boolean isCompressed(UrlResponseInfo info) {
        for (Map.Entry entry : info.getHeaders().getAsList()) {
            if (!((String)entry.getKey()).equalsIgnoreCase("Content-Encoding")) continue;
            return !((String)entry.getValue()).equalsIgnoreCase("identity");
        }
        return false;
    }

    @Nullable
    private static String parseCookies(@Nullable List<String> setCookieHeaders) {
        if (setCookieHeaders == null || setCookieHeaders.isEmpty()) {
            return null;
        }
        return TextUtils.join((CharSequence)";", setCookieHeaders);
    }

    @Nullable
    private static String getFirstHeader(Map<String, List<String>> allHeaders, String headerName) {
        List<String> headers = allHeaders.get(headerName);
        return headers != null && !headers.isEmpty() ? headers.get(0) : null;
    }

    private static int copyByteBuffer(ByteBuffer src, ByteBuffer dst) {
        int remaining = Math.min(src.remaining(), dst.remaining());
        int limit = src.limit();
        src.limit(src.position() + remaining);
        dst.put(src);
        src.limit(limit);
        return remaining;
    }

    private static final class UrlRequestWrapper {
        private final UrlRequest urlRequest;
        private final UrlRequestCallback urlRequestCallback;

        UrlRequestWrapper(UrlRequest urlRequest, UrlRequestCallback urlRequestCallback) {
            this.urlRequest = urlRequest;
            this.urlRequestCallback = urlRequestCallback;
        }

        public void start() {
            this.urlRequest.start();
        }

        public void read(ByteBuffer buffer) {
            this.urlRequest.read(buffer);
        }

        public void close() {
            this.urlRequestCallback.close();
            this.urlRequest.cancel();
        }

        public UrlRequest.Callback getUrlRequestCallback() {
            return this.urlRequestCallback;
        }

        public int getStatus() throws InterruptedException {
            final ConditionVariable conditionVariable = new ConditionVariable();
            final int[] statusHolder = new int[1];
            this.urlRequest.getStatus(new UrlRequest.StatusListener(){

                public void onStatus(int status) {
                    statusHolder[0] = status;
                    conditionVariable.open();
                }
            });
            conditionVariable.block();
            return statusHolder[0];
        }
    }

    @UnstableApi
    public static final class OpenException
    extends HttpDataSource.HttpDataSourceException {
        public final int httpEngineConnectionStatus;

        public OpenException(IOException cause, DataSpec dataSpec, int errorCode, int httpEngineConnectionStatus) {
            super(cause, dataSpec, errorCode, 1);
            this.httpEngineConnectionStatus = httpEngineConnectionStatus;
        }

        public OpenException(String errorMessage, DataSpec dataSpec, int errorCode, int httpEngineConnectionStatus) {
            super(errorMessage, dataSpec, errorCode, 1);
            this.httpEngineConnectionStatus = httpEngineConnectionStatus;
        }

        public OpenException(DataSpec dataSpec, int errorCode, int httpEngineConnectionStatus) {
            super(dataSpec, errorCode, 1);
            this.httpEngineConnectionStatus = httpEngineConnectionStatus;
        }
    }

    private final class UrlRequestCallback
    implements UrlRequest.Callback {
        private volatile boolean isClosed = false;

        private UrlRequestCallback() {
        }

        public void close() {
            this.isClosed = true;
        }

        public synchronized void onRedirectReceived(UrlRequest request, UrlResponseInfo info, String newLocationUrl) {
            UrlRequestWrapper redirectUrlRequestWrapper;
            boolean shouldKeepPost;
            if (this.isClosed) {
                return;
            }
            DataSpec dataSpec = (DataSpec)Assertions.checkNotNull((Object)HttpEngineDataSource.this.currentDataSpec);
            int responseCode = info.getHttpStatusCode();
            if (dataSpec.httpMethod == 2 && (responseCode == 307 || responseCode == 308)) {
                HttpEngineDataSource.this.exception = new HttpDataSource.InvalidResponseCodeException(responseCode, info.getHttpStatusText(), null, info.getHeaders().getAsMap(), dataSpec, Util.EMPTY_BYTE_ARRAY);
                HttpEngineDataSource.this.operation.open();
                return;
            }
            if (HttpEngineDataSource.this.resetTimeoutOnRedirects) {
                HttpEngineDataSource.this.resetConnectTimeout();
            }
            boolean bl = shouldKeepPost = HttpEngineDataSource.this.keepPostFor302Redirects && dataSpec.httpMethod == 2 && responseCode == 302;
            if (!shouldKeepPost && !HttpEngineDataSource.this.handleSetCookieRequests) {
                request.followRedirect();
                return;
            }
            String cookieHeadersValue = HttpEngineDataSource.parseCookies((List)info.getHeaders().getAsMap().get("Set-Cookie"));
            if (!shouldKeepPost && TextUtils.isEmpty((CharSequence)cookieHeadersValue)) {
                request.followRedirect();
                return;
            }
            request.cancel();
            DataSpec redirectUrlDataSpec = !shouldKeepPost && dataSpec.httpMethod == 2 ? dataSpec.buildUpon().setUri(newLocationUrl).setHttpMethod(1).setHttpBody(null).build() : dataSpec.withUri(Uri.parse((String)newLocationUrl));
            if (!TextUtils.isEmpty((CharSequence)cookieHeadersValue)) {
                HashMap<String, String> requestHeaders = new HashMap<String, String>();
                requestHeaders.putAll(dataSpec.httpRequestHeaders);
                requestHeaders.put("Cookie", cookieHeadersValue);
                redirectUrlDataSpec = redirectUrlDataSpec.buildUpon().setHttpRequestHeaders(requestHeaders).build();
            }
            try {
                redirectUrlRequestWrapper = HttpEngineDataSource.this.buildRequestWrapper(redirectUrlDataSpec);
            }
            catch (IOException e) {
                HttpEngineDataSource.this.exception = e;
                return;
            }
            if (HttpEngineDataSource.this.currentUrlRequestWrapper != null) {
                HttpEngineDataSource.this.currentUrlRequestWrapper.close();
            }
            HttpEngineDataSource.this.currentUrlRequestWrapper = redirectUrlRequestWrapper;
            HttpEngineDataSource.this.currentUrlRequestWrapper.start();
        }

        public synchronized void onResponseStarted(UrlRequest request, UrlResponseInfo info) {
            if (this.isClosed) {
                return;
            }
            HttpEngineDataSource.this.responseInfo = info;
            HttpEngineDataSource.this.operation.open();
        }

        public synchronized void onReadCompleted(UrlRequest request, UrlResponseInfo info, ByteBuffer buffer) {
            if (this.isClosed) {
                return;
            }
            HttpEngineDataSource.this.operation.open();
        }

        public synchronized void onSucceeded(UrlRequest request, UrlResponseInfo info) {
            if (this.isClosed) {
                return;
            }
            HttpEngineDataSource.this.finished = true;
            HttpEngineDataSource.this.operation.open();
        }

        public synchronized void onFailed(UrlRequest request, @Nullable UrlResponseInfo info, HttpException error) {
            if (this.isClosed) {
                return;
            }
            if (error instanceof NetworkException && ((NetworkException)error).getErrorCode() == 1) {
                HttpEngineDataSource.this.exception = new UnknownHostException();
            } else {
                HttpEngineDataSource.this.exception = (IOException)error;
            }
            HttpEngineDataSource.this.operation.open();
        }

        public synchronized void onCanceled(UrlRequest request, @Nullable UrlResponseInfo info) {
        }
    }

    public static final class Factory
    implements HttpDataSource.Factory {
        private final HttpEngine httpEngine;
        private final Executor executor;
        private final HttpDataSource.RequestProperties defaultRequestProperties;
        @Nullable
        private Predicate<String> contentTypePredicate;
        @Nullable
        private TransferListener transferListener;
        @Nullable
        private String userAgent;
        private int requestPriority;
        private int connectTimeoutMs;
        private int readTimeoutMs;
        private boolean resetTimeoutOnRedirects;
        private boolean handleSetCookieRequests;
        private boolean keepPostFor302Redirects;

        public Factory(HttpEngine httpEngine, Executor executor) {
            this.httpEngine = (HttpEngine)Assertions.checkNotNull((Object)httpEngine);
            this.executor = executor;
            this.defaultRequestProperties = new HttpDataSource.RequestProperties();
            this.requestPriority = 3;
            this.connectTimeoutMs = 8000;
            this.readTimeoutMs = 8000;
        }

        @Override
        @CanIgnoreReturnValue
        @UnstableApi
        public final Factory setDefaultRequestProperties(Map<String, String> defaultRequestProperties) {
            this.defaultRequestProperties.clearAndSet(defaultRequestProperties);
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Factory setUserAgent(@Nullable String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Factory setRequestPriority(int requestPriority) {
            this.requestPriority = requestPriority;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Factory setConnectionTimeoutMs(int connectTimeoutMs) {
            this.connectTimeoutMs = connectTimeoutMs;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Factory setResetTimeoutOnRedirects(boolean resetTimeoutOnRedirects) {
            this.resetTimeoutOnRedirects = resetTimeoutOnRedirects;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Factory setHandleSetCookieRequests(boolean handleSetCookieRequests) {
            this.handleSetCookieRequests = handleSetCookieRequests;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Factory setReadTimeoutMs(int readTimeoutMs) {
            this.readTimeoutMs = readTimeoutMs;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Factory setContentTypePredicate(@Nullable Predicate<String> contentTypePredicate) {
            this.contentTypePredicate = contentTypePredicate;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Factory setKeepPostFor302Redirects(boolean keepPostFor302Redirects) {
            this.keepPostFor302Redirects = keepPostFor302Redirects;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Factory setTransferListener(@Nullable TransferListener transferListener) {
            this.transferListener = transferListener;
            return this;
        }

        @Override
        @UnstableApi
        public HttpDataSource createDataSource() {
            HttpEngineDataSource dataSource = new HttpEngineDataSource(this.httpEngine, this.executor, this.requestPriority, this.connectTimeoutMs, this.readTimeoutMs, this.resetTimeoutOnRedirects, this.handleSetCookieRequests, this.userAgent, this.defaultRequestProperties, this.contentTypePredicate, this.keepPostFor302Redirects);
            if (this.transferListener != null) {
                dataSource.addTransferListener(this.transferListener);
            }
            return dataSource;
        }
    }
}

