/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource;

import android.net.Uri;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.BaseDataSource;
import androidx.media3.datasource.DataSourceException;
import androidx.media3.datasource.DataSpec;
import com.google.common.collect.Sets;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Set;

@UnstableApi
public class FileDescriptorDataSource
extends BaseDataSource {
    private static final Set<FileDescriptor> inUseFileDescriptors = Sets.newConcurrentHashSet();
    private final FileDescriptor fileDescriptor;
    private final long offset;
    private final long length;
    @Nullable
    private Uri uri;
    @Nullable
    private FileInputStream inputStream;
    private long bytesRemaining;
    private boolean opened;

    public FileDescriptorDataSource(FileDescriptor fileDescriptor, long offset, long length) {
        super(false);
        this.fileDescriptor = (FileDescriptor)Assertions.checkNotNull((Object)fileDescriptor);
        this.offset = offset;
        this.length = length;
    }

    @Override
    public long open(DataSpec dataSpec) throws DataSourceException {
        try {
            this.uri = dataSpec.uri;
            this.transferInitializing(dataSpec);
            if (!inUseFileDescriptors.add(this.fileDescriptor)) {
                throw new DataSourceException(new IllegalStateException("Attempted to re-use an already in-use file descriptor"), -2);
            }
            if (this.length != -1L && dataSpec.position > this.length) {
                throw new DataSourceException(2008);
            }
            FileDescriptorDataSource.seekFileDescriptor(this.fileDescriptor, this.offset + dataSpec.position);
            this.inputStream = new FileInputStream(this.fileDescriptor);
            if (this.length == -1L) {
                FileChannel channel = this.inputStream.getChannel();
                long channelSize = channel.size();
                if (channelSize == 0L) {
                    this.bytesRemaining = -1L;
                } else {
                    this.bytesRemaining = channelSize - channel.position();
                    if (this.bytesRemaining < 0L) {
                        throw new DataSourceException(2008);
                    }
                }
            } else {
                this.bytesRemaining = this.length - dataSpec.position;
                if (this.bytesRemaining < 0L) {
                    throw new DataSourceException(2008);
                }
            }
        }
        catch (DataSourceException e) {
            throw e;
        }
        catch (IOException e) {
            throw new DataSourceException(e, e instanceof FileNotFoundException ? 2005 : 2000);
        }
        if (dataSpec.length != -1L) {
            this.bytesRemaining = this.bytesRemaining == -1L ? dataSpec.length : Math.min(this.bytesRemaining, dataSpec.length);
        }
        this.opened = true;
        this.transferStarted(dataSpec);
        return dataSpec.length != -1L ? dataSpec.length : this.bytesRemaining;
    }

    public int read(byte[] buffer, int offset, int length) throws DataSourceException {
        int bytesRead;
        if (length == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        int bytesToRead = this.bytesRemaining == -1L ? length : (int)Math.min(this.bytesRemaining, (long)length);
        try {
            bytesRead = ((FileInputStream)Util.castNonNull((Object)this.inputStream)).read(buffer, offset, bytesToRead);
        }
        catch (IOException e) {
            throw new DataSourceException(e, 2000);
        }
        if (bytesRead == -1) {
            return -1;
        }
        if (this.bytesRemaining != -1L) {
            this.bytesRemaining -= (long)bytesRead;
        }
        this.bytesTransferred(bytesRead);
        return bytesRead;
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    @Override
    public void close() throws DataSourceException {
        this.uri = null;
        inUseFileDescriptors.remove(this.fileDescriptor);
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException e) {
            throw new DataSourceException(e, 2000);
        }
        finally {
            this.inputStream = null;
            if (this.opened) {
                this.opened = false;
                this.transferEnded();
            }
        }
    }

    private static void seekFileDescriptor(FileDescriptor fileDescriptor, long position) throws DataSourceException {
        try {
            Os.lseek((FileDescriptor)fileDescriptor, (long)position, (int)OsConstants.SEEK_SET);
        }
        catch (ErrnoException e) {
            throw new DataSourceException(e, 2000);
        }
    }
}

