/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.BitmapLoader;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.BitmapUtil;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSourceUtil;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.DefaultDataSource;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@UnstableApi
public final class DataSourceBitmapLoader
implements BitmapLoader {
    public static final Supplier<ListeningExecutorService> DEFAULT_EXECUTOR_SERVICE = Suppliers.memoize(() -> MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor()));
    private final ListeningExecutorService listeningExecutorService;
    private final DataSource.Factory dataSourceFactory;
    @Nullable
    private final BitmapFactory.Options options;
    private final int maximumOutputDimension;

    public DataSourceBitmapLoader(Context context) {
        this((ListeningExecutorService)Assertions.checkStateNotNull((Object)((ListeningExecutorService)DEFAULT_EXECUTOR_SERVICE.get())), new DefaultDataSource.Factory(context));
    }

    public DataSourceBitmapLoader(ListeningExecutorService listeningExecutorService, DataSource.Factory dataSourceFactory) {
        this(listeningExecutorService, dataSourceFactory, null);
    }

    public DataSourceBitmapLoader(ListeningExecutorService listeningExecutorService, DataSource.Factory dataSourceFactory, @Nullable BitmapFactory.Options options) {
        this(listeningExecutorService, dataSourceFactory, options, -1);
    }

    public DataSourceBitmapLoader(ListeningExecutorService listeningExecutorService, DataSource.Factory dataSourceFactory, @Nullable BitmapFactory.Options options, int maximumOutputDimension) {
        this.listeningExecutorService = listeningExecutorService;
        this.dataSourceFactory = dataSourceFactory;
        this.options = options;
        this.maximumOutputDimension = maximumOutputDimension;
    }

    public boolean supportsMimeType(String mimeType) {
        return Util.isBitmapFactorySupportedMimeType((String)mimeType);
    }

    public ListenableFuture<Bitmap> decodeBitmap(byte[] data) {
        return this.listeningExecutorService.submit(() -> BitmapUtil.decode(data, data.length, this.options, this.maximumOutputDimension));
    }

    public ListenableFuture<Bitmap> loadBitmap(Uri uri) {
        return this.listeningExecutorService.submit(() -> DataSourceBitmapLoader.load(this.dataSourceFactory.createDataSource(), uri, this.options, this.maximumOutputDimension));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap load(DataSource dataSource, Uri uri, @Nullable BitmapFactory.Options options, int maximumOutputDimension) throws IOException {
        try {
            DataSpec dataSpec = new DataSpec(uri);
            dataSource.open(dataSpec);
            byte[] readData = DataSourceUtil.readToEnd(dataSource);
            Bitmap bitmap = BitmapUtil.decode(readData, readData.length, options, maximumOutputDimension);
            return bitmap;
        }
        finally {
            dataSource.close();
        }
    }
}

