/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource;

import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.media3.common.PriorityTaskManager;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.TransferListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@UnstableApi
public final class PriorityDataSource
implements DataSource {
    private final DataSource upstream;
    private final PriorityTaskManager priorityTaskManager;
    private final int priority;

    public PriorityDataSource(DataSource upstream, PriorityTaskManager priorityTaskManager, int priority) {
        this.upstream = (DataSource)Assertions.checkNotNull((Object)upstream);
        this.priorityTaskManager = (PriorityTaskManager)Assertions.checkNotNull((Object)priorityTaskManager);
        this.priority = priority;
    }

    @Override
    public void addTransferListener(TransferListener transferListener) {
        Assertions.checkNotNull((Object)transferListener);
        this.upstream.addTransferListener(transferListener);
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        this.priorityTaskManager.proceedOrThrow(this.priority);
        return this.upstream.open(dataSpec);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        this.priorityTaskManager.proceedOrThrow(this.priority);
        return this.upstream.read(buffer, offset, length);
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.upstream.getUri();
    }

    @Override
    public Map<String, List<String>> getResponseHeaders() {
        return this.upstream.getResponseHeaders();
    }

    @Override
    public void close() throws IOException {
        this.upstream.close();
    }

    public static final class Factory
    implements DataSource.Factory {
        private final DataSource.Factory upstreamFactory;
        private final PriorityTaskManager priorityTaskManager;
        private final int priority;

        public Factory(DataSource.Factory upstreamFactory, PriorityTaskManager priorityTaskManager, int priority) {
            this.upstreamFactory = upstreamFactory;
            this.priorityTaskManager = priorityTaskManager;
            this.priority = priority;
        }

        @Override
        public PriorityDataSource createDataSource() {
            return new PriorityDataSource(this.upstreamFactory.createDataSource(), this.priorityTaskManager, this.priority);
        }
    }
}

