/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.container;

import androidx.annotation.Nullable;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.Format;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.CodecSpecificDataUtil;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.container.ParsableNalUnitBitArray;
import com.google.common.collect.ImmutableList;
import com.google.common.math.DoubleMath;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@UnstableApi
public final class NalUnitUtil {
    private static final String TAG = "NalUnitUtil";
    public static final int H264_NAL_UNIT_TYPE_NON_IDR = 1;
    @Deprecated
    public static final int NAL_UNIT_TYPE_NON_IDR = 1;
    public static final int H264_NAL_UNIT_TYPE_PARTITION_A = 2;
    @Deprecated
    public static final int NAL_UNIT_TYPE_PARTITION_A = 2;
    public static final int H264_NAL_UNIT_TYPE_IDR = 5;
    @Deprecated
    public static final int NAL_UNIT_TYPE_IDR = 5;
    public static final int H264_NAL_UNIT_TYPE_SEI = 6;
    @Deprecated
    public static final int NAL_UNIT_TYPE_SEI = 6;
    public static final int H264_NAL_UNIT_TYPE_SPS = 7;
    @Deprecated
    public static final int NAL_UNIT_TYPE_SPS = 7;
    public static final int H264_NAL_UNIT_TYPE_PPS = 8;
    @Deprecated
    public static final int NAL_UNIT_TYPE_PPS = 8;
    public static final int H264_NAL_UNIT_TYPE_AUD = 9;
    @Deprecated
    public static final int NAL_UNIT_TYPE_AUD = 9;
    public static final int H264_NAL_UNIT_TYPE_PREFIX = 14;
    @Deprecated
    public static final int NAL_UNIT_TYPE_PREFIX = 14;
    public static final int H265_NAL_UNIT_TYPE_RASL_R = 9;
    public static final int H265_NAL_UNIT_TYPE_BLA_W_LP = 16;
    public static final int H265_NAL_UNIT_TYPE_CRA = 21;
    public static final int H265_NAL_UNIT_TYPE_VPS = 32;
    public static final int H265_NAL_UNIT_TYPE_SPS = 33;
    public static final int H265_NAL_UNIT_TYPE_PPS = 34;
    public static final int H265_NAL_UNIT_TYPE_AUD = 35;
    public static final int H265_NAL_UNIT_TYPE_PREFIX_SEI = 39;
    public static final int H265_NAL_UNIT_TYPE_SUFFIX_SEI = 40;
    public static final byte[] NAL_START_CODE = new byte[]{0, 0, 0, 1};
    public static final int EXTENDED_SAR = 255;
    public static final float[] ASPECT_RATIO_IDC_VALUES = new float[]{1.0f, 1.0f, 1.0909091f, 0.90909094f, 1.4545455f, 1.2121212f, 2.1818182f, 1.8181819f, 2.909091f, 2.4242425f, 1.6363636f, 1.3636364f, 1.939394f, 1.6161616f, 1.3333334f, 1.5f, 2.0f};
    private static final int INVALID_ID = -1;
    private static final Object scratchEscapePositionsLock = new Object();
    private static int[] scratchEscapePositions = new int[10];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int unescapeStream(byte[] data, int limit) {
        Object object = scratchEscapePositionsLock;
        synchronized (object) {
            int position = 0;
            int scratchEscapeCount = 0;
            while (position < limit) {
                if ((position = NalUnitUtil.findNextUnescapeIndex(data, position, limit)) >= limit) continue;
                if (scratchEscapePositions.length <= scratchEscapeCount) {
                    scratchEscapePositions = Arrays.copyOf(scratchEscapePositions, scratchEscapePositions.length * 2);
                }
                NalUnitUtil.scratchEscapePositions[scratchEscapeCount++] = position;
                position += 3;
            }
            int unescapedLength = limit - scratchEscapeCount;
            int escapedPosition = 0;
            int unescapedPosition = 0;
            for (int i = 0; i < scratchEscapeCount; ++i) {
                int nextEscapePosition = scratchEscapePositions[i];
                int copyLength = nextEscapePosition - escapedPosition;
                System.arraycopy(data, escapedPosition, data, unescapedPosition, copyLength);
                unescapedPosition += copyLength;
                data[unescapedPosition++] = 0;
                data[unescapedPosition++] = 0;
                escapedPosition += copyLength + 3;
            }
            int remainingLength = unescapedLength - unescapedPosition;
            System.arraycopy(data, escapedPosition, data, unescapedPosition, remainingLength);
            return unescapedLength;
        }
    }

    public static void discardToSps(ByteBuffer data) {
        int length = data.position();
        int consecutiveZeros = 0;
        int offset = 0;
        while (offset + 1 < length) {
            int value = data.get(offset) & 0xFF;
            if (consecutiveZeros == 3) {
                if (value == 1 && (data.get(offset + 1) & 0x1F) == 7) {
                    ByteBuffer offsetData = data.duplicate();
                    offsetData.position(offset - 3);
                    offsetData.limit(length);
                    data.position(0);
                    data.put(offsetData);
                    return;
                }
            } else if (value == 0) {
                ++consecutiveZeros;
            }
            if (value != 0) {
                consecutiveZeros = 0;
            }
            ++offset;
        }
        data.clear();
    }

    public static boolean isNalUnitSei(@Nullable String mimeType, byte nalUnitHeaderFirstByte) {
        return "video/avc".equals(mimeType) && (nalUnitHeaderFirstByte & 0x1F) == 6 || "video/hevc".equals(mimeType) && (nalUnitHeaderFirstByte & 0x7E) >> 1 == 39;
    }

    public static boolean isNalUnitSei(Format format, byte nalUnitHeaderFirstByte) {
        return (Objects.equals(format.sampleMimeType, "video/avc") || MimeTypes.containsCodecsCorrespondingToMimeType((String)format.codecs, (String)"video/avc")) && (nalUnitHeaderFirstByte & 0x1F) == 6 || (Objects.equals(format.sampleMimeType, "video/hevc") || MimeTypes.containsCodecsCorrespondingToMimeType((String)format.codecs, (String)"video/hevc")) && (nalUnitHeaderFirstByte & 0x7E) >> 1 == 39;
    }

    public static int getNalUnitType(byte[] data, int offset) {
        return data[offset + 3] & 0x1F;
    }

    public static boolean isH264NalUnitDependedOn(byte nalUnitHeaderFirstByte) {
        int nalRefIdc = (nalUnitHeaderFirstByte & 0x60) >> 5;
        if (nalRefIdc != 0) {
            return true;
        }
        int nalUnitType = nalUnitHeaderFirstByte & 0x1F;
        if (nalUnitType == 1) {
            return false;
        }
        if (nalUnitType == 9) {
            return false;
        }
        return nalUnitType != 14;
    }

    public static int getH265NalUnitType(byte[] data, int offset) {
        return (data[offset + 3] & 0x7E) >> 1;
    }

    public static SpsData parseSpsNalUnit(byte[] nalData, int nalOffset, int nalLimit) {
        return NalUnitUtil.parseSpsNalUnitPayload(nalData, nalOffset + 1, nalLimit);
    }

    public static SpsData parseSpsNalUnitPayload(byte[] nalData, int nalOffset, int nalLimit) {
        int maxNumReorderFrames;
        ParsableNalUnitBitArray data = new ParsableNalUnitBitArray(nalData, nalOffset, nalLimit);
        int profileIdc = data.readBits(8);
        int constraintsFlagsAndReservedZero2Bits = data.readBits(8);
        int levelIdc = data.readBits(8);
        int seqParameterSetId = data.readUnsignedExpGolombCodedInt();
        int chromaFormatIdc = 1;
        boolean separateColorPlaneFlag = false;
        int bitDepthLumaMinus8 = 0;
        int bitDepthChromaMinus8 = 0;
        if (profileIdc == 100 || profileIdc == 110 || profileIdc == 122 || profileIdc == 244 || profileIdc == 44 || profileIdc == 83 || profileIdc == 86 || profileIdc == 118 || profileIdc == 128 || profileIdc == 138) {
            chromaFormatIdc = data.readUnsignedExpGolombCodedInt();
            if (chromaFormatIdc == 3) {
                separateColorPlaneFlag = data.readBit();
            }
            bitDepthLumaMinus8 = data.readUnsignedExpGolombCodedInt();
            bitDepthChromaMinus8 = data.readUnsignedExpGolombCodedInt();
            data.skipBit();
            boolean seqScalingMatrixPresentFlag = data.readBit();
            if (seqScalingMatrixPresentFlag) {
                int limit = chromaFormatIdc != 3 ? 8 : 12;
                for (int i = 0; i < limit; ++i) {
                    boolean seqScalingListPresentFlag = data.readBit();
                    if (!seqScalingListPresentFlag) continue;
                    NalUnitUtil.skipScalingList(data, i < 6 ? 16 : 64);
                }
            }
        }
        int frameNumLength = data.readUnsignedExpGolombCodedInt() + 4;
        int picOrderCntType = data.readUnsignedExpGolombCodedInt();
        int picOrderCntLsbLength = 0;
        boolean deltaPicOrderAlwaysZeroFlag = false;
        if (picOrderCntType == 0) {
            picOrderCntLsbLength = data.readUnsignedExpGolombCodedInt() + 4;
        } else if (picOrderCntType == 1) {
            deltaPicOrderAlwaysZeroFlag = data.readBit();
            data.readSignedExpGolombCodedInt();
            data.readSignedExpGolombCodedInt();
            long numRefFramesInPicOrderCntCycle = data.readUnsignedExpGolombCodedInt();
            int i = 0;
            while ((long)i < numRefFramesInPicOrderCntCycle) {
                data.readUnsignedExpGolombCodedInt();
                ++i;
            }
        }
        int maxNumRefFrames = data.readUnsignedExpGolombCodedInt();
        data.skipBit();
        int picWidthInMbs = data.readUnsignedExpGolombCodedInt() + 1;
        int picHeightInMapUnits = data.readUnsignedExpGolombCodedInt() + 1;
        boolean frameMbsOnlyFlag = data.readBit();
        int frameHeightInMbs = (2 - (frameMbsOnlyFlag ? 1 : 0)) * picHeightInMapUnits;
        if (!frameMbsOnlyFlag) {
            data.skipBit();
        }
        data.skipBit();
        int frameWidth = picWidthInMbs * 16;
        int frameHeight = frameHeightInMbs * 16;
        boolean frameCroppingFlag = data.readBit();
        if (frameCroppingFlag) {
            int cropUnitY;
            int cropUnitX;
            int frameCropLeftOffset = data.readUnsignedExpGolombCodedInt();
            int frameCropRightOffset = data.readUnsignedExpGolombCodedInt();
            int frameCropTopOffset = data.readUnsignedExpGolombCodedInt();
            int frameCropBottomOffset = data.readUnsignedExpGolombCodedInt();
            if (chromaFormatIdc == 0) {
                cropUnitX = 1;
                cropUnitY = 2 - (frameMbsOnlyFlag ? 1 : 0);
            } else {
                int subWidthC = chromaFormatIdc == 3 ? 1 : 2;
                int subHeightC = chromaFormatIdc == 1 ? 2 : 1;
                cropUnitX = subWidthC;
                cropUnitY = subHeightC * (2 - (frameMbsOnlyFlag ? 1 : 0));
            }
            frameWidth -= (frameCropLeftOffset + frameCropRightOffset) * cropUnitX;
            frameHeight -= (frameCropTopOffset + frameCropBottomOffset) * cropUnitY;
        }
        int colorSpace = -1;
        int colorRange = -1;
        int colorTransfer = -1;
        float pixelWidthHeightRatio = 1.0f;
        int n = maxNumReorderFrames = (profileIdc == 44 || profileIdc == 86 || profileIdc == 100 || profileIdc == 110 || profileIdc == 122 || profileIdc == 244) && (constraintsFlagsAndReservedZero2Bits & 0x10) != 0 ? 0 : 16;
        if (data.readBit()) {
            boolean vclHrdParametersPresent;
            boolean nalHrdParametersPresent;
            boolean aspectRatioInfoPresentFlag = data.readBit();
            if (aspectRatioInfoPresentFlag) {
                int aspectRatioIdc = data.readBits(8);
                if (aspectRatioIdc == 255) {
                    int sarWidth = data.readBits(16);
                    int sarHeight = data.readBits(16);
                    if (sarWidth != 0 && sarHeight != 0) {
                        pixelWidthHeightRatio = (float)sarWidth / (float)sarHeight;
                    }
                } else if (aspectRatioIdc < ASPECT_RATIO_IDC_VALUES.length) {
                    pixelWidthHeightRatio = ASPECT_RATIO_IDC_VALUES[aspectRatioIdc];
                } else {
                    Log.w((String)TAG, (String)("Unexpected aspect_ratio_idc value: " + aspectRatioIdc));
                }
            }
            if (data.readBit()) {
                data.skipBit();
            }
            if (data.readBit()) {
                data.skipBits(3);
                int n2 = colorRange = data.readBit() ? 1 : 2;
                if (data.readBit()) {
                    int colorPrimaries = data.readBits(8);
                    int transferCharacteristics = data.readBits(8);
                    data.skipBits(8);
                    colorSpace = ColorInfo.isoColorPrimariesToColorSpace((int)colorPrimaries);
                    colorTransfer = ColorInfo.isoTransferCharacteristicsToColorTransfer((int)transferCharacteristics);
                }
            }
            if (data.readBit()) {
                data.readUnsignedExpGolombCodedInt();
                data.readUnsignedExpGolombCodedInt();
            }
            if (data.readBit()) {
                data.skipBits(65);
            }
            if (nalHrdParametersPresent = data.readBit()) {
                NalUnitUtil.skipHrdParameters(data);
            }
            if (vclHrdParametersPresent = data.readBit()) {
                NalUnitUtil.skipHrdParameters(data);
            }
            if (nalHrdParametersPresent || vclHrdParametersPresent) {
                data.skipBit();
            }
            data.skipBit();
            if (data.readBit()) {
                data.skipBit();
                data.readUnsignedExpGolombCodedInt();
                data.readUnsignedExpGolombCodedInt();
                data.readUnsignedExpGolombCodedInt();
                data.readUnsignedExpGolombCodedInt();
                maxNumReorderFrames = data.readUnsignedExpGolombCodedInt();
                data.readUnsignedExpGolombCodedInt();
            }
        }
        return new SpsData(profileIdc, constraintsFlagsAndReservedZero2Bits, levelIdc, seqParameterSetId, maxNumRefFrames, frameWidth, frameHeight, pixelWidthHeightRatio, bitDepthLumaMinus8, bitDepthChromaMinus8, separateColorPlaneFlag, frameMbsOnlyFlag, frameNumLength, picOrderCntType, picOrderCntLsbLength, deltaPicOrderAlwaysZeroFlag, colorSpace, colorRange, colorTransfer, maxNumReorderFrames);
    }

    public static H265VpsData parseH265VpsNalUnit(byte[] nalData, int nalOffset, int nalLimit) {
        ParsableNalUnitBitArray data = new ParsableNalUnitBitArray(nalData, nalOffset, nalLimit);
        H265NalHeader nalHeader = NalUnitUtil.parseH265NalHeader(data);
        return NalUnitUtil.parseH265VpsNalUnitPayload(data, nalHeader);
    }

    private static H265NalHeader parseH265NalHeader(ParsableNalUnitBitArray data) {
        data.skipBit();
        int nalUnitType = data.readBits(6);
        int layerId = data.readBits(6);
        int temporalId = data.readBits(3) - 1;
        return new H265NalHeader(nalUnitType, layerId, temporalId);
    }

    private static H265VpsData parseH265VpsNalUnitPayload(ParsableNalUnitBitArray data, H265NalHeader nalHeader) {
        int i;
        int j;
        int i2;
        boolean haveLargeEnoughMaxLayerIdInNuh;
        int i3;
        data.skipBits(4);
        boolean baseLayerInternalFlag = data.readBit();
        boolean baseLayerAvailableFlag = data.readBit();
        int maxLayers = data.readBits(6) + 1;
        int maxSubLayersMinus1 = data.readBits(3);
        data.skipBits(17);
        H265ProfileTierLevel profileTierLevel = NalUnitUtil.parseH265ProfileTierLevel(data, true, maxSubLayersMinus1, null);
        int n = i3 = data.readBit() ? 0 : maxSubLayersMinus1;
        while (i3 <= maxSubLayersMinus1) {
            data.readUnsignedExpGolombCodedInt();
            data.readUnsignedExpGolombCodedInt();
            data.readUnsignedExpGolombCodedInt();
            ++i3;
        }
        int maxLayerId = data.readBits(6);
        int numLayerSets = data.readUnsignedExpGolombCodedInt() + 1;
        ImmutableList profileTierLevels = ImmutableList.of((Object)profileTierLevel);
        H265ProfileTierLevelsAndIndices baseLayerProfileTierLevelsAndIndices = new H265ProfileTierLevelsAndIndices((List<H265ProfileTierLevel>)profileTierLevels, new int[1]);
        boolean haveEnoughLayerSets = maxLayers >= 2 && numLayerSets >= 2;
        boolean baseLayerIncluded = baseLayerInternalFlag && baseLayerAvailableFlag;
        boolean bl = haveLargeEnoughMaxLayerIdInNuh = maxLayerId + 1 >= maxLayers;
        if (!(haveEnoughLayerSets && baseLayerIncluded && haveLargeEnoughMaxLayerIdInNuh)) {
            return new H265VpsData(nalHeader, null, baseLayerProfileTierLevelsAndIndices, null, null);
        }
        int[][] layerSetLayerIdList = new int[numLayerSets][maxLayerId + 1];
        int[] numLayersInIdList = new int[numLayerSets];
        int[] layerSetMaxLayerId = new int[numLayerSets];
        layerSetLayerIdList[0][0] = 0;
        numLayersInIdList[0] = 1;
        layerSetMaxLayerId[0] = 0;
        for (int i4 = 1; i4 < numLayerSets; ++i4) {
            int n2 = 0;
            for (int j2 = 0; j2 <= maxLayerId; ++j2) {
                if (data.readBit()) {
                    layerSetLayerIdList[i4][n2++] = j2;
                    layerSetMaxLayerId[i4] = j2;
                }
                numLayersInIdList[i4] = n2;
            }
        }
        if (data.readBit()) {
            data.skipBits(64);
            if (data.readBit()) {
                data.readUnsignedExpGolombCodedInt();
            }
            int numHrdParameters = data.readUnsignedExpGolombCodedInt();
            for (int i5 = 0; i5 < numHrdParameters; ++i5) {
                data.readUnsignedExpGolombCodedInt();
                NalUnitUtil.skipH265HrdParameters(data, i5 == 0 || data.readBit(), maxSubLayersMinus1);
            }
        }
        if (!data.readBit()) {
            return new H265VpsData(nalHeader, null, baseLayerProfileTierLevelsAndIndices, null, null);
        }
        data.byteAlign();
        H265ProfileTierLevel baseLayerProfileTierLevel = NalUnitUtil.parseH265ProfileTierLevel(data, false, maxSubLayersMinus1, profileTierLevel);
        boolean splittingFlag = data.readBit();
        boolean[] scalabilityMaskFlag = new boolean[16];
        int numScalabilityTypes = 0;
        for (int i6 = 0; i6 < 16; ++i6) {
            scalabilityMaskFlag[i6] = data.readBit();
            if (!scalabilityMaskFlag[i6]) continue;
            ++numScalabilityTypes;
        }
        if (numScalabilityTypes == 0 || !scalabilityMaskFlag[1]) {
            return new H265VpsData(nalHeader, null, baseLayerProfileTierLevelsAndIndices, null, null);
        }
        int[] dimensionIdLenMinus1 = new int[numScalabilityTypes];
        for (int i7 = 0; i7 < numScalabilityTypes - (splittingFlag ? 1 : 0); ++i7) {
            dimensionIdLenMinus1[i7] = data.readBits(3);
        }
        int[] dimBitOffset = new int[numScalabilityTypes + 1];
        if (splittingFlag) {
            for (int i8 = 1; i8 < numScalabilityTypes; ++i8) {
                for (int j3 = 0; j3 < i8; ++j3) {
                    int n3 = i8;
                    dimBitOffset[n3] = dimBitOffset[n3] + (dimensionIdLenMinus1[j3] + 1);
                }
            }
            dimBitOffset[numScalabilityTypes] = 6;
        }
        int[][] dimensionId = new int[maxLayers][numScalabilityTypes];
        int[] layerIdInNuh = new int[maxLayers];
        layerIdInNuh[0] = 0;
        boolean nuhLayerIdPresentFlag = data.readBit();
        for (int i9 = 1; i9 < maxLayers; ++i9) {
            int j4;
            layerIdInNuh[i9] = nuhLayerIdPresentFlag ? data.readBits(6) : i9;
            if (!splittingFlag) {
                for (j4 = 0; j4 < numScalabilityTypes; ++j4) {
                    dimensionId[i9][j4] = data.readBits(dimensionIdLenMinus1[j4] + 1);
                }
                continue;
            }
            for (j4 = 0; j4 < numScalabilityTypes; ++j4) {
                dimensionId[i9][j4] = (layerIdInNuh[i9] & (1 << dimBitOffset[j4 + 1]) - 1) >> dimBitOffset[j4];
            }
        }
        int[] viewOrderIdx = new int[maxLayerId + 1];
        int numViews = 1;
        for (int i10 = 0; i10 < maxLayers; ++i10) {
            viewOrderIdx[layerIdInNuh[i10]] = -1;
            int j5 = 0;
            for (int scalabilityMaskFlagIndex = 0; scalabilityMaskFlagIndex < 16; ++scalabilityMaskFlagIndex) {
                if (!scalabilityMaskFlag[scalabilityMaskFlagIndex]) continue;
                if (scalabilityMaskFlagIndex == 1) {
                    viewOrderIdx[layerIdInNuh[i10]] = dimensionId[i10][j5];
                }
                ++j5;
            }
            if (i10 <= 0) continue;
            boolean newView = true;
            for (j5 = 0; j5 < i10; ++j5) {
                if (viewOrderIdx[layerIdInNuh[i10]] != viewOrderIdx[layerIdInNuh[j5]]) continue;
                newView = false;
                break;
            }
            if (!newView) continue;
            ++numViews;
        }
        int viewIdLen = data.readBits(4);
        if (numViews < 2 || viewIdLen == 0) {
            return new H265VpsData(nalHeader, null, baseLayerProfileTierLevelsAndIndices, null, null);
        }
        int[] viewIdVals = new int[numViews];
        for (int i11 = 0; i11 < numViews; ++i11) {
            viewIdVals[i11] = data.readBits(viewIdLen);
        }
        int[] layerIdInVps = new int[maxLayerId + 1];
        for (int i12 = 0; i12 < maxLayers; ++i12) {
            layerIdInVps[Math.min((int)layerIdInNuh[i12], (int)maxLayerId)] = i12;
        }
        ImmutableList.Builder layerInfosBuilder = ImmutableList.builder();
        for (int i13 = 0; i13 <= maxLayerId; ++i13) {
            int viewIdValIdx = Math.min(viewOrderIdx[i13], numViews - 1);
            int viewIdVal = viewIdValIdx >= 0 ? viewIdVals[viewIdValIdx] : -1;
            layerInfosBuilder.add((Object)new H265LayerInfo(layerIdInVps[i13], viewIdVal));
        }
        ImmutableList layerInfos = layerInfosBuilder.build();
        if (((H265LayerInfo)layerInfos.get((int)0)).viewId == -1) {
            return new H265VpsData(nalHeader, null, baseLayerProfileTierLevelsAndIndices, null, null);
        }
        int secondaryViewLayerId = -1;
        for (int i14 = 1; i14 <= maxLayerId; ++i14) {
            if (((H265LayerInfo)layerInfos.get((int)i14)).viewId == -1) continue;
            secondaryViewLayerId = i14;
            break;
        }
        if (secondaryViewLayerId == -1) {
            return new H265VpsData(nalHeader, null, baseLayerProfileTierLevelsAndIndices, null, null);
        }
        boolean[][] directDependencyFlag = new boolean[maxLayers][maxLayers];
        boolean[][] dependencyFlag = new boolean[maxLayers][maxLayers];
        for (i2 = 1; i2 < maxLayers; ++i2) {
            for (j = 0; j < i2; ++j) {
                boolean bl2 = data.readBit();
                dependencyFlag[i2][j] = bl2;
                directDependencyFlag[i2][j] = bl2;
            }
        }
        for (i2 = 1; i2 < maxLayers; ++i2) {
            block21: for (j = 0; j < maxLayers - 1; ++j) {
                for (int k = 0; k < i2; ++k) {
                    if (!dependencyFlag[i2][k] || !dependencyFlag[k][j]) continue;
                    dependencyFlag[i2][j] = true;
                    continue block21;
                }
            }
        }
        int[] numDirectRefLayers = new int[maxLayerId + 1];
        for (int i15 = 0; i15 < maxLayers; ++i15) {
            int d = 0;
            for (int j6 = 0; j6 < i15; ++j6) {
                d += directDependencyFlag[i15][j6] ? 1 : 0;
            }
            numDirectRefLayers[layerIdInNuh[i15]] = d;
        }
        int numIndependentLayers = 0;
        for (int i16 = 0; i16 < maxLayers; ++i16) {
            if (numDirectRefLayers[layerIdInNuh[i16]] != 0) continue;
            ++numIndependentLayers;
        }
        if (numIndependentLayers > 1) {
            return new H265VpsData(nalHeader, null, baseLayerProfileTierLevelsAndIndices, null, null);
        }
        int[] subLayersVpsMaxMinus1 = new int[maxLayers];
        int[] maxSubLayersInLayerSet = new int[numLayerSets];
        if (data.readBit()) {
            for (i = 0; i < maxLayers; ++i) {
                subLayersVpsMaxMinus1[i] = data.readBits(3);
            }
        } else {
            Arrays.fill(subLayersVpsMaxMinus1, 0, maxLayers, maxSubLayersMinus1);
        }
        for (i = 0; i < numLayerSets; ++i) {
            int layerSetMaxSubLayersMinus1 = 0;
            for (int k = 0; k < numLayersInIdList[i]; ++k) {
                int layerId = layerSetLayerIdList[i][k];
                layerSetMaxSubLayersMinus1 = Math.max(layerSetMaxSubLayersMinus1, subLayersVpsMaxMinus1[((H265LayerInfo)layerInfos.get((int)layerId)).layerIdInVps]);
            }
            maxSubLayersInLayerSet[i] = layerSetMaxSubLayersMinus1 + 1;
        }
        if (data.readBit()) {
            for (i = 0; i < maxLayers - 1; ++i) {
                for (int j7 = i + 1; j7 < maxLayers; ++j7) {
                    if (!directDependencyFlag[j7][i]) continue;
                    data.skipBits(3);
                }
            }
        }
        data.skipBit();
        int numProfileTierLevels = data.readUnsignedExpGolombCodedInt() + 1;
        ImmutableList.Builder profileTierLevelsBuilder = ImmutableList.builder();
        profileTierLevelsBuilder.add((Object)profileTierLevel);
        if (numProfileTierLevels > 1) {
            profileTierLevelsBuilder.add((Object)baseLayerProfileTierLevel);
            H265ProfileTierLevel prevProfileTierLevel = baseLayerProfileTierLevel;
            for (int i17 = 2; i17 < numProfileTierLevels; ++i17) {
                H265ProfileTierLevel nextProfileTierLevel = NalUnitUtil.parseH265ProfileTierLevel(data, data.readBit(), maxSubLayersMinus1, prevProfileTierLevel);
                profileTierLevelsBuilder.add((Object)nextProfileTierLevel);
                prevProfileTierLevel = nextProfileTierLevel;
            }
        }
        profileTierLevels = profileTierLevelsBuilder.build();
        int numOutputLayerSets = numLayerSets + data.readUnsignedExpGolombCodedInt();
        if (numOutputLayerSets > numLayerSets) {
            return new H265VpsData(nalHeader, null, baseLayerProfileTierLevelsAndIndices, null, null);
        }
        int defaultOutputLayerIdc = data.readBits(2);
        boolean[][] outputLayerFlag = new boolean[numOutputLayerSets][maxLayerId + 1];
        int[] numOutputLayersInOutputLayerSet = new int[numOutputLayerSets];
        int[] olsHighestOutputLayerId = new int[numOutputLayerSets];
        for (int i18 = 0; i18 < numLayerSets; ++i18) {
            numOutputLayersInOutputLayerSet[i18] = 0;
            olsHighestOutputLayerId[i18] = layerSetMaxLayerId[i18];
            if (defaultOutputLayerIdc == 0) {
                Arrays.fill(outputLayerFlag[i18], 0, numLayersInIdList[i18], true);
                numOutputLayersInOutputLayerSet[i18] = numLayersInIdList[i18];
                continue;
            }
            if (defaultOutputLayerIdc == 1) {
                int highestLayerId = layerSetMaxLayerId[i18];
                for (int j8 = 0; j8 < numLayersInIdList[i18]; ++j8) {
                    outputLayerFlag[i18][j8] = layerSetLayerIdList[i18][j8] == highestLayerId;
                }
                numOutputLayersInOutputLayerSet[i18] = 1;
                continue;
            }
            outputLayerFlag[0][0] = true;
            numOutputLayersInOutputLayerSet[0] = 1;
        }
        int[] profileTierLevelIndices = new int[maxLayerId + 1];
        boolean[][] necessaryLayerFlag = new boolean[numOutputLayerSets][maxLayerId + 1];
        int targetOutputLayerSetIdx = 0;
        for (int i19 = 1; i19 < numOutputLayerSets; ++i19) {
            int j9;
            if (defaultOutputLayerIdc == 2) {
                for (j9 = 0; j9 < numLayersInIdList[i19]; ++j9) {
                    outputLayerFlag[i19][j9] = data.readBit();
                    int n4 = i19;
                    numOutputLayersInOutputLayerSet[n4] = numOutputLayersInOutputLayerSet[n4] + (outputLayerFlag[i19][j9] ? 1 : 0);
                    if (!outputLayerFlag[i19][j9]) continue;
                    olsHighestOutputLayerId[i19] = layerSetLayerIdList[i19][j9];
                }
            }
            if (targetOutputLayerSetIdx == 0 && layerSetLayerIdList[i19][0] == 0 && outputLayerFlag[i19][0]) {
                for (j9 = 1; j9 < numLayersInIdList[i19]; ++j9) {
                    if (layerSetLayerIdList[i19][j9] != secondaryViewLayerId || !outputLayerFlag[i19][secondaryViewLayerId]) continue;
                    targetOutputLayerSetIdx = i19;
                }
            }
            for (j9 = 0; j9 < numLayersInIdList[i19]; ++j9) {
                if (numProfileTierLevels <= 1) continue;
                necessaryLayerFlag[i19][j9] = outputLayerFlag[i19][j9];
                int bitLen = DoubleMath.log2((double)numProfileTierLevels, (RoundingMode)RoundingMode.CEILING);
                if (!necessaryLayerFlag[i19][j9]) {
                    int currLayerIdInVps = ((H265LayerInfo)layerInfos.get((int)layerSetLayerIdList[i19][j9])).layerIdInVps;
                    for (int k = 0; k < j9; ++k) {
                        int refLayerIdInVps = ((H265LayerInfo)layerInfos.get((int)layerSetLayerIdList[i19][k])).layerIdInVps;
                        if (!dependencyFlag[currLayerIdInVps][refLayerIdInVps]) continue;
                        necessaryLayerFlag[i19][j9] = true;
                        break;
                    }
                }
                if (!necessaryLayerFlag[i19][j9]) continue;
                if (targetOutputLayerSetIdx > 0 && i19 == targetOutputLayerSetIdx) {
                    profileTierLevelIndices[j9] = data.readBits(bitLen);
                    continue;
                }
                data.skipBits(bitLen);
            }
            if (numOutputLayersInOutputLayerSet[i19] != 1 || numDirectRefLayers[olsHighestOutputLayerId[i19]] <= 0) continue;
            data.skipBit();
        }
        if (targetOutputLayerSetIdx == 0) {
            return new H265VpsData(nalHeader, null, baseLayerProfileTierLevelsAndIndices, null, null);
        }
        H265RepFormatsAndIndices repFormatsAndIndices = NalUnitUtil.parseH265RepFormatsAndIndices(data, maxLayers);
        data.skipBits(2);
        for (int i20 = 1; i20 < maxLayers; ++i20) {
            if (numDirectRefLayers[layerIdInNuh[i20]] != 0) continue;
            data.skipBit();
        }
        NalUnitUtil.skipH265DpbSize(data, numOutputLayerSets, maxSubLayersInLayerSet, numLayersInIdList, necessaryLayerFlag);
        NalUnitUtil.skipToH265VuiPresentFlagAfterDpbSize(data, maxLayers, directDependencyFlag);
        H265VideoSignalInfosAndIndices videoSignalInfosAndIndices = null;
        if (data.readBit()) {
            data.byteAlign();
            videoSignalInfosAndIndices = NalUnitUtil.parseH265VideoSignalInfosAndIndices(data, maxLayers, numLayerSets, maxSubLayersInLayerSet);
        }
        return new H265VpsData(nalHeader, (List<H265LayerInfo>)layerInfos, new H265ProfileTierLevelsAndIndices((List<H265ProfileTierLevel>)profileTierLevels, profileTierLevelIndices), repFormatsAndIndices, videoSignalInfosAndIndices);
    }

    public static H265SpsData parseH265SpsNalUnit(byte[] nalData, int nalOffset, int nalLimit, @Nullable H265VpsData vpsData) {
        H265NalHeader nalHeader = NalUnitUtil.parseH265NalHeader(new ParsableNalUnitBitArray(nalData, nalOffset, nalLimit));
        return NalUnitUtil.parseH265SpsNalUnitPayload(nalData, nalOffset + 2, nalLimit, nalHeader, vpsData);
    }

    public static H265SpsData parseH265SpsNalUnitPayload(byte[] nalData, int nalOffset, int nalLimit, H265NalHeader nalHeader, @Nullable H265VpsData vpsData) {
        ParsableNalUnitBitArray data = new ParsableNalUnitBitArray(nalData, nalOffset, nalLimit);
        data.skipBits(4);
        int maxSubLayersMinus1 = data.readBits(3);
        boolean multiLayerExtSpsFlag = nalHeader.layerId != 0 && maxSubLayersMinus1 == 7;
        int layerIdInVps = 0;
        if (vpsData != null && !vpsData.layerInfos.isEmpty()) {
            int layerId = Math.min(nalHeader.layerId, vpsData.layerInfos.size() - 1);
            layerIdInVps = ((H265LayerInfo)vpsData.layerInfos.get((int)layerId)).layerIdInVps;
        }
        H265ProfileTierLevel profileTierLevel = null;
        if (!multiLayerExtSpsFlag) {
            data.skipBit();
            profileTierLevel = NalUnitUtil.parseH265ProfileTierLevel(data, true, maxSubLayersMinus1, null);
        } else if (vpsData != null) {
            int profileTierLevelIdx = vpsData.profileTierLevelsAndIndices.indices[layerIdInVps];
            if (vpsData.profileTierLevelsAndIndices.profileTierLevels.size() > profileTierLevelIdx) {
                profileTierLevel = (H265ProfileTierLevel)vpsData.profileTierLevelsAndIndices.profileTierLevels.get(profileTierLevelIdx);
            }
        }
        int seqParameterSetId = data.readUnsignedExpGolombCodedInt();
        int chromaFormatIdc = 0;
        int frameWidth = 0;
        int frameHeight = 0;
        int bitDepthLumaMinus8 = 0;
        int bitDepthChromaMinus8 = 0;
        int spsRepFormatIdx = -1;
        if (multiLayerExtSpsFlag) {
            if (data.readBit()) {
                spsRepFormatIdx = data.readBits(8);
            }
            if (vpsData != null && vpsData.repFormatsAndIndices != null) {
                if (spsRepFormatIdx == -1) {
                    spsRepFormatIdx = vpsData.repFormatsAndIndices.indices[layerIdInVps];
                }
                if (spsRepFormatIdx != -1 && vpsData.repFormatsAndIndices.repFormats.size() > spsRepFormatIdx) {
                    H265RepFormat repFormat = (H265RepFormat)vpsData.repFormatsAndIndices.repFormats.get(spsRepFormatIdx);
                    chromaFormatIdc = repFormat.chromaFormatIdc;
                    frameWidth = repFormat.width;
                    frameHeight = repFormat.height;
                    bitDepthLumaMinus8 = repFormat.bitDepthLumaMinus8;
                    bitDepthChromaMinus8 = repFormat.bitDepthChromaMinus8;
                }
            }
        } else {
            chromaFormatIdc = data.readUnsignedExpGolombCodedInt();
            if (chromaFormatIdc == 3) {
                data.skipBit();
            }
            frameWidth = data.readUnsignedExpGolombCodedInt();
            frameHeight = data.readUnsignedExpGolombCodedInt();
            if (data.readBit()) {
                int confWinLeftOffset = data.readUnsignedExpGolombCodedInt();
                int confWinRightOffset = data.readUnsignedExpGolombCodedInt();
                int confWinTopOffset = data.readUnsignedExpGolombCodedInt();
                int confWinBottomOffset = data.readUnsignedExpGolombCodedInt();
                frameWidth = NalUnitUtil.applyConformanceWindowToWidth(frameWidth, chromaFormatIdc, confWinLeftOffset, confWinRightOffset);
                frameHeight = NalUnitUtil.applyConformanceWindowToHeight(frameHeight, chromaFormatIdc, confWinTopOffset, confWinBottomOffset);
            }
            bitDepthLumaMinus8 = data.readUnsignedExpGolombCodedInt();
            bitDepthChromaMinus8 = data.readUnsignedExpGolombCodedInt();
        }
        int log2MaxPicOrderCntLsbMinus4 = data.readUnsignedExpGolombCodedInt();
        int maxNumReorderPics = -1;
        if (!multiLayerExtSpsFlag) {
            int i;
            int n = i = data.readBit() ? 0 : maxSubLayersMinus1;
            while (i <= maxSubLayersMinus1) {
                data.readUnsignedExpGolombCodedInt();
                maxNumReorderPics = Math.max(data.readUnsignedExpGolombCodedInt(), maxNumReorderPics);
                data.readUnsignedExpGolombCodedInt();
                ++i;
            }
        }
        data.readUnsignedExpGolombCodedInt();
        data.readUnsignedExpGolombCodedInt();
        data.readUnsignedExpGolombCodedInt();
        data.readUnsignedExpGolombCodedInt();
        data.readUnsignedExpGolombCodedInt();
        data.readUnsignedExpGolombCodedInt();
        if (data.readBit()) {
            boolean inferScalingListFlag = false;
            if (multiLayerExtSpsFlag) {
                inferScalingListFlag = data.readBit();
            }
            if (inferScalingListFlag) {
                data.skipBits(6);
            } else if (data.readBit()) {
                NalUnitUtil.skipH265ScalingList(data);
            }
        }
        data.skipBits(2);
        if (data.readBit()) {
            data.skipBits(8);
            data.readUnsignedExpGolombCodedInt();
            data.readUnsignedExpGolombCodedInt();
            data.skipBit();
        }
        NalUnitUtil.skipH265ShortTermReferencePictureSets(data);
        if (data.readBit()) {
            int numLongTermRefPicsSps = data.readUnsignedExpGolombCodedInt();
            for (int i = 0; i < numLongTermRefPicsSps; ++i) {
                int ltRefPicPocLsbSpsLength = log2MaxPicOrderCntLsbMinus4 + 4;
                data.skipBits(ltRefPicPocLsbSpsLength + 1);
            }
        }
        data.skipBits(2);
        int colorSpace = -1;
        int colorRange = -1;
        int colorTransfer = -1;
        float pixelWidthHeightRatio = 1.0f;
        if (data.readBit()) {
            if (data.readBit()) {
                int aspectRatioIdc = data.readBits(8);
                if (aspectRatioIdc == 255) {
                    int sarWidth = data.readBits(16);
                    int sarHeight = data.readBits(16);
                    if (sarWidth != 0 && sarHeight != 0) {
                        pixelWidthHeightRatio = (float)sarWidth / (float)sarHeight;
                    }
                } else if (aspectRatioIdc < ASPECT_RATIO_IDC_VALUES.length) {
                    pixelWidthHeightRatio = ASPECT_RATIO_IDC_VALUES[aspectRatioIdc];
                } else {
                    Log.w((String)TAG, (String)("Unexpected aspect_ratio_idc value: " + aspectRatioIdc));
                }
            }
            if (data.readBit()) {
                data.skipBit();
            }
            if (data.readBit()) {
                data.skipBits(3);
                int n = colorRange = data.readBit() ? 1 : 2;
                if (data.readBit()) {
                    int colorPrimaries = data.readBits(8);
                    int transferCharacteristics = data.readBits(8);
                    data.skipBits(8);
                    colorSpace = ColorInfo.isoColorPrimariesToColorSpace((int)colorPrimaries);
                    colorTransfer = ColorInfo.isoTransferCharacteristicsToColorTransfer((int)transferCharacteristics);
                }
            } else if (vpsData != null && vpsData.videoSignalInfosAndIndices != null) {
                int videoSignalInfoIdx = vpsData.videoSignalInfosAndIndices.indices[layerIdInVps];
                if (vpsData.videoSignalInfosAndIndices.videoSignalInfos.size() > videoSignalInfoIdx) {
                    H265VideoSignalInfo videoSignalInfo = (H265VideoSignalInfo)vpsData.videoSignalInfosAndIndices.videoSignalInfos.get(videoSignalInfoIdx);
                    colorSpace = videoSignalInfo.colorSpace;
                    colorRange = videoSignalInfo.colorRange;
                    colorTransfer = videoSignalInfo.colorTransfer;
                }
            }
            if (data.readBit()) {
                data.readUnsignedExpGolombCodedInt();
                data.readUnsignedExpGolombCodedInt();
            }
            data.skipBit();
            if (data.readBit()) {
                frameHeight *= 2;
            }
        }
        return new H265SpsData(nalHeader, profileTierLevel, chromaFormatIdc, bitDepthLumaMinus8, bitDepthChromaMinus8, seqParameterSetId, frameWidth, frameHeight, pixelWidthHeightRatio, maxNumReorderPics, colorSpace, colorRange, colorTransfer);
    }

    public static PpsData parsePpsNalUnit(byte[] nalData, int nalOffset, int nalLimit) {
        return NalUnitUtil.parsePpsNalUnitPayload(nalData, nalOffset + 1, nalLimit);
    }

    public static PpsData parsePpsNalUnitPayload(byte[] nalData, int nalOffset, int nalLimit) {
        ParsableNalUnitBitArray data = new ParsableNalUnitBitArray(nalData, nalOffset, nalLimit);
        int picParameterSetId = data.readUnsignedExpGolombCodedInt();
        int seqParameterSetId = data.readUnsignedExpGolombCodedInt();
        data.skipBit();
        boolean bottomFieldPicOrderInFramePresentFlag = data.readBit();
        return new PpsData(picParameterSetId, seqParameterSetId, bottomFieldPicOrderInFramePresentFlag);
    }

    @Nullable
    public static H265Sei3dRefDisplayInfoData parseH265Sei3dRefDisplayInfo(byte[] nalData, int nalOffset, int nalLimit) {
        int last1BitBytePos;
        int seiRbspPos = nalOffset + 2;
        for (last1BitBytePos = nalLimit - 1; nalData[last1BitBytePos] == 0 && last1BitBytePos > seiRbspPos; --last1BitBytePos) {
        }
        if (nalData[last1BitBytePos] == 0 || last1BitBytePos <= seiRbspPos) {
            return null;
        }
        ParsableNalUnitBitArray data = new ParsableNalUnitBitArray(nalData, seiRbspPos, last1BitBytePos + 1);
        while (data.canReadBits(16)) {
            int payloadType = 0;
            int nextByte = data.readBits(8);
            while (nextByte == 255) {
                payloadType += 255;
                nextByte = data.readBits(8);
            }
            payloadType += nextByte;
            int payloadSize = 0;
            nextByte = data.readBits(8);
            while (nextByte == 255) {
                payloadSize += 255;
                nextByte = data.readBits(8);
            }
            if ((payloadSize += nextByte) == 0 || !data.canReadBits(payloadSize)) {
                return null;
            }
            if (payloadType != 176) continue;
            int precRefDisplayWidth = data.readUnsignedExpGolombCodedInt();
            boolean refViewingDistanceFlag = data.readBit();
            int precRefViewingDist = 0;
            if (refViewingDistanceFlag) {
                precRefViewingDist = data.readUnsignedExpGolombCodedInt();
            }
            int numRefDisplaysMinus1 = data.readUnsignedExpGolombCodedInt();
            int leftViewId = -1;
            int rightViewId = -1;
            int exponentRefDisplayWidth = -1;
            int mantissaRefDisplayWidth = -1;
            int exponentRefViewingDist = -1;
            int mantissaRefViewingDist = -1;
            for (int i = 0; i <= numRefDisplaysMinus1; ++i) {
                leftViewId = data.readUnsignedExpGolombCodedInt();
                rightViewId = data.readUnsignedExpGolombCodedInt();
                exponentRefDisplayWidth = data.readBits(6);
                if (exponentRefDisplayWidth == 63) {
                    return null;
                }
                int refDispWidthBits = exponentRefDisplayWidth == 0 ? Math.max(0, precRefDisplayWidth - 30) : Math.max(0, exponentRefDisplayWidth + precRefDisplayWidth - 31);
                mantissaRefDisplayWidth = data.readBits(refDispWidthBits);
                if (refViewingDistanceFlag) {
                    exponentRefViewingDist = data.readBits(6);
                    if (exponentRefViewingDist == 63) {
                        return null;
                    }
                    int refViewDistBits = exponentRefViewingDist == 0 ? Math.max(0, precRefViewingDist - 30) : Math.max(0, exponentRefViewingDist + precRefViewingDist - 31);
                    mantissaRefViewingDist = data.readBits(refViewDistBits);
                }
                if (!data.readBit()) continue;
                data.skipBits(10);
            }
            return new H265Sei3dRefDisplayInfoData(precRefDisplayWidth, precRefViewingDist, numRefDisplaysMinus1 + 1, leftViewId, rightViewId, exponentRefDisplayWidth, mantissaRefDisplayWidth, exponentRefViewingDist, mantissaRefViewingDist);
        }
        return null;
    }

    public static int findNalUnit(byte[] data, int startOffset, int endOffset, boolean[] prefixFlags) {
        int length = endOffset - startOffset;
        Assertions.checkState((length >= 0 ? 1 : 0) != 0);
        if (length == 0) {
            return endOffset;
        }
        if (prefixFlags[0]) {
            NalUnitUtil.clearPrefixFlags(prefixFlags);
            return startOffset - 3;
        }
        if (length > 1 && prefixFlags[1] && data[startOffset] == 1) {
            NalUnitUtil.clearPrefixFlags(prefixFlags);
            return startOffset - 2;
        }
        if (length > 2 && prefixFlags[2] && data[startOffset] == 0 && data[startOffset + 1] == 1) {
            NalUnitUtil.clearPrefixFlags(prefixFlags);
            return startOffset - 1;
        }
        int limit = endOffset - 1;
        for (int i = startOffset + 2; i < limit; i += 3) {
            if ((data[i] & 0xFE) != 0) continue;
            if (data[i - 2] == 0 && data[i - 1] == 0 && data[i] == 1) {
                NalUnitUtil.clearPrefixFlags(prefixFlags);
                return i - 2;
            }
            i -= 2;
        }
        boolean bl = length > 2 ? data[endOffset - 3] == 0 && data[endOffset - 2] == 0 && data[endOffset - 1] == 1 : (length == 2 ? prefixFlags[2] && data[endOffset - 2] == 0 && data[endOffset - 1] == 1 : (prefixFlags[0] = prefixFlags[1] && data[endOffset - 1] == 1));
        prefixFlags[1] = length > 1 ? data[endOffset - 2] == 0 && data[endOffset - 1] == 0 : prefixFlags[2] && data[endOffset - 1] == 0;
        prefixFlags[2] = data[endOffset - 1] == 0;
        return endOffset;
    }

    public static void clearPrefixFlags(boolean[] prefixFlags) {
        prefixFlags[0] = false;
        prefixFlags[1] = false;
        prefixFlags[2] = false;
    }

    @Nullable
    public static String getH265BaseLayerCodecsString(List<byte[]> csdBuffers) {
        for (int i = 0; i < csdBuffers.size(); ++i) {
            byte[] buffer = csdBuffers.get(i);
            int limit = buffer.length;
            if (limit <= 3) continue;
            ImmutableList<Integer> nalUnitPositions = NalUnitUtil.findNalUnitPositions(buffer);
            for (int j = 0; j < nalUnitPositions.size(); ++j) {
                if ((Integer)nalUnitPositions.get(j) + 3 >= limit) continue;
                ParsableNalUnitBitArray data = new ParsableNalUnitBitArray(buffer, (Integer)nalUnitPositions.get(j) + 3, limit);
                H265NalHeader nalHeader = NalUnitUtil.parseH265NalHeader(data);
                if (nalHeader.nalUnitType != 33 || nalHeader.layerId != 0) continue;
                return NalUnitUtil.createCodecStringFromH265SpsPalyoad(data);
            }
        }
        return null;
    }

    private static ImmutableList<Integer> findNalUnitPositions(byte[] data) {
        int offset = 0;
        boolean[] prefixFlags = new boolean[3];
        ImmutableList.Builder nalUnitPositions = ImmutableList.builder();
        while (offset < data.length) {
            int nalUnitOffset = NalUnitUtil.findNalUnit(data, offset, data.length, prefixFlags);
            if (nalUnitOffset != data.length) {
                nalUnitPositions.add((Object)nalUnitOffset);
            }
            offset = nalUnitOffset + 3;
        }
        return nalUnitPositions.build();
    }

    @Nullable
    private static String createCodecStringFromH265SpsPalyoad(ParsableNalUnitBitArray data) {
        data.skipBits(4);
        int maxSubLayersMinus1 = data.readBits(3);
        data.skipBit();
        H265ProfileTierLevel profileTierLevel = NalUnitUtil.parseH265ProfileTierLevel(data, true, maxSubLayersMinus1, null);
        return CodecSpecificDataUtil.buildHevcCodecString((int)profileTierLevel.generalProfileSpace, (boolean)profileTierLevel.generalTierFlag, (int)profileTierLevel.generalProfileIdc, (int)profileTierLevel.generalProfileCompatibilityFlags, (int[])profileTierLevel.constraintBytes, (int)profileTierLevel.generalLevelIdc);
    }

    private static int findNextUnescapeIndex(byte[] bytes, int offset, int limit) {
        for (int i = offset; i < limit - 2; ++i) {
            if (bytes[i] != 0 || bytes[i + 1] != 0 || bytes[i + 2] != 3) continue;
            return i;
        }
        return limit;
    }

    private static void skipH265HrdParameters(ParsableNalUnitBitArray data, boolean commonInfPresentFlag, int maxSubLayersMinus1) {
        boolean nalHrdParametersPresentFlag = false;
        boolean vclHrdParametersPresentFlag = false;
        boolean subPicHrdParametersPresentFlag = false;
        if (commonInfPresentFlag) {
            nalHrdParametersPresentFlag = data.readBit();
            vclHrdParametersPresentFlag = data.readBit();
            if (nalHrdParametersPresentFlag || vclHrdParametersPresentFlag) {
                subPicHrdParametersPresentFlag = data.readBit();
                if (subPicHrdParametersPresentFlag) {
                    data.skipBits(19);
                }
                data.skipBits(8);
                if (subPicHrdParametersPresentFlag) {
                    data.skipBits(4);
                }
                data.skipBits(15);
            }
        }
        for (int i = 0; i <= maxSubLayersMinus1; ++i) {
            boolean fixedPicRateGeneralFlag;
            boolean fixedPicRateWithinCvsFlag = fixedPicRateGeneralFlag = data.readBit();
            boolean lowDelayHrdFlag = false;
            int cpbCntMinus1 = 0;
            if (!fixedPicRateGeneralFlag) {
                fixedPicRateWithinCvsFlag = data.readBit();
            }
            if (fixedPicRateWithinCvsFlag) {
                data.readUnsignedExpGolombCodedInt();
            } else {
                lowDelayHrdFlag = data.readBit();
            }
            if (!lowDelayHrdFlag) {
                cpbCntMinus1 = data.readUnsignedExpGolombCodedInt();
            }
            int numSubLayerHrdParameters = 0;
            numSubLayerHrdParameters += nalHrdParametersPresentFlag ? 1 : 0;
            numSubLayerHrdParameters += vclHrdParametersPresentFlag ? 1 : 0;
            for (int j = 0; j < numSubLayerHrdParameters; ++j) {
                for (int k = 0; k <= cpbCntMinus1; ++k) {
                    data.readUnsignedExpGolombCodedInt();
                    data.readUnsignedExpGolombCodedInt();
                    if (subPicHrdParametersPresentFlag) {
                        data.readUnsignedExpGolombCodedInt();
                        data.readUnsignedExpGolombCodedInt();
                    }
                    data.skipBit();
                }
            }
        }
    }

    private static H265ProfileTierLevel parseH265ProfileTierLevel(ParsableNalUnitBitArray data, boolean profilePresentFlag, int maxSubLayersMinus1, @Nullable H265ProfileTierLevel prevProfileTierLevel) {
        int generalProfileSpace = 0;
        boolean generalTierFlag = false;
        int generalProfileIdc = 0;
        int generalProfileCompatibilityFlags = 0;
        int[] constraintBytes = new int[6];
        if (profilePresentFlag) {
            int i;
            generalProfileSpace = data.readBits(2);
            generalTierFlag = data.readBit();
            generalProfileIdc = data.readBits(5);
            generalProfileCompatibilityFlags = 0;
            for (i = 0; i < 32; ++i) {
                if (!data.readBit()) continue;
                generalProfileCompatibilityFlags |= 1 << i;
            }
            for (i = 0; i < constraintBytes.length; ++i) {
                constraintBytes[i] = data.readBits(8);
            }
        } else if (prevProfileTierLevel != null) {
            generalProfileSpace = prevProfileTierLevel.generalProfileSpace;
            generalTierFlag = prevProfileTierLevel.generalTierFlag;
            generalProfileIdc = prevProfileTierLevel.generalProfileIdc;
            generalProfileCompatibilityFlags = prevProfileTierLevel.generalProfileCompatibilityFlags;
            constraintBytes = prevProfileTierLevel.constraintBytes;
        }
        int generalLevelIdc = data.readBits(8);
        int toSkip = 0;
        for (int i = 0; i < maxSubLayersMinus1; ++i) {
            if (data.readBit()) {
                toSkip += 88;
            }
            if (!data.readBit()) continue;
            toSkip += 8;
        }
        data.skipBits(toSkip);
        if (maxSubLayersMinus1 > 0) {
            data.skipBits(2 * (8 - maxSubLayersMinus1));
        }
        return new H265ProfileTierLevel(generalProfileSpace, generalTierFlag, generalProfileIdc, generalProfileCompatibilityFlags, constraintBytes, generalLevelIdc);
    }

    private static int applyConformanceWindowToWidth(int width, int chromaFormatIdc, int offsetLeft, int offsetRight) {
        int subWidthC = chromaFormatIdc == 1 || chromaFormatIdc == 2 ? 2 : 1;
        return width - subWidthC * (offsetLeft + offsetRight);
    }

    private static int applyConformanceWindowToHeight(int height, int chromaFormatIdc, int offsetTop, int offsetBottom) {
        int subHeightC = chromaFormatIdc == 1 ? 2 : 1;
        return height - subHeightC * (offsetTop + offsetBottom);
    }

    private static H265RepFormatsAndIndices parseH265RepFormatsAndIndices(ParsableNalUnitBitArray data, int maxLayers) {
        int i;
        int numRepFormats = data.readUnsignedExpGolombCodedInt() + 1;
        ImmutableList.Builder repFormats = ImmutableList.builderWithExpectedSize((int)numRepFormats);
        int[] repFormatIndices = new int[maxLayers];
        for (i = 0; i < numRepFormats; ++i) {
            repFormats.add((Object)NalUnitUtil.parseH265RepFormat(data));
        }
        if (numRepFormats > 1 && data.readBit()) {
            int bitLen = DoubleMath.log2((double)numRepFormats, (RoundingMode)RoundingMode.CEILING);
            for (int i2 = 1; i2 < maxLayers; ++i2) {
                repFormatIndices[i2] = data.readBits(bitLen);
            }
        } else {
            for (i = 1; i < maxLayers; ++i) {
                repFormatIndices[i] = Math.min(i, numRepFormats - 1);
            }
        }
        return new H265RepFormatsAndIndices((List<H265RepFormat>)repFormats.build(), repFormatIndices);
    }

    private static H265RepFormat parseH265RepFormat(ParsableNalUnitBitArray data) {
        int frameWidth = data.readBits(16);
        int frameHeight = data.readBits(16);
        int chromaFormatIdc = 0;
        int bitDepthLumaMinus8 = 0;
        int bitDepthChromaMinus8 = 0;
        if (data.readBit()) {
            chromaFormatIdc = data.readBits(2);
            if (chromaFormatIdc == 3) {
                data.skipBit();
            }
            bitDepthLumaMinus8 = data.readBits(4);
            bitDepthChromaMinus8 = data.readBits(4);
        }
        if (data.readBit()) {
            int confWinLeftOffset = data.readUnsignedExpGolombCodedInt();
            int confWinRightOffset = data.readUnsignedExpGolombCodedInt();
            int confWinTopOffset = data.readUnsignedExpGolombCodedInt();
            int confWinBottomOffset = data.readUnsignedExpGolombCodedInt();
            frameWidth = NalUnitUtil.applyConformanceWindowToWidth(frameWidth, chromaFormatIdc, confWinLeftOffset, confWinRightOffset);
            frameHeight = NalUnitUtil.applyConformanceWindowToHeight(frameHeight, chromaFormatIdc, confWinTopOffset, confWinBottomOffset);
        }
        return new H265RepFormat(chromaFormatIdc, bitDepthLumaMinus8, bitDepthChromaMinus8, frameWidth, frameHeight);
    }

    private static void skipH265DpbSize(ParsableNalUnitBitArray data, int numOutputLayerSets, int[] maxSubLayersInLayerSet, int[] numLayersInIdList, boolean[][] necessaryLayerFlag) {
        for (int i = 1; i < numOutputLayerSets; ++i) {
            boolean subLayerFlagInfoPresentFlag = data.readBit();
            for (int j = 0; j < maxSubLayersInLayerSet[i]; ++j) {
                boolean subLayerDpbInfoPresentFlag;
                if (j > 0 && subLayerFlagInfoPresentFlag) {
                    subLayerDpbInfoPresentFlag = data.readBit();
                } else {
                    boolean bl = subLayerDpbInfoPresentFlag = j == 0;
                }
                if (!subLayerDpbInfoPresentFlag) continue;
                for (int k = 0; k < numLayersInIdList[i]; ++k) {
                    if (!necessaryLayerFlag[i][k]) continue;
                    data.readUnsignedExpGolombCodedInt();
                }
                data.readUnsignedExpGolombCodedInt();
                data.readUnsignedExpGolombCodedInt();
            }
        }
    }

    private static void skipToH265VuiPresentFlagAfterDpbSize(ParsableNalUnitBitArray data, int maxLayers, boolean[][] directDependencyFlag) {
        int directDepTypeLen = data.readUnsignedExpGolombCodedInt() + 2;
        if (data.readBit()) {
            data.skipBits(directDepTypeLen);
        } else {
            for (int i = 1; i < maxLayers; ++i) {
                for (int j = 0; j < i; ++j) {
                    if (!directDependencyFlag[i][j]) continue;
                    data.skipBits(directDepTypeLen);
                }
            }
        }
        int nonVuiExtensionLen = data.readUnsignedExpGolombCodedInt();
        for (int i = 1; i <= nonVuiExtensionLen; ++i) {
            data.skipBits(8);
        }
    }

    private static H265VideoSignalInfosAndIndices parseH265VideoSignalInfosAndIndices(ParsableNalUnitBitArray data, int maxLayers, int numLayerSets, int[] maxSubLayersInLayerSet) {
        int i;
        boolean crossLayerIrapAlignedFlag = true;
        if (!data.readBit()) {
            crossLayerIrapAlignedFlag = data.readBit();
        }
        if (crossLayerIrapAlignedFlag) {
            data.skipBit();
        }
        boolean bitRatePresentVpsFlag = data.readBit();
        boolean picRatePresentVpsFlag = data.readBit();
        if (bitRatePresentVpsFlag || picRatePresentVpsFlag) {
            for (int i2 = 0; i2 < numLayerSets; ++i2) {
                for (int j = 0; j < maxSubLayersInLayerSet[i2]; ++j) {
                    boolean bitRatePresentFlag = false;
                    boolean picRatePresentFlag = false;
                    if (bitRatePresentVpsFlag) {
                        bitRatePresentFlag = data.readBit();
                    }
                    if (picRatePresentVpsFlag) {
                        picRatePresentFlag = data.readBit();
                    }
                    if (bitRatePresentFlag) {
                        data.skipBits(32);
                    }
                    if (!picRatePresentFlag) continue;
                    data.skipBits(18);
                }
            }
        }
        int numVideoSignalInfos = maxLayers;
        boolean videoSignalInfoIdxPresentFlag = data.readBit();
        if (videoSignalInfoIdxPresentFlag) {
            numVideoSignalInfos = data.readBits(4) + 1;
        }
        ImmutableList.Builder videoSignalInfos = ImmutableList.builderWithExpectedSize((int)numVideoSignalInfos);
        int[] videoSignalInfoIdices = new int[maxLayers];
        for (i = 0; i < numVideoSignalInfos; ++i) {
            videoSignalInfos.add((Object)NalUnitUtil.parseH265VideoSignalInfo(data));
        }
        if (videoSignalInfoIdxPresentFlag && numVideoSignalInfos > 1) {
            for (i = 0; i < maxLayers; ++i) {
                videoSignalInfoIdices[i] = data.readBits(4);
            }
        }
        return new H265VideoSignalInfosAndIndices((List<H265VideoSignalInfo>)videoSignalInfos.build(), videoSignalInfoIdices);
    }

    private static H265VideoSignalInfo parseH265VideoSignalInfo(ParsableNalUnitBitArray data) {
        data.skipBits(3);
        int colorRange = data.readBit() ? 1 : 2;
        int colorSpace = ColorInfo.isoColorPrimariesToColorSpace((int)data.readBits(8));
        int colorTransfer = ColorInfo.isoTransferCharacteristicsToColorTransfer((int)data.readBits(8));
        data.skipBits(8);
        return new H265VideoSignalInfo(colorSpace, colorRange, colorTransfer);
    }

    private static void skipScalingList(ParsableNalUnitBitArray bitArray, int size) {
        int lastScale = 8;
        int nextScale = 8;
        for (int i = 0; i < size; ++i) {
            if (nextScale != 0) {
                int deltaScale = bitArray.readSignedExpGolombCodedInt();
                nextScale = (lastScale + deltaScale + 256) % 256;
            }
            lastScale = nextScale == 0 ? lastScale : nextScale;
        }
    }

    private static void skipHrdParameters(ParsableNalUnitBitArray data) {
        int codedPictureBufferCount = data.readUnsignedExpGolombCodedInt() + 1;
        data.skipBits(8);
        for (int i = 0; i < codedPictureBufferCount; ++i) {
            data.readUnsignedExpGolombCodedInt();
            data.readUnsignedExpGolombCodedInt();
            data.skipBit();
        }
        data.skipBits(20);
    }

    private static void skipH265ScalingList(ParsableNalUnitBitArray bitArray) {
        for (int sizeId = 0; sizeId < 4; ++sizeId) {
            for (int matrixId = 0; matrixId < 6; matrixId += sizeId == 3 ? 3 : 1) {
                if (!bitArray.readBit()) {
                    bitArray.readUnsignedExpGolombCodedInt();
                    continue;
                }
                int coefNum = Math.min(64, 1 << 4 + (sizeId << 1));
                if (sizeId > 1) {
                    bitArray.readSignedExpGolombCodedInt();
                }
                for (int i = 0; i < coefNum; ++i) {
                    bitArray.readSignedExpGolombCodedInt();
                }
            }
        }
    }

    private static void skipH265ShortTermReferencePictureSets(ParsableNalUnitBitArray bitArray) {
        int numShortTermRefPicSets = bitArray.readUnsignedExpGolombCodedInt();
        int previousNumNegativePics = -1;
        int previousNumPositivePics = -1;
        int[] previousDeltaPocS0 = new int[]{};
        int[] previousDeltaPocS1 = new int[]{};
        for (int stRpsIdx = 0; stRpsIdx < numShortTermRefPicSets; ++stRpsIdx) {
            int numPositivePics;
            int numNegativePics;
            int[] deltaPocS1;
            int[] deltaPocS0;
            boolean interRefPicSetPredictionFlag;
            boolean bl = interRefPicSetPredictionFlag = stRpsIdx != 0 && bitArray.readBit();
            if (interRefPicSetPredictionFlag) {
                int dPoc;
                int j;
                int previousNumDeltaPocs = previousNumNegativePics + previousNumPositivePics;
                int deltaRpsSign = bitArray.readBit() ? 1 : 0;
                int absDeltaRps = bitArray.readUnsignedExpGolombCodedInt() + 1;
                int deltaRps = (1 - 2 * deltaRpsSign) * absDeltaRps;
                boolean[] useDeltaFlags = new boolean[previousNumDeltaPocs + 1];
                for (int j2 = 0; j2 <= previousNumDeltaPocs; ++j2) {
                    useDeltaFlags[j2] = !bitArray.readBit() ? bitArray.readBit() : true;
                }
                int i = 0;
                deltaPocS0 = new int[previousNumDeltaPocs + 1];
                deltaPocS1 = new int[previousNumDeltaPocs + 1];
                for (j = previousNumPositivePics - 1; j >= 0; --j) {
                    dPoc = previousDeltaPocS1[j] + deltaRps;
                    if (dPoc >= 0 || !useDeltaFlags[previousNumNegativePics + j]) continue;
                    deltaPocS0[i++] = dPoc;
                }
                if (deltaRps < 0 && useDeltaFlags[previousNumDeltaPocs]) {
                    deltaPocS0[i++] = deltaRps;
                }
                for (j = 0; j < previousNumNegativePics; ++j) {
                    dPoc = previousDeltaPocS0[j] + deltaRps;
                    if (dPoc >= 0 || !useDeltaFlags[j]) continue;
                    deltaPocS0[i++] = dPoc;
                }
                numNegativePics = i;
                deltaPocS0 = Arrays.copyOf(deltaPocS0, numNegativePics);
                i = 0;
                for (j = previousNumNegativePics - 1; j >= 0; --j) {
                    dPoc = previousDeltaPocS0[j] + deltaRps;
                    if (dPoc <= 0 || !useDeltaFlags[j]) continue;
                    deltaPocS1[i++] = dPoc;
                }
                if (deltaRps > 0 && useDeltaFlags[previousNumDeltaPocs]) {
                    deltaPocS1[i++] = deltaRps;
                }
                for (j = 0; j < previousNumPositivePics; ++j) {
                    dPoc = previousDeltaPocS1[j] + deltaRps;
                    if (dPoc <= 0 || !useDeltaFlags[previousNumNegativePics + j]) continue;
                    deltaPocS1[i++] = dPoc;
                }
                numPositivePics = i;
                deltaPocS1 = Arrays.copyOf(deltaPocS1, numPositivePics);
            } else {
                int i;
                numNegativePics = bitArray.readUnsignedExpGolombCodedInt();
                numPositivePics = bitArray.readUnsignedExpGolombCodedInt();
                deltaPocS0 = new int[numNegativePics];
                for (i = 0; i < numNegativePics; ++i) {
                    deltaPocS0[i] = (i > 0 ? deltaPocS0[i - 1] : 0) - (bitArray.readUnsignedExpGolombCodedInt() + 1);
                    bitArray.skipBit();
                }
                deltaPocS1 = new int[numPositivePics];
                for (i = 0; i < numPositivePics; ++i) {
                    deltaPocS1[i] = (i > 0 ? deltaPocS1[i - 1] : 0) + (bitArray.readUnsignedExpGolombCodedInt() + 1);
                    bitArray.skipBit();
                }
            }
            previousNumNegativePics = numNegativePics;
            previousNumPositivePics = numPositivePics;
            previousDeltaPocS0 = deltaPocS0;
            previousDeltaPocS1 = deltaPocS1;
        }
    }

    private NalUnitUtil() {
    }

    public static final class SpsData {
        public final int profileIdc;
        public final int constraintsFlagsAndReservedZero2Bits;
        public final int levelIdc;
        public final int seqParameterSetId;
        public final int maxNumRefFrames;
        public final int width;
        public final int height;
        public final float pixelWidthHeightRatio;
        public final int bitDepthLumaMinus8;
        public final int bitDepthChromaMinus8;
        public final boolean separateColorPlaneFlag;
        public final boolean frameMbsOnlyFlag;
        public final int frameNumLength;
        public final int picOrderCountType;
        public final int picOrderCntLsbLength;
        public final boolean deltaPicOrderAlwaysZeroFlag;
        public final int colorSpace;
        public final int colorRange;
        public final int colorTransfer;
        public final int maxNumReorderFrames;

        public SpsData(int profileIdc, int constraintsFlagsAndReservedZero2Bits, int levelIdc, int seqParameterSetId, int maxNumRefFrames, int width, int height, float pixelWidthHeightRatio, int bitDepthLumaMinus8, int bitDepthChromaMinus8, boolean separateColorPlaneFlag, boolean frameMbsOnlyFlag, int frameNumLength, int picOrderCountType, int picOrderCntLsbLength, boolean deltaPicOrderAlwaysZeroFlag, int colorSpace, int colorRange, int colorTransfer, int maxNumReorderFrames) {
            this.profileIdc = profileIdc;
            this.constraintsFlagsAndReservedZero2Bits = constraintsFlagsAndReservedZero2Bits;
            this.levelIdc = levelIdc;
            this.seqParameterSetId = seqParameterSetId;
            this.maxNumRefFrames = maxNumRefFrames;
            this.width = width;
            this.height = height;
            this.pixelWidthHeightRatio = pixelWidthHeightRatio;
            this.bitDepthLumaMinus8 = bitDepthLumaMinus8;
            this.bitDepthChromaMinus8 = bitDepthChromaMinus8;
            this.separateColorPlaneFlag = separateColorPlaneFlag;
            this.frameMbsOnlyFlag = frameMbsOnlyFlag;
            this.frameNumLength = frameNumLength;
            this.picOrderCountType = picOrderCountType;
            this.picOrderCntLsbLength = picOrderCntLsbLength;
            this.deltaPicOrderAlwaysZeroFlag = deltaPicOrderAlwaysZeroFlag;
            this.colorSpace = colorSpace;
            this.colorRange = colorRange;
            this.colorTransfer = colorTransfer;
            this.maxNumReorderFrames = maxNumReorderFrames;
        }
    }

    public static final class H265NalHeader {
        public final int nalUnitType;
        public final int layerId;
        public final int temporalId;

        public H265NalHeader(int nalUnitType, int layerId, int temporalId) {
            this.nalUnitType = nalUnitType;
            this.layerId = layerId;
            this.temporalId = temporalId;
        }
    }

    public static final class H265VpsData {
        public final H265NalHeader nalHeader;
        public final ImmutableList<H265LayerInfo> layerInfos;
        public final H265ProfileTierLevelsAndIndices profileTierLevelsAndIndices;
        @Nullable
        public final H265RepFormatsAndIndices repFormatsAndIndices;
        @Nullable
        public final H265VideoSignalInfosAndIndices videoSignalInfosAndIndices;

        public H265VpsData(H265NalHeader nalHeader, @Nullable List<H265LayerInfo> layerInfos, H265ProfileTierLevelsAndIndices profileTierLevelsAndIndices, @Nullable H265RepFormatsAndIndices repFormatsAndIndices, @Nullable H265VideoSignalInfosAndIndices videoSignalInfosAndIndices) {
            this.nalHeader = nalHeader;
            this.layerInfos = layerInfos != null ? ImmutableList.copyOf(layerInfos) : ImmutableList.of();
            this.profileTierLevelsAndIndices = profileTierLevelsAndIndices;
            this.repFormatsAndIndices = repFormatsAndIndices;
            this.videoSignalInfosAndIndices = videoSignalInfosAndIndices;
        }
    }

    public static final class H265ProfileTierLevel {
        public final int generalProfileSpace;
        public final boolean generalTierFlag;
        public final int generalProfileIdc;
        public final int generalProfileCompatibilityFlags;
        public final int[] constraintBytes;
        public final int generalLevelIdc;

        public H265ProfileTierLevel(int generalProfileSpace, boolean generalTierFlag, int generalProfileIdc, int generalProfileCompatibilityFlags, int[] constraintBytes, int generalLevelIdc) {
            this.generalProfileSpace = generalProfileSpace;
            this.generalTierFlag = generalTierFlag;
            this.generalProfileIdc = generalProfileIdc;
            this.generalProfileCompatibilityFlags = generalProfileCompatibilityFlags;
            this.constraintBytes = constraintBytes;
            this.generalLevelIdc = generalLevelIdc;
        }
    }

    public static final class H265ProfileTierLevelsAndIndices {
        public final ImmutableList<H265ProfileTierLevel> profileTierLevels;
        public final int[] indices;

        public H265ProfileTierLevelsAndIndices(List<H265ProfileTierLevel> profileTierLevels, int[] indices) {
            this.profileTierLevels = ImmutableList.copyOf(profileTierLevels);
            this.indices = indices;
        }
    }

    public static final class H265RepFormatsAndIndices {
        public final ImmutableList<H265RepFormat> repFormats;
        public final int[] indices;

        public H265RepFormatsAndIndices(List<H265RepFormat> repFormats, int[] indices) {
            this.repFormats = ImmutableList.copyOf(repFormats);
            this.indices = indices;
        }
    }

    public static final class H265VideoSignalInfosAndIndices {
        public final ImmutableList<H265VideoSignalInfo> videoSignalInfos;
        public final int[] indices;

        public H265VideoSignalInfosAndIndices(List<H265VideoSignalInfo> videoSignalInfos, int[] indices) {
            this.videoSignalInfos = ImmutableList.copyOf(videoSignalInfos);
            this.indices = indices;
        }
    }

    public static final class H265LayerInfo {
        public final int layerIdInVps;
        public final int viewId;

        public H265LayerInfo(int layerIdInVps, int viewId) {
            this.layerIdInVps = layerIdInVps;
            this.viewId = viewId;
        }
    }

    public static final class H265SpsData {
        public final H265NalHeader nalHeader;
        @Nullable
        public final H265ProfileTierLevel profileTierLevel;
        public final int chromaFormatIdc;
        public final int bitDepthLumaMinus8;
        public final int bitDepthChromaMinus8;
        public final int seqParameterSetId;
        public final int width;
        public final int height;
        public final float pixelWidthHeightRatio;
        public final int maxNumReorderPics;
        public final int colorSpace;
        public final int colorRange;
        public final int colorTransfer;

        public H265SpsData(H265NalHeader nalHeader, @Nullable H265ProfileTierLevel profileTierLevel, int chromaFormatIdc, int bitDepthLumaMinus8, int bitDepthChromaMinus8, int seqParameterSetId, int width, int height, float pixelWidthHeightRatio, int maxNumReorderPics, int colorSpace, int colorRange, int colorTransfer) {
            this.nalHeader = nalHeader;
            this.profileTierLevel = profileTierLevel;
            this.chromaFormatIdc = chromaFormatIdc;
            this.bitDepthLumaMinus8 = bitDepthLumaMinus8;
            this.bitDepthChromaMinus8 = bitDepthChromaMinus8;
            this.seqParameterSetId = seqParameterSetId;
            this.width = width;
            this.height = height;
            this.pixelWidthHeightRatio = pixelWidthHeightRatio;
            this.maxNumReorderPics = maxNumReorderPics;
            this.colorSpace = colorSpace;
            this.colorRange = colorRange;
            this.colorTransfer = colorTransfer;
        }
    }

    public static final class H265RepFormat {
        public final int chromaFormatIdc;
        public final int bitDepthLumaMinus8;
        public final int bitDepthChromaMinus8;
        public final int width;
        public final int height;

        public H265RepFormat(int chromaFormatIdc, int bitDepthLumaMinus8, int bitDepthChromaMinus8, int width, int height) {
            this.chromaFormatIdc = chromaFormatIdc;
            this.bitDepthLumaMinus8 = bitDepthLumaMinus8;
            this.bitDepthChromaMinus8 = bitDepthChromaMinus8;
            this.width = width;
            this.height = height;
        }
    }

    public static final class H265VideoSignalInfo {
        public final int colorSpace;
        public final int colorRange;
        public final int colorTransfer;

        public H265VideoSignalInfo(int colorSpace, int colorRange, int colorTransfer) {
            this.colorSpace = colorSpace;
            this.colorRange = colorRange;
            this.colorTransfer = colorTransfer;
        }
    }

    public static final class PpsData {
        public final int picParameterSetId;
        public final int seqParameterSetId;
        public final boolean bottomFieldPicOrderInFramePresentFlag;

        public PpsData(int picParameterSetId, int seqParameterSetId, boolean bottomFieldPicOrderInFramePresentFlag) {
            this.picParameterSetId = picParameterSetId;
            this.seqParameterSetId = seqParameterSetId;
            this.bottomFieldPicOrderInFramePresentFlag = bottomFieldPicOrderInFramePresentFlag;
        }
    }

    public static final class H265Sei3dRefDisplayInfoData {
        public final int precRefDisplayWidth;
        public final int precRefViewingDist;
        public final int numRefDisplays;
        public final int leftViewId;
        public final int rightViewId;
        public final int exponentRefDisplayWidth;
        public final int mantissaRefDisplayWidth;
        public final int exponentRefViewingDist;
        public final int mantissaRefViewingDist;

        public H265Sei3dRefDisplayInfoData(int precRefDisplayWidth, int precRefViewingDist, int numRefDisplays, int leftViewId, int rightViewId, int exponentRefDisplayWidth, int mantissaRefDisplayWidth, int exponentRefViewingDist, int mantissaRefViewingDist) {
            this.precRefDisplayWidth = precRefDisplayWidth;
            this.precRefViewingDist = precRefViewingDist;
            this.numRefDisplays = numRefDisplays;
            this.leftViewId = leftViewId;
            this.rightViewId = rightViewId;
            this.exponentRefDisplayWidth = exponentRefDisplayWidth;
            this.mantissaRefDisplayWidth = mantissaRefDisplayWidth;
            this.exponentRefViewingDist = exponentRefViewingDist;
            this.mantissaRefViewingDist = mantissaRefViewingDist;
        }
    }
}

