/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.container;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.media3.common.Metadata;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.base.Joiner;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@UnstableApi
public final class MdtaMetadataEntry
implements Metadata.Entry {
    public static final String KEY_ANDROID_CAPTURE_FPS = "com.android.capture.fps";
    public static final String KEY_EDITABLE_TRACKS_OFFSET = "editable.tracks.offset";
    public static final String KEY_EDITABLE_TRACKS_LENGTH = "editable.tracks.length";
    public static final String KEY_EDITABLE_TRACKS_MAP = "editable.tracks.map";
    public static final String KEY_EDITABLE_TRACKS_SAMPLES_LOCATION = "editable.tracks.samples.location";
    public static final byte EDITABLE_TRACKS_SAMPLES_LOCATION_IN_EDIT_DATA_MP4 = 0;
    public static final byte EDITABLE_TRACKS_SAMPLES_LOCATION_INTERLEAVED = 1;
    public static final int DEFAULT_LOCALE_INDICATOR = 0;
    public static final int TYPE_INDICATOR_RESERVED = 0;
    public static final int TYPE_INDICATOR_STRING = 1;
    public static final int TYPE_INDICATOR_FLOAT32 = 23;
    public static final int TYPE_INDICATOR_INT32 = 67;
    public static final int TYPE_INDICATOR_8_BIT_UNSIGNED_INT = 75;
    public static final int TYPE_INDICATOR_UNSIGNED_INT64 = 78;
    public final String key;
    public final byte[] value;
    public final int localeIndicator;
    public final int typeIndicator;
    public static final Parcelable.Creator<MdtaMetadataEntry> CREATOR = new Parcelable.Creator<MdtaMetadataEntry>(){

        public MdtaMetadataEntry createFromParcel(Parcel in) {
            return new MdtaMetadataEntry(in);
        }

        public MdtaMetadataEntry[] newArray(int size) {
            return new MdtaMetadataEntry[size];
        }
    };

    public MdtaMetadataEntry(String key, byte[] value, int typeIndicator) {
        this(key, value, 0, typeIndicator);
    }

    public MdtaMetadataEntry(String key, byte[] value, int localeIndicator, int typeIndicator) {
        MdtaMetadataEntry.validateData(key, value, typeIndicator);
        this.key = key;
        this.value = value;
        this.localeIndicator = localeIndicator;
        this.typeIndicator = typeIndicator;
    }

    private MdtaMetadataEntry(Parcel in) {
        this.key = (String)Util.castNonNull((Object)in.readString());
        this.value = (byte[])Util.castNonNull((Object)in.createByteArray());
        this.localeIndicator = in.readInt();
        this.typeIndicator = in.readInt();
        MdtaMetadataEntry.validateData(this.key, this.value, this.typeIndicator);
    }

    public List<Integer> getEditableTrackTypesFromMap() {
        Assertions.checkState((boolean)this.key.equals(KEY_EDITABLE_TRACKS_MAP), (Object)"Metadata is not an editable tracks map");
        int numberOfTracks = this.value[1];
        ArrayList<Integer> trackTypes = new ArrayList<Integer>();
        for (int i = 0; i < numberOfTracks; ++i) {
            trackTypes.add(Integer.valueOf(this.value[i + 2]));
        }
        return trackTypes;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MdtaMetadataEntry other = (MdtaMetadataEntry)obj;
        return this.key.equals(other.key) && Arrays.equals(this.value, other.value) && this.localeIndicator == other.localeIndicator && this.typeIndicator == other.typeIndicator;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + Arrays.hashCode(this.value);
        result = 31 * result + this.localeIndicator;
        result = 31 * result + this.typeIndicator;
        return result;
    }

    public String toString() {
        String formattedValue;
        switch (this.typeIndicator) {
            case 1: {
                formattedValue = Util.fromUtf8Bytes((byte[])this.value);
                break;
            }
            case 23: {
                formattedValue = String.valueOf(Float.intBitsToFloat(Ints.fromByteArray((byte[])this.value)));
                break;
            }
            case 67: {
                formattedValue = String.valueOf(Ints.fromByteArray((byte[])this.value));
                break;
            }
            case 75: {
                formattedValue = String.valueOf(Byte.toUnsignedInt(this.value[0]));
                break;
            }
            case 78: {
                formattedValue = String.valueOf(new ParsableByteArray(this.value).readUnsignedLongToLong());
                break;
            }
            case 0: {
                if (this.key.equals(KEY_EDITABLE_TRACKS_MAP)) {
                    formattedValue = MdtaMetadataEntry.getFormattedValueForEditableTracksMap(this.getEditableTrackTypesFromMap());
                    break;
                }
            }
            default: {
                formattedValue = Util.toHexString((byte[])this.value);
            }
        }
        return "mdta: key=" + this.key + ", value=" + formattedValue;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.key);
        dest.writeByteArray(this.value);
        dest.writeInt(this.localeIndicator);
        dest.writeInt(this.typeIndicator);
    }

    public int describeContents() {
        return 0;
    }

    private static void validateData(String key, byte[] value, int typeIndicator) {
        switch (key) {
            case "com.android.capture.fps": {
                Assertions.checkArgument((typeIndicator == 23 && value.length == 4 ? 1 : 0) != 0);
                break;
            }
            case "editable.tracks.offset": 
            case "editable.tracks.length": {
                Assertions.checkArgument((typeIndicator == 78 && value.length == 8 ? 1 : 0) != 0);
                break;
            }
            case "editable.tracks.map": {
                Assertions.checkArgument((typeIndicator == 0 ? 1 : 0) != 0);
                break;
            }
            case "editable.tracks.samples.location": {
                Assertions.checkArgument((typeIndicator == 75 && value.length == 1 && (value[0] == 0 || value[0] == 1) ? 1 : 0) != 0);
                break;
            }
        }
    }

    private static String getFormattedValueForEditableTracksMap(List<Integer> trackTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append("track types = ");
        Joiner.on((char)',').appendTo(sb, trackTypes);
        return sb.toString();
    }
}

