/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Notification;
import android.app.Service;
import android.app.UiModeManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.SystemClock;
import android.security.NetworkSecurityPolicy;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.SparseArray;
import android.util.SparseLongArray;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.C;
import androidx.media3.common.Format;
import androidx.media3.common.MediaItem;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.ParserException;
import androidx.media3.common.Player;
import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.LongArray;
import androidx.media3.common.util.NullableType;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.math.DoubleMath;
import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedBytes;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.InlineMe;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.PolyNull;

public final class Util {
    @UnstableApi
    public static final int SDK_INT = Build.VERSION.SDK_INT;
    @UnstableApi
    public static final String DEVICE = Build.DEVICE;
    @UnstableApi
    public static final String MANUFACTURER = Build.MANUFACTURER;
    @UnstableApi
    public static final String MODEL = Build.MODEL;
    @UnstableApi
    public static final String DEVICE_DEBUG_INFO = DEVICE + ", " + MODEL + ", " + MANUFACTURER + ", " + SDK_INT;
    @UnstableApi
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @UnstableApi
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final String TAG = "Util";
    private static final Pattern XS_DATE_TIME_PATTERN = Pattern.compile("(\\d\\d\\d\\d)\\-(\\d\\d)\\-(\\d\\d)[Tt](\\d\\d):(\\d\\d):(\\d\\d)([\\.,](\\d+))?([Zz]|((\\+|\\-)(\\d?\\d):?(\\d\\d)))?");
    private static final Pattern XS_DURATION_PATTERN = Pattern.compile("^(-)?P(([0-9]*)Y)?(([0-9]*)M)?(([0-9]*)D)?(T(([0-9]*)H)?(([0-9]*)M)?(([0-9.]*)S)?)?$");
    private static final Pattern ESCAPED_CHARACTER_PATTERN = Pattern.compile("%([A-Fa-f0-9]{2})");
    private static final Pattern ISM_PATH_PATTERN = Pattern.compile("(?:.*\\.)?isml?(?:/(manifest(.*))?)?", 2);
    private static final String ISM_HLS_FORMAT_EXTENSION = "format=m3u8-aapl";
    private static final String ISM_DASH_FORMAT_EXTENSION = "format=mpd-time-csf";
    @Nullable
    private static HashMap<String, String> languageTagReplacementMap;
    private static final String[] additionalIsoLanguageReplacements;
    private static final String[] isoLegacyTagReplacements;
    private static final int[] CRC32_BYTES_MSBF;
    private static final int[] CRC16_BYTES_MSBF;
    private static final int[] CRC8_BYTES_MSBF;

    private Util() {
    }

    @Deprecated
    @UnstableApi
    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        return ByteStreams.toByteArray((InputStream)inputStream);
    }

    @UnstableApi
    public static byte[] toByteArray(int ... values) {
        byte[] array = new byte[values.length * 4];
        int index = 0;
        for (int value : values) {
            array[index++] = (byte)(value >> 24);
            array[index++] = (byte)(value >> 16);
            array[index++] = (byte)(value >> 8);
            array[index++] = (byte)value;
        }
        return array;
    }

    @UnstableApi
    public static byte[] toByteArray(float value) {
        return Ints.toByteArray((int)Float.floatToIntBits(value));
    }

    @UnstableApi
    @Nullable
    public static Intent registerReceiverNotExported(Context context, @Nullable BroadcastReceiver receiver, IntentFilter filter) {
        if (SDK_INT < 33) {
            return context.registerReceiver(receiver, filter);
        }
        return context.registerReceiver(receiver, filter, 4);
    }

    @UnstableApi
    @Nullable
    public static ComponentName startForegroundService(Context context, Intent intent) {
        if (SDK_INT >= 26) {
            return context.startForegroundService(intent);
        }
        return context.startService(intent);
    }

    @UnstableApi
    public static void setForegroundServiceNotification(Service service, int notificationId, Notification notification, int foregroundServiceType, String foregroundServiceManifestType) {
        if (SDK_INT >= 29) {
            Api29.startForeground(service, notificationId, notification, foregroundServiceType, foregroundServiceManifestType);
        } else {
            service.startForeground(notificationId, notification);
        }
    }

    @Deprecated
    public static boolean maybeRequestReadExternalStoragePermission(Activity activity, Uri ... uris) {
        for (Uri uri : uris) {
            if (!Util.maybeRequestReadStoragePermission(activity, uri)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean maybeRequestReadExternalStoragePermission(Activity activity, MediaItem ... mediaItems) {
        return Util.maybeRequestReadStoragePermission(activity, mediaItems);
    }

    public static boolean maybeRequestReadStoragePermission(Activity activity, MediaItem ... mediaItems) {
        if (SDK_INT < 23) {
            return false;
        }
        for (MediaItem mediaItem : mediaItems) {
            if (mediaItem.localConfiguration == null) continue;
            if (Util.maybeRequestReadStoragePermission(activity, mediaItem.localConfiguration.uri)) {
                return true;
            }
            ImmutableList<MediaItem.SubtitleConfiguration> subtitleConfigs = mediaItem.localConfiguration.subtitleConfigurations;
            for (int i = 0; i < subtitleConfigs.size(); ++i) {
                if (!Util.maybeRequestReadStoragePermission(activity, ((MediaItem.SubtitleConfiguration)subtitleConfigs.get((int)i)).uri)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean maybeRequestReadStoragePermission(Activity activity, Uri uri) {
        if (!Util.isReadStoragePermissionRequestNeeded(activity, uri)) {
            return false;
        }
        if (SDK_INT < 33) {
            return Util.requestExternalStoragePermission(activity);
        }
        return Util.requestReadMediaPermissions(activity);
    }

    @ChecksSdkIntAtLeast(api=23)
    private static boolean isReadStoragePermissionRequestNeeded(Activity activity, Uri uri) {
        if (SDK_INT < 23) {
            return false;
        }
        if (Util.isLocalFileUri(uri)) {
            return !Util.isAppSpecificStorageFileUri(activity, uri);
        }
        return Util.isMediaStoreExternalContentUri(uri);
    }

    private static boolean isAppSpecificStorageFileUri(Activity activity, Uri uri) {
        try {
            String uriPath = uri.getPath();
            if (uriPath == null) {
                return false;
            }
            String filePath = new File(uriPath).getCanonicalPath();
            String internalAppDirectoryPath = activity.getFilesDir().getCanonicalPath();
            File externalAppDirectory = activity.getExternalFilesDir(null);
            String externalAppDirectoryPath = externalAppDirectory == null ? null : externalAppDirectory.getCanonicalPath();
            return filePath.startsWith(internalAppDirectoryPath) || externalAppDirectoryPath != null && filePath.startsWith(externalAppDirectoryPath);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isMediaStoreExternalContentUri(Uri uri) {
        if (!"content".equals(uri.getScheme()) || !"media".equals(uri.getAuthority())) {
            return false;
        }
        List pathSegments = uri.getPathSegments();
        if (pathSegments.isEmpty()) {
            return false;
        }
        String firstPathSegment = (String)pathSegments.get(0);
        return "external".equals(firstPathSegment) || "external_primary".equals(firstPathSegment);
    }

    public static boolean checkCleartextTrafficPermitted(MediaItem ... mediaItems) {
        if (SDK_INT < 24) {
            return true;
        }
        for (MediaItem mediaItem : mediaItems) {
            if (mediaItem.localConfiguration == null) continue;
            if (Util.isTrafficRestricted(mediaItem.localConfiguration.uri)) {
                return false;
            }
            for (int i = 0; i < mediaItem.localConfiguration.subtitleConfigurations.size(); ++i) {
                if (!Util.isTrafficRestricted(((MediaItem.SubtitleConfiguration)mediaItem.localConfiguration.subtitleConfigurations.get((int)i)).uri)) continue;
                return false;
            }
        }
        return true;
    }

    @UnstableApi
    public static boolean isLocalFileUri(Uri uri) {
        String scheme = uri.getScheme();
        return TextUtils.isEmpty((CharSequence)scheme) || "file".equals(scheme);
    }

    @UnstableApi
    public static boolean isRunningOnEmulator() {
        String deviceName = Ascii.toLowerCase((String)DEVICE);
        return deviceName.contains("emulator") || deviceName.contains("emu64a") || deviceName.contains("emu64x") || deviceName.contains("generic");
    }

    @Deprecated
    @UnstableApi
    @InlineMe(replacement="Objects.equals(o1, o2)", imports={"java.util.Objects"})
    public static boolean areEqual(@Nullable Object o1, @Nullable Object o2) {
        return Objects.equals(o1, o2);
    }

    @UnstableApi
    public static <T> boolean contentEquals(@Nullable SparseArray<T> sparseArray1, @Nullable SparseArray<T> sparseArray2) {
        if (sparseArray1 == null) {
            return sparseArray2 == null;
        }
        if (sparseArray2 == null) {
            return false;
        }
        if (SDK_INT >= 31) {
            return sparseArray1.contentEquals(sparseArray2);
        }
        int size = sparseArray1.size();
        if (size != sparseArray2.size()) {
            return false;
        }
        for (int index = 0; index < size; ++index) {
            int key = sparseArray1.keyAt(index);
            if (Objects.equals(sparseArray1.valueAt(index), sparseArray2.get(key))) continue;
            return false;
        }
        return true;
    }

    @UnstableApi
    public static <T> int contentHashCode(SparseArray<T> sparseArray) {
        if (SDK_INT >= 31) {
            return sparseArray.contentHashCode();
        }
        int hash = 17;
        for (int index = 0; index < sparseArray.size(); ++index) {
            hash = 31 * hash + sparseArray.keyAt(index);
            hash = 31 * hash + Objects.hashCode(sparseArray.valueAt(index));
        }
        return hash;
    }

    @UnstableApi
    public static boolean contains(@NullableType Object[] items, @Nullable Object item) {
        for (Object arrayItem : items) {
            if (!Util.areEqual(arrayItem, item)) continue;
            return true;
        }
        return false;
    }

    @UnstableApi
    public static <T> boolean contains(SparseArray<T> sparseArray, int key) {
        return sparseArray.indexOfKey(key) >= 0;
    }

    @UnstableApi
    public static <T> void removeRange(List<T> list, int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > list.size() || fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex != toIndex) {
            list.subList(fromIndex, toIndex).clear();
        }
    }

    @EnsuresNonNull(value={"#1"})
    @UnstableApi
    public static <T> T castNonNull(@Nullable T value) {
        return value;
    }

    @EnsuresNonNull(value={"#1"})
    @UnstableApi
    public static <T> T[] castNonNullTypeArray(@NullableType T[] value) {
        return value;
    }

    @UnstableApi
    public static <T> T[] nullSafeArrayCopy(T[] input, int length) {
        Assertions.checkArgument(length <= input.length);
        return Arrays.copyOf(input, length);
    }

    @UnstableApi
    public static <T> T[] nullSafeArrayCopyOfRange(T[] input, int from, int to) {
        Assertions.checkArgument(0 <= from);
        Assertions.checkArgument(to <= input.length);
        return Arrays.copyOfRange(input, from, to);
    }

    @UnstableApi
    public static <T> T[] nullSafeArrayAppend(T[] original, T newElement) {
        @NullableType T[] result = Arrays.copyOf(original, original.length + 1);
        result[original.length] = newElement;
        return Util.castNonNullTypeArray(result);
    }

    @UnstableApi
    public static <T> T[] nullSafeArrayConcatenation(T[] first, T[] second) {
        T[] concatenation = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, concatenation, first.length, second.length);
        return concatenation;
    }

    @UnstableApi
    public static <T> void nullSafeListToArray(List<T> list, T[] array) {
        Assertions.checkState(list.size() == array.length);
        list.toArray(array);
    }

    @UnstableApi
    public static Handler createHandlerForCurrentLooper() {
        return Util.createHandlerForCurrentLooper(null);
    }

    @UnstableApi
    public static Handler createHandlerForCurrentLooper(@Nullable // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownInitialization Handler.Callback callback) {
        return Util.createHandler(Assertions.checkStateNotNull(Looper.myLooper()), callback);
    }

    @UnstableApi
    public static Handler createHandlerForCurrentOrMainLooper() {
        return Util.createHandlerForCurrentOrMainLooper(null);
    }

    @UnstableApi
    public static Handler createHandlerForCurrentOrMainLooper(@Nullable // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownInitialization Handler.Callback callback) {
        return Util.createHandler(Util.getCurrentOrMainLooper(), callback);
    }

    @UnstableApi
    public static Handler createHandler(Looper looper, @Nullable // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownInitialization Handler.Callback callback) {
        return new Handler(looper, callback);
    }

    @UnstableApi
    public static boolean postOrRun(Handler handler, Runnable runnable) {
        Looper looper = handler.getLooper();
        if (!looper.getThread().isAlive()) {
            return false;
        }
        if (handler.getLooper() == Looper.myLooper()) {
            runnable.run();
            return true;
        }
        return handler.post(runnable);
    }

    @UnstableApi
    public static <T> ListenableFuture<T> postOrRunWithCompletion(Handler handler, Runnable runnable, T successValue) {
        SettableFuture outputFuture = SettableFuture.create();
        Util.postOrRun(handler, () -> {
            try {
                if (outputFuture.isCancelled()) {
                    return;
                }
                runnable.run();
                outputFuture.set(successValue);
            }
            catch (Throwable e) {
                outputFuture.setException(e);
            }
        });
        return outputFuture;
    }

    @UnstableApi
    public static <T, U> ListenableFuture<T> transformFutureAsync(ListenableFuture<U> future, AsyncFunction<U, T> transformFunction) {
        SettableFuture outputFuture = SettableFuture.create();
        outputFuture.addListener(() -> {
            if (outputFuture.isCancelled()) {
                future.cancel(false);
            }
        }, MoreExecutors.directExecutor());
        future.addListener(() -> {
            Object inputFutureResult;
            try {
                inputFutureResult = Futures.getDone((Future)future);
            }
            catch (CancellationException cancellationException) {
                outputFuture.cancel(false);
                return;
            }
            catch (ExecutionException exception) {
                Throwable cause = exception.getCause();
                outputFuture.setException(cause == null ? exception : cause);
                return;
            }
            catch (Error | RuntimeException error) {
                outputFuture.setException(error);
                return;
            }
            try {
                outputFuture.setFuture(transformFunction.apply(inputFutureResult));
            }
            catch (Throwable exception) {
                outputFuture.setException(exception);
            }
        }, MoreExecutors.directExecutor());
        return outputFuture;
    }

    @UnstableApi
    public static Looper getCurrentOrMainLooper() {
        Looper myLooper = Looper.myLooper();
        return myLooper != null ? myLooper : Looper.getMainLooper();
    }

    @UnstableApi
    public static ExecutorService newSingleThreadExecutor(String threadName) {
        return Executors.newSingleThreadExecutor((Runnable runnable) -> new Thread(runnable, threadName));
    }

    @UnstableApi
    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String threadName) {
        return Executors.newSingleThreadScheduledExecutor((Runnable runnable) -> new Thread(runnable, threadName));
    }

    @UnstableApi
    public static void closeQuietly(@Nullable Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @UnstableApi
    public static boolean readBoolean(Parcel parcel) {
        return parcel.readInt() != 0;
    }

    @UnstableApi
    public static void writeBoolean(Parcel parcel, boolean value) {
        parcel.writeInt(value ? 1 : 0);
    }

    @UnstableApi
    public static String getLocaleLanguageTag(Locale locale) {
        return locale.toLanguageTag();
    }

    @UnstableApi
    public static @PolyNull String normalizeLanguageCode(@PolyNull String language) {
        String replacedLanguage;
        if (language == null) {
            return null;
        }
        String normalizedTag = language.replace('_', '-');
        if (normalizedTag.isEmpty() || normalizedTag.equals("und")) {
            normalizedTag = language;
        }
        normalizedTag = Ascii.toLowerCase((String)normalizedTag);
        String mainLanguage = Util.splitAtFirst(normalizedTag, "-")[0];
        if (languageTagReplacementMap == null) {
            languageTagReplacementMap = Util.createIsoLanguageReplacementMap();
        }
        if ((replacedLanguage = languageTagReplacementMap.get(mainLanguage)) != null) {
            normalizedTag = replacedLanguage + normalizedTag.substring(mainLanguage.length());
            mainLanguage = replacedLanguage;
        }
        if ("no".equals(mainLanguage) || "i".equals(mainLanguage) || "zh".equals(mainLanguage)) {
            normalizedTag = Util.maybeReplaceLegacyLanguageTags(normalizedTag);
        }
        return normalizedTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnstableApi
    public static String loadAsset(Context context, String assetPath) throws IOException {
        String string;
        InputStream inputStream = null;
        try {
            inputStream = context.getAssets().open(assetPath);
            string = Util.fromUtf8Bytes(ByteStreams.toByteArray((InputStream)inputStream));
        }
        catch (Throwable throwable) {
            Util.closeQuietly(inputStream);
            throw throwable;
        }
        Util.closeQuietly(inputStream);
        return string;
    }

    @UnstableApi
    public static String fromUtf8Bytes(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @UnstableApi
    public static String fromUtf8Bytes(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length, StandardCharsets.UTF_8);
    }

    @UnstableApi
    public static byte[] getUtf8Bytes(String value) {
        return value.getBytes(StandardCharsets.UTF_8);
    }

    @UnstableApi
    public static String[] split(String value, String regex) {
        return value.split(regex, -1);
    }

    @UnstableApi
    public static String[] splitAtFirst(String value, String regex) {
        return value.split(regex, 2);
    }

    @UnstableApi
    public static boolean isLinebreak(int c) {
        return c == 10 || c == 13;
    }

    @UnstableApi
    public static String formatInvariant(String format, Object ... args) {
        return String.format(Locale.US, format, args);
    }

    @UnstableApi
    public static int ceilDivide(int numerator, int denominator) {
        return (numerator + denominator - 1) / denominator;
    }

    @UnstableApi
    public static long ceilDivide(long numerator, long denominator) {
        return (numerator + denominator - 1L) / denominator;
    }

    @UnstableApi
    public static int constrainValue(int value, int min, int max) {
        return Math.max(min, Math.min(value, max));
    }

    @UnstableApi
    public static long constrainValue(long value, long min, long max) {
        return Math.max(min, Math.min(value, max));
    }

    @UnstableApi
    public static float constrainValue(float value, float min, float max) {
        return Math.max(min, Math.min(value, max));
    }

    @UnstableApi
    public static long addWithOverflowDefault(long x, long y, long overflowResult) {
        long result = x + y;
        if (((x ^ result) & (y ^ result)) < 0L) {
            return overflowResult;
        }
        return result;
    }

    @UnstableApi
    public static long subtractWithOverflowDefault(long x, long y, long overflowResult) {
        long result = x - y;
        if (((x ^ y) & (x ^ result)) < 0L) {
            return overflowResult;
        }
        return result;
    }

    @UnstableApi
    public static int linearSearch(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    @UnstableApi
    public static int linearSearch(long[] array, long value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    @UnstableApi
    public static int binarySearchFloor(int[] array, int value, boolean inclusive, boolean stayInBounds) {
        int index = Arrays.binarySearch(array, value);
        if (index < 0) {
            index = -(index + 2);
        } else {
            while (--index >= 0 && array[index] == value) {
            }
            if (inclusive) {
                ++index;
            }
        }
        return stayInBounds ? Math.max(0, index) : index;
    }

    @UnstableApi
    public static int binarySearchFloor(long[] array, long value, boolean inclusive, boolean stayInBounds) {
        int index = Arrays.binarySearch(array, value);
        if (index < 0) {
            index = -(index + 2);
        } else {
            while (--index >= 0 && array[index] == value) {
            }
            if (inclusive) {
                ++index;
            }
        }
        return stayInBounds ? Math.max(0, index) : index;
    }

    @UnstableApi
    public static <T extends Comparable<? super T>> int binarySearchFloor(List<? extends Comparable<? super T>> list, T value, boolean inclusive, boolean stayInBounds) {
        int index = Collections.binarySearch(list, value);
        if (index < 0) {
            index = -(index + 2);
        } else {
            while (--index >= 0 && list.get(index).compareTo(value) == 0) {
            }
            if (inclusive) {
                ++index;
            }
        }
        return stayInBounds ? Math.max(0, index) : index;
    }

    @UnstableApi
    public static int binarySearchFloor(LongArray longArray, long value, boolean inclusive, boolean stayInBounds) {
        int lowIndex = 0;
        int highIndex = longArray.size() - 1;
        while (lowIndex <= highIndex) {
            int midIndex = lowIndex + highIndex >>> 1;
            if (longArray.get(midIndex) < value) {
                lowIndex = midIndex + 1;
                continue;
            }
            highIndex = midIndex - 1;
        }
        if (inclusive && highIndex + 1 < longArray.size() && longArray.get(highIndex + 1) == value) {
            ++highIndex;
        } else if (stayInBounds && highIndex == -1) {
            highIndex = 0;
        }
        return highIndex;
    }

    @UnstableApi
    public static int binarySearchCeil(int[] array, int value, boolean inclusive, boolean stayInBounds) {
        int index = Arrays.binarySearch(array, value);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
        } else {
            while (++index < array.length && array[index] == value) {
            }
            if (inclusive) {
                --index;
            }
        }
        return stayInBounds ? Math.min(array.length - 1, index) : index;
    }

    @UnstableApi
    public static int binarySearchCeil(long[] array, long value, boolean inclusive, boolean stayInBounds) {
        int index = Arrays.binarySearch(array, value);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
        } else {
            while (++index < array.length && array[index] == value) {
            }
            if (inclusive) {
                --index;
            }
        }
        return stayInBounds ? Math.min(array.length - 1, index) : index;
    }

    @UnstableApi
    public static <T extends Comparable<? super T>> int binarySearchCeil(List<? extends Comparable<? super T>> list, T value, boolean inclusive, boolean stayInBounds) {
        int index = Collections.binarySearch(list, value);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
        } else {
            int listSize = list.size();
            while (++index < listSize && list.get(index).compareTo(value) == 0) {
            }
            if (inclusive) {
                --index;
            }
        }
        return stayInBounds ? Math.min(list.size() - 1, index) : index;
    }

    @UnstableApi
    public static int compareLong(long left, long right) {
        return left < right ? -1 : (left == right ? 0 : 1);
    }

    @UnstableApi
    public static long minValue(SparseLongArray sparseLongArray) {
        if (sparseLongArray.size() == 0) {
            throw new NoSuchElementException();
        }
        long min = Long.MAX_VALUE;
        for (int i = 0; i < sparseLongArray.size(); ++i) {
            min = Math.min(min, sparseLongArray.valueAt(i));
        }
        return min;
    }

    @UnstableApi
    public static long maxValue(SparseLongArray sparseLongArray) {
        if (sparseLongArray.size() == 0) {
            throw new NoSuchElementException();
        }
        long max = Long.MIN_VALUE;
        for (int i = 0; i < sparseLongArray.size(); ++i) {
            max = Math.max(max, sparseLongArray.valueAt(i));
        }
        return max;
    }

    @UnstableApi
    public static long usToMs(long timeUs) {
        return timeUs == -9223372036854775807L || timeUs == Long.MIN_VALUE ? timeUs : timeUs / 1000L;
    }

    @UnstableApi
    public static long msToUs(long timeMs) {
        return timeMs == -9223372036854775807L || timeMs == Long.MIN_VALUE ? timeMs : timeMs * 1000L;
    }

    @UnstableApi
    public static long sampleCountToDurationUs(long sampleCount, int sampleRate) {
        return Util.scaleLargeValue(sampleCount, 1000000L, sampleRate, RoundingMode.DOWN);
    }

    @UnstableApi
    public static long durationUsToSampleCount(long durationUs, int sampleRate) {
        return Util.scaleLargeValue(durationUs, sampleRate, 1000000L, RoundingMode.UP);
    }

    @UnstableApi
    public static long parseXsDuration(String value) {
        Matcher matcher = XS_DURATION_PATTERN.matcher(value);
        if (matcher.matches()) {
            boolean negated = !TextUtils.isEmpty((CharSequence)matcher.group(1));
            String years = matcher.group(3);
            double durationSeconds = years != null ? Double.parseDouble(years) * 3.1556908E7 : 0.0;
            String months = matcher.group(5);
            durationSeconds += months != null ? Double.parseDouble(months) * 2629739.0 : 0.0;
            String days = matcher.group(7);
            durationSeconds += days != null ? Double.parseDouble(days) * 86400.0 : 0.0;
            String hours = matcher.group(10);
            durationSeconds += hours != null ? Double.parseDouble(hours) * 3600.0 : 0.0;
            String minutes = matcher.group(12);
            durationSeconds += minutes != null ? Double.parseDouble(minutes) * 60.0 : 0.0;
            String seconds = matcher.group(14);
            long durationMillis = (long)((durationSeconds += seconds != null ? Double.parseDouble(seconds) : 0.0) * 1000.0);
            return negated ? -durationMillis : durationMillis;
        }
        return (long)(Double.parseDouble(value) * 3600.0 * 1000.0);
    }

    @UnstableApi
    public static long parseXsDateTime(String value) throws ParserException {
        int timezoneShift;
        Matcher matcher = XS_DATE_TIME_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw ParserException.createForMalformedContainer("Invalid date/time format: " + value, null);
        }
        if (matcher.group(9) == null) {
            timezoneShift = 0;
        } else if (matcher.group(9).equalsIgnoreCase("Z")) {
            timezoneShift = 0;
        } else {
            timezoneShift = Integer.parseInt(matcher.group(12)) * 60 + Integer.parseInt(matcher.group(13));
            if ("-".equals(matcher.group(11))) {
                timezoneShift *= -1;
            }
        }
        GregorianCalendar dateTime = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        dateTime.clear();
        dateTime.set(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)));
        if (!TextUtils.isEmpty((CharSequence)matcher.group(8))) {
            BigDecimal bd = new BigDecimal("0." + matcher.group(8));
            dateTime.set(14, bd.movePointRight(3).intValue());
        }
        long time = dateTime.getTimeInMillis();
        if (timezoneShift != 0) {
            time -= (long)timezoneShift * 60000L;
        }
        return time;
    }

    @UnstableApi
    public static long scaleLargeValue(long value, long multiplier, long divisor, RoundingMode roundingMode) {
        if (value == 0L || multiplier == 0L) {
            return 0L;
        }
        if (divisor >= multiplier && divisor % multiplier == 0L) {
            long divisionFactor = LongMath.divide((long)divisor, (long)multiplier, (RoundingMode)RoundingMode.UNNECESSARY);
            return LongMath.divide((long)value, (long)divisionFactor, (RoundingMode)roundingMode);
        }
        if (divisor < multiplier && multiplier % divisor == 0L) {
            long multiplicationFactor = LongMath.divide((long)multiplier, (long)divisor, (RoundingMode)RoundingMode.UNNECESSARY);
            return LongMath.saturatedMultiply((long)value, (long)multiplicationFactor);
        }
        if (divisor >= value && divisor % value == 0L) {
            long divisionFactor = LongMath.divide((long)divisor, (long)value, (RoundingMode)RoundingMode.UNNECESSARY);
            return LongMath.divide((long)multiplier, (long)divisionFactor, (RoundingMode)roundingMode);
        }
        if (divisor < value && value % divisor == 0L) {
            long multiplicationFactor = LongMath.divide((long)value, (long)divisor, (RoundingMode)RoundingMode.UNNECESSARY);
            return LongMath.saturatedMultiply((long)multiplier, (long)multiplicationFactor);
        }
        return Util.scaleLargeValueFallback(value, multiplier, divisor, roundingMode);
    }

    @UnstableApi
    public static long[] scaleLargeValues(List<Long> values, long multiplier, long divisor, RoundingMode roundingMode) {
        long[] result = new long[values.size()];
        if (multiplier == 0L) {
            return result;
        }
        if (divisor >= multiplier && divisor % multiplier == 0L) {
            long divisionFactor = LongMath.divide((long)divisor, (long)multiplier, (RoundingMode)RoundingMode.UNNECESSARY);
            for (int i = 0; i < result.length; ++i) {
                result[i] = LongMath.divide((long)values.get(i), (long)divisionFactor, (RoundingMode)roundingMode);
            }
            return result;
        }
        if (divisor < multiplier && multiplier % divisor == 0L) {
            long multiplicationFactor = LongMath.divide((long)multiplier, (long)divisor, (RoundingMode)RoundingMode.UNNECESSARY);
            for (int i = 0; i < result.length; ++i) {
                result[i] = LongMath.saturatedMultiply((long)values.get(i), (long)multiplicationFactor);
            }
            return result;
        }
        for (int i = 0; i < result.length; ++i) {
            long value = values.get(i);
            if (value == 0L) continue;
            if (divisor >= value && divisor % value == 0L) {
                long divisionFactor = LongMath.divide((long)divisor, (long)value, (RoundingMode)RoundingMode.UNNECESSARY);
                result[i] = LongMath.divide((long)multiplier, (long)divisionFactor, (RoundingMode)roundingMode);
                continue;
            }
            if (divisor < value && value % divisor == 0L) {
                long multiplicationFactor = LongMath.divide((long)value, (long)divisor, (RoundingMode)RoundingMode.UNNECESSARY);
                result[i] = LongMath.saturatedMultiply((long)multiplier, (long)multiplicationFactor);
                continue;
            }
            result[i] = Util.scaleLargeValueFallback(value, multiplier, divisor, roundingMode);
        }
        return result;
    }

    @UnstableApi
    public static void scaleLargeValuesInPlace(long[] values, long multiplier, long divisor, RoundingMode roundingMode) {
        if (multiplier == 0L) {
            Arrays.fill(values, 0L);
            return;
        }
        if (divisor >= multiplier && divisor % multiplier == 0L) {
            long divisionFactor = LongMath.divide((long)divisor, (long)multiplier, (RoundingMode)RoundingMode.UNNECESSARY);
            for (int i = 0; i < values.length; ++i) {
                values[i] = LongMath.divide((long)values[i], (long)divisionFactor, (RoundingMode)roundingMode);
            }
        } else if (divisor < multiplier && multiplier % divisor == 0L) {
            long multiplicationFactor = LongMath.divide((long)multiplier, (long)divisor, (RoundingMode)RoundingMode.UNNECESSARY);
            for (int i = 0; i < values.length; ++i) {
                values[i] = LongMath.saturatedMultiply((long)values[i], (long)multiplicationFactor);
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == 0L) continue;
                if (divisor >= values[i] && divisor % values[i] == 0L) {
                    long divisionFactor = LongMath.divide((long)divisor, (long)values[i], (RoundingMode)RoundingMode.UNNECESSARY);
                    values[i] = LongMath.divide((long)multiplier, (long)divisionFactor, (RoundingMode)roundingMode);
                    continue;
                }
                if (divisor < values[i] && values[i] % divisor == 0L) {
                    long multiplicationFactor = LongMath.divide((long)values[i], (long)divisor, (RoundingMode)RoundingMode.UNNECESSARY);
                    values[i] = LongMath.saturatedMultiply((long)multiplier, (long)multiplicationFactor);
                    continue;
                }
                values[i] = Util.scaleLargeValueFallback(values[i], multiplier, divisor, roundingMode);
            }
        }
    }

    private static long scaleLargeValueFallback(long value, long multiplier, long divisor, RoundingMode roundingMode) {
        long numerator = LongMath.saturatedMultiply((long)value, (long)multiplier);
        if (numerator != Long.MAX_VALUE && numerator != Long.MIN_VALUE) {
            return LongMath.divide((long)numerator, (long)divisor, (RoundingMode)roundingMode);
        }
        long gcdOfMultiplierAndDivisor = LongMath.gcd((long)Math.abs(multiplier), (long)Math.abs(divisor));
        long simplifiedMultiplier = LongMath.divide((long)multiplier, (long)gcdOfMultiplierAndDivisor, (RoundingMode)RoundingMode.UNNECESSARY);
        long simplifiedDivisor = LongMath.divide((long)divisor, (long)gcdOfMultiplierAndDivisor, (RoundingMode)RoundingMode.UNNECESSARY);
        long gcdOfValueAndSimplifiedDivisor = LongMath.gcd((long)Math.abs(value), (long)Math.abs(simplifiedDivisor));
        long simplifiedValue = LongMath.divide((long)value, (long)gcdOfValueAndSimplifiedDivisor, (RoundingMode)RoundingMode.UNNECESSARY);
        simplifiedDivisor = LongMath.divide((long)simplifiedDivisor, (long)gcdOfValueAndSimplifiedDivisor, (RoundingMode)RoundingMode.UNNECESSARY);
        long simplifiedNumerator = LongMath.saturatedMultiply((long)simplifiedValue, (long)simplifiedMultiplier);
        if (simplifiedNumerator != Long.MAX_VALUE && simplifiedNumerator != Long.MIN_VALUE) {
            return LongMath.divide((long)simplifiedNumerator, (long)simplifiedDivisor, (RoundingMode)roundingMode);
        }
        double multiplicationFactor = (double)simplifiedMultiplier / (double)simplifiedDivisor;
        double result = (double)simplifiedValue * multiplicationFactor;
        if (result > 9.223372036854776E18) {
            return Long.MAX_VALUE;
        }
        if (result < -9.223372036854776E18) {
            return Long.MIN_VALUE;
        }
        return DoubleMath.roundToLong((double)result, (RoundingMode)roundingMode);
    }

    @UnstableApi
    public static long scaleLargeTimestamp(long timestamp, long multiplier, long divisor) {
        return Util.scaleLargeValue(timestamp, multiplier, divisor, RoundingMode.DOWN);
    }

    @UnstableApi
    public static long[] scaleLargeTimestamps(List<Long> timestamps, long multiplier, long divisor) {
        return Util.scaleLargeValues(timestamps, multiplier, divisor, RoundingMode.DOWN);
    }

    @UnstableApi
    public static void scaleLargeTimestampsInPlace(long[] timestamps, long multiplier, long divisor) {
        Util.scaleLargeValuesInPlace(timestamps, multiplier, divisor, RoundingMode.DOWN);
    }

    @UnstableApi
    public static long getMediaDurationForPlayoutDuration(long playoutDuration, float speed) {
        if (speed == 1.0f) {
            return playoutDuration;
        }
        return Math.round((double)playoutDuration * (double)speed);
    }

    @UnstableApi
    public static long getPlayoutDurationForMediaDuration(long mediaDuration, float speed) {
        if (speed == 1.0f) {
            return mediaDuration;
        }
        return Math.round((double)mediaDuration / (double)speed);
    }

    @UnstableApi
    public static int getIntegerCodeForString(String string) {
        int length = string.length();
        Assertions.checkArgument(length <= 4);
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result <<= 8;
            result |= string.charAt(i);
        }
        return result;
    }

    @UnstableApi
    public static long toUnsignedLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    @UnstableApi
    public static long toLong(int mostSignificantBits, int leastSignificantBits) {
        return Util.toUnsignedLong(mostSignificantBits) << 32 | Util.toUnsignedLong(leastSignificantBits);
    }

    @UnstableApi
    public static byte[] getBytesFromHexString(String hexString) {
        byte[] data = new byte[hexString.length() / 2];
        for (int i = 0; i < data.length; ++i) {
            int stringOffset = i * 2;
            data[i] = (byte)((Character.digit(hexString.charAt(stringOffset), 16) << 4) + Character.digit(hexString.charAt(stringOffset + 1), 16));
        }
        return data;
    }

    @UnstableApi
    public static String toHexString(byte[] bytes) {
        StringBuilder result = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            result.append(Character.forDigit(bytes[i] >> 4 & 0xF, 16)).append(Character.forDigit(bytes[i] & 0xF, 16));
        }
        return result.toString();
    }

    @UnstableApi
    public static String getUserAgent(Context context, String applicationName) {
        String versionName;
        try {
            String packageName = context.getPackageName();
            PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 0);
            versionName = info.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            versionName = "?";
        }
        return applicationName + "/" + versionName + " (Linux;Android " + Build.VERSION.RELEASE + ") " + "AndroidXMedia3/1.5.1";
    }

    @UnstableApi
    public static int getCodecCountOfType(@Nullable String codecs, int trackType) {
        String[] codecArray = Util.splitCodecs(codecs);
        int count = 0;
        for (String codec : codecArray) {
            if (trackType != MimeTypes.getTrackTypeOfCodec(codec)) continue;
            ++count;
        }
        return count;
    }

    @UnstableApi
    @Nullable
    public static String getCodecsOfType(@Nullable String codecs, int trackType) {
        String[] codecArray = Util.splitCodecs(codecs);
        if (codecArray.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String codec : codecArray) {
            if (trackType != MimeTypes.getTrackTypeOfCodec(codec)) continue;
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(codec);
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    @UnstableApi
    public static String[] splitCodecs(@Nullable String codecs) {
        if (TextUtils.isEmpty((CharSequence)codecs)) {
            return new String[0];
        }
        return Util.split(codecs.trim(), "(\\s*,\\s*)");
    }

    @UnstableApi
    public static Format getPcmFormat(int pcmEncoding, int channels, int sampleRate) {
        return new Format.Builder().setSampleMimeType("audio/raw").setChannelCount(channels).setSampleRate(sampleRate).setPcmEncoding(pcmEncoding).build();
    }

    @UnstableApi
    public static Format getPcmFormat(AudioProcessor.AudioFormat audioFormat) {
        return Util.getPcmFormat(audioFormat.encoding, audioFormat.channelCount, audioFormat.sampleRate);
    }

    @UnstableApi
    public static int getPcmEncoding(int bitDepth) {
        switch (bitDepth) {
            case 8: {
                return 3;
            }
            case 16: {
                return 2;
            }
            case 24: {
                return 21;
            }
            case 32: {
                return 22;
            }
        }
        return 0;
    }

    @UnstableApi
    public static boolean isEncodingLinearPcm(int encoding) {
        return encoding == 3 || encoding == 2 || encoding == 0x10000000 || encoding == 21 || encoding == 0x50000000 || encoding == 22 || encoding == 0x60000000 || encoding == 4;
    }

    @UnstableApi
    public static boolean isEncodingHighResolutionPcm(int encoding) {
        return encoding == 21 || encoding == 0x50000000 || encoding == 22 || encoding == 0x60000000 || encoding == 4;
    }

    @SuppressLint(value={"InlinedApi"})
    @UnstableApi
    public static int getAudioTrackChannelConfig(int channelCount) {
        switch (channelCount) {
            case 1: {
                return 4;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 28;
            }
            case 4: {
                return 204;
            }
            case 5: {
                return 220;
            }
            case 6: {
                return 252;
            }
            case 7: {
                return 1276;
            }
            case 8: {
                return 6396;
            }
            case 10: {
                if (SDK_INT >= 32) {
                    return 737532;
                }
                return 6396;
            }
            case 12: {
                return 743676;
            }
            case 24: {
                if (SDK_INT >= 32) {
                    return 0x3FFFFFC;
                }
                return 0;
            }
        }
        return 0;
    }

    @UnstableApi
    public static AudioFormat getAudioFormat(int sampleRate, int channelConfig, int encoding) {
        return new AudioFormat.Builder().setSampleRate(sampleRate).setChannelMask(channelConfig).setEncoding(encoding).build();
    }

    @UnstableApi
    public static int getApiLevelThatAudioFormatIntroducedAudioEncoding(int encoding) {
        switch (encoding) {
            case 2: 
            case 3: {
                return 3;
            }
            case 4: 
            case 5: 
            case 6: {
                return 21;
            }
            case 7: 
            case 8: {
                return 23;
            }
            case 14: {
                return 25;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return 28;
            }
            case 20: {
                return 30;
            }
            case 22: {
                return 31;
            }
            case 30: {
                return 34;
            }
        }
        return Integer.MAX_VALUE;
    }

    @UnstableApi
    public static int getPcmFrameSize(int pcmEncoding, int channelCount) {
        return Util.getByteDepth(pcmEncoding) * channelCount;
    }

    @UnstableApi
    public static int getByteDepth(int pcmEncoding) {
        switch (pcmEncoding) {
            case 3: {
                return 1;
            }
            case 2: 
            case 0x10000000: {
                return 2;
            }
            case 21: 
            case 0x50000000: {
                return 3;
            }
            case 4: 
            case 22: 
            case 0x60000000: {
                return 4;
            }
        }
        throw new IllegalArgumentException();
    }

    @UnstableApi
    public static int getAudioUsageForStreamType(int streamType) {
        switch (streamType) {
            case 4: {
                return 4;
            }
            case 8: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 2: {
                return 6;
            }
            case 1: {
                return 13;
            }
            case 0: {
                return 2;
            }
        }
        return 1;
    }

    @Deprecated
    @UnstableApi
    public static int getAudioContentTypeForStreamType(int streamType) {
        switch (streamType) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: {
                return 4;
            }
            case 0: {
                return 1;
            }
        }
        return 2;
    }

    @UnstableApi
    public static int getStreamTypeForAudioUsage(int usage) {
        switch (usage) {
            case 1: 
            case 12: 
            case 14: {
                return 3;
            }
            case 13: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 4;
            }
            case 6: {
                return 2;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return 5;
            }
        }
        return 3;
    }

    @UnstableApi
    public static int generateAudioSessionIdV21(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        return audioManager == null ? -1 : audioManager.generateAudioSessionId();
    }

    @Nullable
    public static UUID getDrmUuid(String drmScheme) {
        switch (Ascii.toLowerCase((String)drmScheme)) {
            case "widevine": {
                return C.WIDEVINE_UUID;
            }
            case "playready": {
                return C.PLAYREADY_UUID;
            }
            case "clearkey": {
                return C.CLEARKEY_UUID;
            }
        }
        try {
            return UUID.fromString(drmScheme);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @UnstableApi
    public static int getErrorCodeForMediaDrmErrorCode(int mediaDrmErrorCode) {
        switch (mediaDrmErrorCode) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return 6002;
            }
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return 6004;
            }
            case 2: 
            case 4: 
            case 7: 
            case 16: 
            case 18: {
                return 6005;
            }
            case 8: 
            case 15: {
                return 6003;
            }
        }
        return 6006;
    }

    @Deprecated
    @UnstableApi
    public static int inferContentType(Uri uri, @Nullable String overrideExtension) {
        return TextUtils.isEmpty((CharSequence)overrideExtension) ? Util.inferContentType(uri) : Util.inferContentTypeForExtension(overrideExtension);
    }

    public static int inferContentType(Uri uri) {
        int contentType;
        String scheme = uri.getScheme();
        if (scheme != null && Ascii.equalsIgnoreCase((CharSequence)"rtsp", (CharSequence)scheme)) {
            return 3;
        }
        String lastPathSegment = uri.getLastPathSegment();
        if (lastPathSegment == null) {
            return 4;
        }
        int lastDotIndex = lastPathSegment.lastIndexOf(46);
        if (lastDotIndex >= 0 && (contentType = Util.inferContentTypeForExtension(lastPathSegment.substring(lastDotIndex + 1))) != 4) {
            return contentType;
        }
        Matcher ismMatcher = ISM_PATH_PATTERN.matcher(Assertions.checkNotNull(uri.getPath()));
        if (ismMatcher.matches()) {
            String extensions = ismMatcher.group(2);
            if (extensions != null) {
                if (extensions.contains(ISM_DASH_FORMAT_EXTENSION)) {
                    return 0;
                }
                if (extensions.contains(ISM_HLS_FORMAT_EXTENSION)) {
                    return 2;
                }
            }
            return 1;
        }
        return 4;
    }

    @Deprecated
    @UnstableApi
    public static int inferContentType(String fileName) {
        return Util.inferContentType(Uri.parse((String)("file:///" + fileName)));
    }

    public static int inferContentTypeForExtension(String fileExtension) {
        switch (fileExtension = Ascii.toLowerCase((String)fileExtension)) {
            case "mpd": {
                return 0;
            }
            case "m3u8": {
                return 2;
            }
            case "ism": 
            case "isml": {
                return 1;
            }
        }
        return 4;
    }

    public static int inferContentTypeForUriAndMimeType(Uri uri, @Nullable String mimeType) {
        if (mimeType == null) {
            return Util.inferContentType(uri);
        }
        switch (mimeType) {
            case "application/dash+xml": {
                return 0;
            }
            case "application/x-mpegURL": {
                return 2;
            }
            case "application/vnd.ms-sstr+xml": {
                return 1;
            }
            case "application/x-rtsp": {
                return 3;
            }
        }
        return 4;
    }

    @Nullable
    public static String getAdaptiveMimeTypeForContentType(int contentType) {
        switch (contentType) {
            case 0: {
                return "application/dash+xml";
            }
            case 2: {
                return "application/x-mpegURL";
            }
            case 1: {
                return "application/vnd.ms-sstr+xml";
            }
        }
        return null;
    }

    @UnstableApi
    public static Uri fixSmoothStreamingIsmManifestUri(Uri uri) {
        String path = uri.getPath();
        if (path == null) {
            return uri;
        }
        Matcher ismMatcher = ISM_PATH_PATTERN.matcher(path);
        if (ismMatcher.matches() && ismMatcher.group(1) == null) {
            return Uri.withAppendedPath((Uri)uri, (String)"Manifest");
        }
        return uri;
    }

    @UnstableApi
    public static String getStringForTime(StringBuilder builder, Formatter formatter, long timeMs) {
        if (timeMs == -9223372036854775807L) {
            timeMs = 0L;
        }
        String prefix = timeMs < 0L ? "-" : "";
        timeMs = Math.abs(timeMs);
        long totalSeconds = (timeMs + 500L) / 1000L;
        long seconds = totalSeconds % 60L;
        long minutes = totalSeconds / 60L % 60L;
        long hours = totalSeconds / 3600L;
        builder.setLength(0);
        return hours > 0L ? formatter.format("%s%d:%02d:%02d", prefix, hours, minutes, seconds).toString() : formatter.format("%s%02d:%02d", prefix, minutes, seconds).toString();
    }

    @UnstableApi
    public static String escapeFileName(String fileName) {
        int i;
        int length = fileName.length();
        int charactersToEscapeCount = 0;
        for (i = 0; i < length; ++i) {
            if (!Util.shouldEscapeCharacter(fileName.charAt(i))) continue;
            ++charactersToEscapeCount;
        }
        if (charactersToEscapeCount == 0) {
            return fileName;
        }
        i = 0;
        StringBuilder builder = new StringBuilder(length + charactersToEscapeCount * 2);
        while (charactersToEscapeCount > 0) {
            char c;
            if (Util.shouldEscapeCharacter(c = fileName.charAt(i++))) {
                builder.append('%').append(Integer.toHexString(c));
                --charactersToEscapeCount;
                continue;
            }
            builder.append(c);
        }
        if (i < length) {
            builder.append(fileName, i, length);
        }
        return builder.toString();
    }

    private static boolean shouldEscapeCharacter(char c) {
        switch (c) {
            case '\"': 
            case '%': 
            case '*': 
            case '/': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '\\': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    @UnstableApi
    @Nullable
    public static String unescapeFileName(String fileName) {
        int length = fileName.length();
        int percentCharacterCount = 0;
        for (int i = 0; i < length; ++i) {
            if (fileName.charAt(i) != '%') continue;
            ++percentCharacterCount;
        }
        if (percentCharacterCount == 0) {
            return fileName;
        }
        int expectedLength = length - percentCharacterCount * 2;
        StringBuilder builder = new StringBuilder(expectedLength);
        Matcher matcher = ESCAPED_CHARACTER_PATTERN.matcher(fileName);
        int startOfNotEscaped = 0;
        while (percentCharacterCount > 0 && matcher.find()) {
            char unescapedCharacter = (char)Integer.parseInt(Assertions.checkNotNull(matcher.group(1)), 16);
            builder.append(fileName, startOfNotEscaped, matcher.start()).append(unescapedCharacter);
            startOfNotEscaped = matcher.end();
            --percentCharacterCount;
        }
        if (startOfNotEscaped < length) {
            builder.append(fileName, startOfNotEscaped, length);
        }
        if (builder.length() != expectedLength) {
            return null;
        }
        return builder.toString();
    }

    @UnstableApi
    public static Uri getDataUriForString(String mimeType, String data) {
        return Uri.parse((String)("data:" + mimeType + ";base64," + Base64.encodeToString((byte[])data.getBytes(), (int)2)));
    }

    @UnstableApi
    public static void sneakyThrow(Throwable t) {
        Util.sneakyThrowInternal(t);
    }

    private static <T extends Throwable> void sneakyThrowInternal(Throwable t) throws T {
        throw t;
    }

    @UnstableApi
    public static void recursiveDelete(File fileOrDirectory) {
        File[] directoryFiles = fileOrDirectory.listFiles();
        if (directoryFiles != null) {
            for (File child : directoryFiles) {
                Util.recursiveDelete(child);
            }
        }
        fileOrDirectory.delete();
    }

    @UnstableApi
    public static File createTempDirectory(Context context, String prefix) throws IOException {
        File tempFile = Util.createTempFile(context, prefix);
        tempFile.delete();
        tempFile.mkdir();
        return tempFile;
    }

    @UnstableApi
    public static File createTempFile(Context context, String prefix) throws IOException {
        return File.createTempFile(prefix, null, Assertions.checkNotNull(context.getCacheDir()));
    }

    @UnstableApi
    public static int crc32(byte[] bytes, int start, int end, int initialValue) {
        for (int i = start; i < end; ++i) {
            initialValue = initialValue << 8 ^ CRC32_BYTES_MSBF[(initialValue >>> 24 ^ bytes[i] & 0xFF) & 0xFF];
        }
        return initialValue;
    }

    @UnstableApi
    public static int crc16(byte[] bytes, int start, int end, int initialValue) {
        for (int i = start; i < end; ++i) {
            int value = UnsignedBytes.toInt((byte)bytes[i]);
            initialValue = Util.crc16UpdateFourBits(value >> 4, initialValue);
            initialValue = Util.crc16UpdateFourBits(value & 0xF, initialValue);
        }
        return initialValue;
    }

    private static int crc16UpdateFourBits(int value, int crc16Register) {
        int mostSignificant4Bits = crc16Register >> 12 & 0xFF;
        mostSignificant4Bits = (mostSignificant4Bits ^ value) & 0xFF;
        crc16Register = crc16Register << 4 & 0xFFFF;
        crc16Register = (crc16Register ^ CRC16_BYTES_MSBF[mostSignificant4Bits]) & 0xFFFF;
        return crc16Register;
    }

    @UnstableApi
    public static int crc8(byte[] bytes, int start, int end, int initialValue) {
        for (int i = start; i < end; ++i) {
            initialValue = CRC8_BYTES_MSBF[initialValue ^ bytes[i] & 0xFF];
        }
        return initialValue;
    }

    @UnstableApi
    public static byte[] gzip(byte[] input) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (GZIPOutputStream os = new GZIPOutputStream(output);){
            os.write(input);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return output.toByteArray();
    }

    @UnstableApi
    public static int getBigEndianInt(ByteBuffer buffer, int index) {
        int value = buffer.getInt(index);
        return buffer.order() == ByteOrder.BIG_ENDIAN ? value : Integer.reverseBytes(value);
    }

    @UnstableApi
    public static ByteBuffer createReadOnlyByteBuffer(ByteBuffer byteBuffer) {
        return byteBuffer.asReadOnlyBuffer().order(byteBuffer.order());
    }

    @UnstableApi
    public static String getCountryCode(@Nullable Context context) {
        String countryCode;
        TelephonyManager telephonyManager;
        if (context != null && (telephonyManager = (TelephonyManager)context.getSystemService("phone")) != null && !TextUtils.isEmpty((CharSequence)(countryCode = telephonyManager.getNetworkCountryIso()))) {
            return Ascii.toUpperCase((String)countryCode);
        }
        return Ascii.toUpperCase((String)Locale.getDefault().getCountry());
    }

    @UnstableApi
    public static String[] getSystemLanguageCodes() {
        String[] systemLocales = Util.getSystemLocales();
        for (int i = 0; i < systemLocales.length; ++i) {
            systemLocales[i] = Util.normalizeLanguageCode(systemLocales[i]);
        }
        return systemLocales;
    }

    @UnstableApi
    public static Locale getDefaultDisplayLocale() {
        return SDK_INT >= 24 ? Locale.getDefault(Locale.Category.DISPLAY) : Locale.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @UnstableApi
    public static boolean inflate(ParsableByteArray input, ParsableByteArray output, @Nullable Inflater inflater) {
        if (input.bytesLeft() <= 0) {
            return false;
        }
        if (output.capacity() < input.bytesLeft()) {
            output.ensureCapacity(2 * input.bytesLeft());
        }
        if (inflater == null) {
            inflater = new Inflater();
        }
        inflater.setInput(input.getData(), input.getPosition(), input.bytesLeft());
        try {
            int outputSize = 0;
            while (true) {
                outputSize += inflater.inflate(output.getData(), outputSize, output.capacity() - outputSize);
                if (inflater.finished()) {
                    output.setLimit(outputSize);
                    boolean bl = true;
                    return bl;
                }
                if (inflater.needsDictionary() || inflater.needsInput()) {
                    boolean bl = false;
                    return bl;
                }
                if (outputSize != output.capacity()) continue;
                output.ensureCapacity(output.capacity() * 2);
                continue;
                break;
            }
        }
        catch (DataFormatException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            inflater.reset();
        }
    }

    @UnstableApi
    public static boolean isTv(Context context) {
        UiModeManager uiModeManager = (UiModeManager)context.getApplicationContext().getSystemService("uimode");
        return uiModeManager != null && uiModeManager.getCurrentModeType() == 4;
    }

    @UnstableApi
    public static boolean isAutomotive(Context context) {
        return SDK_INT >= 23 && context.getPackageManager().hasSystemFeature("android.hardware.type.automotive");
    }

    @UnstableApi
    public static boolean isWear(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.type.watch");
    }

    @UnstableApi
    public static Point getCurrentDisplayModeSize(Context context) {
        Display defaultDisplay = null;
        DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
        if (displayManager != null) {
            defaultDisplay = displayManager.getDisplay(0);
        }
        if (defaultDisplay == null) {
            WindowManager windowManager = Assertions.checkNotNull((WindowManager)context.getSystemService("window"));
            defaultDisplay = windowManager.getDefaultDisplay();
        }
        return Util.getCurrentDisplayModeSize(context, defaultDisplay);
    }

    @UnstableApi
    public static Point getCurrentDisplayModeSize(Context context, Display display) {
        Object displaySize;
        if (display.getDisplayId() == 0 && Util.isTv(context)) {
            String string = displaySize = SDK_INT < 28 ? Util.getSystemProperty("sys.display-size") : Util.getSystemProperty("vendor.display-size");
            if (!TextUtils.isEmpty((CharSequence)displaySize)) {
                try {
                    String[] displaySizeParts = Util.split(((String)displaySize).trim(), "x");
                    if (displaySizeParts.length == 2) {
                        int width = Integer.parseInt(displaySizeParts[0]);
                        int height = Integer.parseInt(displaySizeParts[1]);
                        if (width > 0 && height > 0) {
                            return new Point(width, height);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Log.e(TAG, "Invalid display size: " + (String)displaySize);
            }
            if ("Sony".equals(MANUFACTURER) && MODEL.startsWith("BRAVIA") && context.getPackageManager().hasSystemFeature("com.sony.dtv.hardware.panel.qfhd")) {
                return new Point(3840, 2160);
            }
        }
        displaySize = new Point();
        if (SDK_INT >= 23) {
            Util.getDisplaySizeV23(display, (Point)displaySize);
        } else {
            display.getRealSize((Point)displaySize);
        }
        return displaySize;
    }

    @UnstableApi
    public static String getTrackTypeString(int trackType) {
        switch (trackType) {
            case 0: {
                return "default";
            }
            case 1: {
                return "audio";
            }
            case 2: {
                return "video";
            }
            case 3: {
                return "text";
            }
            case 4: {
                return "image";
            }
            case 5: {
                return "metadata";
            }
            case 6: {
                return "camera motion";
            }
            case -2: {
                return "none";
            }
            case -1: {
                return "unknown";
            }
        }
        return trackType >= 10000 ? "custom (" + trackType + ")" : "?";
    }

    @UnstableApi
    public static boolean isBitmapFactorySupportedMimeType(String mimeType) {
        switch (mimeType) {
            case "image/png": 
            case "image/jpeg": 
            case "image/bmp": 
            case "image/webp": {
                return true;
            }
            case "image/heif": 
            case "image/heic": {
                return SDK_INT >= 26;
            }
            case "image/avif": {
                return SDK_INT >= 34;
            }
        }
        return false;
    }

    @UnstableApi
    public static List<String> getSelectionFlagStrings(int selectionFlags) {
        ArrayList<String> result = new ArrayList<String>();
        if ((selectionFlags & 4) != 0) {
            result.add("auto");
        }
        if ((selectionFlags & 1) != 0) {
            result.add("default");
        }
        if ((selectionFlags & 2) != 0) {
            result.add("forced");
        }
        return result;
    }

    @UnstableApi
    public static List<String> getRoleFlagStrings(int roleFlags) {
        ArrayList<String> result = new ArrayList<String>();
        if ((roleFlags & 1) != 0) {
            result.add("main");
        }
        if ((roleFlags & 2) != 0) {
            result.add("alt");
        }
        if ((roleFlags & 4) != 0) {
            result.add("supplementary");
        }
        if ((roleFlags & 8) != 0) {
            result.add("commentary");
        }
        if ((roleFlags & 0x10) != 0) {
            result.add("dub");
        }
        if ((roleFlags & 0x20) != 0) {
            result.add("emergency");
        }
        if ((roleFlags & 0x40) != 0) {
            result.add("caption");
        }
        if ((roleFlags & 0x80) != 0) {
            result.add("subtitle");
        }
        if ((roleFlags & 0x100) != 0) {
            result.add("sign");
        }
        if ((roleFlags & 0x200) != 0) {
            result.add("describes-video");
        }
        if ((roleFlags & 0x400) != 0) {
            result.add("describes-music");
        }
        if ((roleFlags & 0x800) != 0) {
            result.add("enhanced-intelligibility");
        }
        if ((roleFlags & 0x1000) != 0) {
            result.add("transcribes-dialog");
        }
        if ((roleFlags & 0x2000) != 0) {
            result.add("easy-read");
        }
        if ((roleFlags & 0x4000) != 0) {
            result.add("trick-play");
        }
        if ((roleFlags & 0x8000) != 0) {
            result.add("auxiliary");
        }
        return result;
    }

    @UnstableApi
    public static String getAuxiliaryTrackTypeString(int auxiliaryTrackType) {
        switch (auxiliaryTrackType) {
            case 0: {
                return "undefined";
            }
            case 1: {
                return "original";
            }
            case 2: {
                return "depth-linear";
            }
            case 3: {
                return "depth-inverse";
            }
            case 4: {
                return "depth metadata";
            }
        }
        throw new IllegalStateException("Unsupported auxiliary track type");
    }

    @UnstableApi
    public static long getNowUnixTimeMs(long elapsedRealtimeEpochOffsetMs) {
        return elapsedRealtimeEpochOffsetMs == -9223372036854775807L ? System.currentTimeMillis() : SystemClock.elapsedRealtime() + elapsedRealtimeEpochOffsetMs;
    }

    @UnstableApi
    public static <T> void moveItems(List<T> items, int fromIndex, int toIndex, int newFromIndex) {
        ArrayDeque<T> removedItems = new ArrayDeque<T>();
        int removedItemsLength = toIndex - fromIndex;
        for (int i = removedItemsLength - 1; i >= 0; --i) {
            removedItems.addFirst(items.remove(fromIndex + i));
        }
        items.addAll(Math.min(newFromIndex, items.size()), removedItems);
    }

    @UnstableApi
    public static boolean tableExists(SQLiteDatabase database, String tableName) {
        long count = DatabaseUtils.queryNumEntries((SQLiteDatabase)database, (String)"sqlite_master", (String)"tbl_name = ?", (String[])new String[]{tableName});
        return count > 0L;
    }

    @UnstableApi
    public static int getErrorCodeFromPlatformDiagnosticsInfo(@Nullable String diagnosticsInfo) {
        if (diagnosticsInfo == null) {
            return 0;
        }
        String[] strings = Util.split(diagnosticsInfo, "_");
        int length = strings.length;
        if (length < 2) {
            return 0;
        }
        String digitsSection = strings[length - 1];
        boolean isNegative = length >= 3 && "neg".equals(strings[length - 2]);
        try {
            int errorCode = Integer.parseInt(Assertions.checkNotNull(digitsSection));
            return isNegative ? -errorCode : errorCode;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @UnstableApi
    public static boolean isFrameDropAllowedOnSurfaceInput(Context context) {
        return SDK_INT < 29 || context.getApplicationInfo().targetSdkVersion < 29 || SDK_INT == 30 && (Ascii.equalsIgnoreCase((CharSequence)MODEL, (CharSequence)"moto g(20)") || Ascii.equalsIgnoreCase((CharSequence)MODEL, (CharSequence)"rmx3231")) || SDK_INT == 34 && Ascii.equalsIgnoreCase((CharSequence)MODEL, (CharSequence)"sm-x200");
    }

    @UnstableApi
    public static int getMaxPendingFramesCountForMediaCodecDecoders(Context context) {
        if (Util.isFrameDropAllowedOnSurfaceInput(context)) {
            return 1;
        }
        return 5;
    }

    @UnstableApi
    public static String getFormatSupportString(int formatSupport) {
        switch (formatSupport) {
            case 4: {
                return "YES";
            }
            case 3: {
                return "NO_EXCEEDS_CAPABILITIES";
            }
            case 2: {
                return "NO_UNSUPPORTED_DRM";
            }
            case 1: {
                return "NO_UNSUPPORTED_TYPE";
            }
            case 0: {
                return "NO";
            }
        }
        throw new IllegalStateException();
    }

    @UnstableApi
    public static Player.Commands getAvailableCommands(Player player, Player.Commands permanentAvailableCommands) {
        boolean isPlayingAd = player.isPlayingAd();
        boolean isCurrentMediaItemSeekable = player.isCurrentMediaItemSeekable();
        boolean hasPreviousMediaItem = player.hasPreviousMediaItem();
        boolean hasNextMediaItem = player.hasNextMediaItem();
        boolean isCurrentMediaItemLive = player.isCurrentMediaItemLive();
        boolean isCurrentMediaItemDynamic = player.isCurrentMediaItemDynamic();
        boolean isTimelineEmpty = player.getCurrentTimeline().isEmpty();
        return new Player.Commands.Builder().addAll(permanentAvailableCommands).addIf(4, !isPlayingAd).addIf(5, isCurrentMediaItemSeekable && !isPlayingAd).addIf(6, hasPreviousMediaItem && !isPlayingAd).addIf(7, !isTimelineEmpty && (hasPreviousMediaItem || !isCurrentMediaItemLive || isCurrentMediaItemSeekable) && !isPlayingAd).addIf(8, hasNextMediaItem && !isPlayingAd).addIf(9, !isTimelineEmpty && (hasNextMediaItem || isCurrentMediaItemLive && isCurrentMediaItemDynamic) && !isPlayingAd).addIf(10, !isPlayingAd).addIf(11, isCurrentMediaItemSeekable && !isPlayingAd).addIf(12, isCurrentMediaItemSeekable && !isPlayingAd).build();
    }

    @UnstableApi
    public static long sum(long ... summands) {
        long sum = 0L;
        for (long summand : summands) {
            sum += summand;
        }
        return sum;
    }

    @UnstableApi
    public static Drawable getDrawable(Context context, Resources resources, @DrawableRes int drawableRes) {
        return resources.getDrawable(drawableRes, context.getTheme());
    }

    @UnstableApi
    public static String intToStringMaxRadix(int i) {
        return Integer.toString(i, 36);
    }

    @EnsuresNonNullIf(result=false, expression={"#1"})
    public static boolean shouldShowPlayButton(@Nullable Player player) {
        return Util.shouldShowPlayButton(player, true);
    }

    @EnsuresNonNullIf(result=false, expression={"#1"})
    @UnstableApi
    public static boolean shouldShowPlayButton(@Nullable Player player, boolean playIfSuppressed) {
        return player == null || !player.getPlayWhenReady() || player.getPlaybackState() == 1 || player.getPlaybackState() == 4 || playIfSuppressed && player.getPlaybackSuppressionReason() != 0;
    }

    public static boolean handlePlayButtonAction(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        int state = player.getPlaybackState();
        boolean methodTriggered = false;
        if (state == 1 && player.isCommandAvailable(2)) {
            player.prepare();
            methodTriggered = true;
        } else if (state == 4 && player.isCommandAvailable(4)) {
            player.seekToDefaultPosition();
            methodTriggered = true;
        }
        if (player.isCommandAvailable(1)) {
            player.play();
            methodTriggered = true;
        }
        return methodTriggered;
    }

    public static boolean handlePauseButtonAction(@Nullable Player player) {
        if (player != null && player.isCommandAvailable(1)) {
            player.pause();
            return true;
        }
        return false;
    }

    public static boolean handlePlayPauseButtonAction(@Nullable Player player) {
        return Util.handlePlayPauseButtonAction(player, true);
    }

    @UnstableApi
    public static boolean handlePlayPauseButtonAction(@Nullable Player player, boolean playIfSuppressed) {
        if (Util.shouldShowPlayButton(player, playIfSuppressed)) {
            return Util.handlePlayButtonAction(player);
        }
        return Util.handlePauseButtonAction(player);
    }

    @Nullable
    private static String getSystemProperty(String name) {
        try {
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            Method getMethod = systemProperties.getMethod("get", String.class);
            return (String)getMethod.invoke(systemProperties, name);
        }
        catch (Exception e) {
            Log.e(TAG, "Failed to read system property " + name, e);
            return null;
        }
    }

    @RequiresApi(value=23)
    private static void getDisplaySizeV23(Display display, Point outSize) {
        Display.Mode mode = display.getMode();
        outSize.x = mode.getPhysicalWidth();
        outSize.y = mode.getPhysicalHeight();
    }

    private static String[] getSystemLocales() {
        String[] stringArray;
        Configuration config = Resources.getSystem().getConfiguration();
        if (SDK_INT >= 24) {
            stringArray = Util.getSystemLocalesV24(config);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = Util.getLocaleLanguageTag(config.locale);
        }
        return stringArray;
    }

    @RequiresApi(value=24)
    private static String[] getSystemLocalesV24(Configuration config) {
        return Util.split(config.getLocales().toLanguageTags(), ",");
    }

    private static HashMap<String, String> createIsoLanguageReplacementMap() {
        String[] iso2Languages = Locale.getISOLanguages();
        HashMap<String, String> replacedLanguages = new HashMap<String, String>(iso2Languages.length + additionalIsoLanguageReplacements.length);
        for (String iso2 : iso2Languages) {
            try {
                String iso3 = new Locale(iso2).getISO3Language();
                if (TextUtils.isEmpty((CharSequence)iso3)) continue;
                replacedLanguages.put(iso3, iso2);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        for (int i = 0; i < additionalIsoLanguageReplacements.length; i += 2) {
            replacedLanguages.put(additionalIsoLanguageReplacements[i], additionalIsoLanguageReplacements[i + 1]);
        }
        return replacedLanguages;
    }

    @RequiresApi(api=23)
    private static boolean requestExternalStoragePermission(Activity activity) {
        if (activity.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") != 0) {
            activity.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 0);
            return true;
        }
        return false;
    }

    @RequiresApi(api=33)
    private static boolean requestReadMediaPermissions(Activity activity) {
        if (activity.checkSelfPermission("android.permission.READ_MEDIA_AUDIO") != 0 || activity.checkSelfPermission("android.permission.READ_MEDIA_VIDEO") != 0 || activity.checkSelfPermission("android.permission.READ_MEDIA_IMAGES") != 0) {
            activity.requestPermissions(new String[]{"android.permission.READ_MEDIA_AUDIO", "android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO"}, 0);
            return true;
        }
        return false;
    }

    @RequiresApi(api=24)
    private static boolean isTrafficRestricted(Uri uri) {
        return "http".equals(uri.getScheme()) && !NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(Assertions.checkNotNull(uri.getHost()));
    }

    private static String maybeReplaceLegacyLanguageTags(String languageTag) {
        for (int i = 0; i < isoLegacyTagReplacements.length; i += 2) {
            if (!languageTag.startsWith(isoLegacyTagReplacements[i])) continue;
            return isoLegacyTagReplacements[i + 1] + languageTag.substring(isoLegacyTagReplacements[i].length());
        }
        return languageTag;
    }

    static {
        additionalIsoLanguageReplacements = new String[]{"alb", "sq", "arm", "hy", "baq", "eu", "bur", "my", "tib", "bo", "chi", "zh", "cze", "cs", "dut", "nl", "ger", "de", "gre", "el", "fre", "fr", "geo", "ka", "ice", "is", "mac", "mk", "mao", "mi", "may", "ms", "per", "fa", "rum", "ro", "scc", "hbs-srp", "slo", "sk", "wel", "cy", "id", "ms-ind", "iw", "he", "heb", "he", "ji", "yi", "arb", "ar-arb", "in", "ms-ind", "ind", "ms-ind", "nb", "no-nob", "nob", "no-nob", "nn", "no-nno", "nno", "no-nno", "tw", "ak-twi", "twi", "ak-twi", "bs", "hbs-bos", "bos", "hbs-bos", "hr", "hbs-hrv", "hrv", "hbs-hrv", "sr", "hbs-srp", "srp", "hbs-srp", "cmn", "zh-cmn", "hak", "zh-hak", "nan", "zh-nan", "hsn", "zh-hsn"};
        isoLegacyTagReplacements = new String[]{"i-lux", "lb", "i-hak", "zh-hak", "i-navajo", "nv", "no-bok", "no-nob", "no-nyn", "no-nno", "zh-guoyu", "zh-cmn", "zh-hakka", "zh-hak", "zh-min-nan", "zh-nan", "zh-xiang", "zh-hsn"};
        CRC32_BYTES_MSBF = new int[]{0, 79764919, 159529838, 222504665, 319059676, 398814059, 445009330, 507990021, 638119352, 583659535, 797628118, 726387553, 890018660, 835552979, 1015980042, 944750013, 1276238704, 1221641927, 1167319070, 1095957929, 1595256236, 1540665371, 1452775106, 1381403509, 1780037320, 1859660671, 1671105958, 1733955601, 2031960084, 2111593891, 1889500026, 1952343757, -1742489888, -1662866601, -1851683442, -1788833735, -1960329156, -1880695413, -2103051438, -2040207643, -1104454824, -1159051537, -1213636554, -1284997759, -1389417084, -1444007885, -1532160278, -1603531939, -734892656, -789352409, -575645954, -646886583, -952755380, -1007220997, -827056094, -898286187, -231047128, -151282273, -71779514, -8804623, -515967244, -436212925, -390279782, -327299027, 881225847, 809987520, 1023691545, 969234094, 662832811, 591600412, 771767749, 717299826, 311336399, 374308984, 453813921, 533576470, 25881363, 88864420, 134795389, 214552010, 2023205639, 2086057648, 1897238633, 1976864222, 1804852699, 1867694188, 1645340341, 1724971778, 1587496639, 1516133128, 1461550545, 1406951526, 1302016099, 1230646740, 1142491917, 1087903418, -1398421865, -1469785312, -1524105735, -1578704818, -1079922613, -1151291908, -1239184603, -1293773166, -1968362705, -1905510760, -2094067647, -2014441994, -1716953613, -1654112188, -1876203875, -1796572374, -525066777, -462094256, -382327159, -302564546, -206542021, -143559028, -97365931, -17609246, -960696225, -1031934488, -817968335, -872425850, -709327229, -780559564, -600130067, -654598054, 1762451694, 1842216281, 1619975040, 1682949687, 2047383090, 2127137669, 1938468188, 2001449195, 1325665622, 1271206113, 1183200824, 1111960463, 1543535498, 1489069629, 1434599652, 1363369299, 622672798, 568075817, 748617968, 677256519, 907627842, 853037301, 1067152940, 995781531, 51762726, 131386257, 177728840, 240578815, 269590778, 349224269, 429104020, 491947555, -248556018, -168932423, -122852000, -60002089, -500490030, -420856475, -341238852, -278395381, -685261898, -739858943, -559578920, -630940305, -1004286614, -1058877219, -845023740, -916395085, -1119974018, -1174433591, -1262701040, -1333941337, -1371866206, -1426332139, -1481064244, -1552294533, -1690935098, -1611170447, -1833673816, -1770699233, -2009983462, -1930228819, -2119160460, -2056179517, 1569362073, 1498123566, 1409854455, 1355396672, 1317987909, 1246755826, 1192025387, 1137557660, 2072149281, 2135122070, 1912620623, 1992383480, 1753615357, 1816598090, 1627664531, 1707420964, 295390185, 358241886, 404320391, 483945776, 43990325, 106832002, 186451547, 266083308, 932423249, 861060070, 1041341759, 986742920, 613929101, 542559546, 756411363, 701822548, -978770311, -1050133554, -869589737, -924188512, -693284699, -764654318, -550540341, -605129092, -475935807, -413084042, -366743377, -287118056, -257573603, -194731862, -114850189, -35218492, -1984365303, -1921392450, -2143631769, -2063868976, -1698919467, -1635936670, -1824608069, -1744851700, -1347415887, -1418654458, -1506661409, -1561119128, -1129027987, -1200260134, -1254728445, -1309196108};
        CRC16_BYTES_MSBF = new int[]{0, 4129, 8258, 12387, 16516, 20645, 24774, 28903, 33032, 37161, 41290, 45419, 49548, 53677, 57806, 61935};
        CRC8_BYTES_MSBF = new int[]{0, 7, 14, 9, 28, 27, 18, 21, 56, 63, 54, 49, 36, 35, 42, 45, 112, 119, 126, 121, 108, 107, 98, 101, 72, 79, 70, 65, 84, 83, 90, 93, 224, 231, 238, 233, 252, 251, 242, 245, 216, 223, 214, 209, 196, 195, 202, 205, 144, 151, 158, 153, 140, 139, 130, 133, 168, 175, 166, 161, 180, 179, 186, 189, 199, 192, 201, 206, 219, 220, 213, 210, 255, 248, 241, 246, 227, 228, 237, 234, 183, 176, 185, 190, 171, 172, 165, 162, 143, 136, 129, 134, 147, 148, 157, 154, 39, 32, 41, 46, 59, 60, 53, 50, 31, 24, 17, 22, 3, 4, 13, 10, 87, 80, 89, 94, 75, 76, 69, 66, 111, 104, 97, 102, 115, 116, 125, 122, 137, 142, 135, 128, 149, 146, 155, 156, 177, 182, 191, 184, 173, 170, 163, 164, 249, 254, 247, 240, 229, 226, 235, 236, 193, 198, 207, 200, 221, 218, 211, 212, 105, 110, 103, 96, 117, 114, 123, 124, 81, 86, 95, 88, 77, 74, 67, 68, 25, 30, 23, 16, 5, 2, 11, 12, 33, 38, 47, 40, 61, 58, 51, 52, 78, 73, 64, 71, 82, 85, 92, 91, 118, 113, 120, 127, 106, 109, 100, 99, 62, 57, 48, 55, 34, 37, 44, 43, 6, 1, 8, 15, 26, 29, 20, 19, 174, 169, 160, 167, 178, 181, 188, 187, 150, 145, 152, 159, 138, 141, 132, 131, 222, 217, 208, 215, 194, 197, 204, 203, 230, 225, 232, 239, 250, 253, 244, 243};
    }

    @RequiresApi(value=29)
    private static class Api29 {
        public static void startForeground(Service mediaSessionService, int notificationId, Notification notification, int foregroundServiceType, String foregroundServiceManifestType) {
            try {
                mediaSessionService.startForeground(notificationId, notification, foregroundServiceType);
            }
            catch (RuntimeException e) {
                Log.e(Util.TAG, "The service must be declared with a foregroundServiceType that includes " + foregroundServiceManifestType);
                throw e;
            }
        }

        private Api29() {
        }
    }
}

