/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import android.annotation.SuppressLint;
import android.media.MediaFormat;
import androidx.annotation.Nullable;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.Format;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.util.CodecSpecificDataUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;

@UnstableApi
public final class MediaFormatUtil {
    public static final String KEY_PIXEL_WIDTH_HEIGHT_RATIO_FLOAT = "exo-pixel-width-height-ratio-float";
    public static final String KEY_PCM_ENCODING_EXTENDED = "exo-pcm-encoding-int";
    public static final String KEY_MAX_BIT_RATE = "max-bitrate";
    private static final int MAX_POWER_OF_TWO_INT = 0x40000000;

    @SuppressLint(value={"InlinedApi"})
    public static Format createFormatFromMediaFormat(MediaFormat mediaFormat) {
        ByteBuffer csdByteBuffer;
        Format.Builder formatBuilder = new Format.Builder().setSampleMimeType(mediaFormat.getString("mime")).setLanguage(mediaFormat.getString("language")).setPeakBitrate(MediaFormatUtil.getInteger(mediaFormat, KEY_MAX_BIT_RATE, -1)).setAverageBitrate(MediaFormatUtil.getInteger(mediaFormat, "bitrate", -1)).setCodecs(MediaFormatUtil.getCodecString(mediaFormat)).setFrameRate(MediaFormatUtil.getFrameRate(mediaFormat, -1.0f)).setWidth(MediaFormatUtil.getInteger(mediaFormat, "width", -1)).setHeight(MediaFormatUtil.getInteger(mediaFormat, "height", -1)).setPixelWidthHeightRatio(MediaFormatUtil.getPixelWidthHeightRatio(mediaFormat, 1.0f)).setMaxInputSize(MediaFormatUtil.getInteger(mediaFormat, "max-input-size", -1)).setRotationDegrees(MediaFormatUtil.getInteger(mediaFormat, "rotation-degrees", 0)).setColorInfo(MediaFormatUtil.getColorInfo(mediaFormat)).setSampleRate(MediaFormatUtil.getInteger(mediaFormat, "sample-rate", -1)).setChannelCount(MediaFormatUtil.getInteger(mediaFormat, "channel-count", -1)).setPcmEncoding(MediaFormatUtil.getInteger(mediaFormat, "pcm-encoding", -1));
        ImmutableList.Builder csdBuffers = new ImmutableList.Builder();
        int csdIndex = 0;
        while ((csdByteBuffer = mediaFormat.getByteBuffer("csd-" + csdIndex)) != null) {
            byte[] csdBufferData = new byte[csdByteBuffer.remaining()];
            csdByteBuffer.get(csdBufferData);
            csdByteBuffer.rewind();
            csdBuffers.add((Object)csdBufferData);
            ++csdIndex;
        }
        formatBuilder.setInitializationData((List<byte[]>)csdBuffers.build());
        return formatBuilder.build();
    }

    @SuppressLint(value={"InlinedApi"})
    public static MediaFormat createMediaFormatFromFormat(Format format) {
        MediaFormat result = new MediaFormat();
        MediaFormatUtil.maybeSetInteger(result, "bitrate", format.bitrate);
        MediaFormatUtil.maybeSetInteger(result, KEY_MAX_BIT_RATE, format.peakBitrate);
        MediaFormatUtil.maybeSetInteger(result, "channel-count", format.channelCount);
        MediaFormatUtil.maybeSetColorInfo(result, format.colorInfo);
        MediaFormatUtil.maybeSetString(result, "mime", format.sampleMimeType);
        MediaFormatUtil.maybeSetString(result, "codecs-string", format.codecs);
        MediaFormatUtil.maybeSetFloat(result, "frame-rate", format.frameRate);
        MediaFormatUtil.maybeSetInteger(result, "width", format.width);
        MediaFormatUtil.maybeSetInteger(result, "height", format.height);
        MediaFormatUtil.setCsdBuffers(result, format.initializationData);
        MediaFormatUtil.maybeSetPcmEncoding(result, format.pcmEncoding);
        MediaFormatUtil.maybeSetString(result, "language", format.language);
        MediaFormatUtil.maybeSetInteger(result, "max-input-size", format.maxInputSize);
        MediaFormatUtil.maybeSetInteger(result, "sample-rate", format.sampleRate);
        MediaFormatUtil.maybeSetInteger(result, "caption-service-number", format.accessibilityChannel);
        result.setInteger("rotation-degrees", format.rotationDegrees);
        int selectionFlags = format.selectionFlags;
        MediaFormatUtil.setBooleanAsInt(result, "is-autoselect", selectionFlags & 4);
        MediaFormatUtil.setBooleanAsInt(result, "is-default", selectionFlags & 1);
        MediaFormatUtil.setBooleanAsInt(result, "is-forced-subtitle", selectionFlags & 2);
        result.setInteger("encoder-delay", format.encoderDelay);
        result.setInteger("encoder-padding", format.encoderPadding);
        MediaFormatUtil.maybeSetPixelAspectRatio(result, format.pixelWidthHeightRatio);
        return result;
    }

    public static void maybeSetString(MediaFormat format, String key, @Nullable String value) {
        if (value != null) {
            format.setString(key, value);
        }
    }

    public static void setCsdBuffers(MediaFormat format, List<byte[]> csdBuffers) {
        for (int i = 0; i < csdBuffers.size(); ++i) {
            format.setByteBuffer("csd-" + i, ByteBuffer.wrap(csdBuffers.get(i)));
        }
    }

    public static void maybeSetInteger(MediaFormat format, String key, int value) {
        if (value != -1) {
            format.setInteger(key, value);
        }
    }

    public static void maybeSetFloat(MediaFormat format, String key, float value) {
        if (value != -1.0f) {
            format.setFloat(key, value);
        }
    }

    public static void maybeSetByteBuffer(MediaFormat format, String key, @Nullable byte[] value) {
        if (value != null) {
            format.setByteBuffer(key, ByteBuffer.wrap(value));
        }
    }

    public static void maybeSetColorInfo(MediaFormat format, @Nullable ColorInfo colorInfo) {
        if (colorInfo != null) {
            MediaFormatUtil.maybeSetInteger(format, "color-transfer", colorInfo.colorTransfer);
            MediaFormatUtil.maybeSetInteger(format, "color-standard", colorInfo.colorSpace);
            MediaFormatUtil.maybeSetInteger(format, "color-range", colorInfo.colorRange);
            MediaFormatUtil.maybeSetByteBuffer(format, "hdr-static-info", colorInfo.hdrStaticInfo);
        }
    }

    @Nullable
    public static ColorInfo getColorInfo(MediaFormat mediaFormat) {
        byte[] hdrStaticInfo;
        if (Util.SDK_INT < 24) {
            return null;
        }
        int colorSpace = MediaFormatUtil.getInteger(mediaFormat, "color-standard", -1);
        int colorRange = MediaFormatUtil.getInteger(mediaFormat, "color-range", -1);
        int colorTransfer = MediaFormatUtil.getInteger(mediaFormat, "color-transfer", -1);
        ByteBuffer hdrStaticInfoByteBuffer = mediaFormat.getByteBuffer("hdr-static-info");
        byte[] byArray = hdrStaticInfo = hdrStaticInfoByteBuffer != null ? MediaFormatUtil.getArray(hdrStaticInfoByteBuffer) : null;
        if (!MediaFormatUtil.isValidColorSpace(colorSpace)) {
            colorSpace = -1;
        }
        if (!MediaFormatUtil.isValidColorRange(colorRange)) {
            colorRange = -1;
        }
        if (!MediaFormatUtil.isValidColorTransfer(colorTransfer)) {
            colorTransfer = -1;
        }
        if (colorSpace != -1 || colorRange != -1 || colorTransfer != -1 || hdrStaticInfo != null) {
            return new ColorInfo.Builder().setColorSpace(colorSpace).setColorRange(colorRange).setColorTransfer(colorTransfer).setHdrStaticInfo(hdrStaticInfo).build();
        }
        return null;
    }

    public static int getInteger(MediaFormat mediaFormat, String name, int defaultValue) {
        return mediaFormat.containsKey(name) ? mediaFormat.getInteger(name) : defaultValue;
    }

    public static float getFloat(MediaFormat mediaFormat, String name, float defaultValue) {
        return mediaFormat.containsKey(name) ? mediaFormat.getFloat(name) : defaultValue;
    }

    @Nullable
    public static String getString(MediaFormat mediaFormat, String name, @Nullable String defaultValue) {
        return mediaFormat.containsKey(name) ? mediaFormat.getString(name) : defaultValue;
    }

    @Nullable
    @SuppressLint(value={"InlinedApi"})
    private static String getCodecString(MediaFormat mediaFormat) {
        if (Objects.equals(mediaFormat.getString("mime"), "video/3gpp") && mediaFormat.containsKey("profile") && mediaFormat.containsKey("level")) {
            return CodecSpecificDataUtil.buildH263CodecString(mediaFormat.getInteger("profile"), mediaFormat.getInteger("level"));
        }
        return MediaFormatUtil.getString(mediaFormat, "codecs-string", null);
    }

    private static float getFrameRate(MediaFormat mediaFormat, float defaultValue) {
        float frameRate = defaultValue;
        if (mediaFormat.containsKey("frame-rate")) {
            try {
                frameRate = mediaFormat.getFloat("frame-rate");
            }
            catch (ClassCastException ex) {
                frameRate = mediaFormat.getInteger("frame-rate");
            }
        }
        return frameRate;
    }

    @SuppressLint(value={"InlinedApi"})
    private static float getPixelWidthHeightRatio(MediaFormat mediaFormat, float defaultValue) {
        if (mediaFormat.containsKey("sar-width") && mediaFormat.containsKey("sar-height")) {
            return (float)mediaFormat.getInteger("sar-width") / (float)mediaFormat.getInteger("sar-height");
        }
        return defaultValue;
    }

    public static byte[] getArray(ByteBuffer byteBuffer) {
        byte[] array = new byte[byteBuffer.remaining()];
        byteBuffer.get(array);
        return array;
    }

    public static boolean isVideoFormat(MediaFormat mediaFormat) {
        return MimeTypes.isVideo(mediaFormat.getString("mime"));
    }

    public static boolean isAudioFormat(MediaFormat mediaFormat) {
        return MimeTypes.isAudio(mediaFormat.getString("mime"));
    }

    @Nullable
    public static Integer getTimeLapseFrameRate(MediaFormat format) {
        if (format.containsKey("time-lapse-enable") && format.getInteger("time-lapse-enable") > 0 && format.containsKey("time-lapse-fps")) {
            return format.getInteger("time-lapse-fps");
        }
        return null;
    }

    private static void setBooleanAsInt(MediaFormat format, String key, int value) {
        format.setInteger(key, value != 0 ? 1 : 0);
    }

    @SuppressLint(value={"InlinedApi"})
    private static void maybeSetPixelAspectRatio(MediaFormat mediaFormat, float pixelWidthHeightRatio) {
        mediaFormat.setFloat(KEY_PIXEL_WIDTH_HEIGHT_RATIO_FLOAT, pixelWidthHeightRatio);
        int pixelAspectRatioWidth = 1;
        int pixelAspectRatioHeight = 1;
        if (pixelWidthHeightRatio < 1.0f) {
            pixelAspectRatioHeight = 0x40000000;
            pixelAspectRatioWidth = (int)(pixelWidthHeightRatio * (float)pixelAspectRatioHeight);
        } else if (pixelWidthHeightRatio > 1.0f) {
            pixelAspectRatioWidth = 0x40000000;
            pixelAspectRatioHeight = (int)((float)pixelAspectRatioWidth / pixelWidthHeightRatio);
        }
        mediaFormat.setInteger("sar-width", pixelAspectRatioWidth);
        mediaFormat.setInteger("sar-height", pixelAspectRatioHeight);
    }

    @SuppressLint(value={"InlinedApi"})
    private static void maybeSetPcmEncoding(MediaFormat mediaFormat, int exoPcmEncoding) {
        int mediaFormatPcmEncoding;
        if (exoPcmEncoding == -1) {
            return;
        }
        MediaFormatUtil.maybeSetInteger(mediaFormat, KEY_PCM_ENCODING_EXTENDED, exoPcmEncoding);
        switch (exoPcmEncoding) {
            case 3: {
                mediaFormatPcmEncoding = 3;
                break;
            }
            case 2: {
                mediaFormatPcmEncoding = 2;
                break;
            }
            case 4: {
                mediaFormatPcmEncoding = 4;
                break;
            }
            case 21: {
                mediaFormatPcmEncoding = 21;
                break;
            }
            case 22: {
                mediaFormatPcmEncoding = 22;
                break;
            }
            case 0: {
                mediaFormatPcmEncoding = 0;
                break;
            }
            default: {
                return;
            }
        }
        mediaFormat.setInteger("pcm-encoding", mediaFormatPcmEncoding);
    }

    private static boolean isValidColorSpace(int colorSpace) {
        return colorSpace == 2 || colorSpace == 1 || colorSpace == 6 || colorSpace == -1;
    }

    private static boolean isValidColorRange(int colorRange) {
        return colorRange == 2 || colorRange == 1 || colorRange == -1;
    }

    private static boolean isValidColorTransfer(int colorTransfer) {
        return colorTransfer == 1 || colorTransfer == 3 || colorTransfer == 6 || colorTransfer == 7 || colorTransfer == -1;
    }

    private MediaFormatUtil() {
    }
}

