/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import android.annotation.SuppressLint;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.media3.common.ColorInfo;
import androidx.media3.common.Format;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.ParsableBitArray;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SuppressLint(value={"InlinedApi"})
@UnstableApi
public final class CodecSpecificDataUtil {
    private static final byte[] NAL_START_CODE = new byte[]{0, 0, 0, 1};
    private static final String[] HEVC_GENERAL_PROFILE_SPACE_STRINGS = new String[]{"", "A", "B", "C"};
    private static final int VISUAL_OBJECT_LAYER = 1;
    private static final int VISUAL_OBJECT_LAYER_START = 32;
    private static final int EXTENDED_PAR = 15;
    private static final int RECTANGULAR = 0;
    private static final String CODEC_ID_H263 = "s263";
    private static final String CODEC_ID_AVC1 = "avc1";
    private static final String CODEC_ID_AVC2 = "avc2";
    private static final String CODEC_ID_VP09 = "vp09";
    private static final String CODEC_ID_HEV1 = "hev1";
    private static final String CODEC_ID_HVC1 = "hvc1";
    private static final String CODEC_ID_AV01 = "av01";
    private static final String CODEC_ID_MP4A = "mp4a";
    private static final Pattern PROFILE_PATTERN = Pattern.compile("^\\D?(\\d+)$");
    private static final String TAG = "CodecSpecificDataUtil";

    public static Pair<Integer, Integer> parseAlacAudioSpecificConfig(byte[] audioSpecificConfig) {
        ParsableByteArray byteArray = new ParsableByteArray(audioSpecificConfig);
        byteArray.setPosition(9);
        int channelCount = byteArray.readUnsignedByte();
        byteArray.setPosition(20);
        int sampleRate = byteArray.readUnsignedIntToInt();
        return Pair.create((Object)sampleRate, (Object)channelCount);
    }

    public static List<byte[]> buildCea708InitializationData(boolean isWideAspectRatio) {
        byte[] byArray;
        if (isWideAspectRatio) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 1;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        }
        return Collections.singletonList(byArray);
    }

    public static boolean parseCea708InitializationData(List<byte[]> initializationData) {
        return initializationData.size() == 1 && initializationData.get(0).length == 1 && initializationData.get(0)[0] == 1;
    }

    public static ImmutableList<byte[]> buildVp9CodecPrivateInitializationData(byte profile, byte level, byte bitDepth, byte chromaSubsampling) {
        byte profileId = 1;
        byte levelId = 2;
        byte bitDepthId = 3;
        byte chromaSubsamplingId = 4;
        byte length = 1;
        return ImmutableList.of((Object)new byte[]{profileId, length, profile, levelId, length, level, bitDepthId, length, bitDepth, chromaSubsamplingId, length, chromaSubsampling});
    }

    public static Pair<Integer, Integer> getVideoResolutionFromMpeg4VideoConfig(byte[] videoSpecificConfig) {
        int videoObjectLayerShape;
        int aspectRatioInfo;
        int offset = 0;
        boolean foundVOL = false;
        ParsableByteArray scratchBytes = new ParsableByteArray(videoSpecificConfig);
        while (offset + 3 < videoSpecificConfig.length) {
            if (scratchBytes.readUnsignedInt24() != 1 || (videoSpecificConfig[offset + 3] & 0xF0) != 32) {
                scratchBytes.setPosition(scratchBytes.getPosition() - 2);
                ++offset;
                continue;
            }
            foundVOL = true;
            break;
        }
        Assertions.checkArgument(foundVOL, "Invalid input: VOL not found.");
        ParsableBitArray scratchBits = new ParsableBitArray(videoSpecificConfig);
        scratchBits.skipBits((offset + 4) * 8);
        scratchBits.skipBits(1);
        scratchBits.skipBits(8);
        if (scratchBits.readBit()) {
            scratchBits.skipBits(4);
            scratchBits.skipBits(3);
        }
        if ((aspectRatioInfo = scratchBits.readBits(4)) == 15) {
            scratchBits.skipBits(8);
            scratchBits.skipBits(8);
        }
        if (scratchBits.readBit()) {
            scratchBits.skipBits(2);
            scratchBits.skipBits(1);
            if (scratchBits.readBit()) {
                scratchBits.skipBits(79);
            }
        }
        Assertions.checkArgument((videoObjectLayerShape = scratchBits.readBits(2)) == 0, "Only supports rectangular video object layer shape.");
        Assertions.checkArgument(scratchBits.readBit());
        int vopTimeIncrementResolution = scratchBits.readBits(16);
        Assertions.checkArgument(scratchBits.readBit());
        if (scratchBits.readBit()) {
            Assertions.checkArgument(vopTimeIncrementResolution > 0);
            --vopTimeIncrementResolution;
            int numBitsToSkip = 0;
            while (vopTimeIncrementResolution > 0) {
                ++numBitsToSkip;
                vopTimeIncrementResolution >>= 1;
            }
            scratchBits.skipBits(numBitsToSkip);
        }
        Assertions.checkArgument(scratchBits.readBit());
        int videoObjectLayerWidth = scratchBits.readBits(13);
        Assertions.checkArgument(scratchBits.readBit());
        int videoObjectLayerHeight = scratchBits.readBits(13);
        Assertions.checkArgument(scratchBits.readBit());
        scratchBits.skipBits(1);
        return Pair.create((Object)videoObjectLayerWidth, (Object)videoObjectLayerHeight);
    }

    public static String buildAvcCodecString(int profileIdc, int constraintsFlagsAndReservedZero2Bits, int levelIdc) {
        return String.format("avc1.%02X%02X%02X", profileIdc, constraintsFlagsAndReservedZero2Bits, levelIdc);
    }

    public static String buildHevcCodecString(int generalProfileSpace, boolean generalTierFlag, int generalProfileIdc, int generalProfileCompatibilityFlags, int[] constraintBytes, int generalLevelIdc) {
        int trailingZeroIndex;
        StringBuilder builder = new StringBuilder(Util.formatInvariant("hvc1.%s%d.%X.%c%d", HEVC_GENERAL_PROFILE_SPACE_STRINGS[generalProfileSpace], generalProfileIdc, generalProfileCompatibilityFlags, Character.valueOf(generalTierFlag ? (char)'H' : 'L'), generalLevelIdc));
        for (trailingZeroIndex = constraintBytes.length; trailingZeroIndex > 0 && constraintBytes[trailingZeroIndex - 1] == 0; --trailingZeroIndex) {
        }
        for (int i = 0; i < trailingZeroIndex; ++i) {
            builder.append(String.format(".%02X", constraintBytes[i]));
        }
        return builder.toString();
    }

    public static String buildH263CodecString(int profile, int level) {
        return Util.formatInvariant("s263.%d.%d", profile, level);
    }

    @Nullable
    public static Pair<Integer, Integer> getCodecProfileAndLevel(Format format) {
        if (format.codecs == null) {
            return null;
        }
        String[] parts = format.codecs.split("\\.");
        if ("video/dolby-vision".equals(format.sampleMimeType)) {
            return CodecSpecificDataUtil.getDolbyVisionProfileAndLevel(format.codecs, parts);
        }
        switch (parts[0]) {
            case "s263": {
                return CodecSpecificDataUtil.getH263ProfileAndLevel(format.codecs, parts);
            }
            case "avc1": 
            case "avc2": {
                return CodecSpecificDataUtil.getAvcProfileAndLevel(format.codecs, parts);
            }
            case "vp09": {
                return CodecSpecificDataUtil.getVp9ProfileAndLevel(format.codecs, parts);
            }
            case "hev1": 
            case "hvc1": {
                return CodecSpecificDataUtil.getHevcProfileAndLevel(format.codecs, parts, format.colorInfo);
            }
            case "av01": {
                return CodecSpecificDataUtil.getAv1ProfileAndLevel(format.codecs, parts, format.colorInfo);
            }
            case "mp4a": {
                return CodecSpecificDataUtil.getAacCodecProfileAndLevel(format.codecs, parts);
            }
        }
        return null;
    }

    @Nullable
    public static Pair<Integer, Integer> getHevcProfileAndLevel(String codec, String[] parts, @Nullable ColorInfo colorInfo) {
        int profile;
        if (parts.length < 4) {
            Log.w(TAG, "Ignoring malformed HEVC codec string: " + codec);
            return null;
        }
        Matcher matcher = PROFILE_PATTERN.matcher(parts[1]);
        if (!matcher.matches()) {
            Log.w(TAG, "Ignoring malformed HEVC codec string: " + codec);
            return null;
        }
        String profileString = matcher.group(1);
        if ("1".equals(profileString)) {
            profile = 1;
        } else if ("2".equals(profileString)) {
            profile = colorInfo != null && colorInfo.colorTransfer == 6 ? 4096 : 2;
        } else if ("6".equals(profileString)) {
            profile = 6;
        } else {
            Log.w(TAG, "Unknown HEVC profile string: " + profileString);
            return null;
        }
        String levelString = parts[3];
        Integer level = CodecSpecificDataUtil.hevcCodecStringToProfileLevel(levelString);
        if (level == null) {
            Log.w(TAG, "Unknown HEVC level string: " + levelString);
            return null;
        }
        return new Pair((Object)profile, (Object)level);
    }

    public static byte[] buildNalUnit(byte[] data, int offset, int length) {
        byte[] nalUnit = new byte[length + NAL_START_CODE.length];
        System.arraycopy(NAL_START_CODE, 0, nalUnit, 0, NAL_START_CODE.length);
        System.arraycopy(data, offset, nalUnit, NAL_START_CODE.length, length);
        return nalUnit;
    }

    @Nullable
    public static byte[][] splitNalUnits(byte[] data) {
        if (!CodecSpecificDataUtil.isNalStartCode(data, 0)) {
            return null;
        }
        ArrayList<Integer> starts = new ArrayList<Integer>();
        int nalUnitIndex = 0;
        do {
            starts.add(nalUnitIndex);
        } while ((nalUnitIndex = CodecSpecificDataUtil.findNalStartCode(data, nalUnitIndex + NAL_START_CODE.length)) != -1);
        byte[][] split = new byte[starts.size()][];
        for (int i = 0; i < starts.size(); ++i) {
            int startIndex = (Integer)starts.get(i);
            int endIndex = i < starts.size() - 1 ? (Integer)starts.get(i + 1) : data.length;
            byte[] nal = new byte[endIndex - startIndex];
            System.arraycopy(data, startIndex, nal, 0, nal.length);
            split[i] = nal;
        }
        return split;
    }

    private static int findNalStartCode(byte[] data, int index) {
        int endIndex = data.length - NAL_START_CODE.length;
        for (int i = index; i <= endIndex; ++i) {
            if (!CodecSpecificDataUtil.isNalStartCode(data, i)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isNalStartCode(byte[] data, int index) {
        if (data.length - index <= NAL_START_CODE.length) {
            return false;
        }
        for (int j = 0; j < NAL_START_CODE.length; ++j) {
            if (data[index + j] == NAL_START_CODE[j]) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Pair<Integer, Integer> getDolbyVisionProfileAndLevel(String codec, String[] parts) {
        if (parts.length < 3) {
            Log.w(TAG, "Ignoring malformed Dolby Vision codec string: " + codec);
            return null;
        }
        Matcher matcher = PROFILE_PATTERN.matcher(parts[1]);
        if (!matcher.matches()) {
            Log.w(TAG, "Ignoring malformed Dolby Vision codec string: " + codec);
            return null;
        }
        String profileString = matcher.group(1);
        Integer profile = CodecSpecificDataUtil.dolbyVisionStringToProfile(profileString);
        if (profile == null) {
            Log.w(TAG, "Unknown Dolby Vision profile string: " + profileString);
            return null;
        }
        String levelString = parts[2];
        Integer level = CodecSpecificDataUtil.dolbyVisionStringToLevel(levelString);
        if (level == null) {
            Log.w(TAG, "Unknown Dolby Vision level string: " + levelString);
            return null;
        }
        return new Pair((Object)profile, (Object)level);
    }

    private static Pair<Integer, Integer> getH263ProfileAndLevel(String codec, String[] parts) {
        Pair defaultProfileAndLevel = new Pair((Object)1, (Object)1);
        if (parts.length < 3) {
            Log.w(TAG, "Ignoring malformed H263 codec string: " + codec);
            return defaultProfileAndLevel;
        }
        try {
            int profile = Integer.parseInt(parts[1]);
            int level = Integer.parseInt(parts[2]);
            return new Pair((Object)profile, (Object)level);
        }
        catch (NumberFormatException e) {
            Log.w(TAG, "Ignoring malformed H263 codec string: " + codec);
            return defaultProfileAndLevel;
        }
    }

    @Nullable
    private static Pair<Integer, Integer> getAvcProfileAndLevel(String codec, String[] parts) {
        int levelInteger;
        int profileInteger;
        block7: {
            if (parts.length < 2) {
                Log.w(TAG, "Ignoring malformed AVC codec string: " + codec);
                return null;
            }
            try {
                if (parts[1].length() == 6) {
                    profileInteger = Integer.parseInt(parts[1].substring(0, 2), 16);
                    levelInteger = Integer.parseInt(parts[1].substring(4), 16);
                    break block7;
                }
                if (parts.length >= 3) {
                    profileInteger = Integer.parseInt(parts[1]);
                    levelInteger = Integer.parseInt(parts[2]);
                    break block7;
                }
                Log.w(TAG, "Ignoring malformed AVC codec string: " + codec);
                return null;
            }
            catch (NumberFormatException e) {
                Log.w(TAG, "Ignoring malformed AVC codec string: " + codec);
                return null;
            }
        }
        int profile = CodecSpecificDataUtil.avcProfileNumberToConst(profileInteger);
        if (profile == -1) {
            Log.w(TAG, "Unknown AVC profile: " + profileInteger);
            return null;
        }
        int level = CodecSpecificDataUtil.avcLevelNumberToConst(levelInteger);
        if (level == -1) {
            Log.w(TAG, "Unknown AVC level: " + levelInteger);
            return null;
        }
        return new Pair((Object)profile, (Object)level);
    }

    @Nullable
    private static Pair<Integer, Integer> getVp9ProfileAndLevel(String codec, String[] parts) {
        int levelInteger;
        int profileInteger;
        if (parts.length < 3) {
            Log.w(TAG, "Ignoring malformed VP9 codec string: " + codec);
            return null;
        }
        try {
            profileInteger = Integer.parseInt(parts[1]);
            levelInteger = Integer.parseInt(parts[2]);
        }
        catch (NumberFormatException e) {
            Log.w(TAG, "Ignoring malformed VP9 codec string: " + codec);
            return null;
        }
        int profile = CodecSpecificDataUtil.vp9ProfileNumberToConst(profileInteger);
        if (profile == -1) {
            Log.w(TAG, "Unknown VP9 profile: " + profileInteger);
            return null;
        }
        int level = CodecSpecificDataUtil.vp9LevelNumberToConst(levelInteger);
        if (level == -1) {
            Log.w(TAG, "Unknown VP9 level: " + levelInteger);
            return null;
        }
        return new Pair((Object)profile, (Object)level);
    }

    @Nullable
    private static Pair<Integer, Integer> getAv1ProfileAndLevel(String codec, String[] parts, @Nullable ColorInfo colorInfo) {
        int bitDepthInteger;
        int levelInteger;
        int profileInteger;
        if (parts.length < 4) {
            Log.w(TAG, "Ignoring malformed AV1 codec string: " + codec);
            return null;
        }
        try {
            profileInteger = Integer.parseInt(parts[1]);
            levelInteger = Integer.parseInt(parts[2].substring(0, 2));
            bitDepthInteger = Integer.parseInt(parts[3]);
        }
        catch (NumberFormatException e) {
            Log.w(TAG, "Ignoring malformed AV1 codec string: " + codec);
            return null;
        }
        if (profileInteger != 0) {
            Log.w(TAG, "Unknown AV1 profile: " + profileInteger);
            return null;
        }
        if (bitDepthInteger != 8 && bitDepthInteger != 10) {
            Log.w(TAG, "Unknown AV1 bit depth: " + bitDepthInteger);
            return null;
        }
        int profile = bitDepthInteger == 8 ? 1 : (colorInfo != null && (colorInfo.hdrStaticInfo != null || colorInfo.colorTransfer == 7 || colorInfo.colorTransfer == 6) ? 4096 : 2);
        int level = CodecSpecificDataUtil.av1LevelNumberToConst(levelInteger);
        if (level == -1) {
            Log.w(TAG, "Unknown AV1 level: " + levelInteger);
            return null;
        }
        return new Pair((Object)profile, (Object)level);
    }

    @Nullable
    private static Pair<Integer, Integer> getAacCodecProfileAndLevel(String codec, String[] parts) {
        if (parts.length != 3) {
            Log.w(TAG, "Ignoring malformed MP4A codec string: " + codec);
            return null;
        }
        try {
            int audioObjectTypeIndication;
            int profile;
            int objectTypeIndication = Integer.parseInt(parts[1], 16);
            String mimeType = MimeTypes.getMimeTypeFromMp4ObjectType(objectTypeIndication);
            if ("audio/mp4a-latm".equals(mimeType) && (profile = CodecSpecificDataUtil.mp4aAudioObjectTypeToProfile(audioObjectTypeIndication = Integer.parseInt(parts[2]))) != -1) {
                return new Pair((Object)profile, (Object)0);
            }
        }
        catch (NumberFormatException e) {
            Log.w(TAG, "Ignoring malformed MP4A codec string: " + codec);
        }
        return null;
    }

    private static int avcProfileNumberToConst(int profileNumber) {
        switch (profileNumber) {
            case 66: {
                return 1;
            }
            case 77: {
                return 2;
            }
            case 88: {
                return 4;
            }
            case 100: {
                return 8;
            }
            case 110: {
                return 16;
            }
            case 122: {
                return 32;
            }
            case 244: {
                return 64;
            }
        }
        return -1;
    }

    private static int avcLevelNumberToConst(int levelNumber) {
        switch (levelNumber) {
            case 10: {
                return 1;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 8;
            }
            case 13: {
                return 16;
            }
            case 20: {
                return 32;
            }
            case 21: {
                return 64;
            }
            case 22: {
                return 128;
            }
            case 30: {
                return 256;
            }
            case 31: {
                return 512;
            }
            case 32: {
                return 1024;
            }
            case 40: {
                return 2048;
            }
            case 41: {
                return 4096;
            }
            case 42: {
                return 8192;
            }
            case 50: {
                return 16384;
            }
            case 51: {
                return 32768;
            }
            case 52: {
                return 65536;
            }
        }
        return -1;
    }

    private static int vp9ProfileNumberToConst(int profileNumber) {
        switch (profileNumber) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
        }
        return -1;
    }

    private static int vp9LevelNumberToConst(int levelNumber) {
        switch (levelNumber) {
            case 10: {
                return 1;
            }
            case 11: {
                return 2;
            }
            case 20: {
                return 4;
            }
            case 21: {
                return 8;
            }
            case 30: {
                return 16;
            }
            case 31: {
                return 32;
            }
            case 40: {
                return 64;
            }
            case 41: {
                return 128;
            }
            case 50: {
                return 256;
            }
            case 51: {
                return 512;
            }
            case 60: {
                return 2048;
            }
            case 61: {
                return 4096;
            }
            case 62: {
                return 8192;
            }
        }
        return -1;
    }

    @Nullable
    private static Integer hevcCodecStringToProfileLevel(@Nullable String codecString) {
        if (codecString == null) {
            return null;
        }
        switch (codecString) {
            case "L30": {
                return 1;
            }
            case "L60": {
                return 4;
            }
            case "L63": {
                return 16;
            }
            case "L90": {
                return 64;
            }
            case "L93": {
                return 256;
            }
            case "L120": {
                return 1024;
            }
            case "L123": {
                return 4096;
            }
            case "L150": {
                return 16384;
            }
            case "L153": {
                return 65536;
            }
            case "L156": {
                return 262144;
            }
            case "L180": {
                return 0x100000;
            }
            case "L183": {
                return 0x400000;
            }
            case "L186": {
                return 0x1000000;
            }
            case "H30": {
                return 2;
            }
            case "H60": {
                return 8;
            }
            case "H63": {
                return 32;
            }
            case "H90": {
                return 128;
            }
            case "H93": {
                return 512;
            }
            case "H120": {
                return 2048;
            }
            case "H123": {
                return 8192;
            }
            case "H150": {
                return 32768;
            }
            case "H153": {
                return 131072;
            }
            case "H156": {
                return 524288;
            }
            case "H180": {
                return 0x200000;
            }
            case "H183": {
                return 0x800000;
            }
            case "H186": {
                return 0x2000000;
            }
        }
        return null;
    }

    @Nullable
    private static Integer dolbyVisionStringToProfile(@Nullable String profileString) {
        if (profileString == null) {
            return null;
        }
        switch (profileString) {
            case "00": {
                return 1;
            }
            case "01": {
                return 2;
            }
            case "02": {
                return 4;
            }
            case "03": {
                return 8;
            }
            case "04": {
                return 16;
            }
            case "05": {
                return 32;
            }
            case "06": {
                return 64;
            }
            case "07": {
                return 128;
            }
            case "08": {
                return 256;
            }
            case "09": {
                return 512;
            }
            case "10": {
                return 1024;
            }
        }
        return null;
    }

    @Nullable
    private static Integer dolbyVisionStringToLevel(@Nullable String levelString) {
        if (levelString == null) {
            return null;
        }
        switch (levelString) {
            case "01": {
                return 1;
            }
            case "02": {
                return 2;
            }
            case "03": {
                return 4;
            }
            case "04": {
                return 8;
            }
            case "05": {
                return 16;
            }
            case "06": {
                return 32;
            }
            case "07": {
                return 64;
            }
            case "08": {
                return 128;
            }
            case "09": {
                return 256;
            }
            case "10": {
                return 512;
            }
            case "11": {
                return 1024;
            }
            case "12": {
                return 2048;
            }
            case "13": {
                return 4096;
            }
        }
        return null;
    }

    private static int av1LevelNumberToConst(int levelNumber) {
        switch (levelNumber) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 32;
            }
            case 6: {
                return 64;
            }
            case 7: {
                return 128;
            }
            case 8: {
                return 256;
            }
            case 9: {
                return 512;
            }
            case 10: {
                return 1024;
            }
            case 11: {
                return 2048;
            }
            case 12: {
                return 4096;
            }
            case 13: {
                return 8192;
            }
            case 14: {
                return 16384;
            }
            case 15: {
                return 32768;
            }
            case 16: {
                return 65536;
            }
            case 17: {
                return 131072;
            }
            case 18: {
                return 262144;
            }
            case 19: {
                return 524288;
            }
            case 20: {
                return 0x100000;
            }
            case 21: {
                return 0x200000;
            }
            case 22: {
                return 0x400000;
            }
            case 23: {
                return 0x800000;
            }
        }
        return -1;
    }

    private static int mp4aAudioObjectTypeToProfile(int profileNumber) {
        switch (profileNumber) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 17: {
                return 17;
            }
            case 20: {
                return 20;
            }
            case 23: {
                return 23;
            }
            case 29: {
                return 29;
            }
            case 39: {
                return 39;
            }
            case 42: {
                return 42;
            }
        }
        return -1;
    }

    private CodecSpecificDataUtil() {
    }
}

