/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.text;

import android.os.Bundle;
import android.text.Spannable;
import android.text.Spanned;
import androidx.annotation.Nullable;
import androidx.media3.common.text.HorizontalTextInVerticalContextSpan;
import androidx.media3.common.text.LanguageFeatureSpan;
import androidx.media3.common.text.RubySpan;
import androidx.media3.common.text.TextEmphasisSpan;
import androidx.media3.common.text.VoiceSpan;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Util;
import java.util.ArrayList;

final class CustomSpanBundler {
    private static final int UNKNOWN = -1;
    private static final int RUBY = 1;
    private static final int TEXT_EMPHASIS = 2;
    private static final int HORIZONTAL_TEXT_IN_VERTICAL_CONTEXT = 3;
    private static final int VOICE = 4;
    private static final String FIELD_START_INDEX = Util.intToStringMaxRadix(0);
    private static final String FIELD_END_INDEX = Util.intToStringMaxRadix(1);
    private static final String FIELD_FLAGS = Util.intToStringMaxRadix(2);
    private static final String FIELD_TYPE = Util.intToStringMaxRadix(3);
    private static final String FIELD_PARAMS = Util.intToStringMaxRadix(4);

    public static ArrayList<Bundle> bundleCustomSpans(Spanned text) {
        Bundle bundle;
        ArrayList<Bundle> bundledCustomSpans = new ArrayList<Bundle>();
        for (RubySpan rubySpan : (RubySpan[])text.getSpans(0, text.length(), RubySpan.class)) {
            bundle = CustomSpanBundler.spanToBundle(text, rubySpan, 1, rubySpan.toBundle());
            bundledCustomSpans.add(bundle);
        }
        for (LanguageFeatureSpan languageFeatureSpan : (TextEmphasisSpan[])text.getSpans(0, text.length(), TextEmphasisSpan.class)) {
            bundle = CustomSpanBundler.spanToBundle(text, languageFeatureSpan, 2, ((TextEmphasisSpan)languageFeatureSpan).toBundle());
            bundledCustomSpans.add(bundle);
        }
        for (LanguageFeatureSpan languageFeatureSpan : (HorizontalTextInVerticalContextSpan[])text.getSpans(0, text.length(), HorizontalTextInVerticalContextSpan.class)) {
            bundle = CustomSpanBundler.spanToBundle(text, languageFeatureSpan, 3, null);
            bundledCustomSpans.add(bundle);
        }
        for (VoiceSpan voiceSpan : (VoiceSpan[])text.getSpans(0, text.length(), VoiceSpan.class)) {
            bundle = CustomSpanBundler.spanToBundle(text, voiceSpan, 4, voiceSpan.toBundle());
            bundledCustomSpans.add(bundle);
        }
        return bundledCustomSpans;
    }

    public static void unbundleAndApplyCustomSpan(Bundle customSpanBundle, Spannable text) {
        int start = customSpanBundle.getInt(FIELD_START_INDEX);
        int end = customSpanBundle.getInt(FIELD_END_INDEX);
        int flags = customSpanBundle.getInt(FIELD_FLAGS);
        int customSpanType = customSpanBundle.getInt(FIELD_TYPE, -1);
        Bundle span = customSpanBundle.getBundle(FIELD_PARAMS);
        switch (customSpanType) {
            case 1: {
                text.setSpan((Object)RubySpan.fromBundle(Assertions.checkNotNull(span)), start, end, flags);
                break;
            }
            case 2: {
                text.setSpan((Object)TextEmphasisSpan.fromBundle(Assertions.checkNotNull(span)), start, end, flags);
                break;
            }
            case 3: {
                text.setSpan((Object)new HorizontalTextInVerticalContextSpan(), start, end, flags);
                break;
            }
            case 4: {
                text.setSpan((Object)VoiceSpan.fromBundle(Assertions.checkNotNull(span)), start, end, flags);
                break;
            }
        }
    }

    private static Bundle spanToBundle(Spanned spanned, Object span, int spanType, @Nullable Bundle params) {
        Bundle bundle = new Bundle();
        bundle.putInt(FIELD_START_INDEX, spanned.getSpanStart(span));
        bundle.putInt(FIELD_END_INDEX, spanned.getSpanEnd(span));
        bundle.putInt(FIELD_FLAGS, spanned.getSpanFlags(span));
        bundle.putInt(FIELD_TYPE, spanType);
        if (params != null) {
            bundle.putBundle(FIELD_PARAMS, params);
        }
        return bundle;
    }

    private CustomSpanBundler() {
    }
}

