/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.audio;

import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.audio.SonicAudioProcessor;
import java.nio.ByteBuffer;

class SynchronizedSonicAudioProcessor
implements AudioProcessor {
    private final Object lock;
    private final SonicAudioProcessor sonicAudioProcessor;

    public SynchronizedSonicAudioProcessor(Object lock) {
        this.lock = lock;
        this.sonicAudioProcessor = new SonicAudioProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSpeed(float speed) {
        Object object = this.lock;
        synchronized (object) {
            this.sonicAudioProcessor.setSpeed(speed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPitch(float pitch) {
        Object object = this.lock;
        synchronized (object) {
            this.sonicAudioProcessor.setPitch(pitch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setOutputSampleRateHz(int sampleRateHz) {
        Object object = this.lock;
        synchronized (object) {
            this.sonicAudioProcessor.setOutputSampleRateHz(sampleRateHz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getMediaDuration(long playoutDuration) {
        Object object = this.lock;
        synchronized (object) {
            return this.sonicAudioProcessor.getMediaDuration(playoutDuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getPlayoutDuration(long mediaDuration) {
        Object object = this.lock;
        synchronized (object) {
            return this.sonicAudioProcessor.getPlayoutDuration(mediaDuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getProcessedInputBytes() {
        Object object = this.lock;
        synchronized (object) {
            return this.sonicAudioProcessor.getProcessedInputBytes();
        }
    }

    @Override
    public long getDurationAfterProcessorApplied(long durationUs) {
        return this.getPlayoutDuration(durationUs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AudioProcessor.AudioFormat configure(AudioProcessor.AudioFormat inputAudioFormat) throws AudioProcessor.UnhandledAudioFormatException {
        Object object = this.lock;
        synchronized (object) {
            return this.sonicAudioProcessor.configure(inputAudioFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isActive() {
        Object object = this.lock;
        synchronized (object) {
            return this.sonicAudioProcessor.isActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void queueInput(ByteBuffer inputBuffer) {
        Object object = this.lock;
        synchronized (object) {
            this.sonicAudioProcessor.queueInput(inputBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void queueEndOfStream() {
        Object object = this.lock;
        synchronized (object) {
            this.sonicAudioProcessor.queueEndOfStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ByteBuffer getOutput() {
        Object object = this.lock;
        synchronized (object) {
            return this.sonicAudioProcessor.getOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isEnded() {
        Object object = this.lock;
        synchronized (object) {
            return this.sonicAudioProcessor.isEnded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void flush() {
        Object object = this.lock;
        synchronized (object) {
            this.sonicAudioProcessor.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.sonicAudioProcessor.reset();
        }
    }
}

