/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import androidx.media3.common.audio.SpeedProvider;
import androidx.media3.common.util.UnstableApi;

@UnstableApi
public class SpeedProviderUtil {
    private SpeedProviderUtil() {
    }

    public static long getDurationAfterSpeedProviderApplied(SpeedProvider speedProvider, long durationUs) {
        long speedChangeTimeUs = 0L;
        double outputDurationUs = 0.0;
        while (speedChangeTimeUs < durationUs) {
            long nextSpeedChangeTimeUs = speedProvider.getNextSpeedChangeTimeUs(speedChangeTimeUs);
            if (nextSpeedChangeTimeUs == -9223372036854775807L) {
                nextSpeedChangeTimeUs = Long.MAX_VALUE;
            }
            outputDurationUs += (double)(Math.min(nextSpeedChangeTimeUs, durationUs) - speedChangeTimeUs) / (double)speedProvider.getSpeed(speedChangeTimeUs);
            speedChangeTimeUs = nextSpeedChangeTimeUs;
        }
        return Math.round(outputDurationUs);
    }
}

