/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.audio;

import androidx.annotation.GuardedBy;
import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.audio.BaseAudioProcessor;
import androidx.media3.common.audio.SpeedProvider;
import androidx.media3.common.audio.SynchronizedSonicAudioProcessor;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.LongArray;
import androidx.media3.common.util.LongArrayQueue;
import androidx.media3.common.util.SpeedProviderUtil;
import androidx.media3.common.util.TimestampConsumer;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@UnstableApi
public final class SpeedChangingAudioProcessor
extends BaseAudioProcessor {
    private final Object lock;
    private final SpeedProvider speedProvider;
    private final SynchronizedSonicAudioProcessor sonicAudioProcessor;
    @GuardedBy(value="lock")
    private final LongArrayQueue pendingCallbackInputTimesUs;
    @GuardedBy(value="lock")
    private final Queue<TimestampConsumer> pendingCallbacks;
    @GuardedBy(value="lock")
    private LongArray inputSegmentStartTimesUs;
    @GuardedBy(value="lock")
    private LongArray outputSegmentStartTimesUs;
    @GuardedBy(value="lock")
    private long lastProcessedInputTimeUs;
    @GuardedBy(value="lock")
    private long lastSpeedAdjustedInputTimeUs;
    @GuardedBy(value="lock")
    private long lastSpeedAdjustedOutputTimeUs;
    @GuardedBy(value="lock")
    private long speedAdjustedTimeAsyncInputTimeUs;
    @GuardedBy(value="lock")
    private float currentSpeed;
    private long bytesRead;
    private boolean endOfStreamQueuedToSonic;

    public SpeedChangingAudioProcessor(SpeedProvider speedProvider) {
        this.speedProvider = speedProvider;
        this.lock = new Object();
        this.sonicAudioProcessor = new SynchronizedSonicAudioProcessor(this.lock);
        this.pendingCallbackInputTimesUs = new LongArrayQueue();
        this.pendingCallbacks = new ArrayDeque<TimestampConsumer>();
        this.speedAdjustedTimeAsyncInputTimeUs = -9223372036854775807L;
        this.resetState();
    }

    @Override
    public long getDurationAfterProcessorApplied(long durationUs) {
        return SpeedProviderUtil.getDurationAfterSpeedProviderApplied(this.speedProvider, durationUs);
    }

    @Override
    public AudioProcessor.AudioFormat onConfigure(AudioProcessor.AudioFormat inputAudioFormat) throws AudioProcessor.UnhandledAudioFormatException {
        return this.sonicAudioProcessor.configure(inputAudioFormat);
    }

    @Override
    public void queueInput(ByteBuffer inputBuffer) {
        int bytesToNextSpeedChange;
        long timeUs = Util.scaleLargeTimestamp(this.bytesRead, 1000000L, (long)this.inputAudioFormat.sampleRate * (long)this.inputAudioFormat.bytesPerFrame);
        float newSpeed = this.speedProvider.getSpeed(timeUs);
        this.updateSpeed(newSpeed, timeUs);
        int inputBufferLimit = inputBuffer.limit();
        long nextSpeedChangeTimeUs = this.speedProvider.getNextSpeedChangeTimeUs(timeUs);
        if (nextSpeedChangeTimeUs != -9223372036854775807L) {
            bytesToNextSpeedChange = (int)Util.scaleLargeValue(nextSpeedChangeTimeUs - timeUs, (long)this.inputAudioFormat.sampleRate * (long)this.inputAudioFormat.bytesPerFrame, 1000000L, RoundingMode.CEILING);
            int bytesToNextFrame = this.inputAudioFormat.bytesPerFrame - bytesToNextSpeedChange % this.inputAudioFormat.bytesPerFrame;
            if (bytesToNextFrame != this.inputAudioFormat.bytesPerFrame) {
                bytesToNextSpeedChange += bytesToNextFrame;
            }
            inputBuffer.limit(Math.min(inputBufferLimit, inputBuffer.position() + bytesToNextSpeedChange));
        } else {
            bytesToNextSpeedChange = -1;
        }
        long startPosition = inputBuffer.position();
        if (this.isUsingSonic()) {
            this.sonicAudioProcessor.queueInput(inputBuffer);
            if (bytesToNextSpeedChange != -1 && (long)inputBuffer.position() - startPosition == (long)bytesToNextSpeedChange) {
                this.sonicAudioProcessor.queueEndOfStream();
                this.endOfStreamQueuedToSonic = true;
            }
        } else {
            ByteBuffer buffer = this.replaceOutputBuffer(inputBuffer.remaining());
            if (inputBuffer.hasRemaining()) {
                buffer.put(inputBuffer);
            }
            buffer.flip();
        }
        this.bytesRead += (long)inputBuffer.position() - startPosition;
        this.updateLastProcessedInputTime();
        inputBuffer.limit(inputBufferLimit);
    }

    @Override
    protected void onQueueEndOfStream() {
        if (!this.endOfStreamQueuedToSonic) {
            this.sonicAudioProcessor.queueEndOfStream();
            this.endOfStreamQueuedToSonic = true;
        }
    }

    @Override
    public ByteBuffer getOutput() {
        ByteBuffer output = this.isUsingSonic() ? this.sonicAudioProcessor.getOutput() : super.getOutput();
        this.processPendingCallbacks();
        return output;
    }

    @Override
    public boolean isEnded() {
        return super.isEnded() && this.sonicAudioProcessor.isEnded();
    }

    @Override
    protected void onFlush() {
        this.resetState();
        this.sonicAudioProcessor.flush();
    }

    @Override
    protected void onReset() {
        this.resetState();
        this.sonicAudioProcessor.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSpeedAdjustedTimeAsync(long inputTimeUs, TimestampConsumer callback) {
        Object object = this.lock;
        synchronized (object) {
            Assertions.checkArgument(this.speedAdjustedTimeAsyncInputTimeUs < inputTimeUs);
            this.speedAdjustedTimeAsyncInputTimeUs = inputTimeUs;
            if (inputTimeUs <= this.lastProcessedInputTimeUs && this.pendingCallbackInputTimesUs.isEmpty() || this.isEnded()) {
                callback.onTimestamp(this.calculateSpeedAdjustedTime(inputTimeUs));
                return;
            }
            this.pendingCallbackInputTimesUs.add(inputTimeUs);
            this.pendingCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMediaDurationUs(long playoutDurationUs) {
        Object object = this.lock;
        synchronized (object) {
            int floorIndex;
            for (floorIndex = this.outputSegmentStartTimesUs.size() - 1; floorIndex > 0 && this.outputSegmentStartTimesUs.get(floorIndex) > playoutDurationUs; --floorIndex) {
            }
            long lastSegmentOutputDurationUs = playoutDurationUs - this.outputSegmentStartTimesUs.get(floorIndex);
            long lastSegmentInputDurationUs = floorIndex == this.outputSegmentStartTimesUs.size() - 1 ? this.getMediaDurationUsAtCurrentSpeed(lastSegmentOutputDurationUs) : Math.round((double)lastSegmentOutputDurationUs * SpeedChangingAudioProcessor.divide(this.inputSegmentStartTimesUs.get(floorIndex + 1) - this.inputSegmentStartTimesUs.get(floorIndex), this.outputSegmentStartTimesUs.get(floorIndex + 1) - this.outputSegmentStartTimesUs.get(floorIndex)));
            return this.inputSegmentStartTimesUs.get(floorIndex) + lastSegmentInputDurationUs;
        }
    }

    private long calculateSpeedAdjustedTime(long inputTimeUs) {
        long lastSegmentOutputDurationUs;
        int floorIndex;
        for (floorIndex = this.inputSegmentStartTimesUs.size() - 1; floorIndex > 0 && this.inputSegmentStartTimesUs.get(floorIndex) > inputTimeUs; --floorIndex) {
        }
        if (floorIndex == this.inputSegmentStartTimesUs.size() - 1) {
            if (this.lastSpeedAdjustedInputTimeUs < this.inputSegmentStartTimesUs.get(floorIndex)) {
                this.lastSpeedAdjustedInputTimeUs = this.inputSegmentStartTimesUs.get(floorIndex);
                this.lastSpeedAdjustedOutputTimeUs = this.outputSegmentStartTimesUs.get(floorIndex);
            }
            long lastSegmentInputDurationUs = inputTimeUs - this.lastSpeedAdjustedInputTimeUs;
            lastSegmentOutputDurationUs = this.getPlayoutDurationUsAtCurrentSpeed(lastSegmentInputDurationUs);
        } else {
            long lastSegmentInputDurationUs = inputTimeUs - this.lastSpeedAdjustedInputTimeUs;
            lastSegmentOutputDurationUs = Math.round((double)lastSegmentInputDurationUs * SpeedChangingAudioProcessor.divide(this.outputSegmentStartTimesUs.get(floorIndex + 1) - this.outputSegmentStartTimesUs.get(floorIndex), this.inputSegmentStartTimesUs.get(floorIndex + 1) - this.inputSegmentStartTimesUs.get(floorIndex)));
        }
        this.lastSpeedAdjustedInputTimeUs = inputTimeUs;
        this.lastSpeedAdjustedOutputTimeUs += lastSegmentOutputDurationUs;
        return this.lastSpeedAdjustedOutputTimeUs;
    }

    private static double divide(long dividend, long divisor) {
        return (double)dividend / (double)divisor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingCallbacks() {
        Object object = this.lock;
        synchronized (object) {
            while (!this.pendingCallbacks.isEmpty() && (this.pendingCallbackInputTimesUs.element() <= this.lastProcessedInputTimeUs || this.isEnded())) {
                this.pendingCallbacks.remove().onTimestamp(this.calculateSpeedAdjustedTime(this.pendingCallbackInputTimesUs.remove()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSpeed(float newSpeed, long timeUs) {
        Object object = this.lock;
        synchronized (object) {
            if (newSpeed != this.currentSpeed) {
                this.updateSpeedChangeArrays(timeUs);
                this.currentSpeed = newSpeed;
                if (this.isUsingSonic()) {
                    this.sonicAudioProcessor.setSpeed(newSpeed);
                    this.sonicAudioProcessor.setPitch(newSpeed);
                }
                this.sonicAudioProcessor.flush();
                this.endOfStreamQueuedToSonic = false;
                super.getOutput();
            }
        }
    }

    private void updateSpeedChangeArrays(long currentSpeedChangeInputTimeUs) {
        long lastSpeedChangeOutputTimeUs = this.outputSegmentStartTimesUs.get(this.outputSegmentStartTimesUs.size() - 1);
        long lastSpeedChangeInputTimeUs = this.inputSegmentStartTimesUs.get(this.inputSegmentStartTimesUs.size() - 1);
        long lastSpeedSegmentMediaDurationUs = currentSpeedChangeInputTimeUs - lastSpeedChangeInputTimeUs;
        this.inputSegmentStartTimesUs.add(currentSpeedChangeInputTimeUs);
        this.outputSegmentStartTimesUs.add(lastSpeedChangeOutputTimeUs + this.getPlayoutDurationUsAtCurrentSpeed(lastSpeedSegmentMediaDurationUs));
    }

    private long getPlayoutDurationUsAtCurrentSpeed(long mediaDurationUs) {
        return this.isUsingSonic() ? this.sonicAudioProcessor.getPlayoutDuration(mediaDurationUs) : mediaDurationUs;
    }

    private long getMediaDurationUsAtCurrentSpeed(long playoutDurationUs) {
        return this.isUsingSonic() ? this.sonicAudioProcessor.getMediaDuration(playoutDurationUs) : playoutDurationUs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastProcessedInputTime() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isUsingSonic()) {
                long currentProcessedInputDurationUs = Util.scaleLargeTimestamp(this.sonicAudioProcessor.getProcessedInputBytes(), 1000000L, (long)this.inputAudioFormat.sampleRate * (long)this.inputAudioFormat.bytesPerFrame);
                this.lastProcessedInputTimeUs = this.inputSegmentStartTimesUs.get(this.inputSegmentStartTimesUs.size() - 1) + currentProcessedInputDurationUs;
            } else {
                this.lastProcessedInputTimeUs = Util.scaleLargeTimestamp(this.bytesRead, 1000000L, (long)this.inputAudioFormat.sampleRate * (long)this.inputAudioFormat.bytesPerFrame);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUsingSonic() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentSpeed != 1.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"inputSegmentStartTimesUs", "outputSegmentStartTimesUs"})
    @RequiresNonNull(value={"lock"})
    private void resetState(@UnknownInitialization SpeedChangingAudioProcessor this) {
        Object object = this.lock;
        synchronized (object) {
            this.inputSegmentStartTimesUs = new LongArray();
            this.outputSegmentStartTimesUs = new LongArray();
            this.inputSegmentStartTimesUs.add(0L);
            this.outputSegmentStartTimesUs.add(0L);
            this.lastProcessedInputTimeUs = 0L;
            this.lastSpeedAdjustedInputTimeUs = 0L;
            this.lastSpeedAdjustedOutputTimeUs = 0L;
            this.currentSpeed = 1.0f;
        }
        this.bytesRead = 0L;
        this.endOfStreamQueuedToSonic = false;
    }
}

