/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Collections;
import java.util.List;

public final class TrackSelectionOverride {
    public final TrackGroup mediaTrackGroup;
    public final ImmutableList<Integer> trackIndices;
    private static final String FIELD_TRACK_GROUP = Util.intToStringMaxRadix(0);
    private static final String FIELD_TRACKS = Util.intToStringMaxRadix(1);

    public TrackSelectionOverride(TrackGroup mediaTrackGroup, int trackIndex) {
        this(mediaTrackGroup, (List<Integer>)ImmutableList.of((Object)trackIndex));
    }

    public TrackSelectionOverride(TrackGroup mediaTrackGroup, List<Integer> trackIndices) {
        if (!(trackIndices.isEmpty() || Collections.min(trackIndices) >= 0 && Collections.max(trackIndices) < mediaTrackGroup.length)) {
            throw new IndexOutOfBoundsException();
        }
        this.mediaTrackGroup = mediaTrackGroup;
        this.trackIndices = ImmutableList.copyOf(trackIndices);
    }

    public int getType() {
        return this.mediaTrackGroup.type;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrackSelectionOverride that = (TrackSelectionOverride)obj;
        return this.mediaTrackGroup.equals(that.mediaTrackGroup) && this.trackIndices.equals(that.trackIndices);
    }

    public int hashCode() {
        return this.mediaTrackGroup.hashCode() + 31 * this.trackIndices.hashCode();
    }

    @UnstableApi
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putBundle(FIELD_TRACK_GROUP, this.mediaTrackGroup.toBundle());
        bundle.putIntArray(FIELD_TRACKS, Ints.toArray(this.trackIndices));
        return bundle;
    }

    @UnstableApi
    public static TrackSelectionOverride fromBundle(Bundle bundle) {
        Bundle trackGroupBundle = Assertions.checkNotNull(bundle.getBundle(FIELD_TRACK_GROUP));
        TrackGroup mediaTrackGroup = TrackGroup.fromBundle(trackGroupBundle);
        int[] tracks = Assertions.checkNotNull(bundle.getIntArray(FIELD_TRACKS));
        return new TrackSelectionOverride(mediaTrackGroup, Ints.asList((int[])tracks));
    }
}

