/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import android.os.Looper;
import android.os.Message;
import androidx.annotation.CheckResult;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.media3.common.FlagSet;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.HandlerWrapper;
import androidx.media3.common.util.UnstableApi;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArraySet;

@UnstableApi
public final class ListenerSet<T> {
    private static final int MSG_ITERATION_FINISHED = 0;
    private final Clock clock;
    private final HandlerWrapper handler;
    private final IterationFinishedEvent<T> iterationFinishedEvent;
    private final CopyOnWriteArraySet<ListenerHolder<T>> listeners;
    private final ArrayDeque<Runnable> flushingEvents;
    private final ArrayDeque<Runnable> queuedEvents;
    private final Object releasedLock;
    @GuardedBy(value="releasedLock")
    private boolean released;
    private boolean throwsWhenUsingWrongThread;

    public ListenerSet(Looper looper, Clock clock, IterationFinishedEvent<T> iterationFinishedEvent) {
        this(new CopyOnWriteArraySet<ListenerHolder<T>>(), looper, clock, iterationFinishedEvent, true);
    }

    private ListenerSet(CopyOnWriteArraySet<ListenerHolder<T>> listeners, Looper looper, Clock clock, IterationFinishedEvent<T> iterationFinishedEvent, boolean throwsWhenUsingWrongThread) {
        HandlerWrapper handler;
        this.clock = clock;
        this.listeners = listeners;
        this.iterationFinishedEvent = iterationFinishedEvent;
        this.releasedLock = new Object();
        this.flushingEvents = new ArrayDeque();
        this.queuedEvents = new ArrayDeque();
        this.handler = handler = clock.createHandler(looper, this::handleMessage);
        this.throwsWhenUsingWrongThread = throwsWhenUsingWrongThread;
    }

    @CheckResult
    public ListenerSet<T> copy(Looper looper, IterationFinishedEvent<T> iterationFinishedEvent) {
        return this.copy(looper, this.clock, iterationFinishedEvent);
    }

    @CheckResult
    public ListenerSet<T> copy(Looper looper, Clock clock, IterationFinishedEvent<T> iterationFinishedEvent) {
        return new ListenerSet<T>(this.listeners, looper, clock, iterationFinishedEvent, this.throwsWhenUsingWrongThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T listener) {
        Assertions.checkNotNull(listener);
        Object object = this.releasedLock;
        synchronized (object) {
            if (this.released) {
                return;
            }
            this.listeners.add(new ListenerHolder<T>(listener));
        }
    }

    public void remove(T listener) {
        this.verifyCurrentThread();
        for (ListenerHolder<T> listenerHolder : this.listeners) {
            if (!listenerHolder.listener.equals(listener)) continue;
            listenerHolder.release(this.iterationFinishedEvent);
            this.listeners.remove(listenerHolder);
        }
    }

    public void clear() {
        this.verifyCurrentThread();
        this.listeners.clear();
    }

    public int size() {
        this.verifyCurrentThread();
        return this.listeners.size();
    }

    public void queueEvent(int eventFlag, Event<T> event) {
        this.verifyCurrentThread();
        CopyOnWriteArraySet listenerSnapshot = new CopyOnWriteArraySet(this.listeners);
        this.queuedEvents.add(() -> {
            for (ListenerHolder holder : listenerSnapshot) {
                holder.invoke(eventFlag, event);
            }
        });
    }

    public void flushEvents() {
        this.verifyCurrentThread();
        if (this.queuedEvents.isEmpty()) {
            return;
        }
        if (!this.handler.hasMessages(0)) {
            this.handler.sendMessageAtFrontOfQueue(this.handler.obtainMessage(0));
        }
        boolean recursiveFlushInProgress = !this.flushingEvents.isEmpty();
        this.flushingEvents.addAll(this.queuedEvents);
        this.queuedEvents.clear();
        if (recursiveFlushInProgress) {
            return;
        }
        while (!this.flushingEvents.isEmpty()) {
            this.flushingEvents.peekFirst().run();
            this.flushingEvents.removeFirst();
        }
    }

    public void sendEvent(int eventFlag, Event<T> event) {
        this.queueEvent(eventFlag, event);
        this.flushEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.verifyCurrentThread();
        Iterator<ListenerHolder<T>> iterator = this.releasedLock;
        synchronized (iterator) {
            this.released = true;
        }
        for (ListenerHolder<T> listenerHolder : this.listeners) {
            listenerHolder.release(this.iterationFinishedEvent);
        }
        this.listeners.clear();
    }

    @Deprecated
    public void setThrowsWhenUsingWrongThread(boolean throwsWhenUsingWrongThread) {
        this.throwsWhenUsingWrongThread = throwsWhenUsingWrongThread;
    }

    private boolean handleMessage(Message message) {
        for (ListenerHolder<T> holder : this.listeners) {
            holder.iterationFinished(this.iterationFinishedEvent);
            if (!this.handler.hasMessages(0)) continue;
            break;
        }
        return true;
    }

    private void verifyCurrentThread() {
        if (!this.throwsWhenUsingWrongThread) {
            return;
        }
        Assertions.checkState(Thread.currentThread() == this.handler.getLooper().getThread());
    }

    public static interface IterationFinishedEvent<T> {
        public void invoke(T var1, FlagSet var2);
    }

    private static final class ListenerHolder<T> {
        public final T listener;
        private FlagSet.Builder flagsBuilder;
        private boolean needsIterationFinishedEvent;
        private boolean released;

        public ListenerHolder(T listener) {
            this.listener = listener;
            this.flagsBuilder = new FlagSet.Builder();
        }

        public void release(IterationFinishedEvent<T> event) {
            this.released = true;
            if (this.needsIterationFinishedEvent) {
                this.needsIterationFinishedEvent = false;
                event.invoke(this.listener, this.flagsBuilder.build());
            }
        }

        public void invoke(int eventFlag, Event<T> event) {
            if (!this.released) {
                if (eventFlag != -1) {
                    this.flagsBuilder.add(eventFlag);
                }
                this.needsIterationFinishedEvent = true;
                event.invoke(this.listener);
            }
        }

        public void iterationFinished(IterationFinishedEvent<T> event) {
            if (!this.released && this.needsIterationFinishedEvent) {
                FlagSet flagsToNotify = this.flagsBuilder.build();
                this.flagsBuilder = new FlagSet.Builder();
                this.needsIterationFinishedEvent = false;
                event.invoke(this.listener, flagsToNotify);
            }
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            return this.listener.equals(((ListenerHolder)other).listener);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }

    public static interface Event<T> {
        public void invoke(T var1);
    }
}

